/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.utils;

import android.text.TextUtils;
import android.util.Log;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.center.config.RCRTCConfigImpl;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import cn.rongcloud.rtc.webrtc.ILocalVideoStreamResource;
import cn.rongcloud.rtc.webrtc.IStreamResource;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RTCSDPTools {
    private static final String TAG = RTCSDPTools.class.getSimpleName();
    private static final String AUDIO_CODEC_PARAM_BITRATE = "maxaveragebitrate";
    private static final String VIDEO_CODEC_PARAM_START_BITRATE = "x-google-start-bitrate";

    public static String preferCodec(RCRTCConfigImpl rtcConfig, String sdpDescription, String codec, boolean isAudio, int totalMaxBitRate) {
        String[] serverLines;
        String[] lines = sdpDescription.split("\r\n");
        if (lines.length == 1 && (serverLines = sdpDescription.split("\n")).length > 0) {
            StringBuilder newSdpDescription = new StringBuilder();
            for (String line : serverLines) {
                newSdpDescription.append(line).append("\r\n");
            }
            sdpDescription = newSdpDescription.toString();
            lines = sdpDescription.split("\r\n");
        }
        String opusRTPMap = "a=rtpmap:111 opus";
        String opusNack = "\r\na=rtcp-fb:111 nack";
        int mLineIndex = -1;
        String codecRtpMap = null;
        String regex = "^a=rtpmap:(\\d+) " + codec + "(/\\d+)+[\r]?$";
        Pattern codecPattern = Pattern.compile(regex);
        String mediaDescription = "m=video ";
        if (isAudio) {
            mediaDescription = "m=audio ";
        }
        String candidateDescription = "a=candidate";
        String bitRateFormatStringMin = "\r\na=fmtp:%s x-google-min-bitrate=%d;";
        String bitRateFormatStringMax = "\r\nb=AS:%d";
        String startBitRateFormatString = "x-google-start-bitrate=%d";
        String mVideoTag = "a=mid:video";
        String mAudioTag = "a=mid:audio";
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].startsWith(mediaDescription)) {
                mLineIndex = i;
                continue;
            }
            if (!isAudio) {
                if (lines[i].startsWith(mVideoTag)) {
                    lines[i] = lines[i] + RongRTCUtils.StringFormat(bitRateFormatStringMax, totalMaxBitRate);
                }
            } else if (lines[i].startsWith(mAudioTag)) {
                lines[i] = lines[i] + RongRTCUtils.StringFormat(bitRateFormatStringMax, rtcConfig.getAudioBitrate());
            }
            if (lines[i].startsWith(candidateDescription)) {
                FinLog.d(TAG, lines[i]);
            }
            if (lines[i].startsWith(opusRTPMap) && isAudio) {
                lines[i] = lines[i] + opusNack;
            }
            if (!lines[i].contains("extmap:5")) continue;
            lines[i] = "";
        }
        if (mLineIndex == -1 || codecRtpMap == null) {
            StringBuilder newSdpDescription = new StringBuilder();
            for (String line : lines) {
                if (TextUtils.isEmpty((CharSequence)line)) continue;
                newSdpDescription.append(line).append("\r\n");
            }
            sdpDescription = newSdpDescription.toString();
        }
        if (mLineIndex == -1) {
            FinLog.w(TAG, "No " + mediaDescription + " line, so can't prefer " + codec);
            return sdpDescription;
        }
        if (codecRtpMap == null) {
            FinLog.w(TAG, "No rtpmap for " + codec);
            return sdpDescription;
        }
        FinLog.d(TAG, "Found " + codec + " rtpmap " + codecRtpMap + ", prefer at " + lines[mLineIndex]);
        String[] origMLineParts = lines[mLineIndex].split(" ");
        if (origMLineParts.length > 3) {
            StringBuilder newMLine = new StringBuilder();
            int origPartIndex = 0;
            newMLine.append(origMLineParts[origPartIndex++]).append(" ");
            newMLine.append(origMLineParts[origPartIndex++]).append(" ");
            newMLine.append(origMLineParts[origPartIndex++]).append(" ");
            newMLine.append(codecRtpMap);
            while (origPartIndex < origMLineParts.length) {
                if (!origMLineParts[origPartIndex].equals(codecRtpMap)) {
                    newMLine.append(" ").append(origMLineParts[origPartIndex]);
                }
                ++origPartIndex;
            }
            lines[mLineIndex] = newMLine.toString();
            FinLog.d(TAG, "Change media description: " + lines[mLineIndex]);
        } else {
            FinLog.e(TAG, "Wrong SDP media description format: " + lines[mLineIndex]);
        }
        StringBuilder newSdpDescription = new StringBuilder();
        for (String line : lines) {
            if (TextUtils.isEmpty((CharSequence)line)) continue;
            newSdpDescription.append(line).append("\r\n");
        }
        return newSdpDescription.toString();
    }

    public static String preferRemoteCodec(String sdpDescription, String codec, boolean isAudio, int totalMaxBitRate, int totalMinBitRate) {
        String[] serverLines;
        String[] lines = sdpDescription.split("\r\n");
        if (lines.length == 1 && (serverLines = sdpDescription.split("\n")).length > 0) {
            StringBuilder newSdpDescription = new StringBuilder();
            for (String line : serverLines) {
                newSdpDescription.append(line).append("\r\n");
            }
            sdpDescription = newSdpDescription.toString();
            lines = sdpDescription.split("\r\n");
        }
        int mLineIndex = -1;
        String codecRtpMap = null;
        String regex = "^a=rtpmap:(\\d+) " + codec + "(/\\d+)+[\r]?$";
        Pattern codecPattern = Pattern.compile(regex);
        String mediaDescription = "m=video ";
        if (isAudio) {
            mediaDescription = "m=audio ";
        }
        String candidateDescription = "a=candidate";
        String bitRateFormatStringMin = "\r\na=fmtp:%s x-google-min-bitrate=%d;";
        String bitRateFormatStringMax = "\r\nb=AS:%d";
        String startBitRateFormatString = "x-google-start-bitrate=%d";
        String mVideoTag = "a=mid:video";
        int totalStarBitRate = (int)(0.7f * (float)totalMaxBitRate);
        for (int i = 0; i < lines.length; ++i) {
            Object codecMatcher;
            if (lines[i].startsWith(mediaDescription)) {
                mLineIndex = i;
                continue;
            }
            if (lines[i].startsWith(mVideoTag)) {
                int n = i;
                lines[n] = lines[n] + RongRTCUtils.StringFormat(bitRateFormatStringMax, totalMaxBitRate);
            }
            if (lines[i].startsWith(candidateDescription)) {
                FinLog.d(TAG, lines[i]);
            }
            if (!((Matcher)(codecMatcher = codecPattern.matcher(lines[i]))).matches()) continue;
            codecRtpMap = ((Matcher)codecMatcher).group(1);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(RongRTCUtils.StringFormat(bitRateFormatStringMin, codecRtpMap, totalMinBitRate));
            stringBuffer.append(RongRTCUtils.StringFormat(startBitRateFormatString, totalStarBitRate));
            lines[i] = lines[i] + stringBuffer.toString();
        }
        if (mLineIndex == -1 || codecRtpMap == null) {
            StringBuilder newSdpDescription = new StringBuilder();
            for (String line : lines) {
                if (TextUtils.isEmpty((CharSequence)line)) continue;
                newSdpDescription.append(line).append("\r\n");
            }
            sdpDescription = newSdpDescription.toString();
        }
        if (mLineIndex == -1) {
            FinLog.d(TAG, "No " + mediaDescription + " line, so can't prefer " + codec);
            return sdpDescription;
        }
        if (codecRtpMap == null) {
            FinLog.d(TAG, "No rtpmap for " + codec);
            return sdpDescription;
        }
        FinLog.d(TAG, "Found " + codec + " rtpmap " + codecRtpMap + ", prefer at " + lines[mLineIndex]);
        String[] origMLineParts = lines[mLineIndex].split(" ");
        if (origMLineParts.length > 3) {
            StringBuilder newMLine = new StringBuilder();
            int origPartIndex = 0;
            newMLine.append(origMLineParts[origPartIndex++]).append(" ");
            newMLine.append(origMLineParts[origPartIndex++]).append(" ");
            newMLine.append(origMLineParts[origPartIndex++]).append(" ");
            newMLine.append(codecRtpMap);
            while (origPartIndex < origMLineParts.length) {
                if (!origMLineParts[origPartIndex].equals(codecRtpMap)) {
                    newMLine.append(" ").append(origMLineParts[origPartIndex]);
                }
                ++origPartIndex;
            }
            lines[mLineIndex] = newMLine.toString();
            FinLog.d(TAG, "Change media description: " + lines[mLineIndex]);
        } else {
            FinLog.d(TAG, "Wrong SDP media description format: " + lines[mLineIndex]);
        }
        StringBuilder newSdpDescription = new StringBuilder();
        for (String line : lines) {
            if (TextUtils.isEmpty((CharSequence)line)) continue;
            newSdpDescription.append(line).append("\r\n");
        }
        return newSdpDescription.toString();
    }

    public static String setStartBitrate(String codec, boolean isVideoCodec, String sdpDescription, int bitrateKbps, boolean stereo) {
        Matcher codecMatcher;
        int i;
        String[] lines = sdpDescription.split("\r\n");
        int rtpmapLineIndex = -1;
        boolean sdpFormatUpdated = false;
        String codecRtpMap = null;
        String regex = "^a=rtpmap:(\\d+) " + codec + "(/\\d+)+[\r]?$";
        Pattern codecPattern = Pattern.compile(regex);
        for (i = 0; i < lines.length; ++i) {
            codecMatcher = codecPattern.matcher(lines[i]);
            if (!codecMatcher.matches()) continue;
            codecRtpMap = codecMatcher.group(1);
            rtpmapLineIndex = i;
            break;
        }
        if (codecRtpMap == null) {
            Log.w((String)TAG, (String)("No rtpmap for " + codec + " codec"));
            return sdpDescription;
        }
        Log.d((String)TAG, (String)("Found " + codec + " rtpmap " + codecRtpMap + " at " + lines[rtpmapLineIndex]));
        regex = "^a=fmtp:" + codecRtpMap + " \\w+=\\d+.*[\r]?$";
        codecPattern = Pattern.compile(regex);
        for (i = 0; i < lines.length; ++i) {
            codecMatcher = codecPattern.matcher(lines[i]);
            if (!codecMatcher.matches()) continue;
            Log.d((String)TAG, (String)("Found " + codec + " " + lines[i]));
            if (isVideoCodec) {
                int n = i;
                lines[n] = lines[n] + "; x-google-start-bitrate=" + bitrateKbps;
            } else {
                if (bitrateKbps > 0) {
                    FinLog.d(TAG, "audio option : set maxaveragebitrate " + bitrateKbps + "K");
                    int n = i;
                    lines[n] = lines[n] + "; maxaveragebitrate=" + bitrateKbps * 1000;
                }
                if (stereo) {
                    FinLog.d(TAG, "audio option : set stereo=1");
                    int n = i;
                    lines[n] = lines[n] + "; stereo=1";
                }
            }
            Log.d((String)TAG, (String)("Update remote SDP line: " + lines[i]));
            sdpFormatUpdated = true;
            break;
        }
        StringBuilder newSdpDescription = new StringBuilder();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            newSdpDescription.append(lines[i2]).append("\r\n");
            if (sdpFormatUpdated || i2 != rtpmapLineIndex) continue;
            String bitrateSet = isVideoCodec ? "a=fmtp:" + codecRtpMap + " " + VIDEO_CODEC_PARAM_START_BITRATE + "=" + bitrateKbps : "a=fmtp:" + codecRtpMap + " " + AUDIO_CODEC_PARAM_BITRATE + "=" + bitrateKbps * 1000;
            Log.d((String)TAG, (String)("Add remote SDP line: " + bitrateSet));
            newSdpDescription.append(bitrateSet).append("\r\n");
        }
        return newSdpDescription.toString();
    }

    public static int getTotalMaxBitRate(List<? extends IStreamResource> localStreams) {
        int totalMax = 0;
        if (RongRTCUtils.isEmpty(localStreams)) {
            return totalMax;
        }
        for (IStreamResource iStreamResource : localStreams) {
            if (RCRTCMediaType.VIDEO != iStreamResource.getMediaType()) continue;
            totalMax += ((ILocalVideoStreamResource)iStreamResource).getMaxBitrate();
        }
        return totalMax;
    }

    public static int getTotalMinBitRate(List<? extends IStreamResource> localStreams) {
        int totalMax = 0;
        if (RongRTCUtils.isEmpty(localStreams)) {
            return totalMax;
        }
        for (IStreamResource iStreamResource : localStreams) {
            if (RCRTCMediaType.VIDEO != iStreamResource.getMediaType()) continue;
            totalMax += ((ILocalVideoStreamResource)iStreamResource).getMinBitrate();
        }
        return totalMax;
    }
}

