/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;

public class NetUtils {
    public static final int NETWORK_NONE = 0;
    public static final int NETWORK_WIFI = 1;
    public static final int NETWORK_2G = 2;
    public static final int NETWORK_3G = 3;
    public static final int NETWORK_4G = 4;
    public static final int NETWORK_MOBILE = 5;

    public static int getNetworkState(Context context) {
        NetworkInfo.State state;
        if (null == context) {
            return 0;
        }
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (null == connManager) {
            return 0;
        }
        NetworkInfo activeNetInfo = connManager.getActiveNetworkInfo();
        if (activeNetInfo == null || !activeNetInfo.isAvailable()) {
            return 0;
        }
        NetworkInfo wifiInfo = connManager.getNetworkInfo(1);
        if (null != wifiInfo && null != (state = wifiInfo.getState()) && (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING)) {
            return 1;
        }
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        int networkType = telephonyManager.getNetworkType();
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return 2;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return 3;
            }
            case 13: {
                return 4;
            }
        }
        return 5;
    }

    public static boolean isNetConnected(Context context) {
        NetworkInfo info;
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        return connectivity != null && (info = connectivity.getActiveNetworkInfo()) != null && info.isConnected() && info.getState() == NetworkInfo.State.CONNECTED;
    }

    public static synchronized boolean isWifiConnected(Context context) {
        int networkInfoType;
        NetworkInfo networkInfo;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager != null && (networkInfo = connectivityManager.getActiveNetworkInfo()) != null && ((networkInfoType = networkInfo.getType()) == 1 || networkInfoType == 9)) {
            return networkInfo.isConnected();
        }
        return false;
    }
}

