/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.utils;

import android.os.Build;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;

public class DeviceUtils {
    private static final String TAG = "DeviceUtils";
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            String path = pathname.getName();
            if (path.startsWith("cpu")) {
                for (int i = 3; i < path.length(); ++i) {
                    if (Character.isDigit(path.charAt(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };

    public static float getProcessCpuRate(int cycle) {
        long start = System.currentTimeMillis();
        int coresSize = DeviceUtils.getNumberOfCPUCores();
        float[] results = new float[cycle];
        long maxFreq = 0L;
        long minFreq = 0L;
        float fanal_rate = 0.0f;
        for (int num = 0; num < cycle; ++num) {
            float rate = 0.0f;
            float rate2 = 0.0f;
            float weight = 1.0f / (float)coresSize;
            for (int i = 0; i < coresSize; ++i) {
                long freq = DeviceUtils.getAvaiableCoreCurFreq(i);
                maxFreq = DeviceUtils.getCoreMaxFreq(i);
                minFreq = DeviceUtils.getCoreMinFreq(i);
                if (maxFreq == 0L || maxFreq - minFreq == 0L) {
                    return 0.0f;
                }
                rate += 100.0f * weight * (float)(freq - minFreq) / (float)(maxFreq - minFreq);
                rate2 += (float)freq * 100.0f / (float)maxFreq;
            }
            results[num] = rate;
        }
        Arrays.sort(results);
        return results[(cycle - 1) / 2];
    }

    public static long getCoreMinFreq(int index) {
        String v = DeviceUtils.readProcFile("/sys/devices/system/cpu/cpu" + index + "/cpufreq/cpuinfo_min_freq");
        if (TextUtils.isEmpty((CharSequence)v)) {
            return 0L;
        }
        return Long.parseLong(v);
    }

    public static long getCoreMaxFreq(int index) {
        String v = DeviceUtils.readProcFile("/sys/devices/system/cpu/cpu" + index + "/cpufreq/cpuinfo_max_freq");
        if (TextUtils.isEmpty((CharSequence)v)) {
            return 0L;
        }
        return Long.parseLong(v);
    }

    public static long getAvaiableCoreCurFreq(int index) {
        String v = DeviceUtils.readProcFile("/sys/devices/system/cpu/cpu" + index + "/cpufreq/scaling_cur_freq");
        if (TextUtils.isEmpty((CharSequence)v)) {
            return 0L;
        }
        return Long.parseLong(v);
    }

    public static int getNumberOfCPUCores() {
        int cores;
        if (Build.VERSION.SDK_INT <= 10) {
            return 1;
        }
        try {
            cores = DeviceUtils.getCoresFromFileInfo("/sys/devices/system/cpu/possible");
            if (cores == -1) {
                cores = DeviceUtils.getCoresFromFileInfo("/sys/devices/system/cpu/present");
            }
            if (cores == -1) {
                cores = DeviceUtils.getCoresFromCPUFileList();
            }
        }
        catch (SecurityException var2) {
            cores = -1;
        }
        catch (NullPointerException var3) {
            cores = -1;
        }
        return cores;
    }

    private static int getCoresFromCPUFileList() {
        return new File("/sys/devices/system/cpu").listFiles(CPU_FILTER).length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readProcFile(String fileLocation) {
        FileInputStream is = null;
        BufferedReader buf = null;
        String fileContents = "";
        try {
            is = new FileInputStream(fileLocation);
            buf = new BufferedReader(new InputStreamReader(is));
            fileContents = buf.readLine();
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DeviceUtils.closeStream(is);
                DeviceUtils.closeStream(buf);
                throw throwable;
            }
            DeviceUtils.closeStream(is);
            DeviceUtils.closeStream(buf);
        }
        DeviceUtils.closeStream(is);
        DeviceUtils.closeStream(buf);
        return fileContents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getCoresFromFileInfo(String fileLocation) {
        int res;
        FileInputStream is = null;
        BufferedReader buf = null;
        try {
            is = new FileInputStream(fileLocation);
            buf = new BufferedReader(new InputStreamReader(is));
            String fileContents = buf.readLine();
            res = DeviceUtils.getCoresFromFileString(fileContents);
        }
        catch (IOException e) {
            try {
                res = -1;
            }
            catch (Throwable throwable) {
                DeviceUtils.closeStream(is);
                DeviceUtils.closeStream(buf);
                throw throwable;
            }
            DeviceUtils.closeStream(is);
            DeviceUtils.closeStream(buf);
        }
        DeviceUtils.closeStream(is);
        DeviceUtils.closeStream(buf);
        return res;
    }

    private static void closeStream(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static int getCoresFromFileString(String str) {
        if (str != null && str.matches("0-[\\d]+$")) {
            int cores = Integer.valueOf(str.substring(2)) + 1;
            return cores;
        }
        return -1;
    }
}

