/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.stat;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import cn.rongcloud.rtc.api.RCRTCRoom;
import cn.rongcloud.rtc.api.report.ReportUserInfo;
import cn.rongcloud.rtc.api.report.StatusBean;
import cn.rongcloud.rtc.api.report.StatusReport;
import cn.rongcloud.rtc.api.report.StatusReportParser;
import cn.rongcloud.rtc.api.stream.RCRTCOutputStream;
import cn.rongcloud.rtc.base.RCRTCResourceState;
import cn.rongcloud.rtc.center.RCLocalUserImpl;
import cn.rongcloud.rtc.center.stream.RCTinyVideoOutStream;
import cn.rongcloud.rtc.core.StatsObserver;
import cn.rongcloud.rtc.core.StatsReport;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.stat.RongRtcStatForm;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.NetUtils;
import cn.rongcloud.rtc.utils.PerformanceMonitoring;
import cn.rongcloud.rtc.webrtc.RTCConnectionHolder;
import io.rong.imlib.IMLibRTCClient;
import io.rong.imlib.RongIMClient;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StatHandler
extends Handler
implements StatsObserver {
    public static final String TAG = "StatHandler";
    public static final int WHAT_GET_STATUS = 100;
    public static final int INTERVAL_TIME = 2;
    private Map<String, RongRtcStatForm> mPublishs = new HashMap<String, RongRtcStatForm>();
    private Map<String, RongRtcStatForm> mReceives = new HashMap<String, RongRtcStatForm>();
    private HashMap<String, ReportUserInfo> mUserIdTrackIdMap = new HashMap();
    private StatusReportParser mParser;
    private PerformanceMonitoring mMonitoring;
    private String mRoomId;
    private RTCConnectionHolder mConnectionHolder;
    private Runnable mSendStatRun = new Runnable(){

        @Override
        public void run() {
            StatHandler.this.onGetStatus();
            StatHandler.this.postDelayed(StatHandler.this.mSendStatRun, 2000L);
        }
    };

    public StatHandler(Looper looper, String roomId) {
        super(looper);
        this.mParser = new StatusReportParser();
        this.mRoomId = roomId;
        this.mMonitoring = new PerformanceMonitoring(Process.myPid());
        this.postDelayed(this.mSendStatRun, 2000L);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        switch (msg.what) {
            case 1: {
                this.onHandleAdd(true, msg.obj);
                break;
            }
            case 3: {
                this.onHandleAdd(false, msg.obj);
                break;
            }
            case 2: {
                this.onHandleRemove(true, msg.obj);
                break;
            }
            case 4: {
                this.onHandleRemove(false, msg.obj);
                break;
            }
            case 5: {
                this.onRelease();
                break;
            }
            case 100: {
                if (this.isEmpty()) break;
                this.sendRTCUserState(this.onParseStatusResult((StatsReport[])msg.obj));
            }
        }
    }

    private void sendRTCUserState(StatusReport report) {
        this.onSendData(report, this.mPublishs.values(), true);
        this.onSendData(report, this.mReceives.values(), false);
    }

    private void onSendData(StatusReport report, Collection<RongRtcStatForm> forms, boolean isPublish) {
        if (forms.isEmpty()) {
            return;
        }
        StringBuilder val = new StringBuilder();
        val.append(isPublish ? "R3" : "R4").append("\t").append(isPublish ? report.bitRateSend : report.bitRateRcv).append("\t");
        if (this.mMonitoring.isAboveAndroidO()) {
            val.append(-1).append("\t").append(-1).append("\t").append(this.mMonitoring.getCpuRate());
        } else {
            val.append(this.mMonitoring.getAppRate()).append("\t").append(this.mMonitoring.getProcRate()).append("\t").append(-1);
        }
        val.append("\t").append(this.getNetWorkName(NetUtils.getNetworkState(RTCEngineImpl.getInstance().getContext()))).append("\t").append(report.rtt).append("\t").append(report.ipAddress).append("\t").append(report.googAvailableReceiveBandwidth).append("\t").append(report.googAvailableSendBandwidth).append("\t").append(report.packetsDiscardedOnSend).append("\r");
        for (RongRtcStatForm form : forms) {
            if (form == null) continue;
            val.append((CharSequence)form.createFormStr()).append("\n");
        }
        this.setRTCUserState(val.toString());
    }

    private String getNetWorkName(int networkState) {
        switch (networkState) {
            case 2: {
                return "2G";
            }
            case 3: {
                return "3G";
            }
            case 4: {
                return "4G";
            }
            case 1: {
                return "wlan";
            }
        }
        return "unknown";
    }

    private StatusReport onParseStatusResult(StatsReport[] reports) {
        StatusReport res = this.mParser.getParseResult(reports, this.mUserIdTrackIdMap);
        this.mMonitoring.countCpuData();
        Set<String> keys = res.statusAudioSends.keySet();
        for (String key : keys) {
            this.updateStatForm(this.mPublishs.get(key), res.statusAudioSends.get(key), false, true);
        }
        keys = res.statusVideoSends.keySet();
        for (String key : keys) {
            this.updateStatForm(this.mPublishs.get(key), res.statusVideoSends.get(key), true, true);
        }
        keys = res.statusVideoRcvs.keySet();
        for (String key : keys) {
            this.updateStatForm(this.mReceives.get(key), res.statusVideoRcvs.get(key), true, false);
        }
        keys = res.statusAudioRcvs.keySet();
        for (String key : keys) {
            this.updateStatForm(this.mReceives.get(key), res.statusAudioRcvs.get(key), false, false);
        }
        return res;
    }

    private void updateStatForm(RongRtcStatForm statForm, StatusBean bean, boolean isVideo, boolean isPublish) {
        if (statForm == null || bean == null) {
            return;
        }
        statForm.bitRabte = statForm.bitRabte == -1.0f ? (float)bean.bitRate : (float)(bean.bitRate / 2L);
        statForm.packetLostRate = (float)bean.packetLostRate / 100.0f;
        statForm.googJitterReceived = bean.jitterReceived;
        statForm.codecName = bean.codecName;
        statForm.googFirsReceived = bean.firstReceived;
        statForm.rtt = bean.rtt;
        if (!isPublish) {
            statForm.blockInterValTime = bean.renderDelayMs;
            statForm.mediaState = -1;
        } else {
            RCRTCRoom room = RTCEngineImpl.getInstance().getRoom();
            if (room == null) {
                return;
            }
            RCLocalUserImpl localUser = (RCLocalUserImpl)room.getLocalUser();
            if (localUser != null) {
                if (statForm.trackId.contains(RCTinyVideoOutStream.TINY)) {
                    statForm.mediaState = localUser.getDefaultVideoStream().getResourceState() == RCRTCResourceState.NORMAL ? 1 : 0;
                } else {
                    int mediaState = 0;
                    for (RCRTCOutputStream localAvStream : localUser.getStreamsForInternal()) {
                        if (!TextUtils.equals((CharSequence)statForm.trackId, (CharSequence)(localAvStream.getStreamId() + "_" + localAvStream.getMediaType().getDescription()))) continue;
                        mediaState = localAvStream.getResourceState() == RCRTCResourceState.NORMAL ? 1 : 0;
                        break;
                    }
                    statForm.mediaState = mediaState;
                }
            } else {
                Log.e((String)TAG, (String)"updateStatForm: LocalUser is Null");
            }
        }
        if (isVideo) {
            if (isPublish) {
                statForm.codecType = TextUtils.equals((CharSequence)"unknown", (CharSequence)bean.codecImplementationName) ? "MediaCodec" : bean.codecImplementationName;
                statForm.googNacksReceived = bean.nacksReceived;
                statForm.googPlisReceived = bean.plisReceived;
            } else {
                statForm.codecType = bean.codecImplementationName;
            }
            statForm.frameRate = bean.frameRate;
            statForm.frameHeight = bean.frameHeight;
            statForm.frameWidth = bean.frameWidth;
        } else {
            statForm.audioLevel = String.valueOf(bean.audioLevel);
        }
    }

    public void setRTCUserState(String val) {
        if (RongIMClient.getInstance().getCurrentConnectionStatus() != RongIMClient.ConnectionStatusListener.ConnectionStatus.CONNECTED) {
            return;
        }
        IMLibRTCClient.getInstance().setRTCUserState(this.mRoomId, val, new RongIMClient.OperationCallback(){

            public void onSuccess() {
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                FinLog.e(StatHandler.TAG, "setRTCUserState Failed: " + errorCode.getValue());
            }
        });
    }

    private void onHandleAdd(boolean isPublish, Object obj) {
        if (obj == null) {
            return;
        }
        List forms = (List)obj;
        if (isPublish) {
            this.onAdd(forms, this.mPublishs);
        } else {
            this.onAdd(forms, this.mReceives);
        }
    }

    private void onAdd(List<RongRtcStatForm> forms, Map<String, RongRtcStatForm> map) {
        if (forms == null || forms.isEmpty()) {
            return;
        }
        for (RongRtcStatForm form : forms) {
            if (map.containsKey(form)) continue;
            map.put(form.realTrackId, form);
            ReportUserInfo reportUserInfo = new ReportUserInfo(form.mediaId, form.trackId);
            this.mUserIdTrackIdMap.put(form.realTrackId, reportUserInfo);
        }
    }

    private void onHandleRemove(boolean isPublish, Object obj) {
        if (obj == null) {
            return;
        }
        List trackId = (List)obj;
        if (isPublish) {
            this.onRemove(trackId, this.mPublishs);
        } else {
            this.onRemove(trackId, this.mReceives);
        }
    }

    private void onRemove(List<String> trackIds, Map<String, RongRtcStatForm> map) {
        if (trackIds == null || trackIds.isEmpty()) {
            return;
        }
        block0: for (String trackId : trackIds) {
            if (map.containsKey(trackId)) {
                map.remove(trackId);
                this.mUserIdTrackIdMap.remove(trackId);
                continue;
            }
            Iterator<RongRtcStatForm> iterator = map.values().iterator();
            while (iterator.hasNext()) {
                RongRtcStatForm form = iterator.next();
                if (!trackId.equals(form.trackId)) continue;
                iterator.remove();
                this.mUserIdTrackIdMap.remove(form.realTrackId);
                continue block0;
            }
        }
    }

    private void onRelease() {
        if (this.mPublishs != null) {
            this.mPublishs.clear();
        }
        if (this.mReceives != null) {
            this.mReceives.clear();
        }
        if (this.mUserIdTrackIdMap != null) {
            this.mUserIdTrackIdMap.clear();
        }
        if (this.mMonitoring != null) {
            this.mMonitoring.relase();
        }
        this.mMonitoring = null;
        this.mParser = null;
        this.mPublishs = null;
        this.mReceives = null;
        this.mUserIdTrackIdMap = null;
        this.mConnectionHolder = null;
    }

    private void onGetStatus() {
        if (this.isEmpty()) {
            return;
        }
        RTCConnectionHolder connectionHolder = this.mConnectionHolder;
        if (connectionHolder != null) {
            connectionHolder.getStatus(this);
        }
    }

    private boolean isEmpty() {
        Map<String, RongRtcStatForm> publishs = this.mPublishs;
        Map<String, RongRtcStatForm> receives = this.mReceives;
        if (publishs == null || receives == null) {
            return true;
        }
        return publishs.isEmpty() && receives.isEmpty();
    }

    private void log(String fun, String msg) {
        FinLog.d(TAG, "[" + fun + "] ==> " + msg);
    }

    @Override
    public void onComplete(StatsReport[] reports) {
        this.obtainMessage(100, reports).sendToTarget();
    }

    public void setRTCConnectionHolder(RTCConnectionHolder connectionHolder) {
        this.mConnectionHolder = connectionHolder;
    }
}

