/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.sniffer;

import cn.rongcloud.rtc.imsdk.RongIMClientWrapper;
import cn.rongcloud.rtc.sniffer.SnifferInfo;
import cn.rongcloud.rtc.sniffer.SnifferListener;
import cn.rongcloud.rtc.utils.FinLog;
import io.rong.imlib.RongIMClient;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public class SnifferManager {
    private static final String TAG = "SnifferManager";
    private static final int SOTCKE_TIME_OUT = 1000;
    private static final int SNIFFER_START = 0;
    private SnifferInfo snifferInfo;
    private ArrayList<String> preHosts = new ArrayList();
    private Map<String, String> hostMap = new HashMap<String, String>();

    public static SnifferManager getInstance() {
        return SingletonHolder.instance;
    }

    public void init() {
        FinLog.d(TAG, "init()");
    }

    private SnifferManager() {
    }

    public void snifferServer(String url, final SnifferListener listener) {
        final SnifferInfo snifferInfo = new SnifferInfo(url);
        RongIMClientWrapper.getInstance().solveServerHosts(snifferInfo.getServerHost(), new RongIMClient.ResultCallback<List<String>>(){

            public void onSuccess(List<String> strings) {
                FinLog.i(SnifferManager.TAG, "Sniffer onSuccess");
                SnifferManager.this.printHosts(snifferInfo.getServerHost(), strings);
                snifferInfo.setAllHosts(strings);
                SnifferManager.this.startSniffer(snifferInfo, new SnifferListener(){

                    @Override
                    public void onSuccess(SnifferInfo snifferInfo) {
                        listener.onSuccess(snifferInfo);
                    }

                    @Override
                    public void onFailed() {
                        listener.onFailed();
                    }
                });
            }

            public void onError(RongIMClient.ErrorCode e) {
                FinLog.i(SnifferManager.TAG, "Sniffer onError :: " + e);
                listener.onFailed();
            }
        });
    }

    public void startSniffer(final SnifferInfo info, final SnifferListener listener) {
        if (info.getAllHosts() == null || info.getAllHosts().isEmpty()) {
            listener.onFailed();
        }
        final CountDownLatch countDownLatch = new CountDownLatch(info.getAllHosts().size());
        for (final String host : info.getAllHosts()) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Socket socket = null;
                    try {
                        socket = new Socket();
                        long timeStart = System.currentTimeMillis();
                        socket.connect(new InetSocketAddress(host, info.getPort()), 1000);
                        FinLog.i(SnifferManager.TAG, "connect success() SnifferInfo: " + info);
                        long timeCost = System.currentTimeMillis() - timeStart;
                        info.addOrderedHost(host, timeCost);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            if (socket != null) {
                                socket.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        countDownLatch.countDown();
                        if (countDownLatch.getCount() == 0L) {
                            if (info.getOrderedHosts().isEmpty()) {
                                listener.onFailed();
                            } else {
                                listener.onSuccess(info);
                            }
                        }
                    }
                }
            }).start();
        }
    }

    private void printHosts(String orignHost, List<String> hosts) {
        if (hosts == null || hosts.isEmpty()) {
            FinLog.i(TAG, "hosts is empty!");
        }
        this.hostMap.clear();
        StringBuilder builder = new StringBuilder();
        for (String str : hosts) {
            this.hostMap.put(str, orignHost);
            builder.append(str).append(", ");
        }
        FinLog.i(TAG, builder.substring(0, builder.length() - 1));
    }

    public String getOriginHost(String ip) {
        return this.hostMap.get(ip);
    }

    public void release() {
        this.hostMap.clear();
    }

    private static class SingletonHolder {
        private static final SnifferManager instance = new SnifferManager();

        private SingletonHolder() {
        }
    }
}

