/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.signal;

import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.base.AsyncResult;
import cn.rongcloud.rtc.base.RTCErrorCode;
import io.rong.imlib.RongIMClient;
import java.util.concurrent.locks.LockSupport;

public class SyncIMOperationCallback
extends RongIMClient.OperationCallback {
    private AsyncResult.TemporaryResult mRes = AsyncResult.create();
    private Thread mThread;
    private IRCRTCResultCallback mCallback;
    private boolean mIsSync = true;

    public SyncIMOperationCallback(boolean isSync, IRCRTCResultCallback callback) {
        this.mCallback = callback;
        this.mIsSync = isSync;
        if (this.mIsSync) {
            this.mThread = Thread.currentThread();
        }
    }

    public void onSuccess() {
        if (this.mCallback != null) {
            this.mCallback.onSuccess();
        }
        if (this.mIsSync) {
            LockSupport.unpark(this.mThread);
        }
    }

    public void onError(RongIMClient.ErrorCode errorCode) {
        RTCErrorCode rtcErrorCode = RTCErrorCode.valueOf(errorCode.getValue());
        this.mRes.setAndNotify(rtcErrorCode);
        if (this.mCallback != null) {
            this.mCallback.onFailed(rtcErrorCode);
        }
        if (this.mIsSync) {
            LockSupport.unpark(this.mThread);
        }
    }

    public AsyncResult getResult() {
        if (this.mIsSync) {
            LockSupport.park();
        }
        return this.mRes.getResult();
    }
}

