/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.signal;

import android.text.TextUtils;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.base.AsyncResult;
import cn.rongcloud.rtc.base.RCAttributeType;
import cn.rongcloud.rtc.base.RCRTCAVStreamType;
import cn.rongcloud.rtc.base.RCRTCRoomType;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.core.SessionDescription;
import cn.rongcloud.rtc.proxy.message.messagebeans.InviteInfo;
import cn.rongcloud.rtc.signal.IMSignalWrapper;
import cn.rongcloud.rtc.signal.IUpdateUdpObfuscationKeyListener;
import cn.rongcloud.rtc.signal.MediaSignalWrapper;
import cn.rongcloud.rtc.webrtc.IStreamResource;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.RTCStatusDate;
import java.util.List;
import java.util.Map;

public class SignalManager
implements IUpdateUdpObfuscationKeyListener {
    private MediaSignalWrapper mMediaSignal;
    private IMSignalWrapper mIMSignal;
    private IUpdateUdpObfuscationKeyListener mObfuscationKeyListener;
    private RongIMClient.ConnectionStatusListener.ConnectionStatus mConnectionStatus = RongIMClient.ConnectionStatusListener.ConnectionStatus.UNCONNECTED;

    public static SignalManager getInstance() {
        return SignalManagerHolder.instance;
    }

    private SignalManager() {
        this.init();
    }

    public IUpdateUdpObfuscationKeyListener getObfuscationKeyListener() {
        return this.mObfuscationKeyListener;
    }

    public void setObfuscationKeyListener(IUpdateUdpObfuscationKeyListener obfuscationKeyListener) {
        this.mObfuscationKeyListener = obfuscationKeyListener;
    }

    public int getMaxStreamCount() {
        return this.mMediaSignal.getMaxStreamCount();
    }

    public boolean imSignalIsConnected() {
        return this.mConnectionStatus == RongIMClient.ConnectionStatusListener.ConnectionStatus.CONNECTED;
    }

    public void quitLive(String liveUrl, int roomType, IRCRTCResultCallback callback) {
        this.mMediaSignal.quitLive(liveUrl, roomType, callback);
    }

    private void init() {
        this.mIMSignal = new IMSignalWrapper();
        this.mMediaSignal = new MediaSignalWrapper(this.mIMSignal, this);
    }

    public void onIMConnectChanged(RongIMClient.ConnectionStatusListener.ConnectionStatus connectionStatus) {
        this.mConnectionStatus = connectionStatus;
        this.mMediaSignal.onIMConnectChanged(connectionStatus);
    }

    public void setMediaServerUrl(String url) {
        this.mMediaSignal.setMediaServerUrl(url);
    }

    public AsyncResult<Object[]> syncSendSDPOffer(String roomId, SessionDescription sdp, String clientSessionId, List<? extends IStreamResource> pubStreams, List<? extends IStreamResource> subStreams, RCRTCRoomType roomType, String autoMixJSONInfo, String role) {
        final AsyncResult.TemporaryResult res = AsyncResult.create(Thread.currentThread(), RTCErrorCode.CANCEL_OPERATOR);
        this.mMediaSignal.sendSDPOffer(roomId, sdp, clientSessionId, pubStreams, subStreams, roomType, autoMixJSONInfo, role, new IRCRTCResultDataCallback<Object[]>(){

            @Override
            public void onSuccess(Object[] data) {
                res.setAndNotify(data);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                res.setAndNotify(errorCode);
            }
        });
        return res.waitForGetResult();
    }

    public void rtcPutInnerData(String roomId, RCAttributeType type, String key, String value, MessageContent message, IRCRTCResultCallback callback) {
        this.mIMSignal.rtcPutInnerData(roomId, type.getValue(), key, value, message, callback);
    }

    public AsyncResult syncRtcPutInnerData(String roomId, RCAttributeType type, String key, String value, MessageContent message) {
        final AsyncResult.TemporaryResult res = AsyncResult.create(Thread.currentThread(), RTCErrorCode.CANCEL_OPERATOR);
        this.mIMSignal.rtcPutInnerData(roomId, type.getValue(), key, value, message, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                res.setAndNotify(null);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                res.setAndNotify(RTCErrorCode.RongRTCCodeIMError);
            }
        });
        return res.waitForGetResult();
    }

    public boolean voipIsEnable() {
        return !TextUtils.isEmpty((CharSequence)this.mIMSignal.getVoIPInfo());
    }

    public void joinRoom(String roomId, RCRTCRoomType roomType, boolean isReJoin, IRongCallback.IRTCJoinRoomCallbackEx<Object[]> callback) {
        this.mIMSignal.joinRoom(roomId, roomType, isReJoin, callback);
    }

    public void joinOtherRoom(String roomId, RCRTCRoomType roomType, String key, String value, IRongCallback.IRTCJoinRoomCallbackEx<Object[]> callback) {
        this.mIMSignal.joinOtherRoom(roomId, roomType, key, value, callback);
    }

    public AsyncResult<SessionDescription> syncSubscribeSDP(String roomId, RCRTCRoomType roomType, String clientSessionId, List<? extends IStreamResource> allSubStreams, List<? extends IStreamResource> allPubStreams) {
        final AsyncResult.TemporaryResult tmp = AsyncResult.create(Thread.currentThread(), RTCErrorCode.CANCEL_OPERATOR);
        this.mMediaSignal.subscribeSDP(roomId, roomType, clientSessionId, allSubStreams, allPubStreams, new IRCRTCResultDataCallback<SessionDescription>(){

            @Override
            public void onSuccess(SessionDescription data) {
                tmp.setAndNotify(data);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                tmp.setAndNotify(errorCode);
            }
        });
        return tmp.waitForGetResult();
    }

    public AsyncResult syncRTCSetUserResource(String roomId, RTCStatusDate[] kv, String objNameTotalContent, RTCStatusDate[] content) {
        return this.mIMSignal.rtcSetUserResource(roomId, kv, objNameTotalContent, content, true, null);
    }

    public void rtcSetUserResource(String roomId, RTCStatusDate[] kv, String objNameTotalContent, RTCStatusDate[] content, IRCRTCResultCallback callback) {
        this.mIMSignal.rtcSetUserResource(roomId, kv, objNameTotalContent, content, false, callback);
    }

    public AsyncResult<SessionDescription> syncSubscribeLive(SessionDescription sessionDescription, String liveUrl, RCRTCAVStreamType avStreamType) {
        final AsyncResult.TemporaryResult tmp = AsyncResult.create(Thread.currentThread(), RTCErrorCode.CANCEL_OPERATOR);
        this.mMediaSignal.subscribeLive(sessionDescription, liveUrl, avStreamType, new IRCRTCResultDataCallback<SessionDescription>(){

            @Override
            public void onSuccess(SessionDescription data) {
                tmp.setAndNotify(data);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                tmp.setAndNotify(errorCode);
            }
        });
        return tmp.waitForGetResult();
    }

    public AsyncResult syncResolutionChanged(String roomId, RCRTCRoomType roomType, String clientSessionId, List<? extends IStreamResource> pubStreamRes) {
        final AsyncResult.TemporaryResult tmp = AsyncResult.create(Thread.currentThread(), RTCErrorCode.CANCEL_OPERATOR);
        this.mMediaSignal.onResolutionChanged(roomId, roomType, clientSessionId, pubStreamRes, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                tmp.setAndNotify(null);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                tmp.setAndNotify(errorCode);
            }
        });
        return tmp.waitForGetResult();
    }

    public void leaveRoom(final String roomId, final RCRTCRoomType roomType, final String clientSessionId, final IRCRTCResultCallback callback) {
        this.mIMSignal.leaveRoom(roomId, new IRCRTCResultCallback(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                SignalManager.this.mMediaSignal.quit(roomId, roomType, clientSessionId, null);
                if (callback != null) {
                    callback.onFailed(errorCode);
                }
            }

            @Override
            public void onSuccess() {
                SignalManager.this.mMediaSignal.quit(roomId, roomType, clientSessionId, null);
                if (callback != null) {
                    callback.onSuccess();
                }
            }
        });
    }

    public void sendleaveOtherRoomMessage(String roomId, IRCRTCResultCallback callBack) {
        this.mIMSignal.sendleaveOtherRoomMessage(roomId, callBack);
    }

    public void sendRTCPing(String roomId, RongIMClient.OperationCallback callback) {
        this.mIMSignal.sendRTCPing(roomId, callback);
    }

    public void getRTCConfig(String model, String osVersion, long timestamp, String sdkVersion, IRCRTCResultDataCallback<String> callback) {
        this.mIMSignal.getRTCConfig(model, osVersion, timestamp, sdkVersion, callback);
    }

    public void setAttributeValue(String roomId, RCAttributeType type, String key, String value, MessageContent message, IRCRTCResultCallback callback) {
        this.mIMSignal.setAttributeValue(roomId, type, key, value, message, callback);
    }

    public void deleteAttributes(String roomId, RCAttributeType type, List<String> attributeKeys, MessageContent message, IRCRTCResultCallback callback) {
        this.mIMSignal.deleteAttributes(roomId, type, attributeKeys, message, callback);
    }

    public void getAttributes(String roomId, RCAttributeType type, List<String> attributeKeys, IRCRTCResultDataCallback<Map<String, String>> callback) {
        this.mIMSignal.getAttributes(roomId, type, attributeKeys, callback);
    }

    public void sendIMSignal(String roomId, MessageContent messageContent, IRongCallback.ISendMessageCallback callback) {
        this.mIMSignal.sendIMSignal(roomId, messageContent, callback);
    }

    public void requestJoinOtherRoom(String inviteeRoomId, String inviteeUserId, String mainRoomId, int timeoutTime, String inviteSessionId, String inviteInfo, IRCRTCResultCallback callback) {
        this.mIMSignal.requestJoinOtherRoom(inviteeRoomId, inviteeUserId, mainRoomId, timeoutTime, inviteSessionId, inviteInfo, callback);
    }

    public void cancelRequestJoinOtherRoom(String inviteeRoomId, String inviteeUserId, String mainRoomId, String localUserId, String inviteSessionId, String extra, IRCRTCResultCallback callback) {
        this.mIMSignal.cancelRequestJoinOtherRoom(inviteeRoomId, inviteeUserId, mainRoomId, localUserId, inviteSessionId, extra, callback);
    }

    public void responseJoinOtherRoom(String inviterRoomId, String inviterUserId, boolean agree, String extra, boolean autoMix, String mainRoomId, InviteInfo inviteInfo, String key, String inviteSessionId, IRCRTCResultCallback callback) {
        this.mIMSignal.responseJoinOtherRoom(inviterRoomId, inviterUserId, agree, extra, autoMix, mainRoomId, inviteInfo, key, inviteSessionId, callback);
    }

    public void finishOtherRoom(String otherRoomId, String extra, String mainRoomId, String inviteSessionId, String localUserId, String[] keys, IRCRTCResultCallback callback) {
        this.mIMSignal.finishOtherRoom(otherRoomId, extra, mainRoomId, inviteSessionId, localUserId, keys, callback);
    }

    public void setMCUConfig(String serverUrl, String roomId, String sessionId, String configJson, IRCRTCResultDataCallback<String> callBack) {
        this.mMediaSignal.setMCUConfig(serverUrl, roomId, sessionId, configJson, callBack);
    }

    @Override
    public void onUpdate(String key) {
        if (this.mObfuscationKeyListener != null) {
            this.mObfuscationKeyListener.onUpdate(key);
        }
    }

    public void setRtcToken(String rtcToken) {
        this.mMediaSignal.setRtcToken(rtcToken);
    }

    public void reset() {
        this.mMediaSignal.reset();
    }

    private static class SignalManagerHolder {
        private static SignalManager instance = new SignalManager();

        private SignalManagerHolder() {
        }
    }
}

