/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.signal;

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.base.AsyncResult;
import cn.rongcloud.rtc.base.RCRTCAVStreamType;
import cn.rongcloud.rtc.base.RCRTCRoomType;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.core.SessionDescription;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.live.LiveSubscribeTools;
import cn.rongcloud.rtc.media.http.HttpClient;
import cn.rongcloud.rtc.media.http.Request;
import cn.rongcloud.rtc.media.http.Response;
import cn.rongcloud.rtc.proxy.message.messagebeans.MediaResourceInfo;
import cn.rongcloud.rtc.signal.IMSignalWrapper;
import cn.rongcloud.rtc.signal.IUpdateUdpObfuscationKeyListener;
import cn.rongcloud.rtc.sniffer.SnifferInfo;
import cn.rongcloud.rtc.sniffer.SnifferListener;
import cn.rongcloud.rtc.sniffer.SnifferManager;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import cn.rongcloud.rtc.webrtc.ILocalVideoStreamResource;
import cn.rongcloud.rtc.webrtc.IRemoteVideoStreamResource;
import cn.rongcloud.rtc.webrtc.IStreamResource;
import io.rong.common.RLog;
import io.rong.imlib.IMLibRTCClient;
import io.rong.imlib.RongIMClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaSignalWrapper {
    private static final String TAG = "MediaSignalWrapper";
    private static String RONG_RTC_CONFIG_SERVER_URL = "MESERVER";
    private static final int LIVE_ROOM_TYPE = 2;
    private static final int RESPONSE_OK = 10000;
    private static String RONG_RTC_MEDIA_SERVER_URL = "";
    private static String EXCHANGE_SDP = "/exchange";
    private static String EXIT = "/exit";
    private final String SUBSCRIBE_SDP = "/subscribe";
    private final String SUBSCRIBE_LIVE_SDP = "/broadcast/subscribe ";
    private final String EXIT_LIVE = "/broadcast/exit ";
    private static String CHANGERESOLUTION = "/server/resolution/change";
    private static final String FEATURE_SUPPORT_OBFUSCATION = "Udp-Obfuscation";
    private static final String HEAD_CLIENT_SESSION_ID = "Client-Session-Id";
    private static final String HEAD_REQUEST_ID = "Request-Id";
    private String clusterId;
    private String rtcToken;
    private String[] mOrderedMediaServer;
    private int mediaServerIndex;
    private String liveRtcToken;
    private static String mediaServer;
    private int maxStreamCount;
    private static final int ENGINE_RTC = 4;
    private boolean isSniffing;
    private long lastSnifferTime = 0L;
    private final int TWO_HOURS = 0x6DDD00;
    private static final String PREFIX_HTTP = "http://";
    private static final String PREFIX_HTTPS = "https://";
    private IUpdateUdpObfuscationKeyListener mObfuscationKeyListener;
    private int retry = 0;
    private IMSignalWrapper mImSignal;

    public MediaSignalWrapper(IMSignalWrapper imSignal, IUpdateUdpObfuscationKeyListener obfuscationKeyListener) {
        this.mObfuscationKeyListener = obfuscationKeyListener;
        this.mImSignal = imSignal;
    }

    public String getLiveRtcToken() {
        return this.liveRtcToken;
    }

    public String getRtcToken() {
        return this.rtcToken;
    }

    public void setRtcToken(String token) {
        FinLog.i(TAG, "setRtcToken :: " + token);
        this.rtcToken = token;
    }

    public void setMediaServerUrl(String url) {
        RONG_RTC_MEDIA_SERVER_URL = url;
        FinLog.d(TAG, "setMediaServerUrl as:: " + url);
    }

    private String getMediaServer() {
        if (!TextUtils.isEmpty((CharSequence)this.clusterId)) {
            return this.clusterId;
        }
        if (!TextUtils.isEmpty((CharSequence)RONG_RTC_MEDIA_SERVER_URL)) {
            return RONG_RTC_MEDIA_SERVER_URL;
        }
        if (this.mOrderedMediaServer == null || this.mOrderedMediaServer.length == 0) {
            FinLog.i(TAG, "getMediaServer() return null !");
            this.parseVoIPInfo();
            if (this.mOrderedMediaServer == null || this.mOrderedMediaServer.length == 0) {
                return null;
            }
        }
        String tmpMediaServer = "";
        for (int i = 0; i < this.mOrderedMediaServer.length; ++i) {
            if (TextUtils.isEmpty((CharSequence)this.mOrderedMediaServer[i])) continue;
            tmpMediaServer = this.mOrderedMediaServer[i];
            break;
        }
        FinLog.i(TAG, "Valid media server address :" + tmpMediaServer);
        return tmpMediaServer;
    }

    public void onIMConnectChanged(RongIMClient.ConnectionStatusListener.ConnectionStatus status) {
        boolean expired;
        RLog.i((String)TAG, (String)("onIMConnectChanged status " + status));
        if (this.mOrderedMediaServer == null && status == RongIMClient.ConnectionStatusListener.ConnectionStatus.CONNECTED) {
            this.parseVoIPInfo();
        }
        boolean bl = expired = System.currentTimeMillis() - this.lastSnifferTime >= 0x6DDD00L;
        if (expired && status == RongIMClient.ConnectionStatusListener.ConnectionStatus.CONNECTED && !RTCEngineImpl.getInstance().isInRoom() && !TextUtils.isEmpty((CharSequence)mediaServer)) {
            RLog.i((String)TAG, (String)"onIMConnectChanged sniff ");
            this.isSniffing = true;
            this.lastSnifferTime = System.currentTimeMillis();
            SnifferManager.getInstance().snifferServer(mediaServer, new SnifferListener(){

                @Override
                public void onSuccess(SnifferInfo snifferInfo) {
                    RLog.i((String)MediaSignalWrapper.TAG, (String)"sniff success() :");
                    MediaSignalWrapper.this.printOrderedServer("before sniff host add ", MediaSignalWrapper.this.mOrderedMediaServer);
                    try {
                        int sizeServers = MediaSignalWrapper.this.mOrderedMediaServer.length - MediaSignalWrapper.this.mediaServerIndex;
                        int sizeHost = snifferInfo.getOrderedHosts().size();
                        String[] temp = new String[sizeServers + sizeHost];
                        List<String> orderHosts = snifferInfo.getOrderedHosts();
                        String[] hosts = orderHosts.toArray(new String[0]);
                        System.arraycopy(hosts, 0, temp, 0, hosts.length);
                        System.arraycopy(MediaSignalWrapper.this.mOrderedMediaServer, MediaSignalWrapper.this.mediaServerIndex, temp, hosts.length, sizeServers);
                        MediaSignalWrapper.this.mediaServerIndex = hosts.length;
                        MediaSignalWrapper.access$002(MediaSignalWrapper.this, temp);
                    }
                    catch (Exception e) {
                        FinLog.e(MediaSignalWrapper.TAG, "handle sniffer result error: " + e.getMessage());
                    }
                    MediaSignalWrapper.this.printOrderedServer("after sniff host add ", MediaSignalWrapper.this.mOrderedMediaServer);
                    MediaSignalWrapper.this.isSniffing = false;
                }

                @Override
                public void onFailed() {
                    MediaSignalWrapper.this.isSniffing = false;
                    RLog.i((String)MediaSignalWrapper.TAG, (String)"sniff failed()");
                }
            });
        }
    }

    private void parseVoIPInfo() {
        if (RONG_RTC_CONFIG_SERVER_URL.contains("http")) {
            mediaServer = RONG_RTC_CONFIG_SERVER_URL;
            FinLog.i(TAG, "Change mediaServer as configured: " + mediaServer);
        }
        if (!TextUtils.isEmpty((CharSequence)RONG_RTC_MEDIA_SERVER_URL)) {
            mediaServer = RONG_RTC_MEDIA_SERVER_URL;
            FinLog.i(TAG, "Change mediaServer as set: " + mediaServer);
        }
        if (!TextUtils.isEmpty((CharSequence)mediaServer)) {
            this.mOrderedMediaServer = new String[1];
            this.mOrderedMediaServer[0] = mediaServer;
            mediaServer = this.solveAddress();
            return;
        }
        try {
            String voIPInfo = IMLibRTCClient.getInstance().getVoIPInfo();
            if (TextUtils.isEmpty((CharSequence)voIPInfo)) {
                FinLog.e(TAG, "Can't get VoIP info: please check whether is VoIP service available!!");
                return;
            }
            ReportUtil.libStatus(ReportUtil.TAG.RTCNAVIDATA, "navi", voIPInfo);
            JSONObject jsonObject = new JSONObject(voIPInfo);
            JSONArray jsonArray = jsonObject.getJSONArray("callEngine");
            boolean isRTCEngine = false;
            for (int i = 0; i < jsonArray.length(); ++i) {
                int timeOut;
                JSONObject rtcInfo = (JSONObject)jsonArray.get(i);
                if (rtcInfo.getInt("engineType") != 4) continue;
                isRTCEngine = true;
                mediaServer = rtcInfo.getString("mediaServer");
                this.mOrderedMediaServer = new String[1];
                this.mOrderedMediaServer[0] = mediaServer;
                this.maxStreamCount = rtcInfo.getInt("maxStreamCount");
                JSONArray backupMediaServer = rtcInfo.optJSONArray("backupMediaServer");
                FinLog.i(TAG, "backupMediaServers::" + backupMediaServer);
                if (backupMediaServer != null) {
                    int j;
                    int length = backupMediaServer.length();
                    int start = this.mOrderedMediaServer.length;
                    String[] temp = new String[start + length];
                    for (j = 0; j < start; ++j) {
                        temp[j] = this.mOrderedMediaServer[j];
                    }
                    for (j = 0; j < length; ++j) {
                        temp[start + j] = backupMediaServer.optString(j);
                    }
                    this.mOrderedMediaServer = temp;
                }
                if (rtcInfo.has("timeOut") && (timeOut = rtcInfo.optInt("timeOut")) > 0) {
                    FinLog.d(TAG, "change timeOut as nav config : " + timeOut);
                    HttpClient.getDefault().CONNECT_TIME_OUT = timeOut * 1000;
                }
                mediaServer = this.solveAddress();
                this.printOrderedServer("nav parseVoIPInfo end ", this.mOrderedMediaServer);
            }
            if (!isRTCEngine) {
                FinLog.e(TAG, "Current selection is not RTC Engine. Please check navigation settings:: " + voIPInfo);
            }
        }
        catch (Exception e) {
            FinLog.e(TAG, "parseVoIPInfo error: " + e.getMessage());
        }
    }

    private void printOrderedServer(String info, String[] orderedServer) {
        if (orderedServer == null) {
            FinLog.i(TAG, "printOrderedServer orderedServer is null!");
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (String str : orderedServer) {
            builder.append(str);
            builder.append(", ");
        }
        String servers = builder.substring(0, builder.length() - 2);
        FinLog.i(TAG, info + "printOrderedServer: " + servers);
    }

    private String solveAddress() {
        if (null != this.mOrderedMediaServer) {
            ArrayList<String> addresses = new ArrayList<String>();
            for (int i = 0; i < this.mOrderedMediaServer.length; ++i) {
                String address = this.mOrderedMediaServer[i];
                if (!address.contains("http")) {
                    if (!addresses.contains(PREFIX_HTTP + address)) {
                        addresses.add(PREFIX_HTTP + address);
                    }
                    if (addresses.contains(PREFIX_HTTPS + address)) continue;
                    addresses.add(PREFIX_HTTPS + address);
                    continue;
                }
                if (addresses.contains(address)) continue;
                addresses.add(address);
            }
            String[] newAddress = new String[addresses.size()];
            this.mOrderedMediaServer = newAddress;
            for (int i = 0; i < this.mOrderedMediaServer.length; ++i) {
                this.mOrderedMediaServer[i] = (String)addresses.get(i);
            }
            FinLog.d(TAG, "mOrderedMediaServer = " + Arrays.toString(this.mOrderedMediaServer));
            return this.mOrderedMediaServer[0];
        }
        return mediaServer;
    }

    private int getBackupMediaServerIndex() {
        return 0;
    }

    public void sendSDPOffer(String roomId, SessionDescription sdp, String clientSessionId, List<? extends IStreamResource> pubStreams, List<? extends IStreamResource> subStreams, RCRTCRoomType roomType, String autoMixJSONInfo, String role, IRCRTCResultDataCallback<Object[]> callback) {
        this.sendSDPOffer(roomId, sdp, this.getMediaServer(), false, clientSessionId, this.getBackupMediaServerIndex(), pubStreams, subStreams, roomType.getRoomType(), roomType.getMediaType(), autoMixJSONInfo, role, callback);
    }

    private void sendSDPOffer(final String roomId, final SessionDescription sdp, final String mediaServerAddress, final boolean isRetry, final String clientSessionId, final int backupIndex, final List<? extends IStreamResource> pubStreams, final List<? extends IStreamResource> subStreams, final int roomType, final int liveType, final String autoMixJSONInfo, final String role, final IRCRTCResultDataCallback<Object[]> callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            if (callback != null) {
                callback.onFailed(RTCErrorCode.RongRTCCodeNotInRoom);
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.rtcToken)) {
            ReportUtil.libError(ReportUtil.TAG.SDPEXCHANGE, "roomId|code|desc", roomId, RTCErrorCode.RongRTCCodeRTCTokenIsNull.getValue(), RTCErrorCode.RongRTCCodeRTCTokenIsNull.getReason());
            if (callback != null) {
                callback.onFailed(RTCErrorCode.RongRTCCodeRTCTokenIsNull);
            }
            return;
        }
        JSONObject exchangeSDP = new JSONObject();
        try {
            JSONObject sdpJson = new JSONObject();
            JSONObject extendJson = this.getExtentInfo(pubStreams, role);
            JSONArray subscribeArray = this.parseSubscribeList(subStreams);
            ReportUtil.libTask(ReportUtil.TAG.SDPEXCHANGE, "roomId|mediaUrl|isRetry|subList|sdp", roomId, mediaServerAddress, isRetry, subscribeArray.toString(), sdp.toJsonString());
            sdpJson.put("type", (Object)sdp.type.name().toLowerCase());
            sdpJson.put("sdp", (Object)sdp.description);
            exchangeSDP.put("sdp", (Object)sdpJson);
            exchangeSDP.put("subscribeList", (Object)subscribeArray);
            exchangeSDP.put("resolutionInfo", (Object)this.getResolutionInfo(pubStreams));
            exchangeSDP.put("token", (Object)this.rtcToken);
            exchangeSDP.put("extend", (Object)extendJson);
            if (!(roomType != RCRTCRoomType.LIVE_AUDIO.getRoomType() && roomType != RCRTCRoomType.LIVE_AUDIO_VIDEO.getRoomType() || TextUtils.isEmpty((CharSequence)autoMixJSONInfo))) {
                JSONArray jsonArray = new JSONArray(autoMixJSONInfo);
                exchangeSDP.put("pushOtherRooms", (Object)jsonArray);
                FinLog.i(TAG, "sendSDPOffer autoMixJSON: " + autoMixJSONInfo);
                ReportUtil.libStatus(ReportUtil.TAG.SDPEXCHANGE, "pushOtherRooms", autoMixJSONInfo);
            }
            FinLog.i(TAG, "sendSDPOffer extend: " + extendJson);
        }
        catch (JSONException e) {
            e.printStackTrace();
            ReportUtil.libError(ReportUtil.TAG.SDPEXCHANGE, "roomId|code|desc", roomId, RTCErrorCode.RongRTCCodeParameterError.getValue(), e.getMessage());
            if (callback != null) {
                callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            }
            return;
        }
        Request request = this.getRequest(roomId, roomType, clientSessionId, EXCHANGE_SDP, mediaServerAddress, exchangeSDP);
        HttpClient.getDefault().request(request, new HttpClient.ResultCallback(){

            @Override
            public void onResponse(String result) {
                block19: {
                    try {
                        JSONObject jsonObject = new JSONObject(result);
                        String resultCode = jsonObject.getString("resultCode");
                        int reposeCode = Integer.parseInt(resultCode);
                        if (reposeCode == 10000) {
                            MediaSignalWrapper.this.changeMediaServer2ClusterId(jsonObject);
                            JSONObject sdpObject = jsonObject.getJSONObject("sdp");
                            String sdpInfo = sdpObject.getString("sdp");
                            String type = sdpObject.getString("type");
                            SessionDescription.Type descriptionType = SessionDescription.Type.ANSWER;
                            if (!TextUtils.isEmpty((CharSequence)type)) {
                                if (type.equals("answer")) {
                                    descriptionType = SessionDescription.Type.ANSWER;
                                } else if (type.equals("offer")) {
                                    descriptionType = SessionDescription.Type.OFFER;
                                }
                            }
                            SessionDescription remoteDescription = new SessionDescription(descriptionType, sdpInfo);
                            JSONArray jsonArray = jsonObject.getJSONArray("publishList");
                            FinLog.d(MediaSignalWrapper.TAG, "sendSDPOffer success res = \n" + jsonArray.toString());
                            JSONObject urlsObject = null;
                            String urls = "";
                            if (jsonObject.has("urls") && (urlsObject = jsonObject.optJSONObject("urls")) != null) {
                                urls = urlsObject.toString();
                            }
                            MediaSignalWrapper.this.parseUDPObfuscation(jsonObject);
                            List publishMediaInfoList = MediaSignalWrapper.this.parsePublishList(jsonArray);
                            ReportUtil.libRes(ReportUtil.TAG.SDPEXCHANGE, "roomId|liveInfo|clusterId|code|pubList|sdp", roomId, urls, MediaSignalWrapper.this.clusterId, 0, jsonArray.toString(), remoteDescription.toJsonString());
                            if (callback != null) {
                                callback.onSuccess(new Object[]{remoteDescription, publishMediaInfoList, urlsObject});
                            }
                        } else {
                            RTCErrorCode errorCode = RTCErrorCode.valueOf(reposeCode);
                            if (errorCode == RTCErrorCode.RongRTCCodeTokenInvalid) {
                                ReportUtil.libError(ReportUtil.TAG.SDPEXCHANGE, "roomId|code|desc", roomId, errorCode.getValue(), result);
                                if (MediaSignalWrapper.this.retry > 0) {
                                    MediaSignalWrapper.this.retry = 0;
                                    if (callback != null) {
                                        callback.onFailed(RTCErrorCode.RongRTCCodeTokenInvalid);
                                    }
                                } else {
                                    MediaSignalWrapper.this.retry++;
                                    AsyncResult<String> tokenRes = MediaSignalWrapper.this.mImSignal.syncGetRTCToken(roomId, roomType, liveType);
                                    if (tokenRes.isFailed()) {
                                        MediaSignalWrapper.this.retry = 0;
                                        if (callback != null) {
                                            callback.onFailed(tokenRes.getErrorCode());
                                        }
                                    }
                                    MediaSignalWrapper.this.rtcToken = tokenRes.getData();
                                    MediaSignalWrapper.this.sendSDPOffer(roomId, sdp, mediaServerAddress, isRetry, clientSessionId, backupIndex, pubStreams, subStreams, roomType, liveType, autoMixJSONInfo, role, callback);
                                }
                            } else {
                                ReportUtil.libError(ReportUtil.TAG.SDPEXCHANGE, "roomId|code|desc", roomId, errorCode.getValue(), result);
                                if (callback != null) {
                                    callback.onFailed(errorCode);
                                }
                            }
                        }
                    }
                    catch (JSONException e) {
                        ReportUtil.libError(ReportUtil.TAG.SDPEXCHANGE, "roomId|code|desc", roomId, RTCErrorCode.JsonParseError.getValue(), "Exception: " + e.getMessage() + " , result: " + result);
                        MediaSignalWrapper.this.retrySendSDPOffer(roomId, sdp, clientSessionId, backupIndex, RTCErrorCode.JsonParseError, pubStreams, subStreams, roomType, liveType, autoMixJSONInfo, role, callback);
                    }
                    catch (Exception e) {
                        ReportUtil.libError(ReportUtil.TAG.SDPEXCHANGE, "roomId|code|desc", roomId, RTCErrorCode.UnknownError.getValue(), "Exception: " + e.getMessage() + " , result: " + result);
                        if (callback == null) break block19;
                        callback.onFailed(RTCErrorCode.UnknownError);
                    }
                }
            }

            @Override
            public void onFailure(int errorCode) {
                ReportUtil.libError(ReportUtil.TAG.SDPEXCHANGE, 2, "roomId|code|desc", roomId, errorCode, "sendSDPOffer onFailure");
                MediaSignalWrapper.this.retrySendSDPOffer(roomId, sdp, clientSessionId, backupIndex, RTCErrorCode.valueOf(errorCode), pubStreams, subStreams, roomType, liveType, autoMixJSONInfo, role, callback);
            }
        });
    }

    public void subscribeSDP(String roomId, RCRTCRoomType roomType, String clientSessionId, List<? extends IStreamResource> subStreams, List<? extends IStreamResource> pubStreams, IRCRTCResultDataCallback<SessionDescription> callback) {
        this.subscribe(roomId, roomType, clientSessionId, this.getMediaServer(), subStreams, pubStreams, callback);
    }

    private void subscribe(final String roomId, RCRTCRoomType roomType, String clientSessionId, String mediaServerAddress, List<? extends IStreamResource> subStreams, List<? extends IStreamResource> pubStreams, final IRCRTCResultDataCallback<SessionDescription> callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            if (callback != null) {
                callback.onFailed(RTCErrorCode.RongRTCCodeNotInRoom);
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.rtcToken)) {
            ReportUtil.libError(ReportUtil.TAG.SUBSCRIBEAVSTREAM, "code|desc", RTCErrorCode.RongRTCCodeRTCTokenIsNull.getValue(), RTCErrorCode.RongRTCCodeRTCTokenIsNull.getReason());
            if (callback != null) {
                callback.onFailed(RTCErrorCode.RongRTCCodeRTCTokenIsNull);
            }
            return;
        }
        JSONObject subscribeInfo = new JSONObject();
        try {
            JSONArray subscribeArray = this.parseSubscribeList(subStreams);
            ReportUtil.libTask(ReportUtil.TAG.SUBSCRIBEAVSTREAM, "roomId|mediaUrl|subList", roomId, mediaServerAddress, subscribeArray.toString());
            subscribeInfo.put("subscribeList", (Object)subscribeArray);
            subscribeInfo.put("resolutionInfo", (Object)this.getResolutionInfo(pubStreams));
            subscribeInfo.put("token", (Object)this.rtcToken);
            FinLog.i(TAG, "subscribe subscribeList: " + subscribeArray);
        }
        catch (JSONException e) {
            ReportUtil.libError(ReportUtil.TAG.SUBSCRIBEAVSTREAM, "roomId|code|desc", roomId, RTCErrorCode.RongRTCCodeParameterError.getValue(), e.getMessage());
            e.printStackTrace();
            if (callback != null) {
                callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            }
            return;
        }
        Request request = this.getRequest(roomId, roomType.getRoomType(), clientSessionId, "/subscribe", mediaServerAddress, subscribeInfo);
        HttpClient.getDefault().request(request, new HttpClient.ResultCallback(){

            @Override
            public void onResponse(String result) {
                block12: {
                    try {
                        JSONObject jsonObject = new JSONObject(result);
                        String resultCode = jsonObject.getString("resultCode");
                        int reposeCode = Integer.parseInt(resultCode);
                        if (reposeCode == 10000) {
                            FinLog.d(MediaSignalWrapper.TAG, "subscribe sdp success");
                            JSONObject sdpObject = jsonObject.getJSONObject("sdp");
                            String sdpInfo = sdpObject.getString("sdp");
                            String type = sdpObject.getString("type");
                            SessionDescription.Type descriptionType = SessionDescription.Type.ANSWER;
                            if (!TextUtils.isEmpty((CharSequence)type)) {
                                if (type.equals("answer")) {
                                    descriptionType = SessionDescription.Type.ANSWER;
                                } else if (type.equals("offer")) {
                                    descriptionType = SessionDescription.Type.OFFER;
                                }
                            }
                            SessionDescription remoteDescription = new SessionDescription(descriptionType, sdpInfo);
                            ReportUtil.libRes(ReportUtil.TAG.SUBSCRIBEAVSTREAM, "roomId|code|SDP", roomId, 0, sdpObject.toString());
                            MediaSignalWrapper.this.parseUDPObfuscation(jsonObject);
                            if (callback != null) {
                                callback.onSuccess(remoteDescription);
                            }
                        } else {
                            RTCErrorCode errorCode = RTCErrorCode.valueOf(reposeCode);
                            ReportUtil.libError(ReportUtil.TAG.SUBSCRIBEAVSTREAM, "roomId|code|desc", roomId, errorCode.getValue(), result);
                            if (callback != null) {
                                callback.onFailed(errorCode);
                            }
                        }
                    }
                    catch (JSONException e) {
                        ReportUtil.libError(ReportUtil.TAG.SUBSCRIBEAVSTREAM, "roomId|code|desc", roomId, RTCErrorCode.JsonParseError.getValue(), "Exception: " + e.getMessage() + " , result: " + result);
                        if (callback != null) {
                            callback.onFailed(RTCErrorCode.JsonParseError);
                        }
                    }
                    catch (Exception e) {
                        ReportUtil.libError(ReportUtil.TAG.SUBSCRIBEAVSTREAM, "roomId|code|desc", roomId, RTCErrorCode.UnknownError.getValue(), "Exception: " + e.getMessage() + " , result: " + result);
                        if (callback == null) break block12;
                        callback.onFailed(RTCErrorCode.UnknownError);
                    }
                }
            }

            @Override
            public void onFailure(int errorCode) {
                ReportUtil.libError(ReportUtil.TAG.SUBSCRIBEAVSTREAM, 2, "roomId|code|desc", roomId, errorCode, "HttpRequest Failed");
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode));
                }
            }
        });
    }

    public void onResolutionChanged(String roomId, RCRTCRoomType roomType, String clientSessionId, List<? extends IStreamResource> pubStreamRes, final IRCRTCResultCallback callback) {
        this.changeResolution(roomId, roomType.getRoomType(), clientSessionId, this.getMediaServer(), pubStreamRes, -1, new IRCRTCResultDataCallback<String>(){

            @Override
            public void onSuccess(String data) {
                block6: {
                    try {
                        JSONObject jsonObject = new JSONObject(data);
                        String resultCode = jsonObject.getString("resultCode");
                        int reposeCode = Integer.parseInt(resultCode);
                        if (reposeCode == 10000) {
                            FinLog.v(MediaSignalWrapper.TAG, "onResolutionChanged() success");
                            if (callback != null) {
                                callback.onSuccess();
                            }
                        } else {
                            RTCErrorCode errorCode = RTCErrorCode.valueOf(reposeCode);
                            FinLog.v(MediaSignalWrapper.TAG, "onResolutionChanged() failed errorCode: " + (Object)((Object)errorCode));
                            if (callback != null) {
                                callback.onFailed(errorCode);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callback == null) break block6;
                        callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
                    }
                }
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                FinLog.v(MediaSignalWrapper.TAG, "onResolutionChanged() onFailure() errorCode: " + (Object)((Object)errorCode));
                if (callback != null) {
                    callback.onFailed(errorCode);
                }
            }
        });
    }

    private void changeResolution(final String roomId, final int roomType, final String clientSessionId, String mediaServerAddress, final List<? extends IStreamResource> pubStreamRes, final int backupIndex, final IRCRTCResultDataCallback<String> callback) {
        JSONObject resolutionInfo = new JSONObject();
        try {
            resolutionInfo.put("resolutionInfo", (Object)this.getResolutionInfo(pubStreamRes));
            FinLog.i(TAG, "changeResolution:: " + resolutionInfo.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            if (callback != null) {
                callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            }
            return;
        }
        Request request = this.getRequest(roomId, roomType, clientSessionId, CHANGERESOLUTION, mediaServerAddress, resolutionInfo, false);
        HttpClient.getDefault().request(request, new HttpClient.ResultCallback(){

            @Override
            public void onResponse(String result) {
                if (callback != null) {
                    callback.onSuccess(result);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (MediaSignalWrapper.this.needRetry(backupIndex)) {
                    MediaSignalWrapper.this.changeResolution(roomId, roomType, clientSessionId, MediaSignalWrapper.this.mOrderedMediaServer[backupIndex + 1], pubStreamRes, backupIndex + 1, callback);
                } else if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode));
                }
            }
        });
    }

    public void quit(String roomId, RCRTCRoomType roomType, String clientSessionId, IRCRTCResultCallback callback) {
        this.quit(roomId, roomType.getRoomType(), clientSessionId, this.getMediaServer(), callback);
    }

    private void quit(final String roomId, int roomType, String clientSessionId, String mediaServer, final IRCRTCResultCallback callback) {
        JSONObject quitInfo;
        block3: {
            if (TextUtils.isEmpty((CharSequence)roomId)) {
                callback.onFailed(RTCErrorCode.RongRTCCodeNotInRoom);
                return;
            }
            ReportUtil.libTask(ReportUtil.TAG.LEAVEROOM, "roomId|mediaUrl ", roomId, mediaServer);
            quitInfo = new JSONObject();
            try {
                quitInfo.put("token", (Object)this.getRtcToken());
            }
            catch (JSONException e) {
                e.printStackTrace();
                ReportUtil.libError(ReportUtil.TAG.LEAVEROOM, RTCErrorCode.RongRTCCodeParameterError, "roomId", roomId);
                if (callback == null) break block3;
                callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            }
        }
        this.request(roomId, roomType, clientSessionId, EXIT, mediaServer, quitInfo, false, this.getBackupMediaServerIndex(), new HttpClient.ResultCallback(){

            @Override
            public void onResponse(String result) {
                block6: {
                    try {
                        JSONObject jsonObject = new JSONObject(result);
                        String resultCode = jsonObject.getString("resultCode");
                        if (resultCode.equals("10000")) {
                            ReportUtil.libRes(ReportUtil.TAG.LEAVEROOM, roomId);
                            if (callback != null) {
                                callback.onSuccess();
                            }
                            break block6;
                        }
                        ReportUtil.libError(ReportUtil.TAG.LEAVEROOM, "roomId|code|desc", roomId, resultCode, "Server Result: " + result);
                        if (callback == null) break block6;
                        int errorCode = -1;
                        try {
                            errorCode = Integer.valueOf(resultCode);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        callback.onFailed(RTCErrorCode.valueOf(errorCode));
                    }
                    catch (JSONException e) {
                        ReportUtil.libError(ReportUtil.TAG.LEAVEROOM, "roomId|code|desc", roomId, RTCErrorCode.JsonParseError.getValue(), "JSONException:" + e.getMessage());
                        if (callback == null) break block6;
                        callback.onFailed(RTCErrorCode.JsonParseError);
                    }
                }
            }

            @Override
            public void onFailure(int errorCode) {
                ReportUtil.libError(ReportUtil.TAG.LEAVEROOM, "roomId|code|desc", roomId, errorCode, "Http Request Failed");
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode));
                }
            }
        });
    }

    private AsyncResult<String> syncRequest(String roomId, int roomType, String clientSessionId, String command, String mediaServerAddress, JSONObject body, boolean isAudience, int backupIndex) {
        Request request = this.getRequest(roomId, roomType, clientSessionId, command, mediaServerAddress, body, isAudience);
        Response<String> res = HttpClient.getDefault().syncRequest(request);
        if (res.isSuccess()) {
            return AsyncResult.create(res.getData()).getResult();
        }
        if (this.needRetry(backupIndex)) {
            return this.syncRequest(roomId, roomType, clientSessionId, command, this.mOrderedMediaServer[backupIndex + 1], body, isAudience, backupIndex + 1);
        }
        return AsyncResult.create(RTCErrorCode.valueOf(res.getResponseCode())).getResult();
    }

    private void request(final String roomId, final int roomType, final String clientSessionId, final String command, String mediaServerAddress, final JSONObject body, final boolean isAudience, final int backupIndex, final HttpClient.ResultCallback callback) {
        Request request = this.getRequest(roomId, roomType, clientSessionId, command, mediaServerAddress, body, isAudience);
        HttpClient.getDefault().request(request, new HttpClient.ResultCallback(){

            @Override
            public void onResponse(String result) {
                if (callback != null) {
                    callback.onResponse(result);
                }
            }

            @Override
            public void onFailure(int errorCode) {
                if (MediaSignalWrapper.this.needRetry(backupIndex)) {
                    MediaSignalWrapper.this.request(roomId, roomType, clientSessionId, command, MediaSignalWrapper.this.mOrderedMediaServer[backupIndex + 1], body, isAudience, backupIndex + 1, callback);
                    return;
                }
                if (callback != null) {
                    callback.onFailure(errorCode);
                }
            }
        });
    }

    private List<MediaResourceInfo> parsePublishList(JSONArray jsonArray) {
        ArrayList<MediaResourceInfo> publishMediaInfoList = null;
        if (jsonArray != null) {
            publishMediaInfoList = new ArrayList<MediaResourceInfo>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                try {
                    JSONObject jsonObject = (JSONObject)jsonArray.get(i);
                    MediaResourceInfo publishMediaInfo = new MediaResourceInfo(jsonObject, this.getUserId());
                    publishMediaInfoList.add(publishMediaInfo);
                    continue;
                }
                catch (JSONException e) {
                    FinLog.v(TAG, "e.getMessage() = " + e.getMessage());
                }
            }
            FinLog.v(TAG, "parsePublishList size: " + publishMediaInfoList.size());
        }
        return publishMediaInfoList;
    }

    private JSONObject getResolutionInfo(List<? extends IStreamResource> pubStreamRes) {
        JSONObject result = new JSONObject();
        if (RongRTCUtils.isEmpty(pubStreamRes)) {
            return result;
        }
        try {
            for (IStreamResource iStreamResource : pubStreamRes) {
                if (!(iStreamResource instanceof ILocalVideoStreamResource)) continue;
                ILocalVideoStreamResource videoResource = (ILocalVideoStreamResource)iStreamResource;
                JSONObject info = new JSONObject();
                JSONArray array = new JSONArray();
                info.put("simulcast", videoResource.getStreamType().getValue());
                info.put("resolution", (Object)(videoResource.getWidth() + "X" + videoResource.getHeight()));
                array.put((Object)info);
                result.put(iStreamResource.getStreamId(), (Object)array);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    private JSONObject getExtentInfo(List<? extends IStreamResource> pubStreamRes, String role) {
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        try {
            if (RongRTCUtils.isEmpty(pubStreamRes)) {
                return jsonObject;
            }
            for (IStreamResource iStreamResource : pubStreamRes) {
                if (!(iStreamResource instanceof ILocalVideoStreamResource)) continue;
                ILocalVideoStreamResource outputStream = (ILocalVideoStreamResource)iStreamResource;
                JSONObject normalStream = new JSONObject();
                normalStream.put("trackId", (Object)outputStream.getStreamId());
                normalStream.put("simulcast", outputStream.getStreamType().getValue());
                normalStream.put("resolution", (Object)(outputStream.getWidth() + "X" + outputStream.getHeight()));
                jsonArray.put((Object)normalStream);
            }
            jsonObject.put("resolutionInfo", (Object)jsonArray);
            if (!TextUtils.isEmpty((CharSequence)role)) {
                jsonObject.put("role", (Object)role);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    private JSONArray parseSubscribeList(List<? extends IStreamResource> subStreamRes) {
        JSONArray jsonArray = new JSONArray();
        for (IStreamResource iStreamResource : subStreamRes) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("uri", (Object)iStreamResource.getUri());
                if (iStreamResource instanceof IRemoteVideoStreamResource) {
                    jsonObject.put("simulcast", ((IRemoteVideoStreamResource)((Object)iStreamResource)).getStreamType().getValue());
                }
                jsonArray.put((Object)jsonObject);
            }
            catch (JSONException e) {}
        }
        FinLog.i(TAG, "subscribe stream total:" + subStreamRes.size() + " / subscribed:" + jsonArray.length());
        Log.i((String)TAG, (String)("parseSubscribeList () SubscribeList : " + jsonArray.toString()));
        return jsonArray;
    }

    private void retrySendSDPOffer(String roomId, SessionDescription sdp, String clientSessionId, int backupIndex, RTCErrorCode errorCode, List<? extends IStreamResource> pubStreams, List<? extends IStreamResource> subStreams, int roomType, int liveType, String autoMixJSONInfo, String role, IRCRTCResultDataCallback<Object[]> callback) {
        if (this.needRetry(backupIndex)) {
            String backupUrl = this.mOrderedMediaServer[backupIndex + 1];
            FinLog.i(TAG, "sendSDPOffer retry with mOrderedMediaServer: " + backupUrl);
            this.sendSDPOffer(roomId, sdp, backupUrl, true, clientSessionId, backupIndex + 1, pubStreams, subStreams, roomType, liveType, autoMixJSONInfo, role, callback);
        } else if (callback != null) {
            callback.onFailed(errorCode);
        }
    }

    private boolean needRetry(int backupIndex) {
        return this.mOrderedMediaServer != null && this.mOrderedMediaServer.length > backupIndex + 1;
    }

    private void parseUDPObfuscation(JSONObject jsonObject) {
        try {
            if (this.mObfuscationKeyListener != null && jsonObject != null && jsonObject.has("udpObfuscationKey")) {
                String udpObfuscationKey = jsonObject.getString("udpObfuscationKey");
                this.mObfuscationKeyListener.onUpdate(udpObfuscationKey);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private Request getRequest(String roomId, int roomType, String clientSessionId, String command, String mediaServerAddress, JSONObject body) {
        return this.getRequest(roomId, roomType, clientSessionId, command, mediaServerAddress, body, false);
    }

    private Request getRequest(String roomId, int roomType, String clientSessionId, String command, String mediaServerAddress, JSONObject body, boolean isAudience) {
        return new Request.Builder().url(mediaServerAddress + command).method("POST").header("clientVersion", "4.1.0").header("App-Key", this.getAppKey()).header("Token", isAudience ? this.getLiveRtcToken() : this.getRtcToken()).header("RoomId", roomId).header("clientType", "Android|" + Build.MODEL + "|" + Build.VERSION.RELEASE).header("RoomType", String.valueOf(roomType)).header("UserId", this.getUserId()).header(FEATURE_SUPPORT_OBFUSCATION, "XOR").header(HEAD_CLIENT_SESSION_ID, clientSessionId).header(HEAD_REQUEST_ID, String.valueOf(System.currentTimeMillis())).body(body.toString()).build();
    }

    public int getMaxStreamCount() {
        if (this.maxStreamCount == 0) {
            return 30;
        }
        return this.maxStreamCount;
    }

    public void subscribeLive(SessionDescription sessionDescription, String mcuUrl, RCRTCAVStreamType avStreamType, IRCRTCResultDataCallback<SessionDescription> callback) {
        if (TextUtils.isEmpty((CharSequence)this.liveRtcToken)) {
            this.getTokenAndSubscribeLive(sessionDescription, mcuUrl, avStreamType, callback);
        } else {
            this.subscribeLive(sessionDescription, mcuUrl, avStreamType, false, this.getMediaServer(), -1, callback);
        }
    }

    private void getTokenAndSubscribeLive(final SessionDescription sessionDescription, final String mcuUrl, final RCRTCAVStreamType avStreamType, final IRCRTCResultDataCallback<SessionDescription> callback) {
        RCRTCRoomType roomType = avStreamType.getRoomType();
        this.mImSignal.getRTCToken(this.getUserId(), roomType.getRoomType(), roomType.getMediaType(), new IRCRTCResultDataCallback<String>(){

            @Override
            public void onSuccess(String data) {
                MediaSignalWrapper.this.liveRtcToken = data;
                FinLog.i(MediaSignalWrapper.TAG, "get Live token success and subscribe again!  userId = " + MediaSignalWrapper.this.getUserId());
                MediaSignalWrapper.this.subscribeLive(sessionDescription, mcuUrl, avStreamType, false, MediaSignalWrapper.this.getMediaServer(), -1, callback);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                MediaSignalWrapper.this.retry = 0;
                FinLog.e(MediaSignalWrapper.TAG, "getTokenAndSubscribeLive Failed: " + (Object)((Object)errorCode));
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.RongRTCTokenError);
                }
            }
        });
    }

    private String getUserId() {
        String userId = this.mImSignal.getUserId();
        FinLog.i(TAG, "userId = " + userId);
        return userId;
    }

    private void subscribeLive(final SessionDescription sessionDescription, final String mcuUrl, final RCRTCAVStreamType avStreamType, boolean isRetry, String mediaServerAddress, final int backupIndex, final IRCRTCResultDataCallback<SessionDescription> callback) {
        ReportUtil.libTask(ReportUtil.TAG.SUBSCRIBELIVESTREAM, "liveUrl|mediaUrl|userId|isRetry|sdp", mcuUrl, mediaServerAddress, this.getUserId(), isRetry, sessionDescription.toJsonString());
        JSONObject exchangeSDP = new JSONObject();
        try {
            JSONObject sdpJson = new JSONObject();
            sdpJson.put("type", (Object)sessionDescription.type.name().toLowerCase());
            sdpJson.put("sdp", (Object)sessionDescription.description);
            exchangeSDP.put("sdp", (Object)sdpJson);
            exchangeSDP.put("liveUrl", (Object)mcuUrl);
            if (avStreamType.getSimulcast() != -1) {
                exchangeSDP.put("simulcast", avStreamType.getSimulcast());
            }
            exchangeSDP.put("mediaType", avStreamType.getMediaType());
            FinLog.i(TAG, "subscribeLive sdpInfo: " + exchangeSDP + "   \nuserId:" + this.getUserId());
        }
        catch (JSONException e) {
            e.printStackTrace();
            ReportUtil.libError(ReportUtil.TAG.SUBSCRIBELIVESTREAM, "liveUrl|code|desc", mcuUrl, RTCErrorCode.RongRTCCodeParameterError.getValue(), "JSONException: " + e.getMessage());
            if (callback != null) {
                callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            }
            return;
        }
        Request request = this.getRequest(this.getUserId(), 2, "", "/broadcast/subscribe ", mediaServerAddress, exchangeSDP, true);
        HttpClient.getDefault().request(request, new HttpClient.ResultCallback(){

            @Override
            public void onResponse(String result) {
                block21: {
                    try {
                        JSONObject jsonObject = new JSONObject(result);
                        String resultCode = jsonObject.getString("resultCode");
                        int reposeCode = Integer.parseInt(resultCode);
                        if (reposeCode == 10000) {
                            FinLog.d(MediaSignalWrapper.TAG, "subscribeLive SDP success");
                            MediaSignalWrapper.this.changeMediaServer2ClusterId(jsonObject);
                            JSONArray subscribedJSONArray = null;
                            if (jsonObject.has("subscribedList")) {
                                subscribedJSONArray = jsonObject.getJSONArray("subscribedList");
                            }
                            JSONObject sdpObject = jsonObject.getJSONObject("sdp");
                            String sdpInfo = sdpObject.getString("sdp");
                            String type = sdpObject.getString("type");
                            SessionDescription.Type descriptionType = SessionDescription.Type.ANSWER;
                            if (!TextUtils.isEmpty((CharSequence)type)) {
                                if (type.equals("answer")) {
                                    descriptionType = SessionDescription.Type.ANSWER;
                                } else if (type.equals("offer")) {
                                    descriptionType = SessionDescription.Type.OFFER;
                                }
                            }
                            SessionDescription remoteDescription = new SessionDescription(descriptionType, sdpInfo);
                            String roomId = jsonObject.optString("roomId");
                            ReportUtil.libRes(ReportUtil.TAG.SUBSCRIBELIVESTREAM, "code|roomId|sdp", 0, roomId, remoteDescription.toJsonString());
                            if (subscribedJSONArray != null && !TextUtils.isEmpty((CharSequence)subscribedJSONArray.toString())) {
                                LiveSubscribeTools.getInstance().setmSubscribedJSON(subscribedJSONArray.toString());
                            }
                            MediaSignalWrapper.this.parseUDPObfuscation(jsonObject);
                            if (callback != null) {
                                callback.onSuccess(remoteDescription);
                            }
                        } else {
                            RTCErrorCode errorCode = RTCErrorCode.valueOf(reposeCode);
                            if (errorCode == RTCErrorCode.RongRTCCodeTokenNotInRoom || errorCode == RTCErrorCode.RongRTCCodeTokenExpired) {
                                MediaSignalWrapper.this.liveRtcToken = null;
                                ReportUtil.libError(ReportUtil.TAG.SUBSCRIBELIVESTREAM, "liveUrl|code|desc", mcuUrl, errorCode.getValue(), result);
                                if (MediaSignalWrapper.this.retry > 0) {
                                    MediaSignalWrapper.this.retry = 0;
                                    if (callback != null) {
                                        callback.onFailed(RTCErrorCode.RongRTCCodeTokenInvalid);
                                    }
                                } else {
                                    MediaSignalWrapper.this.retry++;
                                    MediaSignalWrapper.this.getTokenAndSubscribeLive(sessionDescription, mcuUrl, avStreamType, callback);
                                }
                            } else {
                                ReportUtil.libError(ReportUtil.TAG.SUBSCRIBELIVESTREAM, "liveUrl|code|desc", mcuUrl, errorCode.getValue(), result);
                                if (callback != null) {
                                    callback.onFailed(errorCode);
                                }
                            }
                        }
                    }
                    catch (JSONException e) {
                        ReportUtil.libError(ReportUtil.TAG.SUBSCRIBELIVESTREAM, "liveUrl|code|desc", mcuUrl, RTCErrorCode.JsonParseError.getValue(), "JSONException: " + e.getMessage() + " , result: " + result);
                        if (MediaSignalWrapper.this.needRetry(backupIndex)) {
                            FinLog.i(MediaSignalWrapper.TAG, "subscribeLive retry with mOrderedMediaServer: " + MediaSignalWrapper.this.mOrderedMediaServer[backupIndex + 1]);
                            MediaSignalWrapper.this.subscribeLive(sessionDescription, mcuUrl, avStreamType, true, MediaSignalWrapper.this.mOrderedMediaServer[backupIndex + 1], backupIndex + 1, callback);
                        } else if (callback != null) {
                            callback.onFailed(RTCErrorCode.JsonParseError);
                        }
                    }
                    catch (Exception e) {
                        ReportUtil.libError(ReportUtil.TAG.SUBSCRIBELIVESTREAM, "liveUrl|code|desc", mcuUrl, RTCErrorCode.UnknownError.getValue(), "Exception: " + e.getMessage() + " , result: " + result);
                        if (callback == null) break block21;
                        callback.onFailed(RTCErrorCode.UnknownError);
                    }
                }
            }

            @Override
            public void onFailure(int errorCode) {
                ReportUtil.libError(ReportUtil.TAG.SUBSCRIBELIVESTREAM, 2, "liveUrl|code|desc", mcuUrl, errorCode, "HttpRequest Failed");
                if (MediaSignalWrapper.this.needRetry(backupIndex)) {
                    FinLog.i(MediaSignalWrapper.TAG, "subscribeLive retry with mOrderedMediaServer: " + MediaSignalWrapper.this.mOrderedMediaServer[backupIndex + 1]);
                    MediaSignalWrapper.this.subscribeLive(sessionDescription, mcuUrl, avStreamType, true, MediaSignalWrapper.this.mOrderedMediaServer[backupIndex + 1], backupIndex + 1, callback);
                } else if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode));
                }
            }
        });
    }

    private void changeMediaServer2ClusterId(JSONObject jsonObject) {
        this.clusterId = jsonObject.optString("clusterId");
        if (!TextUtils.isEmpty((CharSequence)this.clusterId)) {
            String[] newMediaServers = new String[this.mOrderedMediaServer.length + 1];
            System.arraycopy(this.mOrderedMediaServer, 0, newMediaServers, 1, newMediaServers.length - 1);
            newMediaServers[0] = this.clusterId;
            this.mOrderedMediaServer = newMediaServers;
            this.clusterId = this.solveAddress();
            FinLog.i(TAG, "Change media server to clusterId: " + this.clusterId);
        }
    }

    public void quitLive(final String liveUrl, int roomType, final IRCRTCResultCallback callback) {
        JSONObject quitInfo;
        String mediaServer;
        block2: {
            mediaServer = this.getMediaServer();
            ReportUtil.libTask(ReportUtil.TAG.LEAVELIVE, "liveUrl|mediaUrl|userId", liveUrl, mediaServer, this.getUserId());
            quitInfo = new JSONObject();
            try {
                quitInfo.put("liveUrl", (Object)liveUrl);
            }
            catch (JSONException e) {
                ReportUtil.libError(ReportUtil.TAG.LEAVELIVE, "liveUrl|code|desc", liveUrl, RTCErrorCode.RongRTCCodeParameterError.getValue(), e.getMessage());
                e.printStackTrace();
                if (callback == null) break block2;
                callback.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            }
        }
        this.request(this.getUserId(), roomType, "", "/broadcast/exit ", mediaServer, quitInfo, true, this.getBackupMediaServerIndex(), new HttpClient.ResultCallback(){

            @Override
            public void onResponse(String result) {
                block6: {
                    try {
                        JSONObject jsonObject = new JSONObject(result);
                        String resultCode = jsonObject.getString("resultCode");
                        if (resultCode.equals("10000")) {
                            ReportUtil.libRes(ReportUtil.TAG.LEAVELIVE, "code", 0);
                            if (callback != null) {
                                callback.onSuccess();
                            }
                            break block6;
                        }
                        ReportUtil.libError(ReportUtil.TAG.LEAVELIVE, "code|mediaUrl|liveUrl|desc", resultCode, mediaServer, liveUrl, result);
                        if (callback == null) break block6;
                        int errorCode = -1;
                        try {
                            errorCode = Integer.valueOf(resultCode);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        callback.onFailed(RTCErrorCode.valueOf(errorCode));
                    }
                    catch (JSONException e) {
                        ReportUtil.libError(ReportUtil.TAG.LEAVELIVE, "liveUrl|code|desc", liveUrl, RTCErrorCode.JsonParseError.getValue(), "JSONException: " + e.getMessage() + " , result: " + result);
                        if (callback == null) break block6;
                        callback.onFailed(RTCErrorCode.JsonParseError);
                    }
                }
            }

            @Override
            public void onFailure(int errorCode) {
                ReportUtil.libError(ReportUtil.TAG.LEAVELIVE, "code|mediaUrl|liveUrl|desc", errorCode, mediaServer, liveUrl, "HttpRequest Failed");
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode));
                }
            }
        });
    }

    public void setMCUConfig(String serverUrl, String roomId, String sessionId, String configJson, final IRCRTCResultDataCallback<String> callBack) {
        Request request = new Request.Builder().url(serverUrl + "/server/mcu/config").method("POST").addHeader("RoomId", roomId).addHeader("UserId", this.getUserId()).addHeader("AppKey", this.getAppKey()).addHeader("SessionId", sessionId).addHeader("Token", this.getRtcToken()).body(configJson).build();
        HttpClient.getDefault().request(request, new HttpClient.ResultCallback(){

            @Override
            public void onResponse(String s) {
                if (callBack != null) {
                    callBack.onSuccess(s);
                }
            }

            @Override
            public void onFailure(int i) {
                if (callBack != null) {
                    callBack.onFailed(RTCErrorCode.valueOf(i));
                }
            }
        });
    }

    private String getAppKey() {
        return RTCEngineImpl.getInstance().getAppKey();
    }

    public void reset() {
        this.rtcToken = null;
        this.liveRtcToken = null;
        mediaServer = null;
        this.mOrderedMediaServer = null;
        this.clusterId = null;
        SnifferManager.getInstance().release();
    }

    static /* synthetic */ String[] access$002(MediaSignalWrapper x0, String[] x1) {
        x0.mOrderedMediaServer = x1;
        return x1;
    }
}

