/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.signal;

import android.text.TextUtils;
import android.util.Pair;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.base.AsyncResult;
import cn.rongcloud.rtc.base.RCAttributeType;
import cn.rongcloud.rtc.base.RCRTCRoomType;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.proxy.message.messagebeans.InviteInfo;
import cn.rongcloud.rtc.proxy.message.messagebeans.PKInfo;
import cn.rongcloud.rtc.signal.SyncIMOperationCallback;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import io.rong.imlib.IMLibRTCClient;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.MessageTag;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.RTCStatusDate;
import io.rong.imlib.model.RTCUser;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IMSignalWrapper {
    private static final String TAG = "IMSignalWrapper";

    public void getRTCToken(String roomId, int roomType, int mediaType, final IRCRTCResultDataCallback<String> callback) {
        IMLibRTCClient.getInstance().getRTCToken(roomId, roomType, mediaType, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<String>(){

            public void onSuccess(String s) {
                ReportUtil.libRes(ReportUtil.TAG.GETRTCTOKEN, "code|token", 0, s);
                if (callback != null) {
                    callback.onSuccess(s);
                }
            }

            public void onError(RongIMClient.ErrorCode e) {
                ReportUtil.libError(ReportUtil.TAG.GETRTCTOKEN, "code|desc", e.getValue(), e.getMessage());
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(e.getValue()));
                }
            }
        });
    }

    public AsyncResult<String> syncGetRTCToken(String roomId, int roomType, int mediaType) {
        ReportUtil.libTask(ReportUtil.TAG.GETRTCTOKEN, "roomId|roomType|mediaType", roomId, roomType, mediaType);
        final AsyncResult.TemporaryResult<Thread> res = AsyncResult.create(Thread.currentThread());
        IMLibRTCClient.getInstance().getRTCToken(roomId, roomType, mediaType, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<String>(){

            public void onSuccess(String s) {
                ReportUtil.libRes(ReportUtil.TAG.GETRTCTOKEN, "code|token", 0, s);
                res.setAndNotify(s);
            }

            public void onError(RongIMClient.ErrorCode e) {
                res.setAndNotify(RTCErrorCode.valueOf(e.getValue()));
                ReportUtil.libError(ReportUtil.TAG.GETRTCTOKEN, "code|desc", e.getValue(), e.getMessage());
            }
        });
        return res.waitForGetResult();
    }

    public void rtcPutInnerData(String roomId, int type, String key, String value, MessageContent message, final IRCRTCResultCallback callback) {
        Pair<String, String> res = this.parseMessageContent(message);
        IMLibRTCClient.getInstance().rtcPutInnerDatum(roomId, type, key, value, (String)res.first, (String)res.second, new RongIMClient.OperationCallback(){

            public void onSuccess() {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode.getValue()));
                }
            }
        });
    }

    public String getVoIPInfo() {
        return IMLibRTCClient.getInstance().getVoIPInfo();
    }

    public void joinRoom(final String roomId, RCRTCRoomType roomType, boolean isReJoin, final IRongCallback.IRTCJoinRoomCallbackEx<Object[]> callBack) {
        ReportUtil.libTask(ReportUtil.TAG.JOINRTCROOMANDGETDATA, "roomId|uid|roomType|liveType", roomId, RongIMClient.getInstance().getCurrentUserId(), roomType.getRoomType(), roomType.getMediaType());
        IMLibRTCClient.getInstance().joinRTCRoomAndGetData(roomId, roomType.getRoomType(), roomType.getMediaType(), "", "", (IRongCallback.IRTCJoinRoomCallbackEx)new IRongCallback.IRTCJoinRoomCallbackEx<Object[]>(){

            public void onSuccess(List<RTCUser> list, Object[] exParams) {
                ReportUtil.libRes(ReportUtil.TAG.JOINRTCROOMANDGETDATA, "roomId|code", roomId, 0);
                if (callBack != null) {
                    callBack.onSuccess(list, (Object)exParams);
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.JOINRTCROOMANDGETDATA, "roomId|code|desc", roomId, errorCode.getValue(), errorCode.getMessage());
                if (callBack != null) {
                    callBack.onError(errorCode);
                }
            }
        });
    }

    public void joinOtherRoom(final String roomId, RCRTCRoomType roomType, String key, String value, final IRongCallback.IRTCJoinRoomCallbackEx<Object[]> callBack) {
        ReportUtil.libTask(ReportUtil.TAG.JOINOTHERROOM, "otherRoomId|uid|roomType|liveType|key|value", roomId, RongIMClient.getInstance().getCurrentUserId(), roomType.getRoomType(), roomType.getMediaType());
        IMLibRTCClient.getInstance().joinRTCRoomAndGetData(roomId, roomType.getRoomType(), roomType.getMediaType(), key, value, (IRongCallback.IRTCJoinRoomCallbackEx)new IRongCallback.IRTCJoinRoomCallbackEx<Object[]>(){

            public void onSuccess(List<RTCUser> list, Object[] exParams) {
                ReportUtil.libRes(ReportUtil.TAG.JOINOTHERROOM, "otherRoomId|exParams|code", roomId, exParams == null ? "null" : "length : " + exParams.length, 0);
                if (callBack != null) {
                    callBack.onSuccess(list, (Object)exParams);
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.JOINOTHERROOM, "otherRoomId|code|desc", roomId, errorCode.getValue(), errorCode.getMessage());
                if (callBack != null) {
                    callBack.onError(errorCode);
                }
            }
        });
    }

    public void getRTCConfig(String model, String osVersion, long timestamp, String sdkVersion, final IRCRTCResultDataCallback<String> callback) {
        IMLibRTCClient.getInstance().getRTCConfig(model, osVersion, timestamp, sdkVersion, new IRongCallback.IRTCConfigCallback(){

            public void onSuccess(String config, long version) {
                if (callback != null) {
                    callback.onSuccess(config);
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode.getValue()));
                }
            }
        });
    }

    public String getUserId() {
        return RongIMClient.getInstance().getCurrentUserId();
    }

    public AsyncResult rtcSetUserResource(String roomId, RTCStatusDate[] kv, String objNameTotalContent, RTCStatusDate[] content, boolean isSync, IRCRTCResultCallback callback) {
        SyncIMOperationCallback result = new SyncIMOperationCallback(isSync, callback);
        IMLibRTCClient.getInstance().rtcSetUserResource(roomId, kv, objNameTotalContent, content, (RongIMClient.OperationCallback)result);
        return result.getResult();
    }

    public void leaveRoom(String roomId, final IRCRTCResultCallback callBack) {
        IMLibRTCClient.getInstance().exitRTCRoom(roomId, new RongIMClient.OperationCallback(){

            public void onSuccess() {
                FinLog.d(IMSignalWrapper.TAG, "exitRTCRoom success ");
                if (callBack != null) {
                    callBack.onSuccess();
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                FinLog.e(IMSignalWrapper.TAG, "exitRTCRoom error = " + errorCode);
                callBack.onFailed(RTCErrorCode.valueOf(errorCode.getValue()));
            }
        });
    }

    public void sendleaveOtherRoomMessage(final String roomId, final IRCRTCResultCallback callBack) {
        ReportUtil.libTask(ReportUtil.TAG.LEAVEOTHERROOM, "otherRoomId", roomId);
        IMLibRTCClient.getInstance().exitRTCRoom(roomId, new RongIMClient.OperationCallback(){

            public void onSuccess() {
                ReportUtil.libRes(ReportUtil.TAG.LEAVEOTHERROOM, "otherRoomId|code", roomId, 0);
                if (callBack != null) {
                    callBack.onSuccess();
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.LEAVEOTHERROOM, "otherRoomId|code|desc", roomId, errorCode.getValue(), errorCode.getMessage());
                if (callBack != null) {
                    callBack.onFailed(RTCErrorCode.valueOf(errorCode.getValue()));
                }
            }
        });
    }

    public void sendRTCPing(String roomId, RongIMClient.OperationCallback callback) {
        IMLibRTCClient.getInstance().sendRTCPing(roomId, callback);
    }

    public void setAttributeValue(String roomId, RCAttributeType type, String key, String value, MessageContent message, final IRCRTCResultCallback callback) {
        Pair<String, String> res = this.parseMessageContent(message);
        IMLibRTCClient.getInstance().rtcPutOuterDatum(roomId, type.getValue(), key, value, (String)res.first, (String)res.second, new RongIMClient.OperationCallback(){

            public void onSuccess() {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode.getValue()));
                }
            }
        });
    }

    private Pair<String, String> parseMessageContent(MessageContent message) {
        String objectName = "";
        String messageContent = "";
        if (message != null) {
            MessageTag annotation = message.getClass().getAnnotation(MessageTag.class);
            objectName = annotation.value();
            messageContent = new String(message.encode());
        }
        return Pair.create((Object)objectName, (Object)messageContent);
    }

    public void deleteAttributes(String roomId, RCAttributeType type, List<String> attributeKeys, MessageContent message, final IRCRTCResultCallback callback) {
        Pair<String, String> res = this.parseMessageContent(message);
        String[] keys = null;
        if (attributeKeys != null) {
            keys = new String[attributeKeys.size()];
            attributeKeys.toArray(keys);
        }
        IMLibRTCClient.getInstance().rtcDeleteOuterData(roomId, type.getValue(), keys, (String)res.first, (String)res.second, new RongIMClient.OperationCallback(){

            public void onSuccess() {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode.getValue()));
                }
            }
        });
    }

    public void getAttributes(String roomId, RCAttributeType type, List<String> attributeKeys, final IRCRTCResultDataCallback<Map<String, String>> callback) {
        String[] keys = null;
        if (attributeKeys != null) {
            keys = new String[attributeKeys.size()];
            attributeKeys.toArray(keys);
        }
        IMLibRTCClient.getInstance().rtcGetOuterData(roomId, type.getValue(), keys, new IRongCallback.IRtcIODataCallback(){

            public void onSuccess(Map<String, String> map) {
                if (callback != null) {
                    callback.onSuccess(map);
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode.getValue()));
                }
            }
        });
    }

    private String attributeListToString(List<String> attributeKeys) {
        String keyStr = "";
        if (!RongRTCUtils.isEmpty(attributeKeys)) {
            JSONArray jsonArray = new JSONArray();
            for (String attributeKey : attributeKeys) {
                jsonArray.put((Object)attributeKey);
            }
            keyStr = jsonArray.toString();
        }
        return keyStr;
    }

    public void sendIMSignal(String roomId, MessageContent messageContent, IRongCallback.ISendMessageCallback callback) {
        RongIMClient.getInstance().sendMessage(Conversation.ConversationType.RTC_ROOM, roomId, messageContent, "", "", callback);
    }

    public void requestJoinOtherRoom(String inviteeRoomId, String inviteeUserId, String mainRoomId, int timeoutTime, final String inviteSessionId, String inviteInfo, final IRCRTCResultCallback callback) {
        ReportUtil.libTask(ReportUtil.TAG.REQUESTJOINOTHERROOM, RongRTCUtils.append("inviteSessionId", "inviteInfo"), inviteSessionId, inviteInfo);
        IMLibRTCClient.getInstance().SendRTCLiveInvitation(mainRoomId, inviteeUserId, inviteeRoomId, inviteInfo, inviteSessionId, timeoutTime, new RongIMClient.OperationCallback(){

            public void onSuccess() {
                ReportUtil.libRes(ReportUtil.TAG.REQUESTJOINOTHERROOM, "inviteSessionId", inviteSessionId);
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.REQUESTJOINOTHERROOM, RongRTCUtils.append("inviteSessionId", "code"), inviteSessionId, errorCode.getValue());
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode.getValue()));
                }
            }
        });
    }

    public void cancelRequestJoinOtherRoom(String inviteeRoomId, String inviteeUserId, String mainRoomId, String localUserId, final String inviteSessionId, String extra, final IRCRTCResultCallback callback) {
        String inviteInfo = "";
        JSONObject obj = new JSONObject();
        try {
            obj.putOpt("inviterRoomId", (Object)mainRoomId);
            obj.putOpt("inviterUserId", (Object)localUserId);
            obj.putOpt("inviteeRoomId", (Object)inviteeRoomId);
            obj.putOpt("inviteeUserId", (Object)inviteeUserId);
            if (!TextUtils.isEmpty((CharSequence)extra)) {
                obj.putOpt("extra", (Object)extra);
            }
            inviteInfo = obj.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (TextUtils.isEmpty((CharSequence)inviteInfo)) {
            return;
        }
        ReportUtil.libTask(ReportUtil.TAG.CANCELREQUESTJOINOTHERROOM, RongRTCUtils.append("inviteSessionId", "inviteInfo"), inviteSessionId, inviteInfo);
        IMLibRTCClient.getInstance().CancelRTCLiveInvitation(mainRoomId, inviteeUserId, inviteeRoomId, inviteInfo, inviteSessionId, new RongIMClient.OperationCallback(){

            public void onSuccess() {
                ReportUtil.libRes(ReportUtil.TAG.CANCELREQUESTJOINOTHERROOM, "inviteSessionId", inviteSessionId);
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.CANCELREQUESTJOINOTHERROOM, RongRTCUtils.append("inviteSessionId", "code"), inviteSessionId, errorCode.getValue());
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode.getValue()));
                }
            }
        });
    }

    public void responseJoinOtherRoom(String inviterRoomId, String inviterUserId, boolean agree, String extra, boolean inviteeUserAutoMix, String mainRoomId, InviteInfo inviteInfo, String key, final String inviteSessionId, final IRCRTCResultCallback callback) {
        int answerCode = agree ? 1 : 0;
        String value = "";
        String content = "";
        if (agree) {
            PKInfo info = new PKInfo(inviterUserId, inviterRoomId, inviteInfo.getInviterUserAutoMix(), inviteInfo.getInviteeUserId(), mainRoomId, inviteeUserAutoMix, inviteSessionId);
            value = info.getJSON();
        }
        JSONObject obj_content = new JSONObject();
        try {
            obj_content.putOpt("inviteeUserId", (Object)inviteInfo.getInviteeUserId());
            obj_content.putOpt("inviteeRoomId", (Object)mainRoomId);
            obj_content.putOpt("inviterRoomId", (Object)inviterRoomId);
            obj_content.putOpt("inviterUserId", (Object)inviterUserId);
            obj_content.putOpt("inviteeUserAutoMix", (Object)inviteeUserAutoMix);
            if (!TextUtils.isEmpty((CharSequence)extra)) {
                obj_content.putOpt("extra", (Object)extra);
            }
            if (agree) {
                obj_content.putOpt("MultiRoomKey", (Object)key);
                obj_content.putOpt("MultiRoomValue", (Object)value);
            }
            content = obj_content.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ReportUtil.libTask(ReportUtil.TAG.RESPONSEJOINOTHERROOM, RongRTCUtils.append("inviteSessionId", "key", "value", "content"), inviteSessionId, key, value, content);
        IMLibRTCClient.getInstance().AnswerRTCLiveInvitation(mainRoomId, answerCode, inviterUserId, inviterRoomId, inviteSessionId, content, key, value, new RongIMClient.OperationCallback(){

            public void onSuccess() {
                ReportUtil.libRes(ReportUtil.TAG.RESPONSEJOINOTHERROOM, "inviteSessionId", inviteSessionId);
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.RESPONSEJOINOTHERROOM, "inviteSessionId|code", inviteSessionId, errorCode.getValue());
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode.getValue()));
                }
            }
        });
    }

    public void finishOtherRoom(final String otherRoomId, String extra, final String mainRoomId, String inviteSessionId, String localUserId, String[] keys, final IRCRTCResultCallback callback) {
        String content = "";
        JSONObject obj_content = new JSONObject();
        try {
            obj_content.putOpt("inviteeRoomId", (Object)mainRoomId);
            obj_content.putOpt("inviterRoomId", (Object)otherRoomId);
            obj_content.putOpt("userId", (Object)localUserId);
            if (!TextUtils.isEmpty((CharSequence)extra)) {
                obj_content.putOpt("extra", (Object)extra);
            }
            content = obj_content.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        ReportUtil.libTask(ReportUtil.TAG.FINISHOTHERROOM, "roomId|mainRoomId|keys", otherRoomId, mainRoomId, Arrays.toString(keys));
        IMLibRTCClient.getInstance().HangupRTCLiveInvitation(mainRoomId, otherRoomId, inviteSessionId, content, keys, new RongIMClient.OperationCallback(){

            public void onSuccess() {
                ReportUtil.libRes(ReportUtil.TAG.FINISHOTHERROOM, mainRoomId);
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.FINISHOTHERROOM, "roomId|mainRoomId|code", otherRoomId, mainRoomId, errorCode.getValue());
                if (callback != null) {
                    callback.onFailed(RTCErrorCode.valueOf(errorCode.getValue()));
                }
            }
        });
    }
}

