/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.proxy.message.messagebeans;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RCRTCResourceState;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.webrtc.IStreamResource;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaResourceInfo
implements Parcelable {
    private static final String LOG_TAG = "MediaResourceInfo";
    private String tag = "RongCloudRTC";
    private String streamId;
    private int type;
    private String uri;
    private String features;
    private RCRTCResourceState state = RCRTCResourceState.NORMAL;
    public static final Parcelable.Creator<MediaResourceInfo> CREATOR = new Parcelable.Creator<MediaResourceInfo>(){

        public MediaResourceInfo createFromParcel(Parcel in) {
            return new MediaResourceInfo(in);
        }

        public MediaResourceInfo[] newArray(int size) {
            return new MediaResourceInfo[size];
        }
    };

    public MediaResourceInfo(String tag, String streamId, int type, String uri, String features) {
        this.tag = tag;
        this.streamId = streamId;
        this.type = type;
        this.uri = uri;
        this.features = features;
    }

    public MediaResourceInfo(IStreamResource streamResource) {
        this.tag = streamResource.getTag();
        this.streamId = streamResource.getStreamId();
        this.type = streamResource.getMediaType().getValue();
        this.uri = streamResource.getUri();
        this.state = streamResource.getResourceState();
    }

    protected MediaResourceInfo(Parcel in) {
        this.tag = in.readString();
        this.streamId = in.readString();
        this.type = in.readInt();
        this.uri = in.readString();
        this.features = in.readString();
        this.state = RCRTCResourceState.valueOf(in.readInt());
    }

    public MediaResourceInfo(JSONObject jsonObject, String userId) {
        try {
            int n;
            this.tag = jsonObject.has("tag") ? jsonObject.getString("tag") : "";
            if (jsonObject.has("msid")) {
                this.streamId = jsonObject.getString("msid");
            }
            try {
                if (!TextUtils.isEmpty((CharSequence)userId)) {
                    String tmpLocalUserid = userId;
                    if (this.streamId != null && this.streamId.contains(tmpLocalUserid)) {
                        int i = this.streamId.lastIndexOf(95);
                        this.tag = i != -1 ? this.streamId.substring(i + 1) : "RongCloudRTC";
                    }
                }
            }
            catch (Exception tmpLocalUserid) {
                // empty catch block
            }
            if (TextUtils.isEmpty((CharSequence)this.tag) && !TextUtils.isEmpty((CharSequence)this.streamId) && (n = this.streamId.lastIndexOf("_")) > 0 && n < this.streamId.length() - 1) {
                this.tag = this.streamId.substring(n + 1);
                FinLog.d(LOG_TAG, "MediaResourceInfo tag = " + this.tag + " , and got if from streamId = " + this.streamId);
            }
            if (jsonObject.has("mediaType")) {
                this.type = jsonObject.getInt("mediaType");
            }
            if (jsonObject.has("uri")) {
                this.uri = jsonObject.getString("uri");
            }
            if (jsonObject.has("features")) {
                this.features = jsonObject.getString("features");
            }
            if (jsonObject.has("state")) {
                this.state = RCRTCResourceState.valueOf(jsonObject.getInt("state"));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public MediaResourceInfo() {
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.tag);
        dest.writeString(this.streamId);
        dest.writeInt(this.type);
        dest.writeString(this.uri);
        dest.writeString(this.features);
        dest.writeInt(this.state.getValue());
    }

    public JSONObject getJsonObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.putOpt("tag", (Object)this.tag);
            jsonObject.putOpt("msid", (Object)this.streamId);
            jsonObject.putOpt("mediaType", (Object)this.type);
            jsonObject.putOpt("uri", (Object)this.uri);
            jsonObject.putOpt("features", (Object)this.features);
            jsonObject.putOpt("state", (Object)this.state.getValue());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public RCRTCMediaType getType() {
        return RCRTCMediaType.getMediaType(this.type);
    }

    public void setType(RCRTCMediaType RCRTCMediaType2) {
        this.type = RCRTCMediaType2.getValue();
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean isSupportTiny() {
        return this.features != null && this.features.contains("simulcast");
    }

    public RCRTCResourceState getRCRTCResourceState() {
        return this.state;
    }

    public void setRCRTCResourceState(RCRTCResourceState RCRTCResourceState2) {
        this.state = RCRTCResourceState2;
    }

    public String toString() {
        return "MediaResourceInfo{tag='" + this.tag + '\'' + ", streamId='" + this.streamId + '\'' + ", type=" + this.type + ", uri='" + this.uri + '\'' + ", features='" + this.features + '\'' + ", resourceState=" + (Object)((Object)this.state) + '}';
    }
}

