/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.proxy.message;

import android.os.Parcel;
import android.os.Parcelable;
import cn.rongcloud.rtc.proxy.message.messagebeans.MediaResourceInfo;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RCRTC:TotalContentResources", flag=16)
public class TotalContentResources
extends MessageContent {
    private static final String TAG = "TotalContentResources";
    private List<MediaResourceInfo> uris = new ArrayList<MediaResourceInfo>();
    private String extra;
    public static final Parcelable.Creator<TotalContentResources> CREATOR = new Parcelable.Creator<TotalContentResources>(){

        public TotalContentResources createFromParcel(Parcel source) {
            return new TotalContentResources(source);
        }

        public TotalContentResources[] newArray(int size) {
            return new TotalContentResources[size];
        }
    };

    public TotalContentResources(List<MediaResourceInfo> mediaResourceInfoList) {
        this.uris = mediaResourceInfoList;
    }

    private TotalContentResources(Parcel source) {
        this.extra = source.readString();
        source.readList(this.uris, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public TotalContentResources(byte[] data) {
        super(data);
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
            ReportUtil.report("L-", ReportUtil.TAG.REMOTEUSERTOTALCONTENTTAG, "-S", "TotalContent", jsonStr);
        }
        catch (UnsupportedEncodingException e) {
            RLog.e((String)TAG, (String)"UnsupportedEncodingException ", (Throwable)e);
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            if (jsonObj.has("uris")) {
                if (jsonObj.has("extra")) {
                    this.extra = jsonObj.getString("extra");
                }
                JSONArray array = null;
                if (jsonObj.has("uris")) {
                    array = jsonObj.getJSONArray("uris");
                }
                this.uris = new ArrayList<MediaResourceInfo>();
                if (array != null) {
                    FinLog.d(TAG, "TotalContentResources size() =  " + array.length());
                    for (int i = 0; i < array.length(); ++i) {
                        this.uris.add(new MediaResourceInfo((JSONObject)array.get(i), ""));
                    }
                }
            }
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException " + e.getMessage()));
        }
    }

    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            JSONArray jsonArray = new JSONArray();
            for (MediaResourceInfo info : this.uris) {
                jsonArray.put((Object)info.getJsonObject());
            }
            jsonObj.putOpt("extra", (Object)this.extra);
            jsonObj.putOpt("uris", (Object)jsonArray);
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.extra);
        dest.writeList(this.uris);
    }

    public List<MediaResourceInfo> getMediaResourceInfo() {
        return this.uris;
    }
}

