/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.proxy.message;

import android.os.Parcel;
import android.os.Parcelable;
import cn.rongcloud.rtc.proxy.message.messagebeans.UserState;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RCRTC:state", flag=16)
public class RoomUserStateMessage
extends MessageContent {
    private static final String TAG = "RoomUserStateMessage";
    private List<UserState> userStates;
    public static final Parcelable.Creator<RoomUserStateMessage> CREATOR = new Parcelable.Creator<RoomUserStateMessage>(){

        public RoomUserStateMessage createFromParcel(Parcel source) {
            return new RoomUserStateMessage(source);
        }

        public RoomUserStateMessage[] newArray(int size) {
            return new RoomUserStateMessage[size];
        }
    };

    private RoomUserStateMessage(Parcel source) {
        this.userStates = ParcelUtils.readListFromParcel((Parcel)source, UserState.class);
    }

    public byte[] encode() {
        return new byte[0];
    }

    public RoomUserStateMessage(byte[] data) {
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RLog.e((String)TAG, (String)"UnsupportedEncodingException ", (Throwable)e);
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            if (jsonObj.has("users")) {
                JSONArray jsonArray = jsonObj.optJSONArray("users");
                this.userStates = new ArrayList<UserState>();
                JSONObject jsonExtra = null;
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject jsonUser = (JSONObject)jsonArray.get(i);
                    if (jsonUser == null) continue;
                    String userId = jsonUser.getString("userId");
                    int state = jsonUser.getInt("state");
                    String roomid = "";
                    if (jsonUser.has("extra") && (jsonExtra = jsonUser.getJSONObject("extra")) != null && jsonExtra.has("roomId")) {
                        roomid = jsonExtra.getString("roomId");
                    }
                    this.userStates.add(new UserState(userId, UserState.State.valueOf(state), roomid));
                }
            }
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException " + e.getMessage()));
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeList(this.userStates);
    }

    public List<UserState> getUserStates() {
        return this.userStates;
    }
}

