/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.proxy;

import android.text.TextUtils;
import cn.rongcloud.rtc.base.AsyncResult;
import cn.rongcloud.rtc.proxy.message.messagebeans.MediaResourceInfo;
import cn.rongcloud.rtc.signal.SignalManager;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ResourceTools;
import cn.rongcloud.rtc.webrtc.IStreamResource;
import io.rong.imlib.model.RTCStatusDate;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;

public class ReConnectTool {
    private static final String TAG = "ReConnectTool";
    public static final String NEED_PUBLISH = "need_Publish";
    public static final String NEED_UNPUBLISH = "need_unPublish";
    public static final String NEED_MODIFY_RESOURCE = "need_modify_Resource";

    public static AsyncResult sendSourceMessage(String roomId, boolean forceSendSignal, List<MediaResourceInfo> mediaResourceInfoList, List<? extends IStreamResource> allPubStreams) {
        if (forceSendSignal) {
            return ReConnectTool.sendpublishResourceMessage(roomId, mediaResourceInfoList);
        }
        boolean needunpublish = mediaResourceInfoList.size() != allPubStreams.size();
        String mediaResourceUri = "";
        String localStreamMediaResourceUri = "";
        block0: for (MediaResourceInfo mediaResourceInfo : mediaResourceInfoList) {
            for (IStreamResource iStreamResource : allPubStreams) {
                mediaResourceUri = mediaResourceInfo.getUri();
                localStreamMediaResourceUri = iStreamResource.getUri();
                if (iStreamResource.getMediaType() != mediaResourceInfo.getType() || !TextUtils.equals((CharSequence)iStreamResource.getTag(), (CharSequence)mediaResourceInfo.getTag()) || mediaResourceUri.equals(localStreamMediaResourceUri)) continue;
                needunpublish = true;
                FinLog.e(TAG, "mediaResourceUri      : " + mediaResourceUri);
                FinLog.e(TAG, "localMediaResourceUri : " + localStreamMediaResourceUri);
                break block0;
            }
        }
        FinLog.i(TAG, "need unpublish : " + needunpublish);
        if (needunpublish) {
            return ReConnectTool.republish(roomId, mediaResourceInfoList, allPubStreams);
        }
        return AsyncResult.create().getResult();
    }

    private static String parsePublishData(List<MediaResourceInfo> mediaResourceInfoList) {
        String publishData = "";
        if (mediaResourceInfoList != null) {
            JSONArray jsonArray = new JSONArray();
            for (MediaResourceInfo mediaResourceInfo : mediaResourceInfoList) {
                jsonArray.put((Object)mediaResourceInfo.getJsonObject());
            }
            publishData = jsonArray.toString();
        }
        return publishData;
    }

    public static AsyncResult sendpublishResourceMessage(String roomId, List<MediaResourceInfo> publishMediaInfoList) {
        String publish = ReConnectTool.parsePublishData(publishMediaInfoList);
        FinLog.d(TAG, "sendpublishResourceMessage()-> publish : " + publish);
        RTCStatusDate[] kv = new RTCStatusDate[]{ResourceTools.getStatusDate("uris", publish)};
        RTCStatusDate[] content = new RTCStatusDate[]{ResourceTools.getStatusDate("RCRTC:PublishResource", ResourceTools.getURIS(publishMediaInfoList, true, ""))};
        return SignalManager.getInstance().syncRTCSetUserResource(roomId, kv, "RCRTC:TotalContentResources", content);
    }

    private static AsyncResult republish(String roomId, List<MediaResourceInfo> mediaResourceInfoList, List<? extends IStreamResource> allPubStreams) {
        FinLog.d(TAG, "republish");
        ArrayList<MediaResourceInfo> unPublishResources = new ArrayList<MediaResourceInfo>();
        for (IStreamResource iStreamResource : allPubStreams) {
            if (TextUtils.isEmpty((CharSequence)iStreamResource.getUri())) continue;
            unPublishResources.add(new MediaResourceInfo(iStreamResource));
        }
        String publishData = ReConnectTool.parsePublishData(mediaResourceInfoList);
        FinLog.d(TAG, "republish->totalContent: " + publishData);
        RTCStatusDate[] rTCStatusDateArray = new RTCStatusDate[]{ResourceTools.getStatusDate("uris", publishData)};
        RTCStatusDate[] content = new RTCStatusDate[]{ResourceTools.getStatusDate("RCRTC:UnpublishResource", ResourceTools.getURIS(unPublishResources, true, "")), ResourceTools.getStatusDate("RCRTC:PublishResource", ResourceTools.getURIS(mediaResourceInfoList, true, ""))};
        return SignalManager.getInstance().syncRTCSetUserResource(roomId, rTCStatusDateArray, "RCRTC:TotalContentResources", content);
    }
}

