/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.module.camera;

import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.text.TextUtils;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.core.Camera1Capturer;
import cn.rongcloud.rtc.core.Camera1Enumerator;
import cn.rongcloud.rtc.core.CameraEnumerator;
import cn.rongcloud.rtc.core.CameraVideoCapturer;
import cn.rongcloud.rtc.core.CapturerObserver;
import cn.rongcloud.rtc.core.EglBase;
import cn.rongcloud.rtc.core.SurfaceTextureHelper;
import cn.rongcloud.rtc.core.VideoFrame;
import cn.rongcloud.rtc.module.camera.CameraManager;
import cn.rongcloud.rtc.utils.FinLog;
import java.util.ArrayList;
import java.util.List;

public class CameraManagerImpl
implements CameraManager {
    private final String TAG = "CameraManagerImpl";
    private SurfaceTextureHelper surfaceTextureHelper;
    private Context mContext;
    private int numberOfCameras;
    private CameraVideoCapturer videoCapturer;
    private CameraEnumerator mCameraEnumerator;
    private int mFrameOrientation = -1;
    private int mCameraOrientation = 0;
    private boolean mCameraStarted;
    private CapturerObserver mCapturerObserver;
    private List<IRCRTCResultDataCallback<Boolean>> mStartCameraCallbackList;
    private Handler cameraThreadHandler;

    public CameraManagerImpl(boolean captureToTexture, EglBase.Context eglBaseContext, Context applicationContext) {
        FinLog.d("CameraManagerImpl", "videoConfig: isCaptureToTextureAvailable :" + captureToTexture);
        this.mCameraEnumerator = new Camera1Enumerator(captureToTexture);
        this.surfaceTextureHelper = SurfaceTextureHelper.create("CaptureThread", eglBaseContext);
        this.cameraThreadHandler = this.surfaceTextureHelper.getHandler();
        this.mStartCameraCallbackList = new ArrayList<IRCRTCResultDataCallback<Boolean>>();
        this.mContext = applicationContext;
    }

    private CameraVideoCapturer createCameraCapture(int cameraId) {
        CameraEnumerator enumerator = this.mCameraEnumerator;
        if (enumerator == null) {
            this.onStartCameraFailed(RTCErrorCode.CAMERA_IS_RELEASED);
            return null;
        }
        String[] deviceNames = enumerator.getDeviceNames();
        this.numberOfCameras = deviceNames.length;
        FinLog.v("CameraManagerImpl", "Looking for front facing cameras. numberOfCameras = " + this.numberOfCameras);
        String customDeviceName = null;
        if (cameraId != -1 && TextUtils.isEmpty((CharSequence)(customDeviceName = Camera1Enumerator.getDeviceName(cameraId)))) {
            FinLog.d("CameraManagerImpl", "createCameraCapture: cameraId not available, cameraId is " + cameraId);
            this.onStartCameraFailed(RTCErrorCode.CAMERA_ID_NOT_AVAILABLE);
            return null;
        }
        if (!TextUtils.isEmpty(customDeviceName)) {
            return this.onCreateCapturer(customDeviceName);
        }
        for (String deviceName : deviceNames) {
            if (!enumerator.isFrontFacing(deviceName)) continue;
            FinLog.v("CameraManagerImpl", "Creating front facing camera capturer. deviceName : " + deviceName);
            return this.onCreateCapturer(deviceName);
        }
        FinLog.v("CameraManagerImpl", "Looking for other cameras.");
        for (String deviceName : deviceNames) {
            if (enumerator.isFrontFacing(deviceName)) continue;
            FinLog.v("CameraManagerImpl", "Creating other camera capturer.");
            return this.onCreateCapturer(deviceName);
        }
        FinLog.e("CameraManagerImpl", "No camera found for this device!");
        this.onStartCameraFailed(RTCErrorCode.NO_CAMERA_DEVICE);
        return null;
    }

    private void onStartCameraFailed(RTCErrorCode errorCode) {
        FinLog.e("CameraManagerImpl", "onStartCameraFailed: " + (Object)((Object)errorCode));
        for (IRCRTCResultDataCallback<Boolean> callback : this.mStartCameraCallbackList) {
            if (callback == null) continue;
            callback.onFailed(errorCode);
        }
        this.mStartCameraCallbackList.clear();
    }

    private CameraVideoCapturer onCreateCapturer(String deviceName) {
        CameraVideoCapturer capturer = this.mCameraEnumerator.createCapturer(deviceName, new CameraVideoCapturer.CameraEventsHandler(){

            @Override
            public void onCameraError(String errorDescription) {
                FinLog.v("CameraManagerImpl", "onCameraError: " + errorDescription);
                CameraManagerImpl.this.mCameraStarted = false;
                CameraManagerImpl.this.onStartCameraFailed(RTCErrorCode.OPEN_CAMERA_FAILED);
            }

            @Override
            public void onCameraDisconnected() {
                FinLog.v("CameraManagerImpl", "onCameraDisconnected");
                CameraManagerImpl.this.mCameraStarted = false;
            }

            @Override
            public void onCameraFreezed(String errorDescription) {
                FinLog.v("CameraManagerImpl", "onCameraFreezed: " + errorDescription);
            }

            @Override
            public void onCameraOpening(String cameraName) {
                FinLog.v("CameraManagerImpl", "onCameraOpening: " + cameraName);
            }

            @Override
            public void onFirstFrameAvailable() {
                FinLog.v("CameraManagerImpl", "onFirstFrameAvailable");
            }

            @Override
            public void onCameraClosed() {
                FinLog.v("CameraManagerImpl", "onCameraClosed");
                CameraManagerImpl.this.mCameraStarted = false;
            }

            @Override
            public void onCameraStarted() {
                FinLog.v("CameraManagerImpl", "onCameraStarted");
                CameraManagerImpl.this.mCameraStarted = true;
                CameraManagerImpl.this.onCallbackCameraStart();
            }
        });
        capturer.initialize(this.surfaceTextureHelper, this.mContext, new CapturerObserver(){

            @Override
            public void onCapturerStarted(boolean success) {
                CapturerObserver capturerObserver = CameraManagerImpl.this.mCapturerObserver;
                if (capturerObserver != null) {
                    capturerObserver.onCapturerStarted(success);
                }
            }

            @Override
            public void onCapturerStopped() {
                CapturerObserver capturerObserver = CameraManagerImpl.this.mCapturerObserver;
                if (capturerObserver != null) {
                    capturerObserver.onCapturerStopped();
                }
            }

            @Override
            public void onFrameCaptured(VideoFrame frame) {
                CapturerObserver capturerObserver = CameraManagerImpl.this.mCapturerObserver;
                if (capturerObserver != null) {
                    capturerObserver.onFrameCaptured(frame);
                }
            }
        });
        return capturer;
    }

    private void onCallbackCameraStart() {
        this.execute(new Runnable(){

            @Override
            public void run() {
                for (IRCRTCResultDataCallback callback : CameraManagerImpl.this.mStartCameraCallbackList) {
                    if (callback == null) continue;
                    callback.onSuccess(CameraManagerImpl.this.isFrontCamera());
                }
                CameraManagerImpl.this.mStartCameraCallbackList.clear();
            }
        });
    }

    private void onStartCamera(int cameraId, int width, int height, int frameRate) {
        if (this.mCameraEnumerator == null) {
            this.onStartCameraFailed(RTCErrorCode.CAMERA_IS_RELEASED);
            return;
        }
        if (this.isCapturing()) {
            this.onCallbackCameraStart();
            return;
        }
        CameraVideoCapturer videoCapturer = this.videoCapturer;
        if (videoCapturer != null) {
            String deviceName;
            String string = deviceName = cameraId != -1 ? Camera1Enumerator.getDeviceName(cameraId) : null;
            if (!TextUtils.isEmpty((CharSequence)deviceName) && !TextUtils.equals((CharSequence)((Camera1Capturer)videoCapturer).getCameraName(), (CharSequence)deviceName)) {
                videoCapturer = this.createCameraCapture(cameraId);
            }
        } else {
            videoCapturer = this.createCameraCapture(cameraId);
        }
        this.videoCapturer = videoCapturer;
        if (videoCapturer == null) {
            return;
        }
        videoCapturer.startCapture(width, height, frameRate, this.mCameraOrientation, this.mFrameOrientation);
    }

    @Override
    public boolean isCameraFocusSupported() {
        CameraVideoCapturer capturer = this.videoCapturer;
        return capturer != null && capturer.isAreaFocusSupported();
    }

    @Override
    public boolean isCameraExposurePositionSupported() {
        CameraVideoCapturer capturer = this.videoCapturer;
        return capturer != null && capturer.isAreaExposureSupported();
    }

    @Override
    public boolean setCameraFocusPositionInPreview(float x, float y) {
        CameraVideoCapturer capturer = this.videoCapturer;
        return capturer != null && capturer.startFocusOn(x, y);
    }

    @Override
    public boolean setCameraExposurePositionInPreview(float x, float y) {
        CameraVideoCapturer capturer = this.videoCapturer;
        return capturer != null && capturer.startExposureOn(x, y);
    }

    @Override
    public Rect getAdaptedFrameSize() {
        CameraVideoCapturer capturer = this.videoCapturer;
        if (capturer != null) {
            return capturer.getAdaptedFrameSize();
        }
        return null;
    }

    @Override
    public boolean isFrontCamera() {
        CameraVideoCapturer videoCapturer = this.videoCapturer;
        CameraEnumerator cameraEnumerator = this.mCameraEnumerator;
        if (videoCapturer != null && cameraEnumerator != null) {
            return cameraEnumerator.isFrontFacing(((Camera1Capturer)videoCapturer).getCameraName());
        }
        return false;
    }

    @Override
    public void setFrameOrientation(int orientation) {
        this.mFrameOrientation = orientation;
    }

    @Override
    public boolean isCapturing() {
        return this.mCameraStarted;
    }

    @Override
    public void release() {
        this.execute(new Runnable(){

            @Override
            public void run() {
                CameraManagerImpl.this.onStopCamera();
                CameraManagerImpl.this.mCapturerObserver = null;
                CameraManagerImpl.this.mCameraEnumerator = null;
                if (CameraManagerImpl.this.videoCapturer != null) {
                    CameraManagerImpl.this.videoCapturer.dispose();
                }
                CameraManagerImpl.this.videoCapturer = null;
                if (CameraManagerImpl.this.surfaceTextureHelper != null) {
                    CameraManagerImpl.this.surfaceTextureHelper.dispose();
                }
                CameraManagerImpl.this.surfaceTextureHelper = null;
                CameraManagerImpl.this.mCameraStarted = false;
            }
        });
    }

    @Override
    public void setCameraDisplayOrientation(int orientation) {
        this.mCameraOrientation = orientation;
    }

    @Override
    public void stopCamera() {
        if (this.videoCapturer == null) {
            return;
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                CameraManagerImpl.this.onStopCamera();
            }
        });
    }

    private void onStopCamera() {
        this.mCameraStarted = false;
        CameraVideoCapturer videoCapturer = this.videoCapturer;
        if (videoCapturer != null) {
            try {
                videoCapturer.stopCapture();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace();
            }
        }
    }

    @Override
    public void switchCamera(final int cameraId, boolean mirror, final CameraVideoCapturer.CameraSwitchHandler handler) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                CameraManagerImpl.this.onSwitchCamera(cameraId, handler);
            }
        });
    }

    @Override
    public void switchCamera(final CameraVideoCapturer.CameraSwitchHandler handler) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                CameraManagerImpl.this.onSwitchCamera(-1, handler);
            }
        });
    }

    private void onSwitchCamera(int cameraId, CameraVideoCapturer.CameraSwitchHandler handler) {
        CameraVideoCapturer videoCapturer = this.videoCapturer;
        if (this.numberOfCameras < 2 || videoCapturer == null) {
            if (handler != null) {
                handler.onCameraSwitchError("No video is sent or only one camera is available or error happened.");
            }
            return;
        }
        FinLog.v("CameraManagerImpl", "Switch camera");
        String deviceName = cameraId == -1 ? null : Camera1Enumerator.getDeviceName(cameraId);
        videoCapturer.switchCamera(deviceName, handler);
    }

    @Override
    public void startCamera(final int width, final int height, final int frameRate, final IRCRTCResultDataCallback<Boolean> callback) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                if (callback != null) {
                    CameraManagerImpl.this.mStartCameraCallbackList.add(callback);
                }
                CameraManagerImpl.this.onStartCamera(-1, width, height, frameRate);
            }
        });
    }

    @Override
    public void startCamera(final int cameraId, final int width, final int height, final int frameRate, final IRCRTCResultDataCallback<Boolean> callback) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                if (callback != null) {
                    CameraManagerImpl.this.mStartCameraCallbackList.add(callback);
                }
                CameraManagerImpl.this.onStartCamera(cameraId, width, height, frameRate);
            }
        });
    }

    @Override
    public void restartCamera(final int width, final int height, final int frameRate) {
        if (this.videoCapturer == null) {
            return;
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                CameraManagerImpl.this.onStopCamera();
                CameraManagerImpl.this.onStartCamera(-1, width, height, frameRate);
            }
        });
    }

    @Override
    public void setCaptureObserver(CapturerObserver capturerObserver) {
        this.mCapturerObserver = capturerObserver;
    }

    private void execute(Runnable runnable) {
        this.cameraThreadHandler.post(runnable);
    }
}

