/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.module;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.RemoteException;
import android.text.TextUtils;
import cn.rongcloud.rtc.api.RCRTCRemoteUser;
import cn.rongcloud.rtc.api.callback.IRCRTCRoomEventsListener;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RCRTCResourceState;
import cn.rongcloud.rtc.base.RCRTCRoomType;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.RCRemoteUserImpl;
import cn.rongcloud.rtc.center.RCRoomImpl;
import cn.rongcloud.rtc.center.stream.RCInputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCStreamImpl;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.engine.tools.IRoomIdChangeListener;
import cn.rongcloud.rtc.module.IHeartbeatListener;
import cn.rongcloud.rtc.signal.SignalManager;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import io.rong.imlib.IMLibRTCClient;
import io.rong.imlib.IRTCHeartbeatListener;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.RTCUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class RTCPingManager
implements IRoomIdChangeListener {
    private static final int PING_PERIOD = 10000;
    private static final String TAG = "RTCPingManager";
    private Timer pingTimer;
    private Context mContext;
    private boolean mEnableAutoReconnect;
    private String mMainRoomId;
    private Map<String, HeartbeatInfo> mRoomIdConcurrentHashMap = new ConcurrentHashMap<String, HeartbeatInfo>();
    private StringBuffer stringBuffer_PING = new StringBuffer();
    private String[] roomIdArray = null;
    private int roomIdArrayCount = 0;

    public RTCPingManager(String roomId, Context context, boolean enableAutoReconnect) {
        this.mMainRoomId = roomId;
        this.mContext = context;
        this.mEnableAutoReconnect = enableAutoReconnect;
        this.mRoomIdConcurrentHashMap.clear();
        this.mRoomIdConcurrentHashMap.put(this.mMainRoomId, new HeartbeatInfo(0, 0));
        this.startPing();
    }

    private void startPing() {
        if (this.pingTimer == null) {
            this.pingTimer = new Timer();
        } else {
            this.pingTimer.cancel();
            this.pingTimer = new Timer();
        }
        this.setRTCHeartbeatListener(new IHeartbeatListener(){

            @Override
            public void onSuccess(String roomId) {
                int pingErrorCode = RTCPingManager.this.getPINGErrorCode(roomId);
                int pingFailedCount = RTCPingManager.this.getPingFailedCount(roomId);
                if (pingErrorCode != 0) {
                    FinLog.e(RTCPingManager.TAG, "sendRTCPing.Success :  mPingErrorCode : " + pingErrorCode + " , roomId :" + roomId + " , MainRoomId :" + RTCPingManager.this.mMainRoomId);
                } else {
                    FinLog.v(RTCPingManager.TAG, "sendRTCPing.Success : " + roomId + " , MainRoomId :" + RTCPingManager.this.mMainRoomId);
                }
                RTCPingManager.this.clearHearbeatInfo(roomId);
                if (!(pingFailedCount < 4 || TextUtils.equals((CharSequence)roomId, (CharSequence)RTCPingManager.this.mMainRoomId) || pingErrorCode != RongIMClient.ErrorCode.RC_NET_CHANNEL_INVALID.getValue() && pingErrorCode != RongIMClient.ErrorCode.RC_MSG_RESP_TIMEOUT.getValue())) {
                    RTCPingManager.this.otherRoomConnectedError(roomId, pingErrorCode);
                    return;
                }
                if (TextUtils.equals((CharSequence)roomId, (CharSequence)RTCPingManager.this.mMainRoomId) && (pingErrorCode == RongIMClient.ErrorCode.RC_NET_CHANNEL_INVALID.getValue() || pingErrorCode == RongIMClient.ErrorCode.RC_MSG_RESP_TIMEOUT.getValue())) {
                    RTCEngineImpl.getInstance().sendMessage(8000, new Object[0]);
                }
            }

            @Override
            public void onFailed(RTCErrorCode errorCode, String roomID) {
                int pingErrorCode = errorCode.getValue();
                RTCPingManager.this.updateHeartbeatInfo(roomID, pingErrorCode);
                int pingFailedCount = RTCPingManager.this.getPingFailedCount(roomID);
                FinLog.e(RTCPingManager.TAG, "sendRTCPing() error =  " + pingErrorCode + " , pingFailedCount :" + pingFailedCount + " , netWorkAvailable = " + RTCPingManager.this.isNetWorkAvailable() + " ,IM connectionStatus = " + RongIMClient.getInstance().getCurrentConnectionStatus() + " , roomID :" + roomID + " , EnableAutoReconnect :" + RTCPingManager.this.mEnableAutoReconnect + " , MainRoomId \uff1a" + RTCPingManager.this.mMainRoomId);
                if (pingFailedCount >= 4 && !TextUtils.equals((CharSequence)roomID, (CharSequence)RTCPingManager.this.mMainRoomId)) {
                    RTCPingManager.this.otherRoomConnectedError(roomID, pingErrorCode);
                    return;
                }
                if (TextUtils.equals((CharSequence)roomID, (CharSequence)RTCPingManager.this.mMainRoomId)) {
                    if (RTCPingManager.this.mEnableAutoReconnect) {
                        if (RongIMClient.getInstance().getCurrentConnectionStatus() == RongIMClient.ConnectionStatusListener.ConnectionStatus.CONNECTED && (errorCode.getValue() == 40001 || errorCode.getValue() == RTCErrorCode.RongRTCCodeNoMatchedRoom.getValue())) {
                            RTCPingManager.this.clearHearbeatInfo(roomID);
                            RTCEngineImpl.getInstance().sendMessage(8101, new Object[0]);
                        }
                    } else if (pingFailedCount >= 4) {
                        RTCPingManager.this.clearHearbeatInfo(roomID);
                        FinLog.e(RTCPingManager.TAG, "The number of heartbeats has arrived.");
                        RTCPingManager.this.stopPing();
                        ReportUtil.libStatus(ReportUtil.TAG.EXCEPTIONALLEAVEROOM, "roomId", RTCPingManager.this.mMainRoomId);
                        RTCEngineImpl.getInstance().sendMessage(9001, new Object[0]);
                    }
                }
            }
        });
        this.pingTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                RTCPingManager.access$802(RTCPingManager.this, RTCPingManager.this.mRoomIdConcurrentHashMap.keySet().toArray(new String[RTCPingManager.this.mRoomIdConcurrentHashMap.keySet().size()]));
                RTCPingManager.this.roomIdArrayCount = RTCPingManager.this.roomIdArray.length;
                if (RTCPingManager.this.roomIdArray == null || RTCPingManager.this.roomIdArrayCount == 0) {
                    FinLog.e(RTCPingManager.TAG, "Room number is empty.");
                    return;
                }
                RTCPingManager.this.stringBuffer_PING.setLength(0);
                RTCPingManager.this.stringBuffer_PING.append("[");
                for (int i = 0; i < RTCPingManager.this.roomIdArrayCount; ++i) {
                    RTCPingManager.this.stringBuffer_PING.append(RTCPingManager.this.roomIdArray[i]);
                    if (i == RTCPingManager.this.roomIdArrayCount - 1) continue;
                    RTCPingManager.this.stringBuffer_PING.append(", ");
                }
                RTCPingManager.this.stringBuffer_PING.append(']');
                FinLog.d(RTCPingManager.TAG, "sendRTCPing : " + RTCPingManager.this.stringBuffer_PING.toString());
                IMLibRTCClient.getInstance().SendRTCHeartbeat(RTCPingManager.this.roomIdArray);
            }
        }, 0L, 10000L);
    }

    private void otherRoomConnectedError(String roomId, int pingErrorCode) {
        FinLog.v(TAG, "sendRTCPing.otherRoomConnectedError : " + roomId);
        RTCEngineImpl.getInstance().sendMessage(2078, roomId, pingErrorCode);
        if (this.mRoomIdConcurrentHashMap != null) {
            this.mRoomIdConcurrentHashMap.remove(roomId);
        }
    }

    public void reJoinRoom(RCRTCRoomType roomType) {
        ReportUtil.libTask(ReportUtil.TAG.REJOINROOM, "roomId|uid|roomType|liveType", this.mMainRoomId, RongIMClient.getInstance().getCurrentUserId(), roomType.getRoomType(), roomType.getMediaType());
        SignalManager.getInstance().joinRoom(this.mMainRoomId, roomType, true, new IRongCallback.IRTCJoinRoomCallbackEx<Object[]>(){

            public void onSuccess(List<RTCUser> rtcUsers, Object[] exarams) {
                ReportUtil.libRes(ReportUtil.TAG.REJOINROOM, "roomId|code", RTCPingManager.this.mMainRoomId, 0);
                RTCEngineImpl.getInstance().sendMessage(8102, (Object)rtcUsers);
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                RTCEngineImpl.getInstance().engineError(RTCErrorCode.RECONNECT_ERROR);
                ReportUtil.libError(ReportUtil.TAG.REJOINROOM, 2, "roomId|code|desc", RTCPingManager.this.mMainRoomId, errorCode.getValue(), errorCode.getMessage());
            }
        });
    }

    private boolean isNetWorkAvailable() {
        ConnectivityManager manager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo info = manager.getActiveNetworkInfo();
        if (info != null) {
            return info.isConnected();
        }
        return false;
    }

    public void stopPing() {
        if (this.pingTimer != null) {
            try {
                this.pingTimer.cancel();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.pingTimer = null;
        }
    }

    public void diffUsers(RCRoomImpl room, List<RTCUser> list) {
        RCRTCRemoteUser oldUser2;
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        List<RCRTCRemoteUser> oldRemoteUsers = room.getRemoteUsers();
        int newUserSize = RongRTCUtils.isEmpty(list) ? 0 : list.size();
        ReportUtil.libStatus(ReportUtil.TAG.DIFFDATA, "roomId|oldUsers|newUsers", room.getRoomId(), oldRemoteUsers.size() + 1, newUserSize);
        if (newUserSize == 0) {
            this.onUserLeft(room, oldRemoteUsers);
            return;
        }
        ArrayList<RCRTCRemoteUser> userLefts = new ArrayList<RCRTCRemoteUser>();
        for (RCRTCRemoteUser oldUser2 : oldRemoteUsers) {
            boolean left = true;
            for (RTCUser rtcUser : list) {
                if (!rtcUser.getUid().equals(oldUser2.getUserId())) continue;
                left = false;
                break;
            }
            if (!left) continue;
            userLefts.add(oldUser2);
        }
        ArrayList<RCRTCRemoteUser> newUsers = new ArrayList<RCRTCRemoteUser>();
        oldUser2 = null;
        String localUserId = room.getLocalUser().getUserId();
        for (RTCUser rtcUser : list) {
            if (rtcUser.getData() == null) continue;
            RCRemoteUserImpl tmp = RCRemoteUserImpl.parseRemoteUsers(rtcUser.getUid(), (String)rtcUser.getData().get("uris"));
            oldUser2 = room.getRemoteUser(rtcUser.getUid());
            if (oldUser2 != null) {
                this.differStream((RCRemoteUserImpl)oldUser2, tmp.getStreams(), oldUser2.getStreams(), room.getEventsListener());
                continue;
            }
            if (TextUtils.equals((CharSequence)rtcUser.getUid(), (CharSequence)localUserId)) continue;
            newUsers.add(tmp);
        }
        this.onUserLeft(room, userLefts);
        this.onAddNewUser(room, newUsers);
    }

    private void onAddNewUser(RCRoomImpl room, ArrayList<RCRTCRemoteUser> newUsers) {
        if (RongRTCUtils.isEmpty(newUsers)) {
            return;
        }
        for (RCRTCRemoteUser user : newUsers) {
            room.addRemoteUser(user);
            ReportUtil.reportRemoteUserResource(true, this.mMainRoomId, user.getUserId(), user.getStreams());
            if (room.getEventsListener() == null) continue;
            room.getEventsListener().onRemoteUserPublishResource(user, user.getStreams());
        }
    }

    private void onUserLeft(RCRoomImpl room, List<RCRTCRemoteUser> users) {
        if (RongRTCUtils.isEmpty(users)) {
            return;
        }
        for (RCRTCRemoteUser user : users) {
            room.removeRemoteUser(user.getUserId());
            ReportUtil.libStatus(ReportUtil.TAG.ONREMOTEUSERLEFT, "uid", user.getUserId());
            if (room.getEventsListener() == null) continue;
            room.getEventsListener().onUserLeft(user);
        }
    }

    private void differStream(RCRemoteUserImpl remoteUser, List<RCRTCInputStream> streams, List<RCRTCInputStream> oldStreams, IRCRTCRoomEventsListener eventsListener) {
        int newStreamSize = RongRTCUtils.isEmpty(streams) ? 0 : streams.size();
        int oldStreamSize = RongRTCUtils.isEmpty(oldStreams) ? 0 : oldStreams.size();
        ReportUtil.libStatus(ReportUtil.TAG.DIFFSTREAM, "roomId|userId|oldStreams|newStreams", this.mMainRoomId, remoteUser.getUserId(), oldStreamSize, newStreamSize);
        if (RongRTCUtils.isEmpty(streams)) {
            ReportUtil.reportRemoteUserResource(false, this.mMainRoomId, remoteUser.getUserId(), oldStreams);
            if (eventsListener != null) {
                eventsListener.onRemoteUserUnpublishResource(remoteUser, oldStreams);
            }
            remoteUser.clearStream();
        } else if (RongRTCUtils.isEmpty(oldStreams)) {
            for (RCRTCInputStream stream : streams) {
                remoteUser.addStream(stream);
            }
            ReportUtil.reportRemoteUserResource(true, this.mMainRoomId, remoteUser.getUserId(), streams);
            if (eventsListener != null) {
                eventsListener.onRemoteUserPublishResource(remoteUser, streams);
            }
        } else {
            RCStreamImpl oldStream = null;
            ArrayList<RCRTCInputStream> newStreams = new ArrayList<RCRTCInputStream>();
            for (RCRTCInputStream stream : streams) {
                oldStream = null;
                for (RCRTCInputStream inputStream : oldStreams) {
                    if (!TextUtils.equals((CharSequence)inputStream.getTag(), (CharSequence)stream.getTag()) || inputStream.getMediaType() != stream.getMediaType()) continue;
                    oldStream = (RCInputStreamImpl)inputStream;
                    break;
                }
                if (oldStream == null) {
                    remoteUser.addStream(stream);
                    newStreams.add(stream);
                    continue;
                }
                if (stream.getResourceState() != oldStream.getResourceState()) {
                    oldStream.setResourceState(stream.getResourceState());
                    ReportUtil.libStatus(ReportUtil.TAG.ONREMOTEUSERMODIFYRESOURCE, "modifyMsg", oldStream.toString());
                    if (eventsListener != null) {
                        if (oldStream.getMediaType().equals((Object)RCRTCMediaType.AUDIO)) {
                            eventsListener.onRemoteUserMuteAudio(remoteUser, (RCRTCInputStream)((Object)oldStream), !oldStream.getResourceState().equals((Object)RCRTCResourceState.NORMAL));
                        } else if (oldStream.getMediaType().equals((Object)RCRTCMediaType.VIDEO)) {
                            eventsListener.onRemoteUserMuteVideo(remoteUser, (RCRTCInputStream)((Object)oldStream), oldStream.getResourceState().equals((Object)RCRTCResourceState.NORMAL));
                        }
                    }
                }
                if (TextUtils.equals((CharSequence)stream.getUri(), (CharSequence)oldStream.getUri())) continue;
                oldStream.setUri(stream.getUri());
            }
            if (!RongRTCUtils.isEmpty(newStreams) && eventsListener != null) {
                ReportUtil.reportRemoteUserResource(true, this.mMainRoomId, remoteUser.getUserId(), newStreams);
                eventsListener.onRemoteUserPublishResource(remoteUser, newStreams);
            }
        }
    }

    private void setRTCHeartbeatListener(final IHeartbeatListener callBack) {
        IMLibRTCClient.getInstance().SetRTCHeartbeatListener(new IRTCHeartbeatListener.Stub(){

            public void OnRTCHeartbeat(int code, String roomId) throws RemoteException {
                if (code == 0) {
                    callBack.onSuccess(roomId);
                } else {
                    callBack.onFailed(RTCErrorCode.valueOf(code), roomId);
                }
            }
        });
    }

    @Override
    public void onNotify(String[] roomIds) {
        if (this.mRoomIdConcurrentHashMap != null && roomIds != null && roomIds.length > 0) {
            HashMap<String, HeartbeatInfo> map = new HashMap<String, HeartbeatInfo>(this.mRoomIdConcurrentHashMap.size());
            for (Map.Entry<String, HeartbeatInfo> entry : this.mRoomIdConcurrentHashMap.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
            this.mRoomIdConcurrentHashMap.clear();
            for (String id : roomIds) {
                HeartbeatInfo info = null;
                if (map.containsKey(id)) {
                    info = (HeartbeatInfo)map.get(id);
                }
                this.mRoomIdConcurrentHashMap.put(id, info == null ? new HeartbeatInfo(0, 0) : info);
            }
            map.clear();
            Object var2_2 = null;
        }
    }

    private int getPINGErrorCode(String roomId) {
        int code = 0;
        HeartbeatInfo heartbeatInfo = this.mRoomIdConcurrentHashMap.get(roomId);
        if (heartbeatInfo != null) {
            code = heartbeatInfo.getPingErrorCode();
        }
        return code;
    }

    private int getPingFailedCount(String roomId) {
        int count = 0;
        HeartbeatInfo heartbeatInfo = this.mRoomIdConcurrentHashMap.get(roomId);
        if (heartbeatInfo != null) {
            count = heartbeatInfo.getPingFailedCount();
        }
        return count;
    }

    private void updateHeartbeatInfo(String roomId, int errorCode) {
        HeartbeatInfo heartbeatInfo = this.mRoomIdConcurrentHashMap.get(roomId);
        if (heartbeatInfo != null) {
            heartbeatInfo.setPingErrorCode(errorCode);
            int count = heartbeatInfo.getPingFailedCount();
            heartbeatInfo.setPingFailedCount(++count);
        } else {
            this.mRoomIdConcurrentHashMap.put(roomId, new HeartbeatInfo(errorCode, 0));
        }
    }

    private void clearHearbeatInfo(String roomid) {
        this.mRoomIdConcurrentHashMap.put(roomid, new HeartbeatInfo(0, 0));
    }

    static /* synthetic */ String[] access$802(RTCPingManager x0, String[] x1) {
        x0.roomIdArray = x1;
        return x1;
    }

    private class HeartbeatInfo {
        private int pingErrorCode = 0;
        private int pingFailedCount = 0;

        public HeartbeatInfo(int pingErrorCode, int pingFailedCount) {
            this.pingErrorCode = pingErrorCode;
            this.pingFailedCount = pingFailedCount;
        }

        public int getPingErrorCode() {
            return this.pingErrorCode;
        }

        public int getPingFailedCount() {
            return this.pingFailedCount;
        }

        public void setPingErrorCode(int pingErrorCode) {
            this.pingErrorCode = pingErrorCode;
        }

        public void setPingFailedCount(int pingFailedCount) {
            this.pingFailedCount = pingFailedCount;
        }
    }
}

