/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.module;

import android.content.Context;
import android.media.AudioManager;
import android.util.Log;
import cn.rongcloud.rtc.api.callback.IRCRTCAudioDataListener;
import cn.rongcloud.rtc.api.stream.RCRTCAudioStreamConfig;
import cn.rongcloud.rtc.base.RCRTCAudioFrame;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.base.RCRTCSyncCallBack;
import cn.rongcloud.rtc.center.config.RCRTCConfigImpl;
import cn.rongcloud.rtc.center.stream.RCAudioStreamConfigImpl;
import cn.rongcloud.rtc.core.AudioSource;
import cn.rongcloud.rtc.core.AudioTrack;
import cn.rongcloud.rtc.core.MediaConstraints;
import cn.rongcloud.rtc.core.RongAudioRecord;
import cn.rongcloud.rtc.core.RongAudioTrack;
import cn.rongcloud.rtc.core.audio.AudioDeviceModule;
import cn.rongcloud.rtc.core.audio.CustomAudioDeviceModule;
import cn.rongcloud.rtc.core.audio.OnAudioBufferAvailableListener;
import cn.rongcloud.rtc.core.audio.OnAudioDeviceErrorListener;
import cn.rongcloud.rtc.core.rongRTC.DevicesUtils;
import cn.rongcloud.rtc.utils.AudioUtil;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AudioDeviceManager {
    private static final String AUDIO_GOOGECHO_CANCELLATION_CONSTRAINT = "googEchoCancellation";
    private static final String AUDIO_GOOGECHO_CANCELLATION2_CONSTRAINT = "googEchoCancellation2";
    private static final String AUDIO_GOOGDAE_ECHOCANCELLATION_CONSTRAINT = "googDAEchoCancellation";
    private static final String AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT = "googAutoGainControl";
    private static final String AUDIO_EXPERIMENTAL_AGC = "googAutoGainControl2";
    private static final String AUDIO_AGC_TX_AGC_TARGET_DBOV = "txAgcTargetDbov";
    private static final String AUDIO_AGC_TX_AGC_DIGITAL_COMPRESSION_GAIN = "txAgcDigitaCompressionGain";
    private static final String AUDIO_AGC_TX_AGC_LIMITER = "txAgcLimiter";
    private static final String AUDIO_PRE_AMPLIFIER = "preAmplifier";
    private static final String AUDIO_PRE_AMPLIFIER_LEVEL = "fixedGainFactor";
    private static final String AUDIO_NOISE_SUPPRESSION_CONSTRAINT = "googNoiseSuppression";
    private static final String AUDIO_NOISE_SUPPRESSION_CONSTRAINT_LEVEL = "googNoiseSuppressionLevel";
    private static final String AUDIO_EXPERIMENTAL_NS = "googNoiseSuppression2";
    private static final String AUDIO_HIGH_PASS_FILTER_CONSTRAINT = "googHighpassFilter";
    private static final String AUDIO_TYPING_DETECTION = "googTypingNoiseDetection";
    private static final String AUDIO_RESIDUAL_ECHO_DETECTOR = "residualEchoDetector";
    private static final String AUDIO_STEREO_SWAPPING = "googAudioMirroring";
    private static final String AUDIO_JITTER_BUFFER_MAX_PACKETS = "jitterBufferMaxPackets";
    private static final String AUDIO_JITTER_BUFFER_FAST_ACCELERATE = "jitterBufferFastAccelerate";
    private static final String AUDIO_JITTER_BUFFER_MIN_DELAY_MS = "jitterBufferMinDelayMs";
    private static final String AUDIO_JITTER_BUFFER_ENABLE_RTX_HANDLING = "jitterBufferEnableRtxHandling";
    private static final int DEFAULT_RECORDING_VOLUME = 100;
    private static final String TAG = AudioDeviceManager.class.getSimpleName();
    private AudioDeviceModule audioDeviceModule;
    private boolean isAudioMute;
    private RongAudioRecord rongAudioRecord;
    private MediaConstraints audioConstraints;
    private static final Map<String, Integer> AGC_CONFIG_MAP = new HashMap<String, Integer>();
    private RCAudioStreamConfigImpl audioConfig;
    private int recordingVolume = 100;
    private byte[] localFrame;
    private RCRTCAudioFrame RCRTCAudioFrame = null;
    private IRCRTCAudioDataListener mAudioDataListener;
    private final Object audioBufferListenerLock = new Object();
    private List<OnAudioBufferAvailableListener> audioBufferListeners = new ArrayList<OnAudioBufferAvailableListener>();
    private AudioManager audioManager;
    private RongAudioTrack mRongAudioTrack;

    public AudioDeviceManager(Context context, RCRTCConfigImpl rtcConfig, RCAudioStreamConfigImpl audioConfig) {
        this.audioConfig = audioConfig;
        this.audioManager = this.getAudioManager(context);
        this.initLocalSource();
        this.initAudioDeviceModule(context, rtcConfig);
    }

    private AudioManager getAudioManager(Context context) {
        if (context == null) {
            return null;
        }
        AudioManager audioMgr = (AudioManager)context.getSystemService("audio");
        return audioMgr;
    }

    private void initLocalSource() {
        this.setAudioScenario(this.audioConfig.getAudioEFCTMode());
        Log.d((String)TAG, (String)"initLocalSource: ");
        this.createMediaConstraints();
    }

    private void initAudioDeviceModule(Context context, final RCRTCConfigImpl rtcConfig) {
        OnAudioBufferAvailableListener audioBufferAvailableListener = new OnAudioBufferAvailableListener(){
            byte[] emptyData;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAudioBuffer(ByteBuffer byteBuffer, int sizeInBytes, int sampleRate, int channelCount, int audioFormat) {
                if (AudioDeviceManager.this.isAudioMute) {
                    if (this.emptyData == null || this.emptyData.length != sizeInBytes) {
                        this.emptyData = new byte[sizeInBytes];
                    }
                    byteBuffer.clear();
                    byteBuffer.put(this.emptyData);
                }
                AudioUtil.adjustVolumeAsShort(byteBuffer, AudioUtil.linearToLog(AudioDeviceManager.this.recordingVolume));
                if (!AudioDeviceManager.this.isAudioMute && rtcConfig.isMicrophoneEnable() && AudioDeviceManager.this.mAudioDataListener != null) {
                    if (AudioDeviceManager.this.localFrame == null || AudioDeviceManager.this.localFrame.length != sizeInBytes) {
                        AudioDeviceManager.access$302(AudioDeviceManager.this, new byte[sizeInBytes]);
                    }
                    byteBuffer.rewind();
                    byteBuffer.get(AudioDeviceManager.this.localFrame, 0, AudioDeviceManager.this.localFrame.length);
                    if (AudioDeviceManager.this.RCRTCAudioFrame == null) {
                        AudioDeviceManager.this.RCRTCAudioFrame = new RCRTCAudioFrame();
                    }
                    AudioDeviceManager.this.RCRTCAudioFrame.setBytes(AudioDeviceManager.this.localFrame);
                    AudioDeviceManager.this.RCRTCAudioFrame.setLength(AudioDeviceManager.this.localFrame.length);
                    AudioDeviceManager.this.RCRTCAudioFrame.setChannels(channelCount);
                    AudioDeviceManager.this.RCRTCAudioFrame.setSampleRate(sampleRate);
                    AudioDeviceManager.this.RCRTCAudioFrame.setAudioFormat(audioFormat);
                    byte[] tmp = null;
                    if (AudioDeviceManager.this.mAudioDataListener != null) {
                        tmp = AudioDeviceManager.this.mAudioDataListener.onAudioFrame(AudioDeviceManager.this.RCRTCAudioFrame);
                    }
                    if (tmp != null) {
                        if (tmp.length == byteBuffer.capacity()) {
                            byteBuffer.clear();
                            byteBuffer.put(tmp);
                        } else {
                            FinLog.e(TAG, "Error:The processed data is not the same length as the original data.");
                        }
                        tmp = null;
                    }
                }
                Object object = AudioDeviceManager.this.audioBufferListenerLock;
                synchronized (object) {
                    for (OnAudioBufferAvailableListener listener : AudioDeviceManager.this.audioBufferListeners) {
                        listener.onAudioBuffer(byteBuffer, sizeInBytes, sampleRate, channelCount, audioFormat);
                    }
                }
            }
        };
        RongAudioRecord audioRecord = new RongAudioRecord();
        audioRecord.setOnAudioBufferAvailableListener(audioBufferAvailableListener);
        this.rongAudioRecord = audioRecord;
        this.mRongAudioTrack = new RongAudioTrack();
        OnAudioDeviceErrorListener onAudioDeviceErrorListener = new OnAudioDeviceErrorListener(){

            @Override
            public void onAudioDeviceError(int errorCode) {
                String device = "Device";
                if (errorCode == -1) {
                    device = "Engine";
                } else if (errorCode == -2) {
                    device = "Recorder";
                } else if (errorCode == -3) {
                    device = "Player";
                }
                ReportUtil.libError(ReportUtil.TAG.OPENSLES_DEVICE_ERR, "code|desc", errorCode, "OpenSLES " + device + " Error");
                AudioDeviceManager.this.audioDeviceModule.changeAudioInput();
            }
        };
        this.audioDeviceModule = rtcConfig.isLowLatencyRecordingEnabled() ? CustomAudioDeviceModule.builder(context).setAudioSource(rtcConfig.getAudioSource()).setSampleRate(rtcConfig.getAudioSampleRate()).setUseStereoInput(rtcConfig.isStereo()).setUseStereoOutput(rtcConfig.isStereo()).createEchoAudioDeviceModule(audioBufferAvailableListener, onAudioDeviceErrorListener, audioRecord, this.mRongAudioTrack) : CustomAudioDeviceModule.builder(context).setAudioSource(rtcConfig.getAudioSource()).setSampleRate(rtcConfig.getAudioSampleRate()).setUseStereoInput(rtcConfig.isStereo()).setUseStereoOutput(rtcConfig.isStereo()).createAudioDeviceModule(audioRecord, this.mRongAudioTrack);
    }

    public AudioDeviceModule getAudioDeviceModule() {
        return this.audioDeviceModule;
    }

    public boolean isRecording() {
        if (this.rongAudioRecord != null) {
            return this.rongAudioRecord.isRecording();
        }
        return false;
    }

    public void muteAudio(boolean isMute) {
        this.isAudioMute = isMute;
    }

    public boolean isAudioMute() {
        return this.isAudioMute;
    }

    private void switchAudioSource(RCRTCParamsType.AudioScenario audioScenario, RCRTCSyncCallBack otherActions, AudioTrack audioTrack) {
        AudioSource audioSource;
        if (audioTrack != null && (audioSource = audioTrack.getAudioSource()) != null) {
            audioTrack.setEnabled(false);
            this.refreshAudioConstraints(audioScenario, otherActions);
            audioSource.updateOptions(this.audioConstraints);
            audioTrack.setEnabled(true);
        } else {
            FinLog.w(TAG, "update audio constraints for config failed");
        }
    }

    private MediaConstraints refreshAudioConstraints(RCRTCParamsType.AudioScenario audioScenario, RCRTCSyncCallBack otherActions) {
        this.audioConfig = audioScenario == RCRTCParamsType.AudioScenario.MUSIC ? (RCAudioStreamConfigImpl)RCRTCAudioStreamConfig.Builder.create().buildMusicMode() : (RCAudioStreamConfigImpl)RCRTCAudioStreamConfig.Builder.create().buildDefaultMode();
        if (otherActions != null) {
            otherActions.syncActions();
        }
        Log.d((String)TAG, (String)"refreshAudioConstraints: jch");
        this.createMediaConstraints();
        return this.audioConstraints;
    }

    public void switchSpeechMusicMode(AudioTrack audioTrack, RCRTCParamsType.AudioScenario audioScenario, RCRTCSyncCallBack otherActions) {
        int mode;
        if (this.audioManager == null) {
            FinLog.e(TAG, "changeAudioScenario failed ! audioManager is null");
            return;
        }
        this.switchAudioSource(audioScenario, otherActions, audioTrack);
        this.setAudioScenario(audioScenario);
        int n = mode = DevicesUtils.getAudioMode() == 3 ? 0 : 3;
        if (this.rongAudioRecord != null) {
            int audioSource = audioScenario == RCRTCParamsType.AudioScenario.MUSIC ? 0 : 7;
            this.rongAudioRecord.switchAudioSource(audioSource);
        }
        this.audioManager.setMode(mode);
    }

    private void setAudioScenario(RCRTCParamsType.AudioScenario mode) {
        if (mode == RCRTCParamsType.AudioScenario.MUSIC) {
            DevicesUtils.setPlayMode(DevicesUtils.AudioPlayMode.MUSIC);
        } else {
            DevicesUtils.setPlayMode(DevicesUtils.AudioPlayMode.SPEEK);
        }
    }

    public IRCRTCAudioDataListener getAudioDataListener() {
        return this.mAudioDataListener;
    }

    public void setAudioDataListener(IRCRTCAudioDataListener audioDataListener) {
        this.mAudioDataListener = audioDataListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAudioBufferListener(OnAudioBufferAvailableListener listener) {
        Object object = this.audioBufferListenerLock;
        synchronized (object) {
            this.audioBufferListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAudioBufferListener(OnAudioBufferAvailableListener listener) {
        Object object = this.audioBufferListenerLock;
        synchronized (object) {
            this.audioBufferListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAudioBufferListeners() {
        Object object = this.audioBufferListenerLock;
        synchronized (object) {
            this.audioBufferListeners.clear();
        }
    }

    public void release() {
        this.clearAudioBufferListeners();
        this.isAudioMute = false;
        this.mAudioDataListener = null;
        this.mRongAudioTrack = null;
        if (this.audioDeviceModule != null) {
            this.audioDeviceModule.release();
        }
    }

    public void adjustRecordingVolume(int volume) {
        this.recordingVolume = volume;
    }

    public int getRecodVolume() {
        return this.recordingVolume;
    }

    public void updateAudioConfig(RCRTCAudioStreamConfig config, AudioTrack audioTrack) {
        AudioSource audioSource;
        if (config != null && audioTrack != null && (audioSource = audioTrack.getAudioSource()) != null) {
            this.audioConfig = (RCAudioStreamConfigImpl)config;
            audioTrack.setEnabled(false);
            this.createMediaConstraints();
            Log.d((String)TAG, (String)("updateAudioConfig: jch\uff1a" + this.audioConstraints.toString()));
            audioSource.updateOptions(this.audioConstraints);
            audioTrack.setEnabled(true);
        } else {
            Log.d((String)TAG, (String)"not updateAudioConfig: jch");
        }
    }

    public void setRemoteAudioPCMBufferListener(IRCRTCAudioDataListener listener) {
        if (this.mRongAudioTrack != null) {
            this.mRongAudioTrack.setAudioDataListener(listener);
        }
    }

    public void muteAllRemoteAudio(boolean mute) {
        if (this.audioDeviceModule != null) {
            this.audioDeviceModule.setSpeakerMute(mute);
        }
    }

    public MediaConstraints getAudioConstraints() {
        Log.d((String)TAG, (String)("getAudioConstraints: jch" + this.audioConstraints.toString()));
        return this.audioConstraints;
    }

    protected void createMediaConstraints() {
        this.audioConstraints = new MediaConstraints();
        FinLog.v(TAG, "audioConfig: highPassFilter: isOn = " + this.audioConfig.isHighPassFilters());
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_HIGH_PASS_FILTER_CONSTRAINT, String.valueOf(this.audioConfig.isHighPassFilters())));
        FinLog.v(TAG, "audioConfig: echo cancel: mode " + this.audioConfig.getEchoCancel().name() + " filter " + this.audioConfig.isEchoFilter());
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_GOOGECHO_CANCELLATION_CONSTRAINT, String.valueOf(this.audioConfig.getEchoCancel() == RCRTCParamsType.AECMode.AEC_MODE1)));
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_GOOGDAE_ECHOCANCELLATION_CONSTRAINT, String.valueOf(this.audioConfig.getEchoCancel() == RCRTCParamsType.AECMode.AEC_MODE2)));
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_GOOGECHO_CANCELLATION2_CONSTRAINT, String.valueOf(this.audioConfig.isEchoFilter())));
        FinLog.v(TAG, "audioConfig: noise suppression: mode " + this.audioConfig.getNoiseSuppression().getValue() + " level " + this.audioConfig.getNoiseSuppressionLevel().getValue());
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_TYPING_DETECTION, "false"));
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_RESIDUAL_ECHO_DETECTOR, "false"));
        switch (this.audioConfig.getNoiseSuppression()) {
            case NS_MODE0: {
                this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT, "false"));
                this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_EXPERIMENTAL_NS, "false"));
                break;
            }
            case NS_MODE1: {
                this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT, "false"));
                this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_EXPERIMENTAL_NS, "true"));
                break;
            }
            case NS_MODE2: {
                this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT, "true"));
                this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_EXPERIMENTAL_NS, "false"));
                this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT_LEVEL, String.valueOf(this.audioConfig.getNoiseSuppressionLevel().getValue())));
                break;
            }
            case NS_MODE3: {
                this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT, "true"));
                this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_EXPERIMENTAL_NS, "true"));
                this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT_LEVEL, String.valueOf(this.audioConfig.getNoiseSuppressionLevel().getValue())));
            }
        }
        FinLog.v(TAG, "audioConfig: agc: isOn " + this.audioConfig.isAGCControl());
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT, String.valueOf(this.audioConfig.isAGCControl())));
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_EXPERIMENTAL_AGC, "false"));
        FinLog.v(TAG, "audioConfig: agc config: targetDBOV " + this.audioConfig.getAGCTargetdbov() + " compressionLevel " + this.audioConfig.getAgcCompression());
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_AGC_TX_AGC_LIMITER, "true"));
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_AGC_TX_AGC_TARGET_DBOV, String.valueOf(this.audioConfig.getAGCTargetdbov())));
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_AGC_TX_AGC_DIGITAL_COMPRESSION_GAIN, String.valueOf(this.audioConfig.getAgcCompression())));
        FinLog.v(TAG, "audioConfig: agc config: MIC PreAmplifier isOn " + this.audioConfig.isPreAmplifier() + " MIC level " + this.audioConfig.getPreAmplifierLevel());
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_PRE_AMPLIFIER, String.valueOf(this.audioConfig.isPreAmplifier())));
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_PRE_AMPLIFIER_LEVEL, String.valueOf(this.audioConfig.getPreAmplifierLevel())));
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_JITTER_BUFFER_MIN_DELAY_MS, "true"));
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_JITTER_BUFFER_ENABLE_RTX_HANDLING, "true"));
        Log.d((String)TAG, (String)("createMediaConstraints: " + this.audioConstraints.toString()));
    }

    static /* synthetic */ byte[] access$302(AudioDeviceManager x0, byte[] x1) {
        x0.localFrame = x1;
        return x1;
    }

    static {
        AGC_CONFIG_MAP.put("Nexus 5", 6);
    }
}

