/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine.tools.multiroom;

import android.text.TextUtils;
import cn.rongcloud.rtc.engine.tools.multiroom.AbstractMultipleRoom;
import cn.rongcloud.rtc.engine.tools.multiroom.BaseRoomElemet;
import cn.rongcloud.rtc.proxy.message.messagebeans.PKInfo;
import cn.rongcloud.rtc.utils.FinLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class RoomAttributesElement
extends AbstractMultipleRoom {
    public static final String TAG = "RoomAttributesElement";
    private static final String PUSH_OTHERROOM_ROOMID = "roomId";
    private static final String PUSH_OTHERROOM_AUTOMIX = "autoMix";
    private static final String PUSH_OTHERROOM_SESSIONID = "sessionId";
    private Map<String, PKInfo> concurrentHashMap;
    private String mMainRoomId = "";
    private BaseRoomElemet mBaseRoomElemet;

    public RoomAttributesElement(BaseRoomElemet baseRoomElemet) {
        this.mMainRoomId = baseRoomElemet.getMainRoomId();
        this.concurrentHashMap = new ConcurrentHashMap<String, PKInfo>(16);
        this.mBaseRoomElemet = baseRoomElemet;
    }

    public void put(PKInfo info) {
        if (info == null || TextUtils.isEmpty((CharSequence)info.getMultiRoomKey())) {
            FinLog.d(TAG, "putPKInfo->key is empty.");
            return;
        }
        String key = "";
        if (!TextUtils.equals((CharSequence)info.getInviteeRoomId(), (CharSequence)this.mMainRoomId)) {
            key = info.getInviteeRoomId();
        } else if (!TextUtils.equals((CharSequence)info.getInviterRoomId(), (CharSequence)this.mMainRoomId)) {
            key = info.getInviterRoomId();
        }
        FinLog.d(TAG, "putPKInfo->MultiRoomKey :" + info.getMultiRoomKey() + " , key :" + key);
        this.concurrentHashMap.put(key, info);
    }

    public PKInfo get(String otherRoomId) {
        if (TextUtils.isEmpty((CharSequence)otherRoomId)) {
            return null;
        }
        FinLog.d(TAG, "get. otherRoomId : " + otherRoomId);
        return this.concurrentHashMap.get(otherRoomId);
    }

    public void remove(String otherRoomId) {
        if (TextUtils.isEmpty((CharSequence)otherRoomId)) {
            return;
        }
        FinLog.d(TAG, "remove :" + otherRoomId);
        this.concurrentHashMap.remove(otherRoomId);
    }

    @Override
    public void release() {
        super.release();
        if (this.concurrentHashMap != null) {
            this.concurrentHashMap.clear();
        }
    }

    public String getAutoMixJSONInfo(String otherRoomIgnored) {
        String jsonInfo = "";
        if (this.concurrentHashMap == null || this.concurrentHashMap.size() == 0) {
            FinLog.e(TAG, "autoMix.Info is empty.");
            return jsonInfo;
        }
        JSONArray jsonArray = new JSONArray();
        try {
            String roomId = "";
            String roomSessionId = "";
            boolean autoMix = false;
            for (PKInfo info : this.concurrentHashMap.values()) {
                JSONObject jsonObject = new JSONObject();
                roomId = "";
                roomSessionId = "";
                autoMix = false;
                if (!TextUtils.equals((CharSequence)this.mMainRoomId, (CharSequence)info.getInviterRoomId())) {
                    roomId = info.getInviterRoomId();
                    autoMix = info.getInviterUserAutoMix();
                } else if (!TextUtils.equals((CharSequence)this.mMainRoomId, (CharSequence)info.getInviteeRoomId())) {
                    roomId = info.getInviteeRoomId();
                    autoMix = info.getInviteeUserAutoMix();
                }
                if (!TextUtils.isEmpty((CharSequence)roomId) && this.mBaseRoomElemet != null && !TextUtils.equals((CharSequence)roomId, (CharSequence)otherRoomIgnored)) {
                    roomSessionId = this.mBaseRoomElemet.getRoomSessionId(roomId);
                    if (!TextUtils.isEmpty((CharSequence)roomSessionId)) {
                        jsonObject.putOpt(PUSH_OTHERROOM_ROOMID, (Object)roomId);
                        jsonObject.putOpt(PUSH_OTHERROOM_AUTOMIX, (Object)autoMix);
                        jsonObject.putOpt(PUSH_OTHERROOM_SESSIONID, (Object)roomSessionId);
                        jsonArray.put((Object)jsonObject);
                        continue;
                    }
                    FinLog.e(TAG, "autoMix.Need to join other rooms first. roomId \uff1a " + roomId + " , sessionId : " + roomSessionId + ", otherRoomIgnored :" + otherRoomIgnored);
                    continue;
                }
                FinLog.e(TAG, "autoMix.room is empty. roomId : " + roomId + " , otherRoomIgnored :" + otherRoomIgnored);
            }
            jsonInfo = jsonArray.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FinLog.d(TAG, "autoMixJSON :" + jsonInfo);
        return jsonInfo;
    }
}

