/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine.tools.multiroom;

import android.text.TextUtils;
import cn.rongcloud.rtc.api.RCRTCBaseRoom;
import cn.rongcloud.rtc.api.RCRTCRemoteUser;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import cn.rongcloud.rtc.base.RCRTCSubscribeState;
import cn.rongcloud.rtc.center.RCOtherRoomImpl;
import cn.rongcloud.rtc.center.stream.RCInputStreamImpl;
import cn.rongcloud.rtc.engine.tools.IRoomIdChangeListener;
import cn.rongcloud.rtc.engine.tools.multiroom.AbstractMultipleRoom;
import cn.rongcloud.rtc.utils.FinLog;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class BaseRoomElemet
extends AbstractMultipleRoom {
    public static final String TAG = "BaseRoomElemet";
    private String mMainRoomId = "";
    private Map<String, RCRTCBaseRoom> concurrentHashMap;
    private IRoomIdChangeListener mListener;

    private BaseRoomElemet() {
    }

    public BaseRoomElemet(RCRTCBaseRoom room, IRoomIdChangeListener listener) {
        this.concurrentHashMap = new LinkedHashMap<String, RCRTCBaseRoom>();
        this.mMainRoomId = room.getRoomId();
        FinLog.d(TAG, "MainRoomId : " + this.mMainRoomId);
        this.concurrentHashMap.put(this.mMainRoomId, room);
        this.mListener = listener;
    }

    public void put(String roomId, RCRTCBaseRoom obj) {
        if (TextUtils.isEmpty((CharSequence)roomId) || obj == null) {
            return;
        }
        this.concurrentHashMap.put(roomId, obj);
        FinLog.d("UUKKJJEEE", "put :" + roomId + " thread :" + Thread.currentThread().getName());
        this.notifyChange();
    }

    public RCRTCBaseRoom remove(String roomId) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            return null;
        }
        FinLog.d(TAG, "remove :" + roomId);
        RCRTCBaseRoom baseRoom = this.concurrentHashMap.remove(roomId);
        this.notifyChange();
        return baseRoom;
    }

    public boolean containsKey(String roomId) {
        return this.concurrentHashMap.containsKey(roomId);
    }

    public boolean hasJoinedOtherRoom(String otherRoomId) {
        if (!TextUtils.equals((CharSequence)this.mMainRoomId, (CharSequence)otherRoomId) && this.containsKey(otherRoomId)) {
            FinLog.d(TAG, "hasJoinedOtherRoom->true->otherRoomId :" + otherRoomId);
            return true;
        }
        FinLog.d(TAG, "hasJoinedOtherRoom->false->otherRoomId :" + otherRoomId);
        return false;
    }

    public RCRTCBaseRoom get(String roomId) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            FinLog.e(TAG, "otherRoomRelease.get.RoomId is empty.");
            return null;
        }
        FinLog.d(TAG, "getRoom :" + roomId + " , size :" + this.concurrentHashMap.size());
        return this.concurrentHashMap.get(roomId);
    }

    public void otherRoomRelease(String otherRoomId) {
        if (TextUtils.isEmpty((CharSequence)otherRoomId)) {
            FinLog.e(TAG, "otherRoomRelease.otherRoomId is empty.");
            return;
        }
        RCRTCBaseRoom obj = this.concurrentHashMap.remove(otherRoomId);
        if (obj != null && obj instanceof RCOtherRoomImpl) {
            RCOtherRoomImpl rcOtherRoom = (RCOtherRoomImpl)obj;
            rcOtherRoom.release();
        } else {
            FinLog.e(TAG, "otherRoomRelease.It's not other room.");
        }
    }

    public List<String> leaveAllOtherRoom() {
        ArrayList<String> list = new ArrayList<String>(this.concurrentHashMap.values().size());
        for (String id : this.concurrentHashMap.keySet()) {
            if (TextUtils.equals((CharSequence)id, (CharSequence)this.mMainRoomId)) continue;
            list.add(id);
        }
        FinLog.d(TAG, "leaveAllOtherRoom :" + list.size());
        return list;
    }

    public List<RCRTCInputStream> getOtherRoomInputStreams() {
        ArrayList<RCRTCInputStream> streamList = new ArrayList<RCRTCInputStream>();
        if (this.concurrentHashMap == null || this.concurrentHashMap.size() == 0) {
            return streamList;
        }
        for (RCRTCBaseRoom value : this.concurrentHashMap.values()) {
            if (TextUtils.equals((CharSequence)value.getRoomId(), (CharSequence)this.mMainRoomId)) continue;
            for (RCRTCRemoteUser remoteUser : value.getRemoteUsers()) {
                streamList.addAll(remoteUser.getStreams());
            }
        }
        return streamList;
    }

    public List<RCRTCInputStream> getOtherRoomSubscribedStreams() {
        ArrayList<RCRTCInputStream> streamList = new ArrayList<RCRTCInputStream>();
        if (this.concurrentHashMap == null || this.concurrentHashMap.size() == 0) {
            return streamList;
        }
        for (RCRTCBaseRoom value : this.concurrentHashMap.values()) {
            if (TextUtils.equals((CharSequence)value.getRoomId(), (CharSequence)this.mMainRoomId)) continue;
            for (RCRTCRemoteUser remoteUser : value.getRemoteUsers()) {
                for (RCRTCInputStream stream : remoteUser.getStreams()) {
                    RCInputStreamImpl inputStream = (RCInputStreamImpl)stream;
                    if (inputStream.getSubscribeState() != RCRTCSubscribeState.SUBSCRIBED) continue;
                    streamList.add(inputStream);
                }
            }
        }
        return streamList;
    }

    public RCRTCBaseRoom getRoomByUserId(String userId) {
        RCRTCBaseRoom tmpRoom = null;
        if (TextUtils.isEmpty((CharSequence)this.mMainRoomId) || TextUtils.isEmpty((CharSequence)userId)) {
            FinLog.e(TAG, "getRoomByUserId. userid is empty.");
            return tmpRoom;
        }
        FinLog.d(TAG, "getRoomByUserId . userId :" + userId);
        RCRTCBaseRoom mainRoom = this.get(this.mMainRoomId);
        RCRTCRemoteUser mainRoomRemoteUser = mainRoom.getRemoteUser(userId);
        if (mainRoomRemoteUser != null) {
            tmpRoom = mainRoom;
            FinLog.d(TAG, "getRoomByUserId . mainRoom :" + tmpRoom.getRoomId() + " , userid :" + userId);
        } else {
            ListIterator<Map.Entry<String, RCRTCBaseRoom>> li = new ArrayList<Map.Entry<String, RCRTCBaseRoom>>(this.concurrentHashMap.entrySet()).listIterator(this.concurrentHashMap.size());
            while (li.hasPrevious()) {
                Map.Entry<String, RCRTCBaseRoom> entry = li.previous();
                RCRTCBaseRoom baseRoom = this.concurrentHashMap.get(entry.getKey());
                String baseRoomId = baseRoom.getRoomId();
                FinLog.d(TAG, "getRoomByUserId . key :" + baseRoomId);
                if (TextUtils.equals((CharSequence)this.mMainRoomId, (CharSequence)baseRoomId)) continue;
                for (RCRTCRemoteUser user : baseRoom.getRemoteUsers()) {
                    if (!TextUtils.equals((CharSequence)user.getUserId(), (CharSequence)userId)) continue;
                    FinLog.d(TAG, "getRoomByUserId . otherRoomId :" + baseRoomId + " , mMainRoomId : " + this.mMainRoomId);
                    return baseRoom;
                }
            }
        }
        return tmpRoom;
    }

    public String getMainRoomId() {
        return this.mMainRoomId;
    }

    public String getRoomSessionId(String roomid) {
        String roomSessionId = "";
        if (this.concurrentHashMap != null && this.concurrentHashMap.size() > 0) {
            for (RCRTCBaseRoom room : this.concurrentHashMap.values()) {
                if (!TextUtils.equals((CharSequence)room.getRoomId(), (CharSequence)roomid)) continue;
                roomSessionId = room.getSessionId();
                break;
            }
        }
        FinLog.d(TAG, "getRoomSessionId->roomid :" + roomid + " , SessionId :" + roomSessionId + " thread :" + Thread.currentThread().getName());
        return roomSessionId;
    }

    private void notifyChange() {
        if (this.mListener != null) {
            this.mListener.onNotify(this.concurrentHashMap.keySet().toArray(new String[this.concurrentHashMap.keySet().size()]));
        }
    }

    public boolean isMainRoomUser(String userId) {
        RCRTCBaseRoom mainRoom = this.concurrentHashMap.get(this.mMainRoomId);
        if (mainRoom != null && mainRoom.getRemoteUsers().size() > 0) {
            for (RCRTCRemoteUser remoteUser : mainRoom.getRemoteUsers()) {
                if (!TextUtils.equals((CharSequence)remoteUser.getUserId(), (CharSequence)userId)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void release() {
        super.release();
        if (this.concurrentHashMap != null) {
            this.concurrentHashMap.clear();
        }
        if (this.mListener != null) {
            this.mListener = null;
        }
    }
}

