/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine.action;

import cn.rongcloud.rtc.api.callback.IRCRTCFailedCallback;
import cn.rongcloud.rtc.base.RCRTCStream;
import cn.rongcloud.rtc.engine.InRoomState;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.engine.action.PubSubAction;
import cn.rongcloud.rtc.engine.action.PubSubActionResultCallback;
import cn.rongcloud.rtc.utils.ReportUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class PubSubActionQueue {
    private static final String TAG = "PubSubActionQueue";
    private Queue<PubSubAction> mQueue = new LinkedList<PubSubAction>();
    private InRoomState mInRoomState;
    private boolean mActionRunning = false;

    public PubSubActionQueue(InRoomState inRoomState) {
        this.mInRoomState = inRoomState;
    }

    public void offer(int actionType, List<? extends RCRTCStream> streams, IRCRTCFailedCallback callback) {
        this.offer(actionType, streams, callback, null, true);
    }

    public void offer(int actionType, List<? extends RCRTCStream> streams, boolean switchCallbackThread, IRCRTCFailedCallback callback) {
        this.offer(actionType, streams, callback, null, switchCallbackThread);
    }

    public void offer(int actionType, List<? extends RCRTCStream> streams, Object extra, IRCRTCFailedCallback callback) {
        this.offer(actionType, streams, callback, extra, true);
    }

    public void offer(int actionType, List<? extends RCRTCStream> streams, IRCRTCFailedCallback callback, Object extra, boolean switchCallbackThread) {
        this.onOffer(new PubSubAction(actionType, streams, extra, new PubSubActionResultCallback(callback, switchCallbackThread), new PubSubAction.ICompleteListener(){

            @Override
            public void onComplete() {
                PubSubActionQueue.this.mActionRunning = false;
                PubSubActionQueue.this.nextPubSubAction();
            }
        }));
        this.nextPubSubAction();
    }

    private void nextPubSubAction() {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        if (this.mActionRunning) {
            return;
        }
        PubSubAction action = this.poll();
        if (action == null) {
            return;
        }
        this.mActionRunning = true;
        ReportUtil.libStatus(ReportUtil.TAG.PUBSUBQUEUEPOLL, "type|size", action.getActionType(), this.mQueue.size());
        switch (action.getActionType()) {
            case 1: {
                this.mInRoomState.publishStreams(action.getStreams(), action.getCallback());
                break;
            }
            case 2: {
                this.mInRoomState.unpublishedStreams(action.getStreams(), action.getCallback());
                break;
            }
            case 3: {
                this.mInRoomState.subscribeStreams(action.getStreams(), action.getCallback());
                break;
            }
            case 5: {
                this.mInRoomState.unsubscribeStreams(action.getStreams(), false, "", action.getCallback());
                break;
            }
            case 6: {
                this.mInRoomState.switchStream((Boolean)action.getExtra(), action.getStreams(), action.getCallback());
                break;
            }
            case 7: {
                this.mInRoomState.exchangeVideoSize(action.getCallback());
                break;
            }
            case 4: {
                this.mInRoomState.resubscribeStreams(action.getCallback());
                break;
            }
            case 8: {
                this.mInRoomState.joinOtherExchangeRemoteSDP(action.getCallback());
                break;
            }
            case 9: {
                this.mInRoomState.unsubscribeStreams(action.getStreams(), (Boolean)action.getExtra(), "", action.getCallback());
            }
        }
    }

    private boolean onOffer(PubSubAction action) {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        ReportUtil.libStatus(ReportUtil.TAG.PUBSUBQUEUEOFFER, "type|size", action.getActionType(), this.mQueue.size());
        return this.mQueue.offer(action);
    }

    public void checkIsAllowNeutralize(PubSubAction action) {
        for (PubSubAction ac : this.mQueue) {
            switch (action.getActionType()) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
    }

    private PubSubAction poll() {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        return this.mQueue.poll();
    }

    public void clear() {
        PubSubAction action;
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        while ((action = this.mQueue.poll()) != null) {
            ReportUtil.libStatus(ReportUtil.TAG.PUBSUBQUEUECANCEL, "type", action.getActionType());
            action.cancel();
        }
        this.mActionRunning = false;
        this.mQueue.clear();
    }

    public boolean hasPubAction() {
        for (PubSubAction pubSubAction : this.mQueue) {
            if (pubSubAction.getActionType() != 1) continue;
            return true;
        }
        return false;
    }
}

