/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine.action;

import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.base.RCRTCStream;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import java.util.ArrayList;
import java.util.List;

public class PubSubAction<T> {
    public static final int TYPE_PUBLISH = 1;
    public static final int TYPE_UNPUBLISHED = 2;
    public static final int TYPE_SUBSCRIBE = 3;
    public static final int TYPE_RESUBSCRIBE = 4;
    public static final int TYPE_UNSUBSCRIBE = 5;
    public static final int TYPE_SWITCH_STREAM_TYPE = 6;
    public static final int TYPE_EXCHANGE_VIDEO_SIZE = 7;
    public static final int TYPE_JOIN_OTHER_ROOM_SUCCESS_EXCHANGE_SDP = 8;
    public static final int TYPE_EVENT_UNSUBSCRIBE_STREAMS_EXCHANGE_REMOTE_SDP = 9;
    private final int mActionType;
    private List<RCRTCStream> mStreams = new ArrayList<RCRTCStream>();
    private List<IRCRTCResultDataCallback<T>> mCallbacks = new ArrayList<IRCRTCResultDataCallback<T>>();
    private IRCRTCResultDataCallback<T> mInteriorCallback;
    private ICompleteListener mCompleteListener;
    private Object mExtra;

    public PubSubAction(int actionType, List<RCRTCStream> streams, IRCRTCResultDataCallback<T> callback, ICompleteListener completeListener) {
        this.mActionType = actionType;
        if (!RongRTCUtils.isEmpty(streams)) {
            this.mStreams.addAll(streams);
        }
        if (callback != null) {
            this.mCallbacks.add(callback);
        }
        this.mCompleteListener = completeListener;
        this.mInteriorCallback = new IRCRTCResultDataCallback<T>(){

            @Override
            public void onSuccess(T data) {
                RTCEngineImpl.getInstance().checkIsOnEngineThread();
                for (IRCRTCResultDataCallback cb : PubSubAction.this.mCallbacks) {
                    cb.onSuccess(data);
                }
                PubSubAction.this.mCompleteListener.onComplete();
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                RTCEngineImpl.getInstance().checkIsOnEngineThread();
                for (IRCRTCResultDataCallback cb : PubSubAction.this.mCallbacks) {
                    cb.onFailed(errorCode);
                }
                PubSubAction.this.mCompleteListener.onComplete();
            }
        };
    }

    public PubSubAction(int actionType, List<RCRTCStream> streams, Object extra, IRCRTCResultDataCallback<T> callback, ICompleteListener completeListener) {
        this(actionType, streams, callback, completeListener);
        this.mExtra = extra;
    }

    public IRCRTCResultDataCallback<T> getCallback() {
        return this.mInteriorCallback;
    }

    protected void cancel() {
        for (IRCRTCResultDataCallback<T> cb : this.mCallbacks) {
            cb.onFailed(RTCErrorCode.ILLEGALSTATE);
        }
    }

    public int getActionType() {
        return this.mActionType;
    }

    public List<RCRTCStream> getStreams() {
        return this.mStreams;
    }

    public void mergeAction(PubSubAction action) {
        this.mStreams.addAll(action.mStreams);
        this.mCallbacks.addAll(action.mCallbacks);
    }

    public <V> V getExtra() {
        return (V)this.mExtra;
    }

    public static interface ICompleteListener {
        public void onComplete();
    }
}

