/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.utils.ReportUtil;

class RTCResultCallbackWrapper
extends IRCRTCResultCallback {
    IRCRTCResultCallback callback;
    ReportUtil.TAG tag;
    String roomId = null;
    String keys = null;
    Object[] values = null;
    private boolean enable = true;

    public RTCResultCallbackWrapper(@Nullable IRCRTCResultCallback callback, @NonNull ReportUtil.TAG tag) {
        this.callback = callback;
        this.tag = tag;
    }

    public RTCResultCallbackWrapper(@Nullable IRCRTCResultCallback callback, @NonNull ReportUtil.TAG tag, @Nullable String roomId) {
        this.callback = callback;
        this.tag = tag;
        this.roomId = roomId;
    }

    public RTCResultCallbackWrapper(@Nullable IRCRTCResultCallback callback, @NonNull ReportUtil.TAG tag, String keys, Object ... values) {
        this.callback = callback;
        this.tag = tag;
        this.keys = keys;
        this.values = values;
    }

    public RTCResultCallbackWrapper(@Nullable IRCRTCResultCallback callback, boolean enable) {
        this.callback = callback;
        this.enable = enable;
    }

    @Override
    public void onSuccess() {
        this.onExSuccess();
        if (this.callback != null) {
            this.callback.onSuccess();
        }
    }

    protected void onExSuccess() {
        if (this.enable) {
            if (!TextUtils.isEmpty((CharSequence)this.keys)) {
                ReportUtil.appRes(this.tag, this.keys, this.values);
            } else if (null != this.roomId) {
                ReportUtil.appRes(this.tag, this.roomId);
            } else {
                ReportUtil.appRes(this.tag, "code", 0);
            }
        }
    }

    @Override
    public void onFailed(RTCErrorCode errorCode) {
        this.onExFailed(errorCode);
        if (this.callback != null) {
            this.callback.onFailed(errorCode);
        }
    }

    protected void onExFailed(RTCErrorCode errorCode) {
        if (this.enable) {
            if (!TextUtils.isEmpty((CharSequence)this.keys)) {
                ReportUtil.appError(this.tag, errorCode, this.keys, this.values);
            } else if (null != this.roomId) {
                ReportUtil.appError(this.tag, errorCode, "roomId", this.roomId);
            } else {
                ReportUtil.appError(this.tag, errorCode);
            }
        }
    }
}

