/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine;

import android.content.Context;
import android.media.AudioManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import cn.rongcloud.rtc.RongRTCExtensionModule;
import cn.rongcloud.rtc.api.IAudioEffectManager;
import cn.rongcloud.rtc.api.RCRTCConfig;
import cn.rongcloud.rtc.api.RCRTCOtherRoom;
import cn.rongcloud.rtc.api.RCRTCRoom;
import cn.rongcloud.rtc.api.callback.IRCRTCEngineEventListener;
import cn.rongcloud.rtc.api.callback.IRCRTCFailedCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCStatusReportListener;
import cn.rongcloud.rtc.api.callback.RCRTCLiveCallback;
import cn.rongcloud.rtc.api.stream.RCRTCAudioInputStream;
import cn.rongcloud.rtc.api.stream.RCRTCCameraOutputStream;
import cn.rongcloud.rtc.api.stream.RCRTCFileVideoOutputStream;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import cn.rongcloud.rtc.api.stream.RCRTCLiveInfo;
import cn.rongcloud.rtc.api.stream.RCRTCMicOutputStream;
import cn.rongcloud.rtc.api.stream.RCRTCOutputStream;
import cn.rongcloud.rtc.api.stream.RCRTCVideoInputStream;
import cn.rongcloud.rtc.api.stream.RCRTCVideoOutputStream;
import cn.rongcloud.rtc.api.stream.RCRTCVideoStreamConfig;
import cn.rongcloud.rtc.base.RCAttributeType;
import cn.rongcloud.rtc.base.RCRTCAVStreamType;
import cn.rongcloud.rtc.base.RCRTCResourceState;
import cn.rongcloud.rtc.base.RCRTCRoomType;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.RCEngineEventListenerWrapper;
import cn.rongcloud.rtc.center.RCRoomImpl;
import cn.rongcloud.rtc.center.RCStatusReportListenerWrapper;
import cn.rongcloud.rtc.center.config.RCRTCConfigImpl;
import cn.rongcloud.rtc.center.config.RCServerConfig;
import cn.rongcloud.rtc.center.stream.RCCameraOutputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCFileVideoOutStreamImpl;
import cn.rongcloud.rtc.center.stream.RCMicOutputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCOutputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCVideoOutStreamImpl;
import cn.rongcloud.rtc.core.EglBase;
import cn.rongcloud.rtc.engine.AbstractRTCEngineImpl;
import cn.rongcloud.rtc.engine.DisconnectingState;
import cn.rongcloud.rtc.engine.IdleState;
import cn.rongcloud.rtc.engine.InRoomState;
import cn.rongcloud.rtc.engine.MsgObjectWraper;
import cn.rongcloud.rtc.engine.ObserverState;
import cn.rongcloud.rtc.engine.RTCResultCallbackWrapper;
import cn.rongcloud.rtc.engine.RTCResultDataCallbackWrapper;
import cn.rongcloud.rtc.engine.UnInitState;
import cn.rongcloud.rtc.engine.tools.multiroom.InviteMessageElement;
import cn.rongcloud.rtc.proxy.message.InviteMessage;
import cn.rongcloud.rtc.proxy.message.messagebeans.InviteInfo;
import cn.rongcloud.rtc.signal.SignalManager;
import cn.rongcloud.rtc.sniffer.SnifferManager;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.NetState;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.RongRTCSessionManager;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import cn.rongcloud.rtc.utils.UUID22;
import cn.rongcloud.rtc.webrtc.IWebRTCCore;
import io.rong.common.SystemUtils;
import io.rong.imlib.IMLibExtensionModuleManager;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.MessageContent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;

public class RTCEngineImpl
extends AbstractRTCEngineImpl {
    private static final boolean DEBUG = false;
    private static final String STREAM_TAG_REGEX = "^[A-Za-z0-9]+";
    private static final String TAG = "RTCEngineImpl";
    private static final String ROOM_ID_REGEX = "^[A-Za-z0-9+=\\-_]+$";
    private static final int MAX_ROOM_ID_LENGTH = 64;
    private static final long WAIT_INIT_TIMEOUT = 10000L;
    public ConcurrentHashMap<String, String> version2UserIDs = new ConcurrentHashMap();
    private NetState mNetState = null;
    UnInitState mUnInitState;
    IdleState mIdleState;
    ObserverState mObserverState;
    InRoomState mInRoomState;
    DisconnectingState mDisConnectingState;
    IWebRTCCore mRTCCore;
    Context mContext;
    RCRTCConfigImpl mConfig;
    String mUserId;
    String mToken;
    RCRoomImpl mRoom;
    RCCameraOutputStreamImpl mDefaultVideoStream;
    RCMicOutputStreamImpl mDefaultAudioStream;
    boolean mEnableTinyStream = true;
    EglBase mEglBase;
    EglBase.Context mEglContext;
    private String mAppKey;
    private Handler mUIHandler;
    private RCEngineEventListenerWrapper engineEventListenerWrapper;
    Handler mCallbackHandler;

    public boolean isMicrophoneEnabled() {
        if (this.mConfig != null) {
            return this.mConfig.isMicrophoneEnable();
        }
        return false;
    }

    public int getAudioSampleRate() {
        if (this.mConfig != null) {
            return this.mConfig.getAudioSampleRate();
        }
        return RCServerConfig.getAudioSampleRate();
    }

    public boolean isStereo() {
        if (this.mConfig != null) {
            return this.mConfig.isStereo();
        }
        return RCServerConfig.isStereo();
    }

    public RCRTCConfigImpl getRTCConfig() {
        return this.mConfig;
    }

    public static RTCEngineImpl getInstance() {
        return RTCEngineHolder.instance;
    }

    private RTCEngineImpl() {
        IMLibExtensionModuleManager.getInstance().registerModulesByName(Collections.singletonList(RongRTCExtensionModule.class.getName()));
        this.mUIHandler = new Handler(Looper.getMainLooper());
        this.initCallBackHandler();
        this.initStates();
        this.start();
    }

    private void initCallBackHandler() {
        HandlerThread handlerThread = new HandlerThread("RTCCallback");
        handlerThread.start();
        this.mCallbackHandler = new Handler(handlerThread.getLooper());
    }

    private void initStates() {
        this.mUnInitState = new UnInitState(this);
        this.mIdleState = new IdleState(this);
        this.mObserverState = new ObserverState(this);
        this.mInRoomState = new InRoomState(this);
        this.mDisConnectingState = new DisconnectingState(this);
        this.addState(this.mUnInitState);
        this.addState(this.mIdleState);
        this.addState(this.mObserverState);
        this.addState(this.mInRoomState);
        this.addState(this.mDisConnectingState);
        this.setInitialState(this.mUnInitState);
    }

    public void onIMLogin(String userId, String token) {
        ReportUtil.libStatus(ReportUtil.TAG.IMLOGIN, "userId", userId);
        this.sendMessage(1010, userId, token);
    }

    @Override
    public void init(Context application, RCRTCConfig config) {
        long startTime = System.nanoTime();
        String currentProcess = SystemUtils.getCurrentProcessName((Context)application);
        String mainProcess = application.getPackageName();
        ReportUtil.appTask(ReportUtil.TAG.RTCINIT, "currentProcess|mainProcess", currentProcess, mainProcess);
        RongRTCSessionManager.getInstance().init(application);
        SnifferManager.getInstance().init();
        ((RCRTCConfigImpl)config).updateServerConfig();
        this.sendMessage(1000, application, config);
        try {
            boolean res = this.mUnInitState.waitIniComplete(10000L);
            float useTime = (float)(System.nanoTime() - startTime) * 1.0f / 1000000.0f;
            if (res) {
                ReportUtil.appRes(ReportUtil.TAG.RTCINIT, "useTime", Float.valueOf(useTime));
            } else {
                ReportUtil.appError(ReportUtil.TAG.RTCINIT, "code|desc", RTCErrorCode.RTC_INIT_TIMEOUT.getValue(), "init RTCLib Timeout, Time: " + useTime + "ms");
            }
        }
        catch (InterruptedException e) {
            ReportUtil.appError(ReportUtil.TAG.RTCINIT, "code|desc", RTCErrorCode.UnknownError.getValue(), "init RTCLib InterruptedException");
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
    }

    public void onIMConnectChanged(RongIMClient.ConnectionStatusListener.ConnectionStatus connectionStatus) {
        SignalManager.getInstance().onIMConnectChanged(connectionStatus);
        if (connectionStatus == RongIMClient.ConnectionStatusListener.ConnectionStatus.SIGN_OUT || RongIMClient.ConnectionStatusListener.ConnectionStatus.KICKED_OFFLINE_BY_OTHER_CLIENT == connectionStatus) {
            this.sendMessage(1011, new Object[0]);
        }
    }

    public void setAppKey(String appKey) {
        this.mAppKey = appKey;
    }

    @Override
    public RCRTCCameraOutputStream getDefaultVideoStream() {
        return this.mDefaultVideoStream;
    }

    @Override
    public RCRTCFileVideoOutputStream createFileVideoOutputStream(String path, boolean replace, boolean playback, String tag, RCRTCVideoStreamConfig config) {
        if (TextUtils.isEmpty((CharSequence)tag) || !tag.matches(STREAM_TAG_REGEX) || "RongCloudRTC".equals(tag) || TextUtils.isEmpty((CharSequence)this.mUserId) || this.mContext == null || TextUtils.isEmpty((CharSequence)path) || this.mConfig == null || this.mDefaultAudioStream == null) {
            FinLog.e(TAG, "stream tag is illegal, it must be : [A-Za-z0-9]");
            return null;
        }
        RCFileVideoOutStreamImpl videoOutStream = new RCFileVideoOutStreamImpl(this.mContext, path, replace, playback, tag, this.mUserId, this.mConfig, this.mDefaultAudioStream);
        videoOutStream.setVideoConfig(config);
        return videoOutStream;
    }

    @Override
    public RCRTCMicOutputStream getDefaultAudioStream() {
        return this.mDefaultAudioStream;
    }

    @Override
    public RCRTCVideoOutputStream createVideoStream(String tag, @Nullable RCRTCVideoStreamConfig config) {
        if (TextUtils.isEmpty((CharSequence)tag) || !tag.matches(STREAM_TAG_REGEX) || "RongCloudRTC".equals(tag) || TextUtils.isEmpty((CharSequence)this.mUserId)) {
            FinLog.e(TAG, "stream tag is illegal, it must be : [A-Za-z0-9]");
            return null;
        }
        RCVideoOutStreamImpl videoOutputStream = new RCVideoOutStreamImpl(tag, this.mUserId);
        videoOutputStream.setVideoConfig(config);
        return videoOutputStream;
    }

    public void subscribeStreams(List<? extends RCRTCInputStream> streams, IRCRTCResultCallback callBack) {
        ReportUtil.appTask(ReportUtil.TAG.SUBSCRIBEAVSTREAM, "roomId|streams", this.getRoomId(), ReportUtil.resourceToString(streams));
        if (this.checkStreams(streams, ReportUtil.TAG.SUBSCRIBEAVSTREAM, callBack)) {
            return;
        }
        this.sendMessage(4000, streams, new RTCResultCallbackWrapper(callBack, ReportUtil.TAG.SUBSCRIBEAVSTREAM, this.getRoomId()));
    }

    public void unsubscribeStreams(List<? extends RCRTCInputStream> streams, IRCRTCResultCallback callBack) {
        ReportUtil.appTask(ReportUtil.TAG.UNSUBSCRIBEAVSTREAM, "roomId|streams", this.getRoomId(), ReportUtil.resourceToString(streams));
        if (this.checkStreams(streams, ReportUtil.TAG.UNSUBSCRIBEAVSTREAM, callBack)) {
            return;
        }
        this.sendMessage(4040, streams, new RTCResultCallbackWrapper(callBack, ReportUtil.TAG.UNSUBSCRIBEAVSTREAM, this.getRoomId()));
    }

    public void publishStreams(List<? extends RCRTCOutputStream> streams, IRCRTCResultCallback callBack) {
        ReportUtil.appTask(ReportUtil.TAG.PUBLISHAVSTREAM, "roomId", this.getRoomId());
        if (this.checkStreams(streams, ReportUtil.TAG.PUBLISHAVSTREAM, callBack)) {
            return;
        }
        this.sendMessage(3000, streams, new RTCResultCallbackWrapper(callBack, ReportUtil.TAG.PUBLISHAVSTREAM, this.getRoomId()));
    }

    public void unpublishStreams(List<RCRTCOutputStream> streams, IRCRTCResultCallback callBack) {
        ReportUtil.appTask(ReportUtil.TAG.UNPUBLISHAVSTREAM, "roomId", this.getRoomId());
        if (this.checkStreams(streams, ReportUtil.TAG.UNPUBLISHAVSTREAM, callBack)) {
            return;
        }
        this.sendMessage(3080, streams, new RTCResultCallbackWrapper(callBack, ReportUtil.TAG.UNPUBLISHAVSTREAM, this.getRoomId()));
    }

    private boolean checkStreams(List streams, ReportUtil.TAG tag, IRCRTCResultCallback callBack) {
        if (RongRTCUtils.isEmpty(streams)) {
            this.onFailedCallback(RTCErrorCode.RongRTCCodeParameterError, callBack);
            String roomId = this.mRoom != null ? this.mRoom.getRoomId() : "null";
            ReportUtil.appError(tag, 2, RTCErrorCode.RongRTCCodeParameterError, "roomId", roomId);
            return true;
        }
        return false;
    }

    public void publishLiveStreams(ArrayList<RCRTCOutputStream> streams, IRCRTCResultDataCallback<RCRTCLiveInfo> callBack) {
        this.sendMessage(3010, streams, callBack);
    }

    @Override
    public void subscribeLiveStream(String liveUrl, RCRTCAVStreamType avStreamType, final RCRTCLiveCallback callBack) {
        if (avStreamType == null) {
            ReportUtil.appError(ReportUtil.TAG.SUBSCRIBELIVESTREAM, 2, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), "RCRTCAVStreamType is null ");
            this.onFailedCallback(RTCErrorCode.RongRTCCodeParameterError, callBack);
            return;
        }
        ReportUtil.appTask(ReportUtil.TAG.SUBSCRIBELIVESTREAM, "liveUrl|liveType|simulcast", liveUrl, avStreamType.getMediaType(), avStreamType.getSimulcast());
        this.sendMessage(5000, new Object[]{liveUrl, avStreamType, new RCRTCLiveCallback(){

            @Override
            public void onSuccess() {
                ReportUtil.appTask(ReportUtil.TAG.SUBSCRIBELIVESTREAM, "code", 0);
                if (callBack != null) {
                    callBack.onSuccess();
                }
            }

            @Override
            public void onVideoStreamReceived(RCRTCVideoInputStream stream) {
                if (callBack != null) {
                    callBack.onVideoStreamReceived(stream);
                }
            }

            @Override
            public void onAudioStreamReceived(RCRTCAudioInputStream stream) {
                if (callBack != null) {
                    callBack.onAudioStreamReceived(stream);
                }
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.SUBSCRIBELIVESTREAM, errorCode);
                if (callBack != null) {
                    callBack.onFailed(errorCode);
                }
            }
        }});
    }

    @Override
    public void unsubscribeLiveStream(String liveUrl, IRCRTCResultCallback callBack) {
        ReportUtil.appTask(ReportUtil.TAG.UNSUBSCRIBELIVESTREAM, "liveUrl|userId", liveUrl, this.getUserId());
        this.sendMessage(5010, liveUrl, new RTCResultCallbackWrapper(callBack, ReportUtil.TAG.UNSUBSCRIBELIVESTREAM));
    }

    @Override
    public RCRTCRoom getRoom() {
        return this.mRoom;
    }

    public String getUserId() {
        return this.mUserId;
    }

    @Override
    public void enableSpeaker(boolean enable) {
        ReportUtil.appStatus(ReportUtil.TAG.USESPEAKER, "useSpeaker ", enable);
        AudioManager audioManager = this.getAudioManager();
        if (audioManager != null) {
            audioManager.setSpeakerphoneOn(enable);
        } else {
            ReportUtil.appError(ReportUtil.TAG.USESPEAKER, "code|desc", -1, "AudioManager is Null");
        }
    }

    private AudioManager getAudioManager() {
        if (this.mContext == null) {
            return null;
        }
        AudioManager audioMgr = (AudioManager)this.mContext.getSystemService("audio");
        return audioMgr;
    }

    @Override
    public void joinRoom(String roomId, IRCRTCResultDataCallback<RCRTCRoom> callBack) {
        this.joinRoom(roomId, RCRTCRoomType.MEETING, callBack);
    }

    @Override
    public void joinRoom(String roomId, RCRTCRoomType roomType, IRCRTCResultDataCallback<RCRTCRoom> callBack) {
        ReportUtil.appTask(ReportUtil.TAG.JOINROOM, "roomId|uid|roomType|liveType", roomId, this.mUserId, roomType.getRoomType(), roomType.getMediaType());
        if (!this.joinRoomBeforeCheck(roomId, callBack)) {
            return;
        }
        this.sendMessage(2000, new Object[]{roomId, roomType, new RTCResultDataCallbackWrapper(callBack, ReportUtil.TAG.JOINROOM, roomId)});
    }

    protected boolean joinRoomBeforeCheck(String roomId, IRCRTCResultDataCallback<RCRTCRoom> callBack) {
        if (TextUtils.isEmpty((CharSequence)roomId) || !roomId.matches(ROOM_ID_REGEX) || roomId.length() > 64) {
            this.onFailedCallback(RTCErrorCode.RongRTCCodeParameterError, callBack);
            ReportUtil.appError(ReportUtil.TAG.JOINROOM, 2, "roomId|code|desc", roomId, RTCErrorCode.RongRTCCodeParameterError.getValue(), "RoomId Not Available");
            return false;
        }
        if (!SignalManager.getInstance().imSignalIsConnected()) {
            this.onFailedCallback(RTCErrorCode.RongRTCCodeSignalServerNotConnect, callBack);
            ReportUtil.appError(ReportUtil.TAG.JOINROOM, RTCErrorCode.RongRTCCodeSignalServerNotConnect, "roomId", roomId);
            return false;
        }
        if (!SignalManager.getInstance().voipIsEnable()) {
            FinLog.e(TAG, "Can't get VoIP info: please check whether is VoIP service available!!");
            ReportUtil.appError(ReportUtil.TAG.JOINROOM, RTCErrorCode.ServiceNotOpened, "roomId", roomId);
            this.onFailedCallback(RTCErrorCode.RongRTCCodeVoIPNotAvailable, callBack);
            return false;
        }
        return true;
    }

    @Override
    public void leaveRoom(IRCRTCResultCallback callBack) {
        ReportUtil.appTask(ReportUtil.TAG.LEAVEROOM, "roomId|uid", this.getRoomId(), this.mUserId);
        this.sendMessage(9000, (Object)new RTCResultCallbackWrapper(callBack, ReportUtil.TAG.LEAVEROOM, this.getRoomId()));
    }

    @Override
    public void unInit() {
        this.sendMessage(10000, new Object[0]);
        this.internalRelease();
    }

    private void internalRelease() {
        if (this.engineEventListenerWrapper != null) {
            this.engineEventListenerWrapper.release();
        }
        this.engineEventListenerWrapper = null;
    }

    public synchronized String getClientId() {
        String uuid = RongRTCSessionManager.getInstance().getString("RongRTC_uuid");
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            uuid = UUID22.getUUID22();
            RongRTCSessionManager.getInstance().put("RongRTC_uuid", uuid);
        }
        return uuid;
    }

    @Override
    public void registerStatusReportListener(IRCRTCStatusReportListener statusReportListener) {
        this.sendMessage(2010, (Object)new RCStatusReportListenerWrapper(this.mCallbackHandler, statusReportListener));
    }

    @Override
    public void unregisterStatusReportListener() {
        this.sendMessage(2011, new Object[0]);
    }

    @Override
    public void registerEventListener(IRCRTCEngineEventListener engineEventListener) {
        if (engineEventListener != null) {
            this.engineEventListenerWrapper = new RCEngineEventListenerWrapper(this.mCallbackHandler, engineEventListener);
        }
    }

    @Override
    public void unregisterEventListener() {
        if (this.engineEventListenerWrapper != null) {
            this.engineEventListenerWrapper.setEventsListener(null);
        }
    }

    @Override
    public IAudioEffectManager getAudioEffectManager() {
        RCMicOutputStreamImpl defaultAudioStream = this.mDefaultAudioStream;
        if (defaultAudioStream != null) {
            return defaultAudioStream.getAudioEffectManager();
        }
        return null;
    }

    @Override
    public void joinOtherRoom(String roomId, IRCRTCResultDataCallback<RCRTCOtherRoom> callBack) {
        ReportUtil.appTask(ReportUtil.TAG.JOINOTHERROOM, "otherRoomId", roomId);
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            if (callBack != null) {
                callBack.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            }
            ReportUtil.appError(ReportUtil.TAG.JOINOTHERROOM, "otherRoomId|code", roomId, RTCErrorCode.RongRTCCodeParameterError.getValue());
            return;
        }
        if (!this.isInRoom()) {
            if (callBack != null) {
                callBack.onFailed(RTCErrorCode.NOT_JOINED_MAIN_ROOM);
            }
            ReportUtil.appError(ReportUtil.TAG.JOINOTHERROOM, "otherRoomId|code", roomId, RTCErrorCode.NOT_JOINED_MAIN_ROOM.getValue());
            return;
        }
        if (TextUtils.equals((CharSequence)this.getRoomId(), (CharSequence)roomId)) {
            if (callBack != null) {
                callBack.onFailed(RTCErrorCode.OTHER_ROOM_ID_CANNOT_THE_MAIN_ROOM);
            }
            ReportUtil.appError(ReportUtil.TAG.JOINOTHERROOM, "otherRoomId|code", roomId, RTCErrorCode.OTHER_ROOM_ID_CANNOT_THE_MAIN_ROOM.getValue());
            return;
        }
        this.sendMessage(2070, roomId, new RTCResultDataCallbackWrapper(callBack, false));
    }

    @Override
    public void leaveOtherRoom(String roomId, boolean notifyFinished, IRCRTCResultCallback callBack) {
        String keys = "otherRoomId|notifyFinished|code";
        ReportUtil.appTask(ReportUtil.TAG.LEAVEOTHERROOM, "otherRoomId|notifyFinished", roomId, notifyFinished);
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            if (callBack != null) {
                callBack.onFailed(RTCErrorCode.RongRTCCodeParameterError);
            }
            ReportUtil.appError(ReportUtil.TAG.LEAVEOTHERROOM, keys, roomId, notifyFinished, RTCErrorCode.RongRTCCodeParameterError.getValue());
            return;
        }
        if (!this.isInRoom()) {
            if (callBack != null) {
                callBack.onFailed(RTCErrorCode.NOT_JOINED_MAIN_ROOM);
            }
            ReportUtil.appError(ReportUtil.TAG.LEAVEOTHERROOM, keys, roomId, notifyFinished, RTCErrorCode.NOT_JOINED_MAIN_ROOM.getValue());
            return;
        }
        if (TextUtils.equals((CharSequence)this.getRoomId(), (CharSequence)roomId)) {
            if (callBack != null) {
                callBack.onFailed(RTCErrorCode.OTHER_ROOM_ID_CANNOT_THE_MAIN_ROOM);
            }
            ReportUtil.appError(ReportUtil.TAG.LEAVEOTHERROOM, keys, roomId, notifyFinished, RTCErrorCode.OTHER_ROOM_ID_CANNOT_THE_MAIN_ROOM.getValue());
            return;
        }
        this.sendMessage(2072, roomId, notifyFinished, new RTCResultCallbackWrapper(callBack, false));
    }

    @Override
    public String getVersion() {
        return "4.1.0";
    }

    public boolean checkIsOnEngineThread() {
        Thread thread = Thread.currentThread();
        if (thread != this.getHandler().getLooper().getThread()) {
            String msg = "Current Thread is " + thread.getName() + ", Not on Engine thread!";
            FinLog.e(TAG, msg);
            return false;
        }
        return true;
    }

    public void setEnableTinyStream(boolean enable) {
        if (this.getCurrentState() != this.mInRoomState) {
            this.mEnableTinyStream = enable;
        }
    }

    @Override
    public synchronized EglBase.Context getEglBaseContext() {
        if (this.mEglContext == null) {
            this.mEglBase = EglBase.create();
            this.mEglContext = this.mEglBase.getEglBaseContext();
        }
        return this.mEglContext;
    }

    public void changeVideoSize() {
        this.sendMessage(3050, new Object[0]);
    }

    public void modifyResource(RCOutputStreamImpl stream, boolean isMute) {
        ReportUtil.appOperate(ReportUtil.TAG.MODIFYRESOURCE, "media|isOpen", stream.getMediaType().getDescription(), !isMute);
        stream.setResourceState(isMute ? RCRTCResourceState.DISABLED : RCRTCResourceState.NORMAL);
        this.sendMessage(3100, stream, isMute);
    }

    public void switchStream(boolean tiny, RCRTCInputStream stream, IRCRTCResultCallback callBack) {
        ReportUtil.appTask(ReportUtil.TAG.SWITCHSTREAMTINYORNORMAL, "roomId|isTiny", this.getRoomId(), tiny);
        if (stream == null) {
            ReportUtil.appError(ReportUtil.TAG.SWITCHSTREAMTINYORNORMAL, RTCErrorCode.RongRTCCodeSubscribeNotExistResources);
            this.onFailedCallback(RTCErrorCode.RongRTCCodeSubscribeNotExistResources, callBack);
            return;
        }
        this.sendMessage(3090, tiny, stream, new RTCResultCallbackWrapper(callBack, ReportUtil.TAG.SWITCHSTREAMTINYORNORMAL));
    }

    public void onReceivedMessage(io.rong.imlib.model.Message message) {
        this.sendMessage(7000, (Object)message);
    }

    @Override
    public void setMediaServerUrl(String mediaServerUrl) {
        ReportUtil.appOperate(ReportUtil.TAG.SETMEDIASERVERURL, "mediaUrl", mediaServerUrl);
        SignalManager.getInstance().setMediaServerUrl(mediaServerUrl);
    }

    public void onNetStateChanged(NetState state) {
        FinLog.v(TAG, "onNetStateChanged state = " + (Object)((Object)state));
        if (this.mNetState != null && this.mNetState != state && state != NetState.NONE) {
            this.sendMessage(8000, (Object)state);
        }
        this.mNetState = state;
    }

    public void onFirstFrameRendered(String userId, String tag) {
        ReportUtil.libStatus(ReportUtil.TAG.ONFIRSTFRAME, "roomId|uid", this.getRoomId(), userId);
        this.sendMessage(3301, userId, tag);
    }

    public void onCreateEglFailed(String userId, String tag, Exception e) {
        this.sendMessage(3302, userId, tag, e);
    }

    public void setAttributeValue(String roomId, RCAttributeType type, String key, String value, MessageContent message, IRCRTCResultCallback callback) {
        ReportUtil.TAG tag = type == RCAttributeType.ROOM ? ReportUtil.TAG.SETROOMATTRIBUTEVALUE : ReportUtil.TAG.SETATTRIBUTEVALUE;
        ReportUtil.appTask(tag, "roomId|value|key|content", roomId, value, key, message != null ? new String(message.encode()) : "");
        this.sendMessage(3303, new Object[]{type, key, value, message, new RTCResultCallbackWrapper(callback, tag, roomId), roomId});
    }

    public void deleteAttributes(String roomId, RCAttributeType type, List<String> attributeKeys, MessageContent message, IRCRTCResultCallback callback) {
        ReportUtil.TAG tag = type == RCAttributeType.ROOM ? ReportUtil.TAG.DELETEROOMATTRIBUTE : ReportUtil.TAG.DELETEATTRIBUTE;
        ReportUtil.appTask(tag, "roomId|keys|content", roomId, this.AttributeListtoString(attributeKeys), message != null ? new String(message.encode()) : "");
        this.sendMessage(3304, new Object[]{type, attributeKeys, message, new RTCResultCallbackWrapper(callback, tag, roomId), roomId});
    }

    public void putInnerData(RCAttributeType type, String key, String value, MessageContent message, IRCRTCResultCallback callback) {
        ReportUtil.appTask(ReportUtil.TAG.PUT_INNER_DATA, "roomId|type|key|value|content", this.getRoomId(), type.getValue(), key, value, message != null ? new String(message.encode()) : "");
        this.sendMessage(3307, new Object[]{type, key, value, message, new RTCResultCallbackWrapper(callback, ReportUtil.TAG.PUT_INNER_DATA, this.getRoomId())});
    }

    private String AttributeListtoString(List<String> attributeKeys) {
        String keyStr = "";
        if (attributeKeys != null && !attributeKeys.isEmpty()) {
            JSONArray jsonArray = new JSONArray();
            for (String attributeKey : attributeKeys) {
                jsonArray.put((Object)attributeKey);
            }
            keyStr = jsonArray.toString();
        }
        return keyStr;
    }

    public void getAttributes(String roomId, RCAttributeType type, List<String> attributeKeys, IRCRTCResultDataCallback<Map<String, String>> callback) {
        ReportUtil.TAG tag = type == RCAttributeType.ROOM ? ReportUtil.TAG.GETROOMATTRIBUTE : ReportUtil.TAG.GETATTRIBUTE;
        ReportUtil.appTask(tag, "roomId|keys", roomId, this.AttributeListtoString(attributeKeys));
        this.sendMessage(3305, new Object[]{type, attributeKeys, new RTCResultDataCallbackWrapper(callback, tag, roomId), roomId});
    }

    public void sendIMSignal(MessageContent messageContent, IRongCallback.ISendMessageCallback callback) {
        this.sendMessage(3306, messageContent, callback);
    }

    public String getAppKey() {
        return this.mAppKey;
    }

    public Context getContext() {
        return this.mContext;
    }

    public void onFailedCallback(final RTCErrorCode code, final IRCRTCFailedCallback callback) {
        if (callback == null || code == null) {
            return;
        }
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (callback != null) {
                    callback.onFailed(code);
                }
            }
        });
    }

    public void onSuccessCallback(final Object result, final IRCRTCResultDataCallback callback) {
        if (callback == null) {
            return;
        }
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                callback.onSuccess(result);
            }
        });
    }

    public void onSuccessCallback(final IRCRTCResultCallback callback) {
        if (callback == null) {
            return;
        }
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                callback.onSuccess();
            }
        });
    }

    public boolean isInRoom() {
        return this.getCurrentState() == this.mInRoomState;
    }

    public void postCallback(final Runnable runnable) {
        this.mCallbackHandler.post(new Runnable(){

            @Override
            public void run() {
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
    }

    protected String getRoomId() {
        if (this.mRoom != null) {
            return this.mRoom.getRoomId();
        }
        return "";
    }

    public void postUIThread(Runnable runnable) {
        this.mUIHandler.post(runnable);
    }

    @Override
    public void unhandledMessage(Message msg) {
        super.unhandledMessage(msg);
        switch (msg.what) {
            case 1000: {
                this.mUnInitState.notifyAndReInitCountDownLatch();
                break;
            }
            case 1011: {
                this.mUnInitState.imSignOut();
                break;
            }
            default: {
                MsgObjectWraper obj = new MsgObjectWraper(msg.obj);
                if (obj.getData() instanceof IRCRTCFailedCallback) {
                    ((IRCRTCFailedCallback)obj.getData()).onFailed(RTCErrorCode.ILLEGALSTATE);
                    break;
                }
                if (obj.getData() instanceof Object[]) {
                    Object[] data;
                    for (Object v : data = (Object[])obj.getData()) {
                        if (!(v instanceof IRCRTCFailedCallback)) continue;
                        ((IRCRTCFailedCallback)v).onFailed(RTCErrorCode.ILLEGALSTATE);
                    }
                } else {
                    if (!(obj.getData() instanceof Map)) break;
                    Map data = (Map)obj.getData();
                    for (Object v : data.values()) {
                        if (!(v instanceof IRCRTCFailedCallback)) continue;
                        ((IRCRTCFailedCallback)v).onFailed(RTCErrorCode.ILLEGALSTATE);
                    }
                }
                break;
            }
        }
    }

    public void engineError(RTCErrorCode code) {
        if (this.engineEventListenerWrapper != null) {
            this.engineEventListenerWrapper.onError(code);
        }
    }

    public void requestJoinOtherRoom(String inviteeRoomId, String inviteeUserId, int inviteeTimeoutTime, boolean inviterUserAutoMix, String extra, IRCRTCResultCallback callback) {
        if (!this.isInRoom()) {
            if (callback != null) {
                callback.onFailed(RTCErrorCode.NOT_JOINED_MAIN_ROOM);
            }
            ReportUtil.appError(ReportUtil.TAG.REQUESTJOINOTHERROOM, RongRTCUtils.append("inviteeRoomId", "inviteeUserId", "code"), inviteeRoomId, inviteeUserId, RTCErrorCode.NOT_JOINED_MAIN_ROOM.getValue());
            return;
        }
        if (TextUtils.equals((CharSequence)inviteeRoomId, (CharSequence)this.getRoomId())) {
            if (callback != null) {
                callback.onFailed(RTCErrorCode.OTHER_ROOM_ID_CANNOT_THE_MAIN_ROOM);
            }
            ReportUtil.appError(ReportUtil.TAG.REQUESTJOINOTHERROOM, RongRTCUtils.append("inviteeRoomId", "inviteeUserId", "code"), inviteeRoomId, inviteeUserId, RTCErrorCode.OTHER_ROOM_ID_CANNOT_THE_MAIN_ROOM.getValue());
            return;
        }
        String inviteSessionId = RongRTCUtils.createInviteSessionId(inviteeRoomId, inviteeUserId);
        this.sendMessage(2073, inviteeRoomId, inviteeUserId, inviteeTimeoutTime, inviterUserAutoMix, inviteSessionId, extra, new RTCResultCallbackWrapper(callback, false));
    }

    public void cancelRequestJoinOtherRoom(String inviteeRoomId, String inviteeUserId, String extra, String key, IRCRTCResultCallback callback) {
        if (TextUtils.equals((CharSequence)inviteeRoomId, (CharSequence)this.getRoomId())) {
            if (callback != null) {
                callback.onFailed(RTCErrorCode.OTHER_ROOM_ID_CANNOT_THE_MAIN_ROOM);
            }
            ReportUtil.appError(ReportUtil.TAG.CANCELREQUESTJOINOTHERROOM, key, inviteeRoomId, inviteeUserId, RTCErrorCode.OTHER_ROOM_ID_CANNOT_THE_MAIN_ROOM.getValue());
            return;
        }
        if (!this.isInRoom()) {
            if (callback != null) {
                callback.onFailed(RTCErrorCode.NOT_JOINED_MAIN_ROOM);
            }
            ReportUtil.appError(ReportUtil.TAG.CANCELREQUESTJOINOTHERROOM, key, inviteeRoomId, inviteeUserId, RTCErrorCode.NOT_JOINED_MAIN_ROOM.getValue());
            return;
        }
        InviteMessageElement.InviteTimeoutStatistics inviteTimeoutStatistics = this.mInRoomState.getMultiRoomManager().getInviteMessageElement().get(inviteeUserId);
        String inviteSessionId = "";
        if (inviteTimeoutStatistics != null) {
            inviteSessionId = inviteTimeoutStatistics.getInviteSessionId();
        }
        if (TextUtils.isEmpty((CharSequence)inviteSessionId)) {
            if (callback != null) {
                callback.onFailed(RTCErrorCode.CANCELLED_INVITATION_DOES_NOT_EXIST);
            }
            ReportUtil.appError(ReportUtil.TAG.CANCELREQUESTJOINOTHERROOM, key, inviteeRoomId, inviteeUserId, RTCErrorCode.CANCELLED_INVITATION_DOES_NOT_EXIST.getValue());
            return;
        }
        this.sendMessage(2074, inviteeRoomId, inviteeUserId, inviteSessionId, extra, new RTCResultCallbackWrapper(callback, false));
    }

    public void responseJoinOtherRoom(String inviterRoomId, String inviterUserId, boolean agree, boolean inviteeUserAutoMix, String extra, IRCRTCResultCallback callback) {
        if (!this.isInRoom()) {
            if (callback != null) {
                callback.onFailed(RTCErrorCode.NOT_JOINED_MAIN_ROOM);
            }
            ReportUtil.appError(ReportUtil.TAG.RESPONSEJOINOTHERROOM, RongRTCUtils.append("inviterRoomId", "inviterUserId", "code"), inviterRoomId, inviterUserId, RTCErrorCode.NOT_JOINED_MAIN_ROOM.getValue());
            return;
        }
        if (TextUtils.equals((CharSequence)inviterRoomId, (CharSequence)this.getRoomId())) {
            if (callback != null) {
                callback.onFailed(RTCErrorCode.OTHER_ROOM_ID_CANNOT_THE_MAIN_ROOM);
            }
            ReportUtil.appError(ReportUtil.TAG.RESPONSEJOINOTHERROOM, RongRTCUtils.append("inviterRoomId", "inviterUserId", "code"), inviterRoomId, inviterUserId, RTCErrorCode.OTHER_ROOM_ID_CANNOT_THE_MAIN_ROOM.getValue());
            return;
        }
        InviteMessage inviteMessage = this.mInRoomState.getMultiRoomManager().getInviteNotifyMessageElement().get(inviterUserId);
        if (inviteMessage == null || TextUtils.isEmpty((CharSequence)inviteMessage.getInviteSessionId()) || inviteMessage.getInviteInfo() == null) {
            if (callback != null) {
                callback.onFailed(RTCErrorCode.RESPONDING_INVITATION_DOES_NOT_EXIST);
            }
            ReportUtil.appError(ReportUtil.TAG.RESPONSEJOINOTHERROOM, RongRTCUtils.append("inviterRoomId", "inviterUserId", "code"), inviterRoomId, inviterUserId, RTCErrorCode.RESPONDING_INVITATION_DOES_NOT_EXIST.getValue());
            return;
        }
        String inviteSessionId = inviteMessage.getInviteSessionId();
        InviteInfo inviteInfo = inviteMessage.getInviteInfo();
        this.sendMessage(2075, inviterRoomId, inviterUserId, agree, inviteeUserAutoMix, inviteSessionId, inviteInfo, extra, new RTCResultCallbackWrapper(callback, false));
    }

    public void setUserAttributeValue(String key, String value, MessageContent message, IRCRTCResultCallback callback) {
        ReportUtil.TAG tag = ReportUtil.TAG.SETATTRIBUTEVALUE;
        ReportUtil.appTask(tag, "roomId|value|key|content", this.getRoomId(), value, key, message != null ? new String(message.encode()) : "");
        this.sendMessage(3303, new Object[]{RCAttributeType.USER, key, value, message, new RTCResultCallbackWrapper(callback, tag, this.getRoomId()), this.getRoomId()});
    }

    public void deleteUserAttributes(List<String> attributeKeys, MessageContent message, IRCRTCResultCallback callback) {
        ReportUtil.TAG tag = ReportUtil.TAG.SETATTRIBUTEVALUE;
        ReportUtil.appTask(tag, "roomId|keys|content", this.getRoomId(), this.AttributeListtoString(attributeKeys), message != null ? new String(message.encode()) : "");
        this.sendMessage(3304, new Object[]{RCAttributeType.USER, attributeKeys, message, new RTCResultCallbackWrapper(callback, tag, this.getRoomId()), this.getRoomId()});
    }

    public void getUserAttributes(List<String> attributeKeys, IRCRTCResultDataCallback<Map<String, String>> callback) {
        ReportUtil.TAG tag = ReportUtil.TAG.SETATTRIBUTEVALUE;
        ReportUtil.appTask(tag, "roomId|keys", this.getRoomId(), this.AttributeListtoString(attributeKeys));
        this.sendMessage(3305, new Object[]{RCAttributeType.USER, attributeKeys, new RTCResultDataCallbackWrapper(callback, tag, this.getRoomId()), this.getRoomId()});
    }

    private static class RTCEngineHolder {
        static RTCEngineImpl instance = new RTCEngineImpl();

        private RTCEngineHolder() {
        }
    }
}

