/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine;

import android.os.Message;
import android.text.TextUtils;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCStatusReportListener;
import cn.rongcloud.rtc.api.callback.RCRTCLiveCallback;
import cn.rongcloud.rtc.api.stream.RCRTCAudioInputStream;
import cn.rongcloud.rtc.api.stream.RCRTCVideoInputStream;
import cn.rongcloud.rtc.base.RCRTCAVStreamType;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.stream.RCInputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCRTCAudioInputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCStreamImpl;
import cn.rongcloud.rtc.center.stream.RCVideoInputStreamImpl;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.engine.AbstractBaseState;
import cn.rongcloud.rtc.engine.MsgObjectWraper;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.live.LiveSubscribeTools;
import cn.rongcloud.rtc.signal.SignalManager;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.NetUtils;
import cn.rongcloud.rtc.utils.ReportUtil;

public class ObserverState
extends AbstractBaseState {
    private static final String TAG = "ObserverState";
    private RCRTCAVStreamType mAvStreamType;
    private String mLiveUrl;
    private RCRTCLiveCallback mSubscribeLiveCallback;

    public ObserverState(RTCEngineImpl engine) {
        super(engine);
    }

    @Override
    protected boolean handleMessage(Message msg, MsgObjectWraper obj) {
        switch (msg.what) {
            case 2060: {
                this.onAddTrack((String)obj.getData(0), (String)obj.getData(1), (RCRTCMediaType)((Object)obj.getData(2)), (MediaStreamTrack)obj.getData(3));
                break;
            }
            case 5010: {
                this.unsubscribeLiveStream((String)obj.getData(0), (IRCRTCResultCallback)obj.getData(1));
                break;
            }
            case 5000: {
                this.subscribeLive((String)obj.getData(0), (RCRTCAVStreamType)((Object)obj.getData(1)), (RCRTCLiveCallback)obj.getData(2));
                break;
            }
            case 5001: {
                this.onSubscribeLiveSuccess((RCRTCAVStreamType)((Object)obj.getData(0)), (RCRTCLiveCallback)obj.getData(1));
                break;
            }
            case 8000: {
                this.reconnect();
                break;
            }
            case 8002: {
                RTCEngineImpl.getInstance().engineError(RTCErrorCode.RECONNECT_ERROR);
                break;
            }
            case 2010: {
                this.mEngine.mRTCCore.setRTCStatusReportListener((IRCRTCStatusReportListener)obj.getData());
                break;
            }
            case 2011: {
                this.mEngine.mRTCCore.setRTCStatusReportListener(null);
                break;
            }
            case 10000: {
                this.unInit(msg);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void onAddTrack(String userId, String tag, RCRTCMediaType mediaType, MediaStreamTrack track) {
        String streamId = RCStreamImpl.makeStreamId(userId, tag);
        final boolean isAudio = mediaType == RCRTCMediaType.AUDIO;
        final RCInputStreamImpl inputStream = isAudio ? new RCRTCAudioInputStreamImpl(userId, tag, streamId) : new RCVideoInputStreamImpl(userId, tag, streamId);
        inputStream.setTrack(track);
        LiveSubscribeTools.getInstance().addSubLiveStream(inputStream);
        if (this.mSubscribeLiveCallback == null) {
            return;
        }
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (isAudio) {
                    ObserverState.this.mSubscribeLiveCallback.onAudioStreamReceived((RCRTCAudioInputStream)inputStream);
                } else {
                    ObserverState.this.mSubscribeLiveCallback.onVideoStreamReceived((RCRTCVideoInputStream)inputStream);
                }
            }
        });
    }

    private void subscribeLive(String liveUrl, final RCRTCAVStreamType avStreamType, final RCRTCLiveCallback callBack) {
        ReportUtil.libTask(ReportUtil.TAG.ENGINESUBSCRIBELIVESTREAM, "liveUrl|mediaType|simulcast", liveUrl, avStreamType.getMediaType(), avStreamType.getSimulcast());
        if (!TextUtils.equals((CharSequence)this.mLiveUrl, (CharSequence)liveUrl)) {
            ReportUtil.appError(ReportUtil.TAG.ENGINESUBSCRIBELIVESTREAM, 2, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), "liveUrl not equal, originalLiveURL: " + this.mLiveUrl + "\n params:" + liveUrl);
            this.onFailedCallback(RTCErrorCode.RongRTCCodeParameterError, callBack);
            return;
        }
        this.mEngine.mRTCCore.subscribeLiveStream(liveUrl, avStreamType, new IRCRTCResultCallback(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.ENGINESUBSCRIBELIVESTREAM, "code|desc", errorCode.getValue(), errorCode.getReason());
                ObserverState.this.onFailedCallback(errorCode, callBack);
            }

            @Override
            public void onSuccess() {
                ReportUtil.libRes(ReportUtil.TAG.ENGINESUBSCRIBELIVESTREAM, "code", 0);
                ObserverState.this.sendMessage(5001, new Object[]{avStreamType, callBack});
            }
        });
    }

    private void onSubscribeLiveSuccess(RCRTCAVStreamType avStreamType, final RCRTCLiveCallback callback) {
        this.mAvStreamType = avStreamType;
        if (callback == null) {
            return;
        }
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                callback.onSuccess();
            }
        });
    }

    private void reconnect() {
        FinLog.d(TAG, "reConnect");
        if (!NetUtils.isNetConnected(this.mEngine.mContext)) {
            FinLog.e(TAG, "net work unavailable");
            return;
        }
        this.mEngine.mRTCCore.subscribeLiveStream(this.mLiveUrl, this.mAvStreamType, new IRCRTCResultCallback(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                FinLog.e(ObserverState.TAG, "Live Reconnected Failed: " + (Object)((Object)errorCode));
                ObserverState.this.sendMessage(8002, new Object[0]);
            }

            @Override
            public void onSuccess() {
                FinLog.d(ObserverState.TAG, "Live Reconnected onSuccess");
            }
        });
    }

    protected void unsubscribeLiveStream(String liveUrl, final IRCRTCResultCallback callBack) {
        ReportUtil.libTask(ReportUtil.TAG.UNSUBSCRIBELIVESTREAM, "liveUrl", liveUrl);
        if (!TextUtils.equals((CharSequence)this.mLiveUrl, (CharSequence)liveUrl)) {
            this.onFailedCallback(RTCErrorCode.RongRTCCodeParameterError, callBack);
            ReportUtil.libError(ReportUtil.TAG.UNSUBSCRIBELIVESTREAM, 2, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), "liveUrl not equal, originalLiveURL: " + this.mLiveUrl + "\n paramLiveUrl:" + liveUrl);
            return;
        }
        LiveSubscribeTools.getInstance().release();
        SignalManager.getInstance().quitLive(liveUrl, this.mAvStreamType.getRoomType().getRoomType(), new IRCRTCResultCallback(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.UNSUBSCRIBELIVESTREAM, "code|desc", errorCode.getValue(), errorCode.getReason());
                ObserverState.this.onFailedCallback(errorCode, callBack);
            }

            @Override
            public void onSuccess() {
                ReportUtil.libRes(ReportUtil.TAG.UNSUBSCRIBELIVESTREAM, "code", 0);
                ObserverState.this.onSuccessCallback(callBack);
            }
        });
        this.transitionTo(this.mEngine.mDisConnectingState);
    }

    private void unInit(Message msg) {
        this.mEngine.clearDeferredMessage();
        this.mEngine.deferMessage(msg);
        this.transitionTo(this.mEngine.mDisConnectingState);
    }

    @Override
    public void exit() {
        super.exit();
        this.mAvStreamType = null;
        this.mLiveUrl = null;
        this.mSubscribeLiveCallback = null;
    }

    public void setLiveParams(RCRTCAVStreamType avStreamType, String liveUrl, RCRTCLiveCallback callback) {
        this.mAvStreamType = avStreamType;
        this.mLiveUrl = liveUrl;
        this.mSubscribeLiveCallback = callback;
    }

    @Override
    public String getName() {
        return TAG;
    }
}

