/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine;

import android.os.Message;
import android.text.TextUtils;
import android.util.Pair;
import cn.rongcloud.rtc.api.RCRTCBaseRoom;
import cn.rongcloud.rtc.api.RCRTCOtherRoom;
import cn.rongcloud.rtc.api.RCRTCRemoteUser;
import cn.rongcloud.rtc.api.RCRTCRoom;
import cn.rongcloud.rtc.api.callback.IRCRTCFailedCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCStatusReportListener;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import cn.rongcloud.rtc.api.stream.RCRTCLiveInfo;
import cn.rongcloud.rtc.api.stream.RCRTCOutputStream;
import cn.rongcloud.rtc.base.RCAttributeType;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.base.RCRTCRoomType;
import cn.rongcloud.rtc.base.RCRTCStream;
import cn.rongcloud.rtc.base.RCRTCStreamType;
import cn.rongcloud.rtc.base.RCRTCSubscribeState;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.RCLocalUserImpl;
import cn.rongcloud.rtc.center.RCOtherRoomImpl;
import cn.rongcloud.rtc.center.RCRemoteUserImpl;
import cn.rongcloud.rtc.center.RCRoomImpl;
import cn.rongcloud.rtc.center.stream.RCInputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCOutputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCStreamImpl;
import cn.rongcloud.rtc.center.stream.RCTinyVideoOutStream;
import cn.rongcloud.rtc.center.stream.RCVideoInputStreamImpl;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.engine.AbstractBaseState;
import cn.rongcloud.rtc.engine.MsgObjectWraper;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.engine.action.PubSubActionQueue;
import cn.rongcloud.rtc.engine.tools.HandleRTCMsgTools;
import cn.rongcloud.rtc.engine.tools.MultiRoomManager;
import cn.rongcloud.rtc.engine.tools.multiroom.InviteMessageElement;
import cn.rongcloud.rtc.proxy.message.messagebeans.InviteInfo;
import cn.rongcloud.rtc.proxy.message.messagebeans.MediaResourceInfo;
import cn.rongcloud.rtc.proxy.message.messagebeans.PKInfo;
import cn.rongcloud.rtc.signal.SignalManager;
import cn.rongcloud.rtc.stat.RongRtcStatMagr;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.NetUtils;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.ResourceTools;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import cn.rongcloud.rtc.webrtc.IStreamResource;
import cn.rongcloud.rtc.webrtc.MediaCommonParams;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.RTCStatusDate;
import io.rong.imlib.model.RTCUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class InRoomState
extends AbstractBaseState {
    private static final String TAG = "InRoomState";
    private PubSubActionQueue mActionQueue = new PubSubActionQueue(this);
    private RCRoomImpl mRoom;
    private RCLocalUserImpl mLocalUser;
    private HandleRTCMsgTools mReceivedMsgTools;
    private MultiRoomManager mMultiRoomManager;

    public InRoomState(RTCEngineImpl engine) {
        super(engine);
    }

    @Override
    public void enter() {
        this.mRoom = this.mEngine.mRoom;
        this.mLocalUser = (RCLocalUserImpl)this.mRoom.getLocalUser();
        this.mActionQueue.clear();
        this.mReceivedMsgTools = new HandleRTCMsgTools(this);
        super.enter();
    }

    @Override
    public boolean handleMessage(Message msg, MsgObjectWraper obj) {
        switch (msg.what) {
            case 3000: {
                this.mActionQueue.offer(1, (List)obj.getData(0), (IRCRTCFailedCallback)obj.getData(1));
                break;
            }
            case 3010: {
                this.mActionQueue.offer(1, (List)obj.getData(0), (IRCRTCResultDataCallback)obj.getData(1));
                break;
            }
            case 3001: {
                this.onPublishStreamsSuccess((List)obj.getData(0), (List)obj.getData(1), (RCRTCLiveInfo)obj.getData(2), (IRCRTCResultDataCallback)obj.getData(3));
                break;
            }
            case 3080: {
                this.mActionQueue.offer(2, (List)obj.getData(0), (IRCRTCResultCallback)obj.getData(1));
                break;
            }
            case 3081: {
                this.onUnpublishedStreamsSuccess((List)obj.getData(0), (List)obj.getData(1), (IRCRTCResultDataCallback)obj.getData(2));
                break;
            }
            case 4000: {
                this.mActionQueue.offer(3, (List)obj.getData(0), (IRCRTCResultCallback)obj.getData(1));
                break;
            }
            case 3091: 
            case 4001: {
                this.onSubscribeStreamSuccess((List)obj.getData(0), (IRCRTCResultDataCallback)obj.getData(1));
                break;
            }
            case 4040: {
                this.mActionQueue.offer(5, (List)obj.getData(0), (IRCRTCResultCallback)obj.getData(1));
                break;
            }
            case 4041: {
                this.onUnsubscribeResourcesSuccess((List)obj.getData(0), (IRCRTCResultDataCallback)obj.getData(1));
                break;
            }
            case 3090: {
                this.mActionQueue.offer(6, Collections.singletonList((RCRTCInputStream)obj.getData(1)), obj.getData(0), (IRCRTCFailedCallback)((IRCRTCResultCallback)obj.getData(2)));
                break;
            }
            case 3092: {
                this.onSwitchStreamFailed((Boolean)obj.getData(0), (List)obj.getData(1));
                this.onPubSubFailed(msg, obj);
                break;
            }
            case 3002: 
            case 3082: 
            case 4002: 
            case 4042: {
                this.onPubSubFailed(msg, obj);
                break;
            }
            case 3050: {
                this.mActionQueue.offer(7, null, null);
                break;
            }
            case 3051: {
                ((IRCRTCResultDataCallback)obj.getData(1)).onSuccess(null);
                break;
            }
            case 8000: {
                this.reconnect(false);
                break;
            }
            case 8002: {
                RTCEngineImpl.getInstance().engineError(RTCErrorCode.RECONNECT_ERROR);
                break;
            }
            case 8001: {
                this.onStartReconnectSuccess((Pair<List<MediaResourceInfo>, RCRTCLiveInfo>)((Pair)obj.getData()));
                break;
            }
            case 3100: {
                this.sendModifyResourceSignal((RCOutputStreamImpl)obj.getData(0), (Boolean)obj.getData(1));
                break;
            }
            case 7000: {
                this.mReceivedMsgTools.handleRTCMessage((io.rong.imlib.model.Message)obj.getData());
                break;
            }
            case 2060: {
                this.addTrack((String)obj.getData(0), (String)obj.getData(1), (RCRTCMediaType)((Object)obj.getData(2)), (MediaStreamTrack)obj.getData(3));
                break;
            }
            case 8101: {
                this.mRoom.getPingManager().reJoinRoom(this.mRoom.getRoomType());
                break;
            }
            case 8102: {
                this.onReJoinRoomSuccess((List)obj.getData());
                break;
            }
            case 3301: {
                this.mRoom.getEventsListener().onFirstRemoteVideoFrame((String)obj.getData(0), (String)obj.getData(1));
                break;
            }
            case 3302: {
                break;
            }
            case 3303: {
                SignalManager.getInstance().setAttributeValue((String)obj.getData(5), (RCAttributeType)((Object)obj.getData(0)), (String)obj.getData(1), (String)obj.getData(2), (MessageContent)obj.getData(3), (IRCRTCResultCallback)obj.getData(4));
                break;
            }
            case 3307: {
                SignalManager.getInstance().rtcPutInnerData(this.mRoom.getRoomId(), (RCAttributeType)((Object)obj.getData(0)), (String)obj.getData(1), (String)obj.getData(2), (MessageContent)obj.getData(3), (IRCRTCResultCallback)obj.getData(4));
                break;
            }
            case 3304: {
                SignalManager.getInstance().deleteAttributes((String)obj.getData(4), (RCAttributeType)((Object)obj.getData(0)), (List)obj.getData(1), (MessageContent)obj.getData(2), (IRCRTCResultCallback)obj.getData(3));
                break;
            }
            case 3305: {
                SignalManager.getInstance().getAttributes((String)obj.getData(3), (RCAttributeType)((Object)obj.getData(0)), (List)obj.getData(1), (IRCRTCResultDataCallback)obj.getData(2));
                break;
            }
            case 3306: {
                SignalManager.getInstance().sendIMSignal(this.mRoom.getRoomId(), (MessageContent)obj.getData(0), (IRongCallback.ISendMessageCallback)obj.getData(1));
                break;
            }
            case 2010: {
                this.mEngine.mRTCCore.setRTCStatusReportListener((IRCRTCStatusReportListener)obj.getData());
                break;
            }
            case 2011: {
                this.mEngine.mRTCCore.setRTCStatusReportListener(null);
                break;
            }
            case 5020: {
                SignalManager.getInstance().setMCUConfig((String)obj.getData(0), this.mRoom.getRoomId(), this.mRoom.getSessionId(), (String)obj.getData(1), (IRCRTCResultDataCallback)obj.getData(2));
                break;
            }
            case 9001: {
                if (this.mRoom.getEventsListener() != null) {
                    this.mRoom.getEventsListener().onLeaveRoom(RCRTCParamsType.LeaveRoomReason.NETWORK_NOT_AVAILABLE.getValue());
                }
                this.releaseRoom(null);
                break;
            }
            case 9000: {
                this.releaseRoom((IRCRTCResultCallback)obj.getData());
                break;
            }
            case 10000: {
                this.mEngine.clearDeferredMessage();
                this.mEngine.deferMessage(msg);
                this.releaseRoom(null);
                break;
            }
            case 2070: {
                this.joinOtherRoom(String.valueOf(obj.getData(0)), (IRCRTCResultDataCallback)obj.getData(1));
                break;
            }
            case 2071: {
                Object[] joinOtherSuccess_exarams = (Object[])obj.getData(3);
                IRCRTCResultDataCallback joinOtherRoomSuccess_callback = (IRCRTCResultDataCallback)obj.getData(4);
                if (joinOtherSuccess_exarams == null) {
                    this.onFailedCallback(RTCErrorCode.RongRTCCodeParameterError, joinOtherRoomSuccess_callback);
                    break;
                }
                this.onJoinOtherRoomSuccess(String.valueOf(obj.getData(0)), (RCRTCRoomType)((Object)obj.getData(1)), (List)obj.getData(2), joinOtherSuccess_exarams, joinOtherRoomSuccess_callback);
                break;
            }
            case 2072: {
                this.leaveOtherRoom(String.valueOf(obj.getData(0)), (Boolean)obj.getData(1), (IRCRTCResultCallback)obj.getData(2));
                break;
            }
            case 2073: {
                this.sendRequestJoinOtherRoomMessage(obj);
                break;
            }
            case 2074: {
                this.sendCancelRequestJoinOtherRoomMessage(obj);
                break;
            }
            case 2075: {
                this.responseJoinOtherRoom(obj);
                break;
            }
            case 2076: {
                ((IRCRTCResultDataCallback)obj.getData()).onSuccess(null);
                break;
            }
            case 2077: {
                ((IRCRTCResultDataCallback)obj.getData(0)).onFailed(RTCErrorCode.valueOf((Integer)obj.getData(1)));
                break;
            }
            case 2078: {
                String otherRoomId = (String)obj.getData(0);
                int pingErrorCode = (Integer)obj.getData(1);
                FinLog.e(TAG, "otherRoomId :" + otherRoomId + " pingErrorCode :" + pingErrorCode);
                RCOtherRoomImpl otherRoom = (RCOtherRoomImpl)this.getMultiRoomManager().getBaseRoomElemet().remove(otherRoomId);
                if (otherRoom != null) {
                    otherRoom.release();
                }
                if (this.mRoom == null) break;
                this.mRoom.removeOtherRoomId(otherRoomId);
                if (this.mRoom.getEventsListener() == null) break;
                this.mRoom.getEventsListener().onOtherRoomConnectionError(otherRoomId);
                break;
            }
            case 2079: {
                this.sendleaveOtherRoomMessage((RCOtherRoomImpl)obj.getData(0), (Boolean)obj.getData(1), (IRCRTCResultCallback)obj.getData(2));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void sendFinishOtherRoomMessage(final String otherRoomId, final IRCRTCResultCallback callBack) {
        if (this.mRoom == null || TextUtils.isEmpty((CharSequence)this.mRoom.getRoomId()) || this.mRoom.getLocalUser() == null || TextUtils.isEmpty((CharSequence)this.mRoom.getLocalUser().getUserId())) {
            this.onFailedCallback(RTCErrorCode.RongRTCCodeParameterError, callBack);
            FinLog.e(TAG, "sendFinishOtherRoomMessage. Parameter is empty.");
            return;
        }
        String[] keys = new String[1];
        String inviteSessionId = "";
        String multiRoomKey = "";
        PKInfo pkInfo = this.mMultiRoomManager.getRoomAttributesElement().get(otherRoomId);
        if (pkInfo != null && !TextUtils.isEmpty((CharSequence)pkInfo.getInviteSessionId())) {
            keys[0] = multiRoomKey = pkInfo.getMultiRoomKey();
            inviteSessionId = pkInfo.getInviteSessionId();
        }
        ReportUtil.libTask(ReportUtil.TAG.FINISHOTHERROOM, "otherRoomId|multiRoomKey|inviteSessionId", otherRoomId, multiRoomKey, inviteSessionId);
        SignalManager.getInstance().finishOtherRoom(otherRoomId, "", this.mRoom.getRoomId(), inviteSessionId, this.mRoom.getLocalUser().getUserId(), keys, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                ReportUtil.libRes(ReportUtil.TAG.FINISHOTHERROOM, "otherRoomId", otherRoomId);
                InRoomState.this.onSuccessCallback(callBack);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.FINISHOTHERROOM, "otherRoomId|code", otherRoomId, errorCode.getValue());
                InRoomState.this.onFailedCallback(errorCode, callBack);
            }
        });
        this.mMultiRoomManager.getRoomAttributesElement().remove(multiRoomKey);
    }

    private void sendCancelRequestJoinOtherRoomMessage(MsgObjectWraper obj) {
        String inviteeRoomId = String.valueOf(obj.getData(0));
        final IRCRTCResultCallback cancel_callback = (IRCRTCResultCallback)obj.getData(4);
        final String cancel_userId = String.valueOf(obj.getData(1));
        final String inviteSessionId = (String)obj.getData(2);
        String extra = "";
        Object cancel_extra_Obj = obj.getData(3);
        if (cancel_extra_Obj != null) {
            extra = String.valueOf(cancel_extra_Obj);
        }
        SignalManager.getInstance().cancelRequestJoinOtherRoom(inviteeRoomId, cancel_userId, this.mRoom.getRoomId(), this.mRoom.getLocalUser().getUserId(), inviteSessionId, extra, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                InRoomState.this.getMultiRoomManager().getInviteMessageElement().remove(cancel_userId);
                ReportUtil.appRes(ReportUtil.TAG.CANCELREQUESTJOINOTHERROOM, "inviteSessionId", inviteSessionId);
                InRoomState.this.onSuccessCallback(cancel_callback);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.CANCELREQUESTJOINOTHERROOM, "inviteSessionId", inviteSessionId, errorCode.getValue());
                InRoomState.this.onFailedCallback(errorCode, cancel_callback);
            }
        });
    }

    private void responseJoinOtherRoom(MsgObjectWraper obj) {
        final String inviterUserId = String.valueOf(obj.getData(1));
        String inviterRoomId = String.valueOf(obj.getData(0));
        boolean agree = (Boolean)obj.getData(2);
        boolean inviteeUserAutoMix = (Boolean)obj.getData(3);
        String extra = "";
        Object extra_Obj = obj.getData(6);
        if (extra_Obj != null) {
            extra = String.valueOf(extra_Obj);
        }
        final String inviteSessionId = (String)obj.getData(4);
        final IRCRTCResultCallback callback = (IRCRTCResultCallback)obj.getData(7);
        InviteInfo inviteInfo = (InviteInfo)obj.getData(5);
        String key = RongRTCUtils.createRoomKey(inviterRoomId, this.mRoom.getRoomId());
        SignalManager.getInstance().responseJoinOtherRoom(inviterRoomId, inviterUserId, agree, extra, inviteeUserAutoMix, this.mRoom.getRoomId(), inviteInfo, key, inviteSessionId, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                ReportUtil.appRes(ReportUtil.TAG.RESPONSEJOINOTHERROOM, "inviteSessionId", inviteSessionId);
                InRoomState.this.mMultiRoomManager.getInviteNotifyMessageElement().remove(inviterUserId, inviteSessionId);
                InRoomState.this.onSuccessCallback(callback);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.RESPONSEJOINOTHERROOM, "inviteSessionId|code", inviteSessionId, errorCode.getValue());
                InRoomState.this.onFailedCallback(errorCode, callback);
            }
        });
    }

    private void sendRequestJoinOtherRoomMessage(MsgObjectWraper obj) {
        final String inviteeRoomId = String.valueOf(obj.getData(0));
        final String inviteeUserId = String.valueOf(obj.getData(1));
        int timeoutTime = (Integer)obj.getData(2);
        boolean autoMix = (Boolean)obj.getData(3);
        final String inviteSessionId = (String)obj.getData(4);
        String extra = "";
        Object extraObj = obj.getData(5);
        if (extraObj != null) {
            extra = String.valueOf(extraObj);
        }
        String mainRoomId = this.mRoom.getRoomId();
        final IRCRTCResultCallback callback = (IRCRTCResultCallback)obj.getData(6);
        String localUserId = this.mRoom.getLocalUser().getUserId();
        InviteInfo info = new InviteInfo(inviteeRoomId, inviteeUserId, timeoutTime, inviteSessionId, mainRoomId, localUserId, autoMix);
        String inviteInfo = info.toString(extra);
        long startInviteTime = System.currentTimeMillis();
        ReportUtil.appTask(ReportUtil.TAG.REQUESTJOINOTHERROOM, RongRTCUtils.append("inviteeRoomId", "inviteeUserId", "startInviteTime"), inviteeRoomId, inviteeUserId, startInviteTime);
        InviteMessageElement.InviteTimeoutStatistics inviteTimeoutStatistics = new InviteMessageElement.InviteTimeoutStatistics(inviteSessionId, startInviteTime);
        this.mMultiRoomManager.getInviteMessageElement().put(inviteeUserId, inviteTimeoutStatistics);
        final String rkey = RongRTCUtils.append("inviteeRoomId", "inviteeUserId", "inviteSessionId", "code");
        SignalManager.getInstance().requestJoinOtherRoom(inviteeRoomId, inviteeUserId, mainRoomId, timeoutTime, inviteSessionId, inviteInfo, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                ReportUtil.appRes(ReportUtil.TAG.REQUESTJOINOTHERROOM, rkey, inviteeRoomId, inviteeUserId, inviteSessionId);
                InRoomState.this.onSuccessCallback(callback);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.REQUESTJOINOTHERROOM, rkey, inviteeRoomId, inviteeUserId, inviteSessionId, errorCode.getValue());
                InRoomState.this.onFailedCallback(errorCode, callback);
            }
        });
    }

    private void addTrack(String userId, String tag, RCRTCMediaType mediaType, MediaStreamTrack track) {
        RCRTCBaseRoom tmpRoom;
        if (this.mLocalUser != null && !TextUtils.isEmpty((CharSequence)this.mLocalUser.getUserId())) {
            FinLog.d("BaseRoomElemet", "getRoomByUserId . localUserId :" + this.mLocalUser.getUserId());
        }
        if ((tmpRoom = this.mMultiRoomManager.getBaseRoomElemet().getRoomByUserId(userId)) == null) {
            FinLog.e(TAG, "addTrack.Room is empty.uid :" + userId + " , tag :" + tag + " , mediaType :" + mediaType.getValue());
            return;
        }
        FinLog.e(TAG, "addTrack.roomId : +" + tmpRoom.getRoomId());
        RCRTCRemoteUser remoteUser = tmpRoom.getRemoteUser(userId);
        if (remoteUser == null) {
            return;
        }
        RCRTCInputStream stream = remoteUser.getStream(tag, mediaType);
        if (stream == null) {
            return;
        }
        FinLog.d("subscribedStreams", "addTrack : " + stream.getUri());
        stream.setTrack(track);
        if (mediaType == RCRTCMediaType.VIDEO) {
            if (tmpRoom instanceof RCRTCRoom) {
                ((RCRoomImpl)tmpRoom).getEventsListener().onVideoTrackAdd(userId, tag);
            } else if (tmpRoom instanceof RCRTCOtherRoom) {
                ((RCOtherRoomImpl)tmpRoom).getRCRoomListener().onVideoTrackAdd((RCRTCOtherRoom)tmpRoom, userId, tag);
            }
        }
    }

    private void onReJoinRoomSuccess(List<RTCUser> rtcUsers) {
        this.mRoom.getPingManager().diffUsers(this.mRoom, rtcUsers);
        this.reconnect(true);
    }

    private void reconnect(boolean forceSendSignal) {
        FinLog.d(TAG, "reconnect");
        if (!NetUtils.isNetConnected(this.mEngine.mContext)) {
            FinLog.e(TAG, "Net Work not Connected");
            return;
        }
        this.mEngine.mRTCCore.reconnectConnection(forceSendSignal, this.mLocalUser.getStreamsForInternal(), this.getAllSubscribedStreams(), new MediaCommonParams<Pair<List<MediaResourceInfo>, RCRTCLiveInfo>>(this.mRoom.getRoomId(), this.mRoom.getClientSessionId(), this.mRoom.getRoomType(), this.mMultiRoomManager.getRoomAttributesElement().getAutoMixJSONInfo(""), this.mLocalUser.getRole(), new IRCRTCResultDataCallback<Pair<List<MediaResourceInfo>, RCRTCLiveInfo>>(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                FinLog.e(InRoomState.TAG, "reconnectConnection Failed: " + (Object)((Object)errorCode));
                InRoomState.this.sendMessage(8002, new Object[0]);
            }

            @Override
            public void onSuccess(Pair<List<MediaResourceInfo>, RCRTCLiveInfo> data) {
                InRoomState.this.sendMessage(8001, (Object)data);
            }
        }));
    }

    private void onStartReconnectSuccess(Pair<List<MediaResourceInfo>, RCRTCLiveInfo> data) {
        this.mLocalUser.updateMediaInfos((List)data.first);
    }

    private void sendModifyResourceSignal(RCOutputStreamImpl stream, boolean isMute) {
        ReportUtil.appTask(ReportUtil.TAG.MODIFYRESOURCE, "media|isOpen", stream.getMediaType().getDescription(), !isMute);
        ArrayList<MediaResourceInfo> modifyResourceList = new ArrayList<MediaResourceInfo>();
        JSONArray jsonArray = new JSONArray();
        for (RCRTCOutputStream rcStream : this.mLocalUser.getStreamsForInternal()) {
            if (TextUtils.isEmpty((CharSequence)rcStream.getUri())) continue;
            MediaResourceInfo mediaResourceInfo = new MediaResourceInfo(rcStream);
            if (stream == rcStream) {
                modifyResourceList.add(mediaResourceInfo);
            }
            jsonArray.put((Object)mediaResourceInfo.getJsonObject());
        }
        if (modifyResourceList.isEmpty()) {
            FinLog.e(TAG, "sendModifyResourceSignal: modifyResourceList is Null");
            return;
        }
        String publish = jsonArray.toString();
        FinLog.i(TAG, "setRTCUserData publish " + publish);
        RTCStatusDate[] kv = new RTCStatusDate[]{ResourceTools.getStatusDate("uris", publish)};
        RTCStatusDate[] content = new RTCStatusDate[]{ResourceTools.getStatusDate("RCRTC:ModifyResource", ResourceTools.getURIS(modifyResourceList, true, ""))};
        SignalManager.getInstance().rtcSetUserResource(this.mRoom.getRoomId(), kv, "RCRTC:TotalContentResources", content, new IRCRTCResultCallback(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.MODIFYRESOURCE, "code|desc", errorCode.getValue(), errorCode.getReason());
            }

            @Override
            public void onSuccess() {
                ReportUtil.appRes(ReportUtil.TAG.MODIFYRESOURCE, "code", 0);
            }
        });
    }

    public void releaseRoom(final IRCRTCResultCallback callBack) {
        List<String> otherRoomIds = this.getMultiRoomManager().getBaseRoomElemet().leaveAllOtherRoom();
        if (otherRoomIds != null && otherRoomIds.size() > 0) {
            for (final String otherRoomId : otherRoomIds) {
                this.getMultiRoomManager().getBaseRoomElemet().otherRoomRelease(otherRoomId);
                SignalManager.getInstance().sendleaveOtherRoomMessage(otherRoomId, new IRCRTCResultCallback(){

                    @Override
                    public void onSuccess() {
                        FinLog.d(InRoomState.TAG, "releaseRoom->leaveOtherRoom Success :" + otherRoomId);
                    }

                    @Override
                    public void onFailed(RTCErrorCode errorCode) {
                        FinLog.d(InRoomState.TAG, "releaseRoom->leaveOtherRoom Failed :" + otherRoomId + " errorCode :" + errorCode.getValue());
                    }
                });
            }
        }
        ReportUtil.libTask(ReportUtil.TAG.RELEASEROOM, "roomId", this.getRoomId());
        this.mActionQueue.clear();
        RongRtcStatMagr.instance.release();
        RongRTCUtils.customRate = false;
        this.mEngine.version2UserIDs.clear();
        RongRTCUtils.customFPS = false;
        this.mEngine.mDefaultAudioStream.resetStream();
        this.mEngine.mDefaultVideoStream.resetStream();
        this.mLocalUser.release();
        this.mRoom.release();
        final String roomId = this.mRoom.getRoomId();
        SignalManager.getInstance().leaveRoom(roomId, this.mRoom.getRoomType(), this.mRoom.getClientSessionId(), new IRCRTCResultCallback(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libErrorW(ReportUtil.TAG.RELEASEROOM, errorCode, "roomId", roomId);
                InRoomState.this.onFailedCallback(errorCode, callBack);
            }

            @Override
            public void onSuccess() {
                ReportUtil.libRes(ReportUtil.TAG.RELEASEROOM, roomId);
                InRoomState.this.onSuccessCallback(callBack);
            }
        });
        this.mLocalUser = null;
        this.mRoom = null;
        this.mEngine.mRoom = null;
        FinLog.i(TAG, "releaseAll end");
        this.mMultiRoomManager.release();
        this.transitionTo(this.mEngine.mDisConnectingState);
    }

    private void onPubSubFailed(Message msg, MsgObjectWraper obj) {
        Object[] data;
        RTCErrorCode errorCode = null;
        IRCRTCFailedCallback callback = null;
        for (Object v : data = (Object[])obj.getData()) {
            if (v instanceof RTCErrorCode) {
                errorCode = (RTCErrorCode)((Object)v);
                continue;
            }
            if (!(v instanceof IRCRTCFailedCallback)) continue;
            callback = (IRCRTCFailedCallback)v;
        }
        if (callback != null && errorCode != null) {
            callback.onFailed(errorCode);
        } else {
            FinLog.e(TAG, "onPubSubFailed: msg.what=" + msg.what + " , callback=" + (null == callback ? "null" : callback.toString()) + " , errorCode=" + (null == errorCode ? "null" : Integer.valueOf(errorCode.getValue())));
        }
    }

    public void unpublishedStreams(final List<RCRTCOutputStream> unpublishedStreams, final IRCRTCResultDataCallback callBack) {
        ReportUtil.libTask(ReportUtil.TAG.UNPUBLISHAVSTREAM, "roomId", this.getRoomId());
        for (RCRTCOutputStream unpublishedStream : unpublishedStreams) {
            if (unpublishedStream != this.mEngine.getDefaultVideoStream() || this.mEngine.mDefaultVideoStream.getTinyVideoOutStream() == null) continue;
            unpublishedStreams.add(this.mEngine.mDefaultVideoStream.getTinyVideoOutStream());
            break;
        }
        List<RCRTCOutputStream> publishedStreams = this.mLocalUser.getStreamsForInternal();
        publishedStreams.removeAll(unpublishedStreams);
        this.mEngine.mRTCCore.unpublishedStreams(publishedStreams, this.getAllSubscribedStreams(), unpublishedStreams, new MediaCommonParams<List<MediaResourceInfo>>(this.mRoom.getRoomId(), this.mRoom.getClientSessionId(), this.mRoom.getRoomType(), this.mMultiRoomManager.getRoomAttributesElement().getAutoMixJSONInfo(""), this.mLocalUser.getRole(), new IRCRTCResultDataCallback<List<MediaResourceInfo>>(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.UNPUBLISHAVSTREAM, errorCode, "roomId", InRoomState.this.getRoomId());
                InRoomState.this.sendMessage(3082, new Object[]{errorCode, callBack});
            }

            @Override
            public void onSuccess(List<MediaResourceInfo> data) {
                ReportUtil.libRes(ReportUtil.TAG.UNPUBLISHAVSTREAM, InRoomState.this.getRoomId());
                InRoomState.this.sendMessage(3081, unpublishedStreams, data, callBack);
            }
        }));
    }

    private void onUnpublishedStreamsSuccess(List<RCRTCOutputStream> unpublishedStreams, List<MediaResourceInfo> mediaResourceInfos, IRCRTCResultDataCallback callBack) {
        for (RCRTCOutputStream stream : unpublishedStreams) {
            ((RCOutputStreamImpl)stream).stop();
            if (stream != this.mEngine.getDefaultAudioStream() && stream != this.mEngine.getDefaultVideoStream()) {
                ((RCStreamImpl)((Object)stream)).release();
                if (stream instanceof RCTinyVideoOutStream) {
                    this.mEngine.mDefaultVideoStream.setTinyVideoOutStream(null);
                }
            } else {
                ((RCOutputStreamImpl)stream).setUri(null);
            }
            this.mLocalUser.removePublishedStream(stream);
        }
        this.mLocalUser.updateMediaInfos(mediaResourceInfos);
        callBack.onSuccess(null);
    }

    public void publishStreams(final List streams, final IRCRTCResultDataCallback callBack) {
        RCTinyVideoOutStream tinyVideoOutStream;
        ReportUtil.libTask(ReportUtil.TAG.PUBLISHAVSTREAM, "roomId", this.getRoomId());
        List<RCRTCOutputStream> pubList = this.mLocalUser.getStreamsForInternal();
        if (this.mEngine.mEnableTinyStream && streams.contains(this.mEngine.getDefaultVideoStream()) && (tinyVideoOutStream = this.mEngine.mDefaultVideoStream.getTinyVideoOutStream()) == null) {
            tinyVideoOutStream = new RCTinyVideoOutStream(this.mEngine.mUserId);
            this.mEngine.mDefaultVideoStream.setTinyVideoOutStream(tinyVideoOutStream);
            streams.add(tinyVideoOutStream);
        }
        pubList.addAll(streams);
        this.mEngine.mRTCCore.publishStream(pubList, streams, this.getAllSubscribedStreams(), new MediaCommonParams<Pair<List<MediaResourceInfo>, RCRTCLiveInfo>>(this.mRoom.getRoomId(), this.mRoom.getClientSessionId(), this.mRoom.getRoomType(), this.mMultiRoomManager.getRoomAttributesElement().getAutoMixJSONInfo(""), this.mLocalUser.getRole(), new IRCRTCResultDataCallback<Pair<List<MediaResourceInfo>, RCRTCLiveInfo>>(){

            @Override
            public void onSuccess(Pair<List<MediaResourceInfo>, RCRTCLiveInfo> data) {
                ReportUtil.libRes(ReportUtil.TAG.PUBLISHAVSTREAM, InRoomState.this.getRoomId());
                InRoomState.this.sendMessage(3001, streams, data.first, data.second, callBack);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libErrorW(ReportUtil.TAG.PUBLISHAVSTREAM, errorCode, "roomId", InRoomState.this.getRoomId());
                InRoomState.this.sendMessage(3002, new Object[]{errorCode, streams, callBack});
            }
        }));
    }

    private void onPublishStreamsSuccess(List<RCRTCOutputStream> streams, List<MediaResourceInfo> mediaResourceInfos, RCRTCLiveInfo liveInfo, IRCRTCResultDataCallback callback) {
        this.mLocalUser.addPublishedStream(streams);
        block0: for (RCRTCOutputStream outputStream : this.mLocalUser.getStreamsForInternal()) {
            for (MediaResourceInfo info : mediaResourceInfos) {
                if (info.getType() != outputStream.getMediaType() || !info.getTag().equals(outputStream.getTag())) continue;
                ((RCOutputStreamImpl)outputStream).updateMediaInfo(info);
                if (!streams.contains(outputStream)) continue block0;
                ((RCOutputStreamImpl)outputStream).start();
                continue block0;
            }
        }
        callback.onSuccess(liveInfo);
    }

    public void subscribeStreams(List<? extends RCRTCInputStream> streams, IRCRTCResultDataCallback callBack) {
        ReportUtil.libTask(ReportUtil.TAG.ENGINESUBSCRIBESTREAMS, "roomId|streams", this.mRoom.getRoomId(), ReportUtil.resourceToString(streams));
        ArrayList<RCRTCInputStream> allInputStreams = new ArrayList<RCRTCInputStream>();
        for (RCRTCRemoteUser remoteUser : this.mRoom.getRemoteUsers()) {
            allInputStreams.addAll(remoteUser.getStreams());
        }
        allInputStreams.addAll(this.getMultiRoomManager().getBaseRoomElemet().getOtherRoomInputStreams());
        if (RongRTCUtils.resourceNotExist(allInputStreams, streams)) {
            ReportUtil.libErrorW(ReportUtil.TAG.ENGINESUBSCRIBESTREAMS, RTCErrorCode.RongRTCCodeSubscribeNotExistResources, "roomId", this.mRoom.getRoomId());
            callBack.onFailed(RTCErrorCode.RongRTCCodeSubscribeNotExistResources);
            return;
        }
        List<IStreamResource> subscribedStreams = this.getAllSubscribedStreams();
        for (RCRTCInputStream rCRTCInputStream : streams) {
            Iterator<IStreamResource> iterator = subscribedStreams.iterator();
            while (iterator.hasNext()) {
                IStreamResource streamResource = iterator.next();
                RCRTCMediaType mediaType = rCRTCInputStream.getMediaType();
                if (!TextUtils.equals((CharSequence)streamResource.getStreamId(), (CharSequence)rCRTCInputStream.getStreamId()) || mediaType != streamResource.getMediaType()) continue;
                FinLog.d(TAG, "subscribedStreams.Delete duplicate.Uri : " + streamResource.getUri() + " , new :" + rCRTCInputStream.getUri());
                iterator.remove();
            }
        }
        subscribedStreams.addAll(streams);
        this.onSubScribeStreams(subscribedStreams, callBack, ReportUtil.TAG.ENGINESUBSCRIBESTREAMS);
    }

    public void resubscribeStreams(IRCRTCResultDataCallback callback) {
        ReportUtil.libTask(ReportUtil.TAG.RESUBSCRIBESTREAMS, "roomId", this.getRoomId());
        this.onSubScribeStreams(this.getAllSubscribedStreams(), callback, ReportUtil.TAG.RESUBSCRIBESTREAMS);
    }

    private void onSubScribeStreams(final List<? extends IStreamResource> allSubStreams, final IRCRTCResultDataCallback callback, final ReportUtil.TAG tag) {
        this.mEngine.mRTCCore.subscribeStreams(this.mLocalUser.getStreamsForInternal(), allSubStreams, new MediaCommonParams(this.mRoom.getRoomId(), this.mRoom.getClientSessionId(), this.mRoom.getRoomType(), this.mMultiRoomManager.getRoomAttributesElement().getAutoMixJSONInfo(""), this.mLocalUser.getRole(), new IRCRTCResultCallback(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                if (tag != null) {
                    ReportUtil.libErrorW(tag, errorCode, "roomId", InRoomState.this.getRoomId());
                }
                InRoomState.this.sendMessage(4002, new Object[]{errorCode, callback});
            }

            @Override
            public void onSuccess() {
                if (tag != null) {
                    ReportUtil.libRes(tag, InRoomState.this.getRoomId());
                }
                InRoomState.this.sendMessage(4001, allSubStreams, callback);
            }
        }));
    }

    private void onSubscribeStreamSuccess(List<? extends RCRTCInputStream> streams, IRCRTCResultDataCallback callback) {
        for (RCRTCInputStream rCRTCInputStream : streams) {
            ((RCInputStreamImpl)rCRTCInputStream).setSubscribeState(RCRTCSubscribeState.SUBSCRIBED);
        }
        callback.onSuccess(null);
    }

    public void unsubscribeStreams(final List<? extends RCRTCInputStream> streams, boolean needExchangeSDP, String otherRoomIgnored, final IRCRTCResultDataCallback callback) {
        ReportUtil.libTask(ReportUtil.TAG.UNSUBSCRIBEAVSTREAM, "roomId|streams|notifyFinished", this.getRoomId(), ReportUtil.resourceToString(streams), needExchangeSDP);
        ArrayList<RCRTCInputStream> allInputStreams = new ArrayList<RCRTCInputStream>();
        for (RCRTCRemoteUser remoteUser : this.mRoom.getRemoteUsers()) {
            allInputStreams.addAll(remoteUser.getStreams());
        }
        List<IStreamResource> subscribedStreams = this.getAllSubscribedStreams();
        subscribedStreams.removeAll(streams);
        this.mEngine.mRTCCore.unsubscribeStreams(this.mLocalUser.getStreamsForInternal(), subscribedStreams, streams, needExchangeSDP, new MediaCommonParams(this.mRoom.getRoomId(), this.mRoom.getClientSessionId(), this.mRoom.getRoomType(), this.mMultiRoomManager.getRoomAttributesElement().getAutoMixJSONInfo(otherRoomIgnored), this.mLocalUser.getRole(), new IRCRTCResultCallback(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libErrorW(ReportUtil.TAG.UNSUBSCRIBEAVSTREAM, errorCode, InRoomState.this.getRoomId(), new Object[0]);
                InRoomState.this.sendMessage(4042, new Object[]{errorCode, callback});
            }

            @Override
            public void onSuccess() {
                ReportUtil.libRes(ReportUtil.TAG.UNSUBSCRIBEAVSTREAM, InRoomState.this.getRoomId());
                InRoomState.this.sendMessage(4041, streams, callback);
            }
        }));
    }

    private String getRoomId() {
        return this.mEngine.getRoomId();
    }

    private void onUnsubscribeResourcesSuccess(List<? extends RCRTCInputStream> streams, IRCRTCResultDataCallback callback) {
        for (RCRTCInputStream rCRTCInputStream : streams) {
            ((RCInputStreamImpl)rCRTCInputStream).setSubscribeState(RCRTCSubscribeState.INIT);
        }
        callback.onSuccess(null);
    }

    public void switchStream(final boolean tiny, final List<RCRTCInputStream> streams, final IRCRTCResultDataCallback callback) {
        ReportUtil.libTask(ReportUtil.TAG.SWITCHSTREAMTINYORNORMAL, "roomId|isTiny", this.getRoomId(), tiny);
        for (RCRTCStream rCRTCStream : streams) {
            ((RCVideoInputStreamImpl)rCRTCStream).setStreamType(tiny ? RCRTCStreamType.TINY : RCRTCStreamType.NORMAL);
        }
        List<IStreamResource> subStreams = this.getAllSubscribedStreams();
        for (RCRTCInputStream stream : streams) {
            if (subStreams.contains(stream)) continue;
            subStreams.add(stream);
        }
        this.mEngine.mRTCCore.subscribeStreams(this.mLocalUser.getStreamsForInternal(), subStreams, new MediaCommonParams(this.mRoom.getRoomId(), this.mRoom.getClientSessionId(), this.mRoom.getRoomType(), this.mMultiRoomManager.getRoomAttributesElement().getAutoMixJSONInfo(""), this.mLocalUser.getRole(), new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                ReportUtil.libRes(ReportUtil.TAG.SWITCHSTREAMTINYORNORMAL, "code", 0);
                InRoomState.this.sendMessage(3091, streams, callback);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.SWITCHSTREAMTINYORNORMAL, "code|desc", errorCode.getValue(), errorCode.getReason());
                InRoomState.this.sendMessage(3092, new Object[]{tiny, streams, errorCode, callback});
            }
        }));
    }

    private void onSwitchStreamFailed(boolean tiny, List<RCRTCStream> streams) {
        for (RCRTCStream stream : streams) {
            ((RCVideoInputStreamImpl)stream).setStreamType(!tiny ? RCRTCStreamType.TINY : RCRTCStreamType.NORMAL);
        }
    }

    public void exchangeVideoSize(final IRCRTCResultDataCallback callback) {
        ReportUtil.libTask(ReportUtil.TAG.EXCHANGEVIDEOSIZE, "roomId", this.getRoomId());
        this.mEngine.mRTCCore.exchangeVideoSize(this.getAllPubStreams(), this.getAllSubscribedStreams(), new MediaCommonParams(this.mRoom.getRoomId(), this.mRoom.getClientSessionId(), this.mRoom.getRoomType(), this.mMultiRoomManager.getRoomAttributesElement().getAutoMixJSONInfo(""), this.mLocalUser.getRole(), new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                ReportUtil.libRes(ReportUtil.TAG.EXCHANGEVIDEOSIZE, "code", 0);
                InRoomState.this.sendMessage(3051, null, callback);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.EXCHANGEVIDEOSIZE, "code|desc", errorCode.getValue(), errorCode.getReason());
                InRoomState.this.sendMessage(3051, new Object[]{errorCode, callback});
            }
        }));
    }

    private List<IStreamResource> getAllPubStreams() {
        ArrayList<IStreamResource> pubList = new ArrayList<IStreamResource>();
        pubList.addAll(this.mLocalUser.getStreamsForInternal());
        return pubList;
    }

    private List<IStreamResource> getAllSubscribedStreams() {
        List<RCRTCRemoteUser> remoteUsers = this.mRoom.getRemoteUsers();
        ArrayList<IStreamResource> subList = new ArrayList<IStreamResource>();
        for (RCRTCRemoteUser remoteUser : remoteUsers) {
            for (RCRTCInputStream stream : remoteUser.getStreams()) {
                RCInputStreamImpl inputStream = (RCInputStreamImpl)stream;
                if (inputStream.getSubscribeState() != RCRTCSubscribeState.SUBSCRIBED) continue;
                subList.add(inputStream);
            }
        }
        subList.addAll(this.getMultiRoomManager().getBaseRoomElemet().getOtherRoomSubscribedStreams());
        return subList;
    }

    public void joinOtherExchangeRemoteSDP(final IRCRTCResultDataCallback callback) {
        FinLog.d(TAG, "joinOtherExchangeRemoteSDP->start");
        if (!this.mActionQueue.hasPubAction()) {
            this.mEngine.mRTCCore.exchangeRemoteSDP(false, this.mLocalUser.getStreamsForInternal(), this.getAllSubscribedStreams(), new MediaCommonParams<Pair<List<MediaResourceInfo>, JSONObject>>(this.mRoom.getRoomId(), this.mRoom.getClientSessionId(), this.mRoom.getRoomType(), this.mMultiRoomManager.getRoomAttributesElement().getAutoMixJSONInfo(""), this.mLocalUser.getRole(), new IRCRTCResultDataCallback<Pair<List<MediaResourceInfo>, JSONObject>>(){

                @Override
                public void onSuccess(Pair<List<MediaResourceInfo>, JSONObject> data) {
                    FinLog.d(InRoomState.TAG, "joinOtherExchangeRemoteSDP->onSuccess");
                    InRoomState.this.sendMessage(2076, (Object)callback);
                }

                @Override
                public void onFailed(RTCErrorCode errorCode) {
                    FinLog.e(InRoomState.TAG, "joinOtherExchangeRemoteSDP->onFailed :" + errorCode.getValue());
                    InRoomState.this.sendMessage(2077, callback, errorCode.getValue());
                }
            }));
        } else {
            FinLog.e(TAG, "joinOtherExchangeRemoteSDP->onFailed hasPubAction :" + this.mActionQueue.hasPubAction());
            this.sendMessage(2077, new Object[]{callback, RTCErrorCode.RongRTCCodeParameterError});
        }
    }

    public void userLeft() {
        this.mEngine.mRTCCore.exchangeRemoteSDP(false, this.mLocalUser.getStreamsForInternal(), this.getAllSubscribedStreams(), new MediaCommonParams<Pair<List<MediaResourceInfo>, JSONObject>>(this.mRoom.getRoomId(), this.mRoom.getClientSessionId(), this.mRoom.getRoomType(), this.mMultiRoomManager.getRoomAttributesElement().getAutoMixJSONInfo(""), this.mLocalUser.getRole(), new IRCRTCResultDataCallback<Pair<List<MediaResourceInfo>, JSONObject>>(){

            @Override
            public void onSuccess(Pair<List<MediaResourceInfo>, JSONObject> data) {
                FinLog.i(InRoomState.TAG, "exchangeRemoteSDP.onSuccess");
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                FinLog.i(InRoomState.TAG, "exchangeRemoteSDP.onFailed :" + errorCode.getValue());
            }
        }));
    }

    public PubSubActionQueue getPubSubQueue() {
        return this.mActionQueue;
    }

    @Override
    public String getName() {
        return TAG;
    }

    private void joinOtherRoom(final String roomId, final IRCRTCResultDataCallback<RCRTCOtherRoom> callBack) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.putOpt("roomId", (Object)this.mRoom.getRoomId());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        SignalManager.getInstance().joinOtherRoom(roomId, this.mRoom.getRoomType(), "extra", jsonObject.toString(), new IRongCallback.IRTCJoinRoomCallbackEx<Object[]>(){

            public void onSuccess(List<RTCUser> rtcUsers, Object[] exarams) {
                InRoomState.this.sendMessage(2071, new Object[]{roomId, InRoomState.this.mRoom.getRoomType(), rtcUsers, exarams, callBack});
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.JOINOTHERROOM, "otherRoomId|code", roomId, errorCode.getValue());
                RTCErrorCode code = RTCErrorCode.valueOf(errorCode.getValue());
                InRoomState.this.onFailedCallback(code, callBack);
            }
        });
    }

    public void kickFromOtherRooms(String roomId) {
        RCRTCOtherRoom otherRoom = (RCRTCOtherRoom)this.mMultiRoomManager.getBaseRoomElemet().get(roomId);
        ArrayList<RCRTCInputStream> subscribedStreams = new ArrayList<RCRTCInputStream>();
        if (otherRoom != null) {
            if (otherRoom.getRemoteUsers() != null && otherRoom.getRemoteUsers().size() > 0) {
                for (RCRTCRemoteUser remoteUser : otherRoom.getRemoteUsers()) {
                    if (remoteUser.getStreams() == null || remoteUser.getStreams().size() <= 0) continue;
                    for (RCRTCInputStream stream : remoteUser.getStreams()) {
                        RCInputStreamImpl inputStream = (RCInputStreamImpl)stream;
                        if (inputStream.getSubscribeState() != RCRTCSubscribeState.SUBSCRIBED) continue;
                        subscribedStreams.add(stream);
                    }
                }
            }
        } else {
            ReportUtil.libStatus(ReportUtil.TAG.KICKEDFROMSERVER, "otherRoomId|desc", roomId, "RCRTCOtherRoom is empty.");
        }
        final int subscribedStreamSize = subscribedStreams.size();
        ReportUtil.libStatus(ReportUtil.TAG.KICKEDFROMSERVER, "otherRoomId|SubscribedStreamSize", roomId, subscribedStreamSize);
        this.unsubscribeStreams(subscribedStreams, true, roomId, new IRCRTCResultDataCallback(){

            public void onSuccess(Object data) {
                FinLog.d(InRoomState.TAG, "kickFromOtherRooms->unsubscribeStreams->onSuccess.SubscribedStreamSize:" + subscribedStreamSize);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                FinLog.d(InRoomState.TAG, "kickFromOtherRooms->unsubscribeStreams->onFailed :" + errorCode.getValue() + " , SubscribedStreamSize:" + subscribedStreamSize);
            }
        });
    }

    private void leaveOtherRoom(final String roomId, final boolean notifyFinished, final IRCRTCResultCallback callBack) {
        RCRTCOtherRoom otherRoom;
        if (notifyFinished) {
            this.mRoom.removeOtherRoomId(roomId);
        }
        if ((otherRoom = (RCRTCOtherRoom)this.mMultiRoomManager.getBaseRoomElemet().remove(roomId)) == null) {
            ReportUtil.appError(ReportUtil.TAG.LEAVEOTHERROOM, "otherRoomId|notifyFinished|code", roomId, notifyFinished, RTCErrorCode.RongRTCCodeParameterError.getValue());
            this.onFailedCallback(RTCErrorCode.RongRTCCodeParameterError, callBack);
            return;
        }
        ArrayList<RCRTCInputStream> subscribedStreams = new ArrayList<RCRTCInputStream>();
        if (otherRoom.getRemoteUsers() != null && otherRoom.getRemoteUsers().size() > 0) {
            for (RCRTCRemoteUser remoteUser : otherRoom.getRemoteUsers()) {
                if (remoteUser.getStreams() == null || remoteUser.getStreams().size() <= 0) continue;
                for (RCRTCInputStream stream : remoteUser.getStreams()) {
                    RCInputStreamImpl inputStream = (RCInputStreamImpl)stream;
                    if (inputStream.getSubscribeState() != RCRTCSubscribeState.SUBSCRIBED) continue;
                    subscribedStreams.add(stream);
                }
            }
        }
        if (subscribedStreams.size() > 0) {
            this.mActionQueue.offer(9, subscribedStreams, new IRCRTCResultCallback(){

                @Override
                public void onSuccess() {
                    FinLog.d(InRoomState.TAG, "leaveOtherRoom->unSubscribe . onSuccess . roomId :" + roomId + " , notifyFinished :" + notifyFinished);
                    InRoomState.this.sendMessage(2079, (RCOtherRoomImpl)otherRoom, notifyFinished, callBack);
                }

                @Override
                public void onFailed(RTCErrorCode errorCode) {
                    FinLog.d(InRoomState.TAG, "leaveOtherRoom->unSubscribe . onFailed . roomId :" + roomId + " , errorCode :" + errorCode.getValue() + " , notifyFinished :" + notifyFinished);
                    InRoomState.this.sendMessage(2079, (RCOtherRoomImpl)otherRoom, notifyFinished, callBack);
                }
            }, true, true);
        } else {
            FinLog.d(TAG, "leaveOtherRoom");
            this.mEngine.mRTCCore.exchangeRemoteSDP(false, this.mLocalUser.getStreamsForInternal(), this.getAllSubscribedStreams(), new MediaCommonParams<Pair<List<MediaResourceInfo>, JSONObject>>(this.mRoom.getRoomId(), this.mRoom.getClientSessionId(), this.mRoom.getRoomType(), this.mMultiRoomManager.getRoomAttributesElement().getAutoMixJSONInfo(""), this.mLocalUser.getRole(), new IRCRTCResultDataCallback<Pair<List<MediaResourceInfo>, JSONObject>>(){

                @Override
                public void onSuccess(Pair<List<MediaResourceInfo>, JSONObject> data) {
                    FinLog.d(InRoomState.TAG, "leaveOtherRoom->exchangeRemoteSDP->onSuccess");
                    InRoomState.this.sendMessage(2079, (RCOtherRoomImpl)otherRoom, notifyFinished, callBack);
                }

                @Override
                public void onFailed(RTCErrorCode errorCode) {
                    FinLog.e(InRoomState.TAG, "leaveOtherRoom->exchangeRemoteSDP->onFailed :" + errorCode.getValue());
                    InRoomState.this.sendMessage(2079, (RCOtherRoomImpl)otherRoom, notifyFinished, callBack);
                }
            }));
        }
    }

    private void onJoinOtherRoomSuccess(String roomId, RCRTCRoomType roomType, List<RTCUser> userList, Object[] exParams, IRCRTCResultDataCallback<RCRTCOtherRoom> callback) {
        RCLocalUserImpl localUser = new RCLocalUserImpl(this.mEngine.mUserId, null);
        this.mRoom.addOtherRoomId(roomId);
        String sessionId = null;
        LinkedHashMap<String, RCRTCRemoteUser> remoteUsers = new LinkedHashMap<String, RCRTCRemoteUser>();
        if (exParams.length >= 2) {
            sessionId = String.valueOf(exParams[1]);
        }
        if (exParams.length >= 3 && exParams[2] != null) {
            HashMap roomData = (HashMap)exParams[2];
            if (roomData != null && roomData.size() > 0) {
                PKInfo info = null;
                for (Map.Entry entry : roomData.entrySet()) {
                    info = new PKInfo((String)entry.getKey(), (String)entry.getValue());
                    if (TextUtils.equals((CharSequence)info.getInviteeRoomId(), (CharSequence)this.getRoomId()) || TextUtils.equals((CharSequence)info.getInviterRoomId(), (CharSequence)this.getRoomId())) {
                        this.mMultiRoomManager.getRoomAttributesElement().put(info);
                        continue;
                    }
                    FinLog.w(TAG, "Not part of the PK list. key :" + (String)entry.getKey());
                }
            }
        } else {
            FinLog.w(TAG, "KV not found.");
        }
        if (!RongRTCUtils.isEmpty(userList)) {
            FinLog.d(TAG, "RTCUser size : " + userList.size());
            String extra = null;
            for (RTCUser user : userList) {
                String id = user.getUid();
                FinLog.d(TAG, "uid = " + id);
                if (localUser.getUserId().equals(id)) continue;
                HashMap data = user.getData();
                String uris = null;
                if (data != null) {
                    uris = (String)data.get("uris");
                    extra = (String)data.get("extra");
                    String otherRoomId = RongRTCUtils.getUserProfile(extra);
                    if (!TextUtils.isEmpty((CharSequence)otherRoomId)) continue;
                }
                FinLog.d(TAG, "joinOtherRoom . uris = " + uris + " , extra :" + extra);
                RCRemoteUserImpl remoteUser = RCRemoteUserImpl.parseRemoteUsers(id, uris);
                remoteUsers.put(id, remoteUser);
            }
        }
        FinLog.d(TAG, "JoinOtherRoomSuccess->roomId : " + roomId + " , sessionId :" + sessionId);
        RCOtherRoomImpl otherRoom = new RCOtherRoomImpl(roomId, roomType, remoteUsers, sessionId, this.mEngine.mCallbackHandler);
        this.mMultiRoomManager.getBaseRoomElemet().put(roomId, otherRoom);
        ReportUtil.appRes(ReportUtil.TAG.JOINOTHERROOM, "otherRoomId", roomId);
        this.onSuccessCallback(otherRoom, callback);
        this.mActionQueue.offer(8, null, null);
    }

    private void sendleaveOtherRoomMessage(RCOtherRoomImpl rcOtherRoom, final boolean notifyFinished, final IRCRTCResultCallback callBack) {
        final String roomId = rcOtherRoom.getRoomId();
        rcOtherRoom.release();
        SignalManager.getInstance().sendleaveOtherRoomMessage(roomId, new IRCRTCResultCallback(){

            @Override
            public void onSuccess() {
                ReportUtil.appRes(ReportUtil.TAG.LEAVEOTHERROOM, "otherRoomId|notifyFinished", roomId, notifyFinished);
                if (notifyFinished) {
                    InRoomState.this.sendFinishOtherRoomMessage(roomId, callBack);
                } else {
                    InRoomState.this.onSuccessCallback(callBack);
                }
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.LEAVEOTHERROOM, "otherRoomId|notifyFinished|code", roomId, notifyFinished, errorCode.getValue());
                if (notifyFinished) {
                    InRoomState.this.sendFinishOtherRoomMessage(roomId, callBack);
                } else {
                    InRoomState.this.onFailedCallback(errorCode, callBack);
                }
            }
        });
    }

    public MultiRoomManager getMultiRoomManager() {
        return this.mMultiRoomManager;
    }

    public void setMultiRoomManager(MultiRoomManager manager) {
        this.mMultiRoomManager = manager;
    }
}

