/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine;

import android.os.Message;
import android.text.TextUtils;
import cn.rongcloud.rtc.api.RCRTCRemoteUser;
import cn.rongcloud.rtc.api.RCRTCRoom;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.api.callback.RCRTCLiveCallback;
import cn.rongcloud.rtc.base.RCAttributeType;
import cn.rongcloud.rtc.base.RCRTCAVStreamType;
import cn.rongcloud.rtc.base.RCRTCRoomType;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.RCLocalUserImpl;
import cn.rongcloud.rtc.center.RCRemoteUserImpl;
import cn.rongcloud.rtc.center.RCRoomImpl;
import cn.rongcloud.rtc.center.stream.RCOutputStreamImpl;
import cn.rongcloud.rtc.engine.AbstractBaseState;
import cn.rongcloud.rtc.engine.MsgObjectWraper;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.engine.tools.MultiRoomManager;
import cn.rongcloud.rtc.module.RTCPingManager;
import cn.rongcloud.rtc.proxy.message.UnPublishResourceMessage;
import cn.rongcloud.rtc.proxy.message.messagebeans.MediaResourceInfo;
import cn.rongcloud.rtc.proxy.message.messagebeans.PKInfo;
import cn.rongcloud.rtc.signal.SignalManager;
import cn.rongcloud.rtc.stat.RongRtcStatMagr;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import cn.rongcloud.rtc.webrtc.RTCConnectionEvents;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.RTCUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class IdleState
extends AbstractBaseState {
    private static final String TAG = "IdleState";
    private boolean executeIng;
    private boolean connection_Initialized;
    private Queue<Message> deferSubLiveMessages = new LinkedList<Message>();

    public IdleState(RTCEngineImpl engine) {
        super(engine);
    }

    @Override
    public void enter() {
        super.enter();
        this.executeIng = false;
        this.connection_Initialized = false;
    }

    @Override
    protected boolean handleMessage(Message msg, MsgObjectWraper obj) {
        switch (msg.what) {
            case 2000: {
                this.joinRoom((String)obj.getData(0), (RCRTCRoomType)((Object)obj.getData(1)), (IRCRTCResultDataCallback)obj.getData(2));
                break;
            }
            case 2001: {
                this.onJoinRoomSuccess((String)obj.getData(0), (RCRTCRoomType)((Object)obj.getData(1)), (List)obj.getData(2), (Object[])obj.getData(3), (IRCRTCResultDataCallback)obj.getData(4));
                break;
            }
            case 5000: {
                if (this.executeIng) {
                    Message message = this.mEngine.obtainMessage();
                    message.copyFrom(msg);
                    this.deferSubLiveMessages.add(message);
                    break;
                }
                this.subscribeLive((String)obj.getData(0), (RCRTCAVStreamType)((Object)obj.getData(1)), (RCRTCLiveCallback)obj.getData(2));
                break;
            }
            case 5002: {
                this.onSubscribeLiveFailed();
                break;
            }
            case 5001: {
                this.onSubscribeLiveSuccess((String)obj.getData(0), (RCRTCAVStreamType)((Object)obj.getData(1)), (RCRTCLiveCallback)obj.getData(2));
                break;
            }
            case 2010: 
            case 2060: 
            case 7000: {
                this.mEngine.deferMessage(msg);
                break;
            }
            case 10000: {
                this.unInit(msg);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void subscribeLive(final String liveUrl, final RCRTCAVStreamType avStreamType, final RCRTCLiveCallback callBack) {
        ReportUtil.libTask(ReportUtil.TAG.ENGINESUBSCRIBELIVESTREAM, "liveUrl|mediaType|simulcast", liveUrl, avStreamType.getMediaType(), avStreamType.getSimulcast());
        this.executeIng = true;
        if (TextUtils.isEmpty((CharSequence)liveUrl)) {
            ReportUtil.libError(ReportUtil.TAG.ENGINESUBSCRIBELIVESTREAM, 2, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), "liveUrl is null !");
            this.onFailedCallback(RTCErrorCode.RongRTCCodeParameterError, callBack);
            return;
        }
        if (!this.connection_Initialized) {
            this.initPeerConnection();
        }
        this.mEngine.mRTCCore.subscribeLiveStream(liveUrl, avStreamType, new IRCRTCResultCallback(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.libError(ReportUtil.TAG.ENGINESUBSCRIBELIVESTREAM, "code|desc", errorCode.getValue(), errorCode.getReason());
                IdleState.this.sendMessage(5002, new Object[0]);
                IdleState.this.onFailedCallback(errorCode, callBack);
            }

            @Override
            public void onSuccess() {
                ReportUtil.libRes(ReportUtil.TAG.ENGINESUBSCRIBELIVESTREAM, "code", 0);
                IdleState.this.sendMessage(5001, new Object[]{liveUrl, avStreamType, callBack});
            }
        });
    }

    private void onSubscribeLiveSuccess(String liveUrl, RCRTCAVStreamType avStreamType, final RCRTCLiveCallback callback) {
        this.mEngine.mObserverState.setLiveParams(avStreamType, liveUrl, callback);
        if (callback == null) {
            return;
        }
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                callback.onSuccess();
            }
        });
        while (!this.deferSubLiveMessages.isEmpty()) {
            this.mEngine.deferMessage(this.deferSubLiveMessages.poll());
        }
        this.transitionTo(this.mEngine.mObserverState);
    }

    private void onSubscribeLiveFailed() {
        if (this.deferSubLiveMessages.isEmpty()) {
            this.transitionTo(this.mEngine.mDisConnectingState);
        } else {
            Message msg = this.deferSubLiveMessages.poll();
            MsgObjectWraper obj = new MsgObjectWraper(msg.obj);
            this.subscribeLive((String)obj.getData(0), (RCRTCAVStreamType)((Object)obj.getData(1)), (RCRTCLiveCallback)obj.getData(2));
        }
    }

    private void initPeerConnection() {
        this.mEngine.mRTCCore.initPeerConnection(this.mEngine.mUserId, SignalManager.getInstance().getMaxStreamCount(), new RTCConnectionEvents());
        this.connection_Initialized = true;
    }

    private void joinRoom(final String roomId, final RCRTCRoomType roomType, final IRCRTCResultDataCallback<RCRTCRoom> callBack) {
        ReportUtil.libTask(ReportUtil.TAG.JOINROOM, "roomId|uid|roomType|liveType", roomId, this.mEngine.getUserId(), roomType.getRoomType(), roomType.getMediaType());
        if (this.executeIng) {
            ReportUtil.libErrorW(ReportUtil.TAG.JOINROOM, RTCErrorCode.RongRTCCodeJoinRepeatedRoom, "roomId", roomId);
            this.onFailedCallback(RTCErrorCode.RongRTCCodeJoinRepeatedRoom, callBack);
            return;
        }
        this.executeIng = true;
        this.reportLog();
        SignalManager.getInstance().joinRoom(roomId, roomType, false, new IRongCallback.IRTCJoinRoomCallbackEx<Object[]>(){

            public void onSuccess(List<RTCUser> rtcUsers, Object[] exarams) {
                ReportUtil.libRes(ReportUtil.TAG.JOINROOM, roomId);
                IdleState.this.sendMessage(2001, new Object[]{roomId, roomType, rtcUsers, exarams, callBack});
            }

            public void onError(RongIMClient.ErrorCode errorCode) {
                RTCErrorCode code = RTCErrorCode.valueOf(errorCode.getValue());
                ReportUtil.libErrorW(ReportUtil.TAG.JOINROOM, code, "roomId", roomId);
                IdleState.this.onFailedCallback(code, callBack);
            }
        });
    }

    private void onJoinRoomSuccess(String roomId, RCRTCRoomType roomType, List<RTCUser> list, Object[] exParams, IRCRTCResultDataCallback<RCRTCRoom> callback) {
        this.handleRoomInfo(roomId, roomType, list, exParams);
        SignalManager.getInstance().setRtcToken(this.mEngine.mRoom.getRtcToken());
        this.initPeerConnection();
        RongRtcStatMagr.instance.setRoomId(roomId);
        this.transitionTo(this.mEngine.mInRoomState);
        this.onSuccessCallback(this.mEngine.mRoom, callback);
    }

    private void handleRoomInfo(String roomId, RCRTCRoomType roomType, List<RTCUser> list, Object[] exParams) {
        RCRoomImpl rcRoom;
        this.mEngine.mRoom = rcRoom = this.createRCRoom(roomId, roomType, list, exParams);
        SignalManager.getInstance().setRtcToken(rcRoom.getRtcToken());
    }

    private RCRoomImpl createRCRoom(String roomId, RCRTCRoomType roomType, List<RTCUser> list, Object[] exParams) {
        RCLocalUserImpl localUser = new RCLocalUserImpl(this.mEngine.mUserId, null);
        String sessionId = null;
        String rtcToken = null;
        LinkedHashMap<String, RCRTCRemoteUser> remoteUsers = new LinkedHashMap<String, RCRTCRemoteUser>();
        List<RCOutputStreamImpl> oldStreams = null;
        if (exParams.length >= 1) {
            rtcToken = String.valueOf(exParams[0]);
        }
        if (exParams.length >= 2) {
            sessionId = String.valueOf(exParams[1]);
        }
        HashMap roomData = null;
        if (exParams.length >= 3 && exParams[2] != null) {
            roomData = (HashMap)exParams[2];
        }
        ArrayList<String> otherRoomIdList = null;
        if (!RongRTCUtils.isEmpty(list)) {
            FinLog.d(TAG, "RTCUser size : " + list.size());
            String extra = null;
            String sourceRoomId = null;
            for (RTCUser user : list) {
                String id = user.getUid();
                FinLog.v(TAG, "uid = " + id);
                HashMap data = user.getData();
                String uris = null;
                if (data != null) {
                    uris = (String)data.get("uris");
                    extra = (String)data.get("extra");
                    sourceRoomId = RongRTCUtils.getUserProfile(extra);
                    if (!TextUtils.isEmpty((CharSequence)sourceRoomId)) {
                        if (otherRoomIdList == null) {
                            otherRoomIdList = new ArrayList<String>();
                        }
                        otherRoomIdList.add(sourceRoomId);
                        continue;
                    }
                }
                FinLog.v(TAG, "uris = " + uris + " , extra : " + extra);
                if (localUser.getUserId().equals(id)) {
                    oldStreams = RCOutputStreamImpl.parseOutputStreams(id, uris);
                    continue;
                }
                RCRemoteUserImpl rcRemoteUser = RCRemoteUserImpl.parseRemoteUsers(id, uris);
                remoteUsers.put(id, rcRemoteUser);
            }
        }
        this.sendUnpublishedCmd(oldStreams, roomId);
        RTCPingManager rtcPingManager = new RTCPingManager(roomId, this.mEngine.mContext, this.mEngine.mConfig.isAutoReconnect());
        FinLog.d(TAG, "JoinMainRoomSuccess->roomId : " + roomId + " , sessionId :" + sessionId);
        RCRoomImpl impl = new RCRoomImpl(roomId, roomType, localUser, remoteUsers, sessionId, rtcToken, rtcPingManager, this.mEngine.mCallbackHandler, otherRoomIdList);
        MultiRoomManager multiRoomManager = new MultiRoomManager(impl, rtcPingManager);
        if (roomData != null && roomData.size() > 0) {
            PKInfo info = null;
            for (Map.Entry entry : roomData.entrySet()) {
                info = new PKInfo((String)entry.getKey(), (String)entry.getValue());
                if (TextUtils.equals((CharSequence)info.getInviteeRoomId(), (CharSequence)roomId) || TextUtils.equals((CharSequence)info.getInviterRoomId(), (CharSequence)roomId)) {
                    multiRoomManager.getRoomAttributesElement().put(info);
                    continue;
                }
                FinLog.w(TAG, "Not part of the PK list. key :" + (String)entry.getKey());
            }
        } else {
            FinLog.w(TAG, "KV not found.");
        }
        this.mEngine.mInRoomState.setMultiRoomManager(multiRoomManager);
        return impl;
    }

    private void sendUnpublishedCmd(List<RCOutputStreamImpl> oldStreams, String roomId) {
        if (RongRTCUtils.isEmpty(oldStreams)) {
            return;
        }
        ArrayList<MediaResourceInfo> unPublishResourceList = new ArrayList<MediaResourceInfo>();
        for (RCOutputStreamImpl localStream : oldStreams) {
            unPublishResourceList.add(new MediaResourceInfo(localStream));
        }
        SignalManager.getInstance().rtcPutInnerData(roomId, RCAttributeType.USER, "uris", "[]", new UnPublishResourceMessage(unPublishResourceList), null);
    }

    private void reportLog() {
        ReportUtil.libStatus(ReportUtil.TAG.RTCCONFIG, "config", this.mEngine.mConfig.formatLogString());
    }

    private void unInit(Message msg) {
        this.mEngine.clearDeferredMessage();
        this.mEngine.deferMessage(msg);
        this.transitionTo(this.mEngine.mDisConnectingState);
    }

    @Override
    public void exit() {
        super.exit();
        this.executeIng = false;
    }

    @Override
    public String getName() {
        return TAG;
    }
}

