/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.engine;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.os.Message;
import cn.rongcloud.rtc.RongRTCMessageRouter;
import cn.rongcloud.rtc.center.stream.RCCameraOutputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCMicOutputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCStreamImpl;
import cn.rongcloud.rtc.core.EglBase;
import cn.rongcloud.rtc.core.audio.AudioMixer;
import cn.rongcloud.rtc.engine.AbstractBaseState;
import cn.rongcloud.rtc.engine.MsgObjectWraper;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.engine.UnInitState;
import cn.rongcloud.rtc.monitor.NetworkConnectChangedReceiver;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.webrtc.IWebRTCCore;
import io.rong.imlib.ModuleManager;

public class DisconnectingState
extends AbstractBaseState {
    private static final String TAG = "DisconnectingState";

    public DisconnectingState(RTCEngineImpl engine) {
        super(engine);
    }

    @Override
    public void enter() {
        super.enter();
        this.closePeerConnection();
    }

    private void closePeerConnection() {
        IWebRTCCore rtcCore = this.mEngine.mRTCCore;
        if (rtcCore != null) {
            rtcCore.closePeerConnection();
        }
    }

    @Override
    protected boolean handleMessage(Message msg, MsgObjectWraper obj) {
        switch (msg.what) {
            case 1010: {
                this.mEngine.deferMessage(msg);
                break;
            }
            case 10000: {
                this.unInit();
                this.mEngine.transitionTo(this.mEngine.mUnInitState);
                break;
            }
            default: {
                this.mEngine.deferMessage(msg);
                this.mEngine.transitionTo(this.mEngine.mIdleState);
            }
        }
        return true;
    }

    private void unInit() {
        EglBase eglBase;
        IWebRTCCore rtcCore;
        RCMicOutputStreamImpl defaultAudioStream;
        FinLog.d(TAG, "unInit --> enter");
        UnInitState uninitState = this.mEngine.mUnInitState;
        uninitState.mCallInited = false;
        RongRTCMessageRouter messageRouter = uninitState.mMessageRouter;
        if (messageRouter != null) {
            ModuleManager.removeMessageRouter((ModuleManager.MessageRouter)messageRouter);
            uninitState.mMessageRouter = null;
        }
        NetworkConnectChangedReceiver networkConnectChangedReceiver = uninitState.networkConnectChangedReceiver;
        Context context = this.mEngine.mContext;
        if (context != null && networkConnectChangedReceiver != null) {
            try {
                context.unregisterReceiver((BroadcastReceiver)networkConnectChangedReceiver);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            uninitState.networkConnectChangedReceiver = null;
        }
        if ((defaultAudioStream = this.mEngine.mDefaultAudioStream) != null) {
            defaultAudioStream.release();
            this.mEngine.mDefaultAudioStream = null;
        }
        AudioMixer.getInstance().setDefaultAudioStream(null);
        RCCameraOutputStreamImpl defaultVideoStream = this.mEngine.mDefaultVideoStream;
        if (defaultVideoStream != null) {
            ((RCStreamImpl)defaultVideoStream).release();
            this.mEngine.mDefaultVideoStream = null;
        }
        if ((rtcCore = this.mEngine.mRTCCore) != null) {
            rtcCore.release();
            this.mEngine.mRTCCore = null;
        }
        if ((eglBase = this.mEngine.mEglBase) != null) {
            eglBase.detachCurrent();
            eglBase.release();
            this.mEngine.mEglBase = null;
            this.mEngine.mEglContext = null;
        }
        this.mEngine.mContext = null;
        FinLog.d(TAG, "unInit --> over");
    }

    @Override
    public String getName() {
        return TAG;
    }
}

