/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.earmonitor;

import android.content.Context;
import android.media.AudioManager;
import android.support.annotation.NonNull;
import android.util.Log;
import cn.rongcloud.rtc.earmonitor.EarMonitor;
import cn.rongcloud.rtc.earmonitor.SilentPlayer;
import com.huawei.multimedia.audiokit.interfaces.HwAudioKaraokeFeatureKit;
import com.huawei.multimedia.audiokit.interfaces.HwAudioKit;
import com.huawei.multimedia.audiokit.interfaces.IAudioKitCallback;

public class HuaweiEarMonitor
implements EarMonitor {
    private static final String TAG = "HWEarMonitor";
    private HwAudioKit audioKit;
    private HwAudioKaraokeFeatureKit feature;
    private SilentPlayer silentPlayer;
    private Context context;
    private boolean enabled = false;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public synchronized void init(Context context) {
        if (this.audioKit != null) {
            Log.d((String)TAG, (String)"Already initialized.");
            return;
        }
        this.context = context;
        this.silentPlayer = new SilentPlayer();
        this.audioKit = new HwAudioKit(context, new IAudioKitCallback(){

            public void onResult(int code) {
                if (code == 0) {
                    Log.d((String)HuaweiEarMonitor.TAG, (String)"init: AUDIO_KIT_SUCCESS");
                    HuaweiEarMonitor.this.feature = (HwAudioKaraokeFeatureKit)HuaweiEarMonitor.this.audioKit.createFeature(HwAudioKit.FeatureType.HWAUDIO_FEATURE_KARAOKE);
                } else if (code == 1000) {
                    HuaweiEarMonitor.this.feature.setParameter(HwAudioKaraokeFeatureKit.ParameName.CMD_SET_VOCAL_VOLUME_BASE, 100);
                    Log.d((String)HuaweiEarMonitor.TAG, (String)"init: KARAOKE_SUCCESS");
                } else {
                    Log.d((String)HuaweiEarMonitor.TAG, (String)("init: FAILED " + code));
                }
            }
        });
        this.audioKit.initialize();
    }

    @Override
    public int enable() {
        if (this.feature == null || this.enabled) {
            Log.e((String)TAG, (String)"enable: feature is null.");
            return -1;
        }
        if (!this.feature.isKaraokeFeatureSupport()) {
            Log.e((String)TAG, (String)"enable: not support.");
            return -1;
        }
        AudioManager am = (AudioManager)this.context.getSystemService("audio");
        am.setMode(0);
        if (this.feature.enableKaraokeFeature(true) != 0) {
            Log.e((String)TAG, (String)"enable: failed.");
            return -1;
        }
        this.enabled = true;
        this.silentPlayer.play();
        return 0;
    }

    @Override
    public void disable() {
        if (this.enabled) {
            this.enabled = false;
            this.silentPlayer.stop();
            if (this.feature != null) {
                this.feature.enableKaraokeFeature(false);
                this.silentPlayer.stop();
            }
        }
    }

    @Override
    public boolean isSupported() {
        return this.feature != null && this.feature.isKaraokeFeatureSupport();
    }

    @Override
    public synchronized void destroy() {
        this.disable();
        if (this.feature != null) {
            this.feature.destroy();
            this.feature = null;
        }
        if (this.audioKit != null) {
            this.audioKit.destroy();
            this.audioKit = null;
        }
        this.silentPlayer = null;
    }

    @Override
    public void adjustVolume(int volume) {
        if (this.feature != null) {
            this.feature.setParameter(HwAudioKaraokeFeatureKit.ParameName.CMD_SET_VOCAL_VOLUME_BASE, volume);
        }
    }

    @NonNull
    public String toString() {
        return "HuaweiEarMonitor";
    }
}

