/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.earmonitor;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import cn.rongcloud.rtc.earmonitor.DefaultEarMonitor;
import cn.rongcloud.rtc.earmonitor.EarMonitor;
import cn.rongcloud.rtc.earmonitor.HuaweiEarMonitor;
import cn.rongcloud.rtc.earmonitor.VivoEarMonitor;
import cn.rongcloud.rtc.module.AudioDeviceManager;
import cn.rongcloud.rtc.utils.ReportUtil;

public class EarMonitorManager {
    private static final String TAG = "EarMonitorManager";
    private EarMonitor earMonitor;
    private AudioDeviceManager mAudioDeviceManager;

    public void init(Context context, AudioDeviceManager audioDeviceManager) {
        this.mAudioDeviceManager = audioDeviceManager;
        EarMonitor em = this.findEarMonitor(audioDeviceManager);
        em.init(context);
        this.earMonitor = em;
    }

    private EarMonitor findEarMonitor(AudioDeviceManager audioDeviceManager) {
        EarMonitor em = null;
        String manufacturer = Build.MANUFACTURER.trim();
        Log.d((String)TAG, (String)("findEarMonitor: manufacturer=" + manufacturer));
        if (manufacturer.contains("vivo")) {
            em = new VivoEarMonitor();
        } else if (manufacturer.contains("HUAWEI") && this.checkHwAudioKitExist()) {
            em = new HuaweiEarMonitor();
        }
        if (em == null) {
            this.earMonitor = em = new DefaultEarMonitor(audioDeviceManager);
        }
        Log.d((String)TAG, (String)("findEarMonitor: " + em.getClass().getCanonicalName()));
        return em;
    }

    public void release() {
        EarMonitor em = this.earMonitor;
        this.earMonitor = null;
        if (em != null) {
            em.destroy();
        } else {
            Log.e((String)TAG, (String)"destroyEarMonitor: already destroyed.");
        }
    }

    public void enable(boolean enable) {
        ReportUtil.appTask(ReportUtil.TAG.ENABLE_EAR_MONITOR, "enable", enable);
        EarMonitor em = this.earMonitor;
        if (em == null) {
            ReportUtil.appError(ReportUtil.TAG.ENABLE_EAR_MONITOR, "msg", "earMonitor is null.");
            return;
        }
        if (enable) {
            if (!em.isSupported()) {
                em.destroy();
                ReportUtil.appStatus(ReportUtil.TAG.ENABLE_EAR_MONITOR, "msg", em + " change to default.");
                this.earMonitor = em = new DefaultEarMonitor(this.mAudioDeviceManager);
            }
            if (em.enable() != 0) {
                ReportUtil.appError(ReportUtil.TAG.ENABLE_EAR_MONITOR, "msg", "EarMonitor.enable() returned false.");
            }
        } else {
            em.disable();
        }
    }

    private boolean checkHwAudioKitExist() {
        try {
            Class.forName("com.huawei.multimedia.audiokit.interfaces.HwAudioKit");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

