/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.custom;

import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import cn.rongcloud.rtc.custom.MediaDecoder;
import cn.rongcloud.rtc.custom.OnPcmAvailableListener;
import cn.rongcloud.rtc.utils.FinLog;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MediaAudioDecoder
extends MediaDecoder {
    private static final String TAG = "MediaAudioDecoder";
    private static final String KEY_PCM_ENCODING = "pcm-encoding";
    private static final int STATE_UNINITIALIZED = 1;
    private static final int STATE_INITIALIZED = 2;
    private static final int STATE_RUNNING = 3;
    private static final int STATE_STOPPED = 4;
    private static final int DEQUEUE_WAIT_TIME_US = 10000;
    private MediaExtractor mAudioExtractor = null;
    private MediaCodec mAudioCodec = null;
    private MediaFormat mAudioFormat = null;
    private OnPcmAvailableListener mOnPcmAvailableListener;
    private HandlerThread decoderThread = new HandlerThread("AudioDecoder");
    private Handler decoderHandler;
    private int mState = 1;
    private int repeatCount = 1;
    private boolean seeking = false;
    private long seekTimeUs = 0L;
    private long firstFramePresentationTimeUs = 0L;
    private ByteBuffer inputBuffer;
    private ByteBuffer outputBuffer;

    @Override
    public boolean init(FileDescriptor fd, long offset, long len) {
        this.decoderThread.start();
        this.decoderHandler = new Handler(this.decoderThread.getLooper());
        try {
            this.mAudioExtractor = new MediaExtractor();
            this.mAudioExtractor.setDataSource(fd, offset, len);
            int trackIndex = this.selectAudioTrack(this.mAudioExtractor);
            if (trackIndex < 0) {
                FinLog.d(TAG, "Audio track not found, index=" + trackIndex);
                this.mAudioExtractor.release();
                return false;
            }
            this.mAudioExtractor.seekTo(0L, 2);
            this.firstFramePresentationTimeUs = this.mAudioExtractor.getSampleTime();
            this.mAudioFormat = this.mAudioExtractor.getTrackFormat(trackIndex);
            String mimeType = this.mAudioFormat.getString("mime");
            this.mAudioCodec = MediaCodec.createDecoderByType((String)mimeType);
            this.mAudioCodec.configure(this.mAudioFormat, null, null, 0);
        }
        catch (IOException e) {
            FinLog.d(TAG, "Init failed: " + e.getMessage());
            if (this.mAudioExtractor != null) {
                this.mAudioExtractor.release();
            }
            if (this.mAudioCodec != null) {
                this.mAudioCodec.release();
            }
            this.decoderThread.quit();
            return false;
        }
        this.mState = 2;
        return true;
    }

    public int getChannelCount() {
        if (this.mAudioFormat == null) {
            return -1;
        }
        return this.mAudioFormat.getInteger("channel-count");
    }

    public int getSampleRate() {
        if (this.mAudioFormat == null) {
            return -1;
        }
        return this.mAudioFormat.getInteger("sample-rate");
    }

    public MediaFormat getMediaFormat() {
        return this.mAudioFormat;
    }

    public int getAudioFormat() {
        if (this.mAudioFormat == null) {
            return -1;
        }
        int audioFormat = 2;
        if (this.mAudioFormat.containsKey(KEY_PCM_ENCODING)) {
            audioFormat = this.mAudioFormat.getInteger(KEY_PCM_ENCODING);
        }
        return audioFormat;
    }

    public long getDurationUs() {
        if (this.mAudioFormat == null) {
            return -1L;
        }
        long duration = 0L;
        if (this.mAudioFormat.containsKey("durationUs")) {
            duration = this.mAudioFormat.getLong("durationUs");
        }
        return duration;
    }

    public void seekTo(long timeUs) {
        if (this.mState != 3) {
            throw new IllegalStateException("seekTo() called on state " + this.mState);
        }
        this.seekTimeUs = this.firstFramePresentationTimeUs + timeUs;
        this.seeking = true;
    }

    public void setRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
    }

    @Override
    public void start() {
        this.start(0L);
    }

    public void start(final long presentationTimeUs) {
        if (this.mState != 2) {
            throw new IllegalStateException("start() called on uninitialized MediaAudioDecoder.");
        }
        this.decoderHandler.post(new Runnable(){

            @Override
            public void run() {
                MediaAudioDecoder.this.mAudioExtractor.seekTo(presentationTimeUs, 2);
                MediaAudioDecoder.this.mAudioCodec.start();
                MediaAudioDecoder.this.processInputOutput();
            }
        });
        this.mState = 3;
    }

    @Override
    public void stop() {
        if (this.mState != 3) {
            FinLog.e(TAG, "stop() called on state " + this.mState);
        }
        this.mState = 4;
    }

    public void setPcmAvailableListener(OnPcmAvailableListener listener) {
        this.mOnPcmAvailableListener = listener;
    }

    private ByteBuffer getInputBuffer(MediaCodec codec, int index) {
        if (Build.VERSION.SDK_INT >= 21) {
            return codec.getInputBuffer(index);
        }
        return codec.getInputBuffers()[index];
    }

    private ByteBuffer getOutputBuffer(MediaCodec codec, int index) {
        if (Build.VERSION.SDK_INT >= 21) {
            return codec.getOutputBuffer(index);
        }
        return codec.getOutputBuffers()[index];
    }

    private void processInputOutput() {
        new Thread("ProcessInputOutput"){

            @Override
            public void run() {
                while (MediaAudioDecoder.this.mState == 3) {
                    MediaAudioDecoder.this.feedInputBuffer();
                    MediaAudioDecoder.this.drainOutputBuffer();
                }
                MediaAudioDecoder.this.stopInternal();
            }
        }.start();
    }

    private void seekToInternal() {
        this.mAudioCodec.flush();
        this.mAudioExtractor.seekTo(this.seekTimeUs, 2);
    }

    private void onInputBufferAvailable(MediaCodec codec, int index) {
        if (this.seeking) {
            this.seekToInternal();
            this.seeking = false;
        }
        try {
            this.inputBuffer = this.getInputBuffer(codec, index);
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"MediaCodec.flush() may be called.");
            return;
        }
        this.inputBuffer.clear();
        int readSize = this.mAudioExtractor.readSampleData(this.inputBuffer, 0);
        if (readSize < 0) {
            if (this.repeatCount > 0) {
                --this.repeatCount;
            }
            if (this.repeatCount == -1 || this.repeatCount > 0) {
                this.seekTo(0L);
                this.onInputBufferAvailable(codec, index);
                return;
            }
        }
        if (readSize >= 0) {
            codec.queueInputBuffer(index, 0, readSize, this.mAudioExtractor.getSampleTime() - this.firstFramePresentationTimeUs, this.mAudioExtractor.getSampleFlags());
            this.mAudioExtractor.advance();
        } else {
            codec.queueInputBuffer(index, 0, 0, 0L, 4);
        }
    }

    private void onOutputBufferAvailable(MediaCodec codec, int index, MediaCodec.BufferInfo bufferInfo) {
        if (this.seeking) {
            return;
        }
        try {
            this.outputBuffer = this.getOutputBuffer(codec, index);
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"MediaCodec.flush() may be called.");
            return;
        }
        byte[] bytes = new byte[bufferInfo.size];
        this.outputBuffer.position(bufferInfo.offset);
        this.outputBuffer.limit(bufferInfo.offset + bufferInfo.size);
        this.outputBuffer.get(bytes);
        if ((bufferInfo.flags & 4) != 0) {
            if (this.mOnPcmAvailableListener != null) {
                FinLog.e(TAG, "T-onOutputBufferAvailable: onPcmEnd");
                this.mOnPcmAvailableListener.onPcmEnd();
            }
            return;
        }
        if (this.mOnPcmAvailableListener != null) {
            this.mOnPcmAvailableListener.onPcm(bytes, bufferInfo.presentationTimeUs);
        }
        codec.releaseOutputBuffer(index, false);
    }

    private void onOutputFormatChanged(MediaCodec codec, MediaFormat mediaFormat) {
        this.mAudioFormat = mediaFormat;
    }

    private boolean feedInputBuffer() {
        int inputBufferIndex = this.mAudioCodec.dequeueInputBuffer(10000L);
        if (inputBufferIndex < 0) {
            return false;
        }
        this.onInputBufferAvailable(this.mAudioCodec, inputBufferIndex);
        return true;
    }

    private boolean drainOutputBuffer() {
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        int outputBufferIndex = this.mAudioCodec.dequeueOutputBuffer(bufferInfo, 10000L);
        if (outputBufferIndex == -2) {
            this.onOutputFormatChanged(this.mAudioCodec, this.mAudioCodec.getOutputFormat());
            return true;
        }
        if (outputBufferIndex < 0) {
            return false;
        }
        this.onOutputBufferAvailable(this.mAudioCodec, outputBufferIndex, bufferInfo);
        return true;
    }

    private void stopInternal() {
        this.mAudioCodec.stop();
        this.mAudioCodec.release();
        this.mAudioExtractor.release();
        this.mAudioExtractor = null;
        this.mOnPcmAvailableListener = null;
        this.decoderHandler.getLooper().quit();
        this.decoderHandler = null;
    }

    private int selectAudioTrack(MediaExtractor extractor) {
        int trackCount = extractor.getTrackCount();
        Log.i((String)TAG, (String)("selectAudioTrack: " + trackCount));
        for (int i = 0; i < trackCount; ++i) {
            MediaFormat trackFormat = extractor.getTrackFormat(i);
            String mimeType = trackFormat.getString("mime");
            if (!mimeType.contains("audio/")) continue;
            extractor.selectTrack(i);
            return i;
        }
        return -1;
    }
}

