/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.crypto;

import cn.rongcloud.rtc.core.RtpSender;
import cn.rongcloud.rtc.crypto.CustomAudioFrameEncryptor;
import cn.rongcloud.rtc.crypto.CustomVideoFrameEncryptor;
import cn.rongcloud.rtc.utils.FinLog;
import java.util.HashMap;
import java.util.Map;

public class CustomFrameEncryptorFactory
implements RtpSender.DisposeObserver {
    private static final String TAG = CustomFrameEncryptorFactory.class.getSimpleName();
    private Map<String, CustomAudioFrameEncryptor> audioSendMap = new HashMap<String, CustomAudioFrameEncryptor>();
    private Map<String, CustomVideoFrameEncryptor> videoSendMap = new HashMap<String, CustomVideoFrameEncryptor>();

    @Override
    public void onDispose(RtpSender sender) {
        FinLog.i(TAG, "custom_crypto dispose frameEncryptor " + sender.id());
        this.release(sender);
    }

    public static CustomFrameEncryptorFactory getInstance() {
        return SingleHolder.instance;
    }

    public CustomVideoFrameEncryptor createCustomVideoFrameEncryptor(String trackKind, String trackId) {
        Map<String, CustomVideoFrameEncryptor> videoMap = this.videoSendMap;
        if (trackKind.equals("video")) {
            if (videoMap.get(trackId) == null) {
                CustomVideoFrameEncryptor customVideoFrameEncryptor = CustomVideoFrameEncryptor.create();
                videoMap.put(trackId, customVideoFrameEncryptor);
                return customVideoFrameEncryptor;
            }
            return videoMap.get(trackId);
        }
        return null;
    }

    public CustomAudioFrameEncryptor createCustomAudioFrameEncryptor(String trackKind, String trackId) {
        Map<String, CustomAudioFrameEncryptor> audioMap = this.audioSendMap;
        if (trackKind.equals("audio")) {
            if (audioMap.get(trackId) == null) {
                CustomAudioFrameEncryptor customAudioFrameEncryptor = CustomAudioFrameEncryptor.create();
                audioMap.put(trackId, customAudioFrameEncryptor);
                return customAudioFrameEncryptor;
            }
            return audioMap.get(trackId);
        }
        return null;
    }

    public void release(RtpSender rtpSender) {
        CustomAudioFrameEncryptor customAudioFrameEncryptor;
        Map<String, CustomVideoFrameEncryptor> videoMap = this.videoSendMap;
        Map<String, CustomAudioFrameEncryptor> audioMap = this.audioSendMap;
        CustomVideoFrameEncryptor customVideoFrameEncryptor = videoMap.get(rtpSender.id());
        if (customVideoFrameEncryptor != null) {
            FinLog.i(TAG, "custom_crypto dispose release video send " + rtpSender.id());
            customVideoFrameEncryptor.release();
            videoMap.remove(rtpSender.id());
        }
        if ((customAudioFrameEncryptor = audioMap.get(rtpSender.id())) != null) {
            FinLog.i(TAG, "custom_crypto dispose release audio send " + rtpSender.id());
            customAudioFrameEncryptor.release();
            audioMap.remove(rtpSender.id());
        }
    }

    public void release() {
        FinLog.i(TAG, "custom_crypto dispose release all ");
        for (String key : this.videoSendMap.keySet()) {
            CustomVideoFrameEncryptor customVideoFrameEncryptor = this.videoSendMap.get(key);
            customVideoFrameEncryptor.release();
        }
        for (String key : this.audioSendMap.keySet()) {
            CustomAudioFrameEncryptor customAudioFrameEncryptor = this.audioSendMap.get(key);
            customAudioFrameEncryptor.release();
        }
        this.videoSendMap.clear();
        this.audioSendMap.clear();
    }

    private static class SingleHolder {
        static CustomFrameEncryptorFactory instance = new CustomFrameEncryptorFactory();

        private SingleHolder() {
        }
    }
}

