/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.crypto;

import cn.rongcloud.rtc.core.RtpReceiver;
import cn.rongcloud.rtc.crypto.CustomAudioFrameDecryptor;
import cn.rongcloud.rtc.crypto.CustomVideoFrameDecryptor;
import cn.rongcloud.rtc.utils.FinLog;
import java.util.HashMap;
import java.util.Map;

public class CustomFrameDecryptorFactory
implements RtpReceiver.DisposeObserver {
    private static final String TAG = CustomFrameDecryptorFactory.class.getSimpleName();
    private Map<String, CustomAudioFrameDecryptor> audioRecvMap = new HashMap<String, CustomAudioFrameDecryptor>();
    private Map<String, CustomVideoFrameDecryptor> videoRecvMap = new HashMap<String, CustomVideoFrameDecryptor>();

    @Override
    public void onDispose(RtpReceiver receiver) {
        FinLog.i(TAG, "custom_crypto dispose frameDecryptor " + receiver.id());
        this.release(receiver);
    }

    public void releaseAudioDecryptor(String trackId) {
        CustomAudioFrameDecryptor customAudioFrameDecryptor = this.audioRecvMap.get(trackId);
        if (customAudioFrameDecryptor != null) {
            customAudioFrameDecryptor.release();
            this.audioRecvMap.remove(trackId);
        }
    }

    public void releaseVideoDecryptor(String trackId) {
        CustomVideoFrameDecryptor customVideoFrameDecryptor = this.videoRecvMap.get(trackId);
        if (customVideoFrameDecryptor != null) {
            customVideoFrameDecryptor.release();
            this.videoRecvMap.remove(trackId);
        }
    }

    public static CustomFrameDecryptorFactory getInstance() {
        return SingleHolder.instance;
    }

    public CustomVideoFrameDecryptor createCustomVideoFrameDecryptor(String trackKind, String trackId) {
        Map<String, CustomVideoFrameDecryptor> videoMap = this.videoRecvMap;
        if (trackKind.equals("video")) {
            if (videoMap.get(trackId) == null) {
                CustomVideoFrameDecryptor customVideoFrameDecryptor = CustomVideoFrameDecryptor.create();
                videoMap.put(trackId, customVideoFrameDecryptor);
                return customVideoFrameDecryptor;
            }
            return videoMap.get(trackId);
        }
        return null;
    }

    public CustomAudioFrameDecryptor createCustomAudioFrameDecryptor(String trackKind, String trackId) {
        Map<String, CustomAudioFrameDecryptor> audioMap = this.audioRecvMap;
        if (trackKind.equals("audio")) {
            if (audioMap.get(trackId) == null) {
                CustomAudioFrameDecryptor customAudioFrameDecryptor = CustomAudioFrameDecryptor.create();
                audioMap.put(trackId, customAudioFrameDecryptor);
                return customAudioFrameDecryptor;
            }
            return audioMap.get(trackId);
        }
        return null;
    }

    private void release(RtpReceiver rtpReceiver) {
        CustomAudioFrameDecryptor customAudioFrameDecryptor;
        Map<String, CustomVideoFrameDecryptor> videoMap = this.videoRecvMap;
        Map<String, CustomAudioFrameDecryptor> audioMap = this.audioRecvMap;
        CustomVideoFrameDecryptor customVideoFrameDecryptor = videoMap.get(rtpReceiver.id());
        if (customVideoFrameDecryptor != null) {
            FinLog.i(TAG, "custom_crypto dispose release video recv " + rtpReceiver.id());
            customVideoFrameDecryptor.release();
            videoMap.remove(rtpReceiver.id());
        }
        if ((customAudioFrameDecryptor = audioMap.get(rtpReceiver.id())) != null) {
            FinLog.i(TAG, "custom_crypto dispose release audio recv " + rtpReceiver.id());
            customAudioFrameDecryptor.release();
            audioMap.remove(rtpReceiver.id());
        }
    }

    public void release() {
        FinLog.i(TAG, "custom_crypto dispose release all ");
        for (String key : this.videoRecvMap.keySet()) {
            CustomVideoFrameDecryptor customVideoFrameDecryptor = this.videoRecvMap.get(key);
            customVideoFrameDecryptor.release();
        }
        for (String key : this.audioRecvMap.keySet()) {
            CustomAudioFrameDecryptor customAudioFrameDecryptor = this.audioRecvMap.get(key);
            customAudioFrameDecryptor.release();
        }
        this.videoRecvMap.clear();
        this.audioRecvMap.clear();
    }

    private static class SingleHolder {
        static CustomFrameDecryptorFactory instance = new CustomFrameDecryptorFactory();

        private SingleHolder() {
        }
    }
}

