/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core.audio;

import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AudioEffect;
import android.media.audiofx.NoiseSuppressor;
import android.os.Build;
import android.support.annotation.Nullable;
import cn.rongcloud.rtc.core.Logging;
import cn.rongcloud.rtc.core.audio.RongRtcAudioUtils;
import java.util.UUID;

class RongRtcAudioEffects {
    private static final boolean DEBUG = false;
    private static final String TAG = "RongRtcAudioEffectsExternal";
    private static final UUID AOSP_ACOUSTIC_ECHO_CANCELER = UUID.fromString("bb392ec0-8d4d-11e0-a896-0002a5d5c51b");
    private static final UUID AOSP_NOISE_SUPPRESSOR = UUID.fromString("c06c8400-8e06-11e0-9cb6-0002a5d5c51b");
    @Nullable
    private static AudioEffect.Descriptor[] cachedEffects;
    @Nullable
    private AcousticEchoCanceler aec;
    @Nullable
    private NoiseSuppressor ns;
    private boolean shouldEnableAec;
    private boolean shouldEnableNs;

    public static boolean isAcousticEchoCancelerSupported() {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        return RongRtcAudioEffects.isEffectTypeAvailable(AudioEffect.EFFECT_TYPE_AEC, AOSP_ACOUSTIC_ECHO_CANCELER);
    }

    public static boolean isNoiseSuppressorSupported() {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        return RongRtcAudioEffects.isEffectTypeAvailable(AudioEffect.EFFECT_TYPE_NS, AOSP_NOISE_SUPPRESSOR);
    }

    public RongRtcAudioEffects() {
        Logging.d(TAG, "ctor" + RongRtcAudioUtils.getThreadInfo());
    }

    public boolean setAEC(boolean enable) {
        Logging.d(TAG, "setAEC(" + enable + ")");
        if (!RongRtcAudioEffects.isAcousticEchoCancelerSupported()) {
            Logging.w(TAG, "Platform AEC is not supported");
            this.shouldEnableAec = false;
            return false;
        }
        if (this.aec != null && enable != this.shouldEnableAec) {
            Logging.e(TAG, "Platform AEC state can't be modified while recording");
            return false;
        }
        this.shouldEnableAec = enable;
        return true;
    }

    public boolean setNS(boolean enable) {
        Logging.d(TAG, "setNS(" + enable + ")");
        if (!RongRtcAudioEffects.isNoiseSuppressorSupported()) {
            Logging.w(TAG, "Platform NS is not supported");
            this.shouldEnableNs = false;
            return false;
        }
        if (this.ns != null && enable != this.shouldEnableNs) {
            Logging.e(TAG, "Platform NS state can't be modified while recording");
            return false;
        }
        this.shouldEnableNs = enable;
        return true;
    }

    public void enable(int audioSession) {
        boolean enable;
        boolean enabled;
        Logging.d(TAG, "enable(audioSession=" + audioSession + ")");
        RongRtcAudioEffects.assertTrue(this.aec == null);
        RongRtcAudioEffects.assertTrue(this.ns == null);
        if (RongRtcAudioEffects.isAcousticEchoCancelerSupported()) {
            this.aec = AcousticEchoCanceler.create((int)audioSession);
            if (this.aec != null) {
                enabled = this.aec.getEnabled();
                boolean bl = enable = this.shouldEnableAec && RongRtcAudioEffects.isAcousticEchoCancelerSupported();
                if (this.aec.setEnabled(enable) != 0) {
                    Logging.e(TAG, "Failed to set the AcousticEchoCanceler state");
                }
                Logging.d(TAG, "AcousticEchoCanceler: was " + (enabled ? "enabled" : "disabled") + ", enable: " + enable + ", is now: " + (this.aec.getEnabled() ? "enabled" : "disabled"));
            } else {
                Logging.e(TAG, "Failed to create the AcousticEchoCanceler instance");
            }
        }
        if (RongRtcAudioEffects.isNoiseSuppressorSupported()) {
            this.ns = NoiseSuppressor.create((int)audioSession);
            if (this.ns != null) {
                enabled = this.ns.getEnabled();
                boolean bl = enable = this.shouldEnableNs && RongRtcAudioEffects.isNoiseSuppressorSupported();
                if (this.ns.setEnabled(enable) != 0) {
                    Logging.e(TAG, "Failed to set the NoiseSuppressor state");
                }
                Logging.d(TAG, "NoiseSuppressor: was " + (enabled ? "enabled" : "disabled") + ", enable: " + enable + ", is now: " + (this.ns.getEnabled() ? "enabled" : "disabled"));
            } else {
                Logging.e(TAG, "Failed to create the NoiseSuppressor instance");
            }
        }
    }

    public void release() {
        Logging.d(TAG, "release");
        if (this.aec != null) {
            this.aec.release();
            this.aec = null;
        }
        if (this.ns != null) {
            this.ns.release();
            this.ns = null;
        }
    }

    private boolean effectTypeIsVoIP(UUID type) {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        return AudioEffect.EFFECT_TYPE_AEC.equals(type) && RongRtcAudioEffects.isAcousticEchoCancelerSupported() || AudioEffect.EFFECT_TYPE_NS.equals(type) && RongRtcAudioEffects.isNoiseSuppressorSupported();
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    @Nullable
    private static AudioEffect.Descriptor[] getAvailableEffects() {
        if (cachedEffects != null) {
            return cachedEffects;
        }
        cachedEffects = AudioEffect.queryEffects();
        return cachedEffects;
    }

    private static boolean isEffectTypeAvailable(UUID effectType, UUID blackListedUuid) {
        AudioEffect.Descriptor[] effects = RongRtcAudioEffects.getAvailableEffects();
        if (effects == null) {
            return false;
        }
        for (AudioEffect.Descriptor d : effects) {
            if (!d.type.equals(effectType)) continue;
            return !d.uuid.equals(blackListedUuid);
        }
        return false;
    }
}

