/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core.audio;

import cn.rongcloud.rtc.core.CalledByNative;
import cn.rongcloud.rtc.core.audio.OnAudioBufferAvailableListener;
import cn.rongcloud.rtc.core.audio.OnAudioDeviceErrorListener;
import java.nio.ByteBuffer;

public class CustomEchoAudioRecorder {
    private static final String TAG = "CustomEchoAudioRecorder";
    public static final int OpenSLESEngineError = -1;
    public static final int OpenSLESRecorderError = -2;
    public static final int OpenSLESPlayerError = -3;
    private OnAudioDeviceErrorListener onAudioDeviceErrorListener;
    private ByteBuffer byteBuffer;
    private long nativeAudioRecorder;
    private OnAudioBufferAvailableListener onAudioBufferAvailableListener;

    public CustomEchoAudioRecorder(OnAudioBufferAvailableListener onAudioBufferAvailableListener, OnAudioDeviceErrorListener onAudioDeviceErrorListener) {
        this.onAudioBufferAvailableListener = onAudioBufferAvailableListener;
        this.onAudioDeviceErrorListener = onAudioDeviceErrorListener;
    }

    public void enableEcho(boolean enable) {
        CustomEchoAudioRecorder.nativeEnableEcho(this.nativeAudioRecorder, enable);
    }

    @CalledByNative
    private void onNativeError(int errorCode) {
        if (this.onAudioDeviceErrorListener != null) {
            this.onAudioDeviceErrorListener.onAudioDeviceError(errorCode);
        }
    }

    @CalledByNative
    private void setNativeRecorder(long nativeAudioRecorder, int bufferSize) {
        this.nativeAudioRecorder = nativeAudioRecorder;
        this.byteBuffer = ByteBuffer.allocateDirect(bufferSize);
        CustomEchoAudioRecorder.nativeCacheDirectBufferAddress(this.nativeAudioRecorder, this.byteBuffer);
    }

    @CalledByNative
    private void onAudioSamplesReady(int sampleRate, int channelCount, int bytesPerSample) {
        if (this.onAudioBufferAvailableListener != null) {
            int sampleFormat = bytesPerSample == 2 ? 2 : 3;
            this.onAudioBufferAvailableListener.onAudioBuffer(this.byteBuffer, this.byteBuffer.capacity(), sampleRate, channelCount, sampleFormat);
        }
    }

    private static native void nativeCacheDirectBufferAddress(long var0, ByteBuffer var2);

    private static native void nativeEnableEcho(long var0, boolean var2);
}

