/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core.audio;

import android.content.Context;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Process;
import android.support.annotation.Nullable;
import cn.rongcloud.rtc.core.CalledByNative;
import cn.rongcloud.rtc.core.Logging;
import cn.rongcloud.rtc.core.ThreadUtils;
import cn.rongcloud.rtc.core.audio.RongRtcAudioUtils;
import cn.rongcloud.rtc.core.audio.VolumeLogger;
import java.nio.ByteBuffer;

public class CustomAudioTrack {
    private static final String TAG = "CustomAudioTrackExternal";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final long AUDIO_TRACK_THREAD_JOIN_TIMEOUT_MS = 2000L;
    private long nativeAudioTrack;
    private final Context context;
    private final AudioManager audioManager;
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private ByteBuffer byteBuffer;
    @Nullable
    private AudioTrackProxy audioTrack;
    @Nullable
    private AudioTrackThread audioThread;
    private final VolumeLogger volumeLogger;
    private volatile boolean speakerMute;
    private byte[] emptyBytes;
    private boolean dumpFle;
    private String dumpFilePath;

    @CalledByNative
    CustomAudioTrack(Context context, AudioManager audioManager, AudioTrackProxy aTrackProxy) {
        this.threadChecker.detachThread();
        this.context = context;
        this.audioManager = audioManager;
        this.audioTrack = aTrackProxy;
        this.volumeLogger = new VolumeLogger(audioManager);
    }

    public CustomAudioTrack(Context context, AudioManager audioManager, AudioTrackProxy aTrackProxy, boolean dumpFle, String dumpFilePath) {
        this(context, audioManager, aTrackProxy);
        this.dumpFle = dumpFle;
        this.dumpFilePath = dumpFilePath;
    }

    @CalledByNative
    public void setNativeAudioTrack(long nativeAudioTrack) {
        this.nativeAudioTrack = nativeAudioTrack;
    }

    @CalledByNative
    private boolean initPlayout(int sampleRate, int channels) {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "initPlayout(sampleRate=" + sampleRate + ", channels=" + channels + ")");
        int bytesPerFrame = channels * 2;
        this.byteBuffer = ByteBuffer.allocateDirect(bytesPerFrame * (sampleRate / 100));
        Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.emptyBytes = new byte[this.byteBuffer.capacity()];
        CustomAudioTrack.nativeCacheDirectBufferAddress(this.nativeAudioTrack, this.byteBuffer);
        int channelConfig = this.channelCountToConfiguration(channels);
        int minBufferSizeInBytes = AudioTrack.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)2);
        Logging.d(TAG, "AudioTrack.getMinBufferSize: " + minBufferSizeInBytes);
        if (minBufferSizeInBytes < this.byteBuffer.capacity()) {
            Logging.e(TAG, "AudioTrack.getMinBufferSize returns an invalid value.");
            return false;
        }
        if (this.audioTrack == null) {
            Logging.e(TAG, "AudioTrack is NULL when init.");
            return false;
        }
        if (this.audioTrack.isInitialized()) {
            Logging.e(TAG, "AudioTrack is already initialized.");
            return false;
        }
        try {
            this.audioTrack.init(sampleRate, channelConfig, minBufferSizeInBytes);
        }
        catch (IllegalArgumentException e) {
            Logging.e(TAG, e.getMessage());
            this.releaseAudioResources();
            return false;
        }
        if (!this.audioTrack.isInitialized()) {
            Logging.e(TAG, "Initialization of audio track failed.");
            this.releaseAudioResources();
            return false;
        }
        return true;
    }

    @CalledByNative
    private boolean startPlayout() {
        this.threadChecker.checkIsOnValidThread();
        this.volumeLogger.start();
        Logging.d(TAG, "startPlayout");
        CustomAudioTrack.assertTrue(this.audioTrack != null);
        CustomAudioTrack.assertTrue(this.audioThread == null);
        try {
            this.audioTrack.play();
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "AudioTrack.play failed: " + e.getMessage());
            this.releaseAudioResources();
            return false;
        }
        if (!this.audioTrack.isPlaying()) {
            this.releaseAudioResources();
            return false;
        }
        this.audioThread = new AudioTrackThread("AudioTrackJavaThread");
        this.audioThread.start();
        return true;
    }

    @CalledByNative
    private boolean stopPlayout() {
        this.threadChecker.checkIsOnValidThread();
        this.volumeLogger.stop();
        Logging.d(TAG, "stopPlayout");
        CustomAudioTrack.assertTrue(this.audioThread != null);
        this.audioThread.stopThread();
        Logging.d(TAG, "Stopping the AudioTrackThread...");
        this.audioThread.interrupt();
        if (!ThreadUtils.joinUninterruptibly(this.audioThread, 2000L)) {
            Logging.e(TAG, "Join of AudioTrackThread timed out.");
            RongRtcAudioUtils.logAudioState(TAG, this.context, this.audioManager);
        }
        Logging.d(TAG, "AudioTrackThread has now been stopped.");
        this.audioThread = null;
        this.releaseAudioResources();
        return true;
    }

    @CalledByNative
    private int getStreamMaxVolume() {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "getStreamMaxVolume");
        return this.audioManager.getStreamMaxVolume(0);
    }

    @CalledByNative
    private boolean setStreamVolume(int volume) {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "setStreamVolume(" + volume + ")");
        if (this.isVolumeFixed()) {
            Logging.e(TAG, "The device implements a fixed volume policy.");
            return false;
        }
        this.audioManager.setStreamVolume(0, volume, 0);
        return true;
    }

    private boolean isVolumeFixed() {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        return this.audioManager.isVolumeFixed();
    }

    @CalledByNative
    private int getStreamVolume() {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "getStreamVolume");
        return this.audioManager.getStreamVolume(0);
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private int channelCountToConfiguration(int channels) {
        return channels == 1 ? 4 : 12;
    }

    private static native void nativeCacheDirectBufferAddress(long var0, ByteBuffer var2);

    private static native void nativeGetPlayoutData(long var0, int var2);

    public void setSpeakerMute(boolean mute) {
        Logging.w(TAG, "setSpeakerMute(" + mute + ")");
        this.speakerMute = mute;
    }

    private void releaseAudioResources() {
        Logging.d(TAG, "releaseAudioResources");
        this.audioTrack.release();
    }

    private class AudioTrackThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioTrackThread(String name) {
            super(name);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Logging.d(CustomAudioTrack.TAG, "AudioTrackThread" + RongRtcAudioUtils.getThreadInfo());
            CustomAudioTrack.assertTrue(CustomAudioTrack.this.audioTrack.isPlaying());
            int sizeInBytes = CustomAudioTrack.this.byteBuffer.capacity();
            while (this.keepAlive) {
                int bytesWritten;
                CustomAudioTrack.nativeGetPlayoutData(CustomAudioTrack.this.nativeAudioTrack, sizeInBytes);
                CustomAudioTrack.assertTrue(sizeInBytes <= CustomAudioTrack.this.byteBuffer.remaining());
                if (CustomAudioTrack.this.speakerMute) {
                    CustomAudioTrack.this.byteBuffer.clear();
                    CustomAudioTrack.this.byteBuffer.put(CustomAudioTrack.this.emptyBytes);
                    CustomAudioTrack.this.byteBuffer.position(0);
                }
                if ((bytesWritten = CustomAudioTrack.this.audioTrack.write(CustomAudioTrack.this.byteBuffer, sizeInBytes)) != sizeInBytes) {
                    Logging.e(CustomAudioTrack.TAG, "AudioTrack.write played invalid number of bytes: " + bytesWritten);
                    if (bytesWritten < 0) {
                        this.keepAlive = false;
                        Logging.e(CustomAudioTrack.TAG, "AudioTrack.write failed: " + bytesWritten);
                    }
                }
                CustomAudioTrack.this.byteBuffer.rewind();
            }
            if (CustomAudioTrack.this.audioTrack != null) {
                Logging.d(CustomAudioTrack.TAG, "Calling AudioTrack.stop...");
                try {
                    CustomAudioTrack.this.audioTrack.stop();
                    Logging.d(CustomAudioTrack.TAG, "AudioTrack.stop is done.");
                }
                catch (IllegalStateException e) {
                    Logging.e(CustomAudioTrack.TAG, "AudioTrack.stop failed: " + e.getMessage());
                }
            }
        }

        public void stopThread() {
            Logging.d(CustomAudioTrack.TAG, "stopThread");
            this.keepAlive = false;
        }
    }

    public static interface AudioTrackProxy {
        public void init(int var1, int var2, int var3);

        public int write(ByteBuffer var1, int var2);

        public void play();

        public void stop();

        public void release();

        public boolean isInitialized();

        public boolean isPlaying();
    }
}

