/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core.audio;

import android.content.Context;
import android.media.AudioManager;
import android.support.annotation.Nullable;
import cn.rongcloud.rtc.core.JniCommon;
import cn.rongcloud.rtc.core.Logging;
import cn.rongcloud.rtc.core.audio.AudioDeviceModule;
import cn.rongcloud.rtc.core.audio.CustomAudioRecord;
import cn.rongcloud.rtc.core.audio.CustomAudioTrack;
import cn.rongcloud.rtc.core.audio.CustomEchoAudioRecorder;
import cn.rongcloud.rtc.core.audio.OnAudioBufferAvailableListener;
import cn.rongcloud.rtc.core.audio.OnAudioDeviceErrorListener;
import cn.rongcloud.rtc.core.audio.RongRtcAudioManager;
import cn.rongcloud.rtc.utils.ReportUtil;

public class CustomAudioDeviceModule
implements AudioDeviceModule {
    private static final String TAG = "CustomAudioDeviceModule";
    private final Context context;
    private final AudioManager audioManager;
    @Nullable
    private final CustomAudioRecord audioInput;
    @Nullable
    private final CustomAudioTrack audioOutput;
    @Nullable
    private final CustomEchoAudioRecorder echoAudioInput;
    private final int sampleRate;
    private final boolean useStereoInput;
    private final boolean useStereoOutput;
    private final Object nativeLock = new Object();
    private long nativeAudioDeviceModule;

    public static Builder builder(Context context) {
        return new Builder(context);
    }

    private CustomAudioDeviceModule(Context context, AudioManager audioManager, CustomEchoAudioRecorder echoAudioInput, CustomAudioRecord audioInput, CustomAudioTrack audioOutput, int sampleRate, boolean useStereoInput, boolean useStereoOutput) {
        this.context = context;
        this.audioManager = audioManager;
        this.echoAudioInput = echoAudioInput;
        this.audioInput = audioInput;
        this.audioOutput = audioOutput;
        this.sampleRate = sampleRate;
        this.useStereoInput = useStereoInput;
        this.useStereoOutput = useStereoOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNativeAudioDeviceModulePointer() {
        Object object = this.nativeLock;
        synchronized (object) {
            if (this.nativeAudioDeviceModule == 0L) {
                this.nativeAudioDeviceModule = this.echoAudioInput == null ? CustomAudioDeviceModule.nativeCreateAudioDeviceModule(this.context, this.audioManager, this.audioInput, this.audioOutput, this.sampleRate, this.useStereoInput, this.useStereoOutput) : CustomAudioDeviceModule.nativeCreateEchoAudioDeviceModule(this.context, this.audioManager, this.echoAudioInput, this.audioOutput, this.sampleRate, this.useStereoInput, this.useStereoOutput);
            }
            return this.nativeAudioDeviceModule;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.nativeLock;
        synchronized (object) {
            if (this.nativeAudioDeviceModule != 0L) {
                JniCommon.nativeReleaseRef(this.nativeAudioDeviceModule);
                this.nativeAudioDeviceModule = 0L;
            }
        }
    }

    @Override
    public void setSpeakerMute(boolean mute) {
        Logging.d(TAG, "setSpeakerMute: " + mute);
        this.audioOutput.setSpeakerMute(mute);
    }

    @Override
    public void setMicrophoneMute(boolean mute) {
        Logging.d(TAG, "setMicrophoneMute: " + mute);
        this.audioInput.setMicrophoneMute(mute);
    }

    @Override
    public void setEcho(boolean enable) {
        if (this.echoAudioInput == null) {
            ReportUtil.appError(ReportUtil.TAG.ENABLE_EAR_MONITOR, "msg", "echoAudioInput is null");
            return;
        }
        this.echoAudioInput.enableEcho(enable);
    }

    @Override
    public void changeAudioInput() {
        CustomAudioDeviceModule.nativeChangeAudioInput(this.nativeAudioDeviceModule, this.context, this.audioManager, this.audioInput, this.sampleRate, this.useStereoInput, this.useStereoOutput);
    }

    private static native long nativeCreateAudioDeviceModule(Context var0, AudioManager var1, CustomAudioRecord var2, CustomAudioTrack var3, int var4, boolean var5, boolean var6);

    private static native long nativeCreateEchoAudioDeviceModule(Context var0, AudioManager var1, CustomEchoAudioRecorder var2, CustomAudioTrack var3, int var4, boolean var5, boolean var6);

    private static native void nativeChangeAudioInput(long var0, Context var2, AudioManager var3, CustomAudioRecord var4, int var5, boolean var6, boolean var7);

    public static class Builder {
        private final Context context;
        private final AudioManager audioManager;
        private int sampleRate;
        private int audioSource = 7;
        private int audioFormat = 2;
        private boolean useStereoInput;
        private boolean useStereoOutput;

        private Builder(Context context) {
            this.context = context;
            this.audioManager = (AudioManager)context.getSystemService("audio");
            this.sampleRate = RongRtcAudioManager.getSampleRate(this.audioManager);
        }

        public Builder setSampleRate(int sampleRate) {
            Logging.d(CustomAudioDeviceModule.TAG, "Sample rate overridden to: " + sampleRate);
            this.sampleRate = sampleRate;
            return this;
        }

        public Builder setAudioSource(int audioSource) {
            this.audioSource = audioSource;
            return this;
        }

        public Builder setAudioFormat(int audioFormat) {
            this.audioFormat = audioFormat;
            return this;
        }

        public Builder setUseStereoInput(boolean useStereoInput) {
            this.useStereoInput = useStereoInput;
            return this;
        }

        public Builder setUseStereoOutput(boolean useStereoOutput) {
            this.useStereoOutput = useStereoOutput;
            return this;
        }

        public AudioDeviceModule createAudioDeviceModule(CustomAudioRecord.AudioRecordProxy aRecordProxy, CustomAudioTrack.AudioTrackProxy aTrackProxy) {
            CustomAudioRecord audioInput = new CustomAudioRecord(this.context, this.audioManager, aRecordProxy, this.audioSource, this.audioFormat);
            CustomAudioTrack audioOutput = new CustomAudioTrack(this.context, this.audioManager, aTrackProxy);
            return new CustomAudioDeviceModule(this.context, this.audioManager, null, audioInput, audioOutput, this.sampleRate, this.useStereoInput, this.useStereoOutput);
        }

        public AudioDeviceModule createEchoAudioDeviceModule(OnAudioBufferAvailableListener onAudioBufferAvailableListener, OnAudioDeviceErrorListener onAudioDeviceErrorListener, CustomAudioRecord.AudioRecordProxy aRecordProxy, CustomAudioTrack.AudioTrackProxy aTrackProxy) {
            CustomEchoAudioRecorder echoAudioInput = new CustomEchoAudioRecorder(onAudioBufferAvailableListener, onAudioDeviceErrorListener);
            CustomAudioRecord audioInput = new CustomAudioRecord(this.context, this.audioManager, aRecordProxy, this.audioSource, this.audioFormat);
            CustomAudioTrack audioOutput = new CustomAudioTrack(this.context, this.audioManager, aTrackProxy);
            return new CustomAudioDeviceModule(this.context, this.audioManager, echoAudioInput, audioInput, audioOutput, this.sampleRate, this.useStereoInput, this.useStereoOutput);
        }
    }
}

