/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core.audio;

import android.content.Context;
import android.media.AudioTrack;
import android.os.Build;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import cn.rongcloud.rtc.api.RCRTCAudioMixer;
import cn.rongcloud.rtc.api.callback.RCRTCAudioMixingStateChangeListener;
import cn.rongcloud.rtc.center.stream.RCMicOutputStreamImpl;
import cn.rongcloud.rtc.core.audio.OnAudioBufferAvailableListener;
import cn.rongcloud.rtc.custom.MediaAudioDecoder;
import cn.rongcloud.rtc.custom.OnPcmAvailableListener;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.utils.AudioBufferStream;
import cn.rongcloud.rtc.utils.AudioUtil;
import cn.rongcloud.rtc.utils.FinLog;
import java.nio.ByteBuffer;

public class AudioMixer
extends RCRTCAudioMixer
implements OnAudioBufferAvailableListener,
OnPcmAvailableListener {
    private static final String TAG = "RongRTCAudioMixer";
    private static final AudioMixer sInstance = new AudioMixer();
    private static final int MAX_VOL = 100;
    private static final int MIN_VOL = 0;
    private static final int STATE_START = 0;
    private static final int STATE_PAUSE = 1;
    private static final int STATE_STOP = 2;
    private MediaAudioDecoder mAudioDecoder;
    private AudioBufferStream mAudioBufferStream;
    private AudioTrack mAudioTrack;
    private RCRTCAudioMixingStateChangeListener audioMixingStateChangeListener;
    private int mState = 2;
    private int mixingVolume = 100;
    private int playbackVolume = 100;
    private long totalDurationUs = 0L;
    private float currentPosition = 0.0f;
    private RCRTCAudioMixer.Mode mode;
    private boolean playback = false;
    private RCMicOutputStreamImpl mDefaultAudioStream;

    @Deprecated
    public static AudioMixer getInstance() {
        return sInstance;
    }

    public void setDefaultAudioStream(RCMicOutputStreamImpl defaultAudioStream) {
        this.mDefaultAudioStream = defaultAudioStream;
    }

    @Override
    public boolean startMix(String path, RCRTCAudioMixer.Mode mode, boolean playback, int loopCount) {
        RCMicOutputStreamImpl defaultAudioStream = this.mDefaultAudioStream;
        if (this.mState != 2 && defaultAudioStream != null) {
            this.stop();
        }
        this.mode = mode;
        this.playback = playback;
        MediaAudioDecoder audioDecoder = new MediaAudioDecoder();
        Context context = RTCEngineImpl.getInstance().getContext();
        if (context == null) {
            FinLog.e(TAG, "startMix: context is null.");
            return false;
        }
        if (!audioDecoder.init(path, context)) {
            FinLog.e(TAG, "startMix: failed to init audio decoder.");
            return false;
        }
        this.mAudioTrack = AudioUtil.createAudioTrack(audioDecoder.getMediaFormat(), 0);
        if (this.mAudioTrack == null) {
            FinLog.e(TAG, "startMix: failed to create audio track.");
            return false;
        }
        float volume = (float)this.playbackVolume / 100.0f * (AudioTrack.getMaxVolume() - AudioTrack.getMinVolume());
        this.mAudioTrack.setStereoVolume(volume, volume);
        this.currentPosition = 0.0f;
        this.totalDurationUs = audioDecoder.getDurationUs();
        this.mAudioBufferStream = new AudioBufferStream(audioDecoder.getSampleRate(), audioDecoder.getChannelCount(), audioDecoder.getAudioFormat(), RTCEngineImpl.getInstance().getAudioSampleRate(), RTCEngineImpl.getInstance().isStereo() ? 2 : 1, 2);
        audioDecoder.setPcmAvailableListener(this);
        audioDecoder.setRepeatCount(loopCount);
        audioDecoder.start();
        this.mAudioDecoder = audioDecoder;
        if (defaultAudioStream != null) {
            defaultAudioStream.registerAudioBufferListener(this);
        }
        this.mState = 0;
        if (this.audioMixingStateChangeListener != null) {
            this.audioMixingStateChangeListener.onStateChanged(RCRTCAudioMixer.MixingState.PLAY);
        }
        return true;
    }

    @Override
    public void write(byte[] data, int sampleRate, int channelCount, int audioFormat, int volume, RCRTCAudioMixer.Mode mode) {
        this.mixingVolume = Math.max(0, Math.min(100, volume));
        this.mode = mode;
        RCMicOutputStreamImpl defaultAudioStream = this.mDefaultAudioStream;
        if (this.mAudioBufferStream == null && defaultAudioStream != null) {
            this.mAudioBufferStream = new AudioBufferStream(sampleRate, channelCount, audioFormat, RTCEngineImpl.getInstance().getAudioSampleRate(), RTCEngineImpl.getInstance().isStereo() ? 2 : 1, 2);
            defaultAudioStream.registerAudioBufferListener(this);
            this.mState = 0;
            this.mAudioTrack = AudioUtil.createAudioTrack(sampleRate, channelCount, audioFormat, 0);
        }
        if (this.mAudioBufferStream != null) {
            this.mAudioBufferStream.write(data);
        }
    }

    @Override
    public void setAudioMixingStateChangeListener(RCRTCAudioMixingStateChangeListener listener) {
        this.audioMixingStateChangeListener = listener;
    }

    @Override
    public void onAudioBuffer(ByteBuffer byteBuffer, int sizeInBytes, int sampleRate, int channelCount, int audioFormat) {
        if (this.mState != 0) {
            return;
        }
        AudioBufferStream audioBufferStream = this.mAudioBufferStream;
        if (audioBufferStream == null) {
            return;
        }
        byte[] data = audioBufferStream.read(sizeInBytes / (channelCount * 2));
        if (data == null) {
            return;
        }
        AudioUtil.adjustVolumeAsShort(data, AudioUtil.linearToLog(this.mixingVolume));
        switch (this.mode) {
            case MIX: {
                AudioUtil.mixAsShort(data, byteBuffer);
                break;
            }
            case REPLACE: {
                byteBuffer.clear();
                byteBuffer.put(data);
                break;
            }
        }
    }

    @Override
    public void onPcm(byte[] data, long presentationTimeUs) {
        if (this.mState == 2) {
            return;
        }
        try {
            this.currentPosition = (float)((double)presentationTimeUs / (double)this.totalDurationUs);
        }
        catch (ArithmeticException e) {
            this.currentPosition = 0.0f;
        }
        AudioBufferStream audioBufferStream = this.mAudioBufferStream;
        if (audioBufferStream != null) {
            audioBufferStream.write(data);
        }
        AudioTrack audioTrack = this.mAudioTrack;
        if (this.playback && audioTrack != null) {
            try {
                if (Build.VERSION.SDK_INT >= 21) {
                    audioTrack.write(ByteBuffer.wrap(data), data.length, 1);
                } else {
                    audioTrack.write(data, 0, data.length);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onPcmEnd() {
        this.stop(true);
    }

    @Override
    public void setPlayback(boolean playback) {
        this.playback = playback;
    }

    @Override
    public void setMixingVolume(@IntRange(from=0L, to=100L) int vol) {
        this.mixingVolume = Math.max(Math.min(vol, 100), 0);
    }

    @Override
    public int getMixingVolume() {
        return this.mixingVolume;
    }

    @Override
    public void setPlaybackVolume(@IntRange(from=0L, to=100L) int vol) {
        this.playbackVolume = Math.max(Math.min(vol, 100), 0);
        AudioTrack audioTrack = this.mAudioTrack;
        if (audioTrack != null) {
            float volume = (float)this.playbackVolume / 100.0f * (AudioTrack.getMaxVolume() - AudioTrack.getMinVolume());
            audioTrack.setStereoVolume(volume, volume);
        }
    }

    @Override
    public int getPlaybackVolume() {
        return this.playbackVolume;
    }

    @Override
    public int getDurationMillis() {
        return (int)(this.totalDurationUs / 1000L);
    }

    @Override
    public int getDurationMillis(String path) {
        return AudioUtil.durationOfMediaFile(path);
    }

    @Override
    public float getCurrentPosition() {
        return this.currentPosition;
    }

    @Override
    public void seekTo(@FloatRange(from=0.0, to=1.0) float position) {
        long presentationTimeUs = (long)((float)this.totalDurationUs * position);
        if (this.mAudioDecoder != null) {
            this.mAudioDecoder.seekTo(presentationTimeUs);
            this.currentPosition = position;
        }
        if (this.mAudioTrack != null) {
            this.mAudioTrack.pause();
            this.mAudioTrack.flush();
            this.mAudioTrack.play();
        }
    }

    @Override
    public void stop() {
        this.stop(false);
    }

    private void stop(boolean mixEnd) {
        if (this.mState != 2) {
            RCRTCAudioMixingStateChangeListener listener;
            this.mState = 2;
            if (this.mDefaultAudioStream != null) {
                this.mDefaultAudioStream.unregisterAudioBufferListener(this);
            }
            if (this.mAudioDecoder != null) {
                this.mAudioDecoder.stop();
            }
            this.mAudioBufferStream.release();
            if (this.mAudioTrack != null) {
                this.mAudioTrack.pause();
                this.mAudioTrack.release();
            }
            if ((listener = this.audioMixingStateChangeListener) != null) {
                if (!mixEnd) {
                    listener.onStateChanged(RCRTCAudioMixer.MixingState.STOPPED);
                } else {
                    listener.onMixEnd();
                }
            }
            this.mAudioDecoder = null;
            this.mAudioBufferStream = null;
            this.mAudioTrack = null;
            this.totalDurationUs = 0L;
            this.currentPosition = 0.0f;
        }
    }

    @Override
    public void resume() {
        if (this.mState == 1) {
            this.mState = 0;
            if (this.audioMixingStateChangeListener != null) {
                this.audioMixingStateChangeListener.onStateChanged(RCRTCAudioMixer.MixingState.PLAY);
            }
        }
    }

    @Override
    public void pause() {
        if (this.mState == 0) {
            this.mState = 1;
            if (this.audioMixingStateChangeListener != null) {
                this.audioMixingStateChangeListener.onStateChanged(RCRTCAudioMixer.MixingState.PAUSED);
            }
        }
    }

    @Override
    public void setVolume(@IntRange(from=0L, to=100L) int volume) {
        this.setPlaybackVolume(volume);
        this.setMixingVolume(volume);
    }
}

