/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import android.support.annotation.Nullable;
import cn.rongcloud.rtc.core.CalledByNative;
import cn.rongcloud.rtc.core.EncodedImage;
import cn.rongcloud.rtc.core.VideoEncoder;
import java.nio.ByteBuffer;

class VideoEncoderWrapper {
    VideoEncoderWrapper() {
    }

    @CalledByNative
    static boolean getScalingSettingsOn(VideoEncoder.ScalingSettings scalingSettings) {
        return scalingSettings.on;
    }

    @Nullable
    @CalledByNative
    static Integer getScalingSettingsLow(VideoEncoder.ScalingSettings scalingSettings) {
        return scalingSettings.low;
    }

    @Nullable
    @CalledByNative
    static Integer getScalingSettingsHigh(VideoEncoder.ScalingSettings scalingSettings) {
        return scalingSettings.high;
    }

    @CalledByNative
    static VideoEncoder.Callback createEncoderCallback(final long nativeEncoder) {
        return new VideoEncoder.Callback(){

            @Override
            public void onEncodedFrame(EncodedImage frame, VideoEncoder.CodecSpecificInfo info) {
                VideoEncoderWrapper.nativeOnEncodedFrame(nativeEncoder, frame.buffer, frame.encodedWidth, frame.encodedHeight, frame.captureTimeNs, frame.frameType.getNative(), frame.rotation, frame.completeFrame, frame.qp);
            }
        };
    }

    private static native void nativeOnEncodedFrame(long var0, ByteBuffer var2, int var3, int var4, long var5, int var7, int var8, boolean var9, Integer var10);
}

