/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import android.support.annotation.Nullable;
import cn.rongcloud.rtc.core.LibvpxH264Decoder;
import cn.rongcloud.rtc.core.LibvpxVp8Decoder;
import cn.rongcloud.rtc.core.LibvpxVp9Decoder;
import cn.rongcloud.rtc.core.VideoCodecInfo;
import cn.rongcloud.rtc.core.VideoDecoder;
import cn.rongcloud.rtc.core.VideoDecoderFactory;
import java.util.ArrayList;
import java.util.HashMap;

public class SoftwareVideoDecoderFactory
extends VideoDecoderFactory {
    @Override
    @Deprecated
    @Nullable
    public VideoDecoder createDecoder(String codecType) {
        return this.createDecoder(new VideoCodecInfo(codecType, new HashMap<String, String>()));
    }

    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo codecType) {
        if (codecType.getName().equalsIgnoreCase("VP8")) {
            return new LibvpxVp8Decoder();
        }
        if (codecType.getName().equalsIgnoreCase("VP9") && LibvpxVp9Decoder.nativeIsSupported()) {
            return new LibvpxVp9Decoder();
        }
        if (codecType.getName().equalsIgnoreCase("H264") && LibvpxH264Decoder.nativeIsSupported()) {
            return new LibvpxH264Decoder();
        }
        return null;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        return SoftwareVideoDecoderFactory.supportedCodecs();
    }

    static VideoCodecInfo[] supportedCodecs() {
        ArrayList<VideoCodecInfo> codecs = new ArrayList<VideoCodecInfo>();
        codecs.add(new VideoCodecInfo("VP8", new HashMap<String, String>()));
        if (LibvpxVp9Decoder.nativeIsSupported()) {
            codecs.add(new VideoCodecInfo("VP9", new HashMap<String, String>()));
        }
        if (LibvpxH264Decoder.nativeIsSupported()) {
            codecs.add(new VideoCodecInfo("H264", new HashMap<String, String>()));
        }
        return codecs.toArray(new VideoCodecInfo[codecs.size()]);
    }
}

