/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import android.support.annotation.Nullable;
import cn.rongcloud.rtc.core.CalledByNative;
import cn.rongcloud.rtc.core.DtmfSender;
import cn.rongcloud.rtc.core.FrameEncryptor;
import cn.rongcloud.rtc.core.JniCommon;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.core.RtpParameters;
import cn.rongcloud.rtc.utils.FinLog;

public class RtpSender {
    private static final String TAG = RtpSender.class.getSimpleName();
    private long nativeRtpSender;
    @Nullable
    private MediaStreamTrack cachedTrack;
    private boolean ownsTrack = true;
    @Nullable
    private final DtmfSender dtmfSender;
    private long nativeEncryptor;
    private DisposeObserver disposeObserver;

    @CalledByNative
    public RtpSender(long nativeRtpSender) {
        this.nativeRtpSender = nativeRtpSender;
        long nativeTrack = RtpSender.nativeGetTrack(nativeRtpSender);
        this.cachedTrack = MediaStreamTrack.createMediaStreamTrack(nativeTrack);
        long nativeDtmfSender = RtpSender.nativeGetDtmfSender(nativeRtpSender);
        this.dtmfSender = nativeDtmfSender != 0L ? new DtmfSender(nativeDtmfSender) : null;
    }

    public boolean setTrack(@Nullable MediaStreamTrack track, boolean takeOwnership) {
        this.checkRtpSenderExists();
        if (!RtpSender.nativeSetTrack(this.nativeRtpSender, track == null ? 0L : track.getNativeMediaStreamTrack())) {
            return false;
        }
        if (this.cachedTrack != null && this.ownsTrack) {
            this.cachedTrack.dispose();
        }
        this.cachedTrack = track;
        this.ownsTrack = takeOwnership;
        return true;
    }

    @Nullable
    public MediaStreamTrack track() {
        return this.cachedTrack;
    }

    public boolean setParameters(RtpParameters parameters) {
        this.checkRtpSenderExists();
        return RtpSender.nativeSetParameters(this.nativeRtpSender, parameters);
    }

    public RtpParameters getParameters() {
        this.checkRtpSenderExists();
        return RtpSender.nativeGetParameters(this.nativeRtpSender);
    }

    public String id() {
        this.checkRtpSenderExists();
        return RtpSender.nativeGetId(this.nativeRtpSender);
    }

    @Nullable
    public DtmfSender dtmf() {
        return this.dtmfSender;
    }

    public void setFrameEncryptor(FrameEncryptor frameEncryptor) {
        this.checkRtpSenderExists();
        RtpSender.nativeSetFrameEncryptor(this.nativeRtpSender, frameEncryptor.getNativeFrameEncryptor());
    }

    public void setCustomFrameEncryptor(FrameEncryptor frameEncryptor) {
        this.checkRtpSenderExists();
        if (frameEncryptor == null) {
            if (this.nativeEncryptor != 0L) {
                this.releaseCustomFrameEncryptor();
            }
        } else {
            FinLog.i(TAG, "custom_crypto frameEncryptor.getNativeFrameEncryptor() " + frameEncryptor.getNativeFrameEncryptor());
            this.nativeEncryptor = RtpSender.nativeSetCustomFrameEncryptor(this.nativeRtpSender, frameEncryptor.getNativeFrameEncryptor());
        }
    }

    public void setDisposeObserver(DisposeObserver disposeObserver) {
        this.disposeObserver = disposeObserver;
    }

    public void dispose() {
        this.checkRtpSenderExists();
        if (this.dtmfSender != null) {
            this.dtmfSender.dispose();
        }
        if (this.cachedTrack != null && this.ownsTrack) {
            this.cachedTrack.dispose();
        }
        this.releaseCustomFrameEncryptor();
        JniCommon.nativeReleaseRef(this.nativeRtpSender);
        this.nativeRtpSender = 0L;
    }

    void releaseCustomFrameEncryptor() {
        if (this.nativeEncryptor != 0L) {
            RtpSender.nativeUnsetCustomFrameEncryptor(this.nativeRtpSender, this.nativeEncryptor);
            JniCommon.nativeReleaseRef(this.nativeEncryptor);
            this.nativeEncryptor = 0L;
        }
        if (this.disposeObserver != null) {
            this.disposeObserver.onDispose(this);
        }
    }

    long getNativeRtpSender() {
        this.checkRtpSenderExists();
        return this.nativeRtpSender;
    }

    private void checkRtpSenderExists() {
        if (this.nativeRtpSender == 0L) {
            throw new IllegalStateException("RtpSender has been disposed.");
        }
    }

    private static native boolean nativeSetTrack(long var0, long var2);

    private static native long nativeGetTrack(long var0);

    private static native long nativeGetDtmfSender(long var0);

    private static native boolean nativeSetParameters(long var0, RtpParameters var2);

    private static native RtpParameters nativeGetParameters(long var0);

    private static native String nativeGetId(long var0);

    private static native void nativeSetFrameEncryptor(long var0, long var2);

    private static native long nativeSetCustomFrameEncryptor(long var0, long var2);

    private static native void nativeUnsetCustomFrameEncryptor(long var0, long var2);

    public static interface DisposeObserver {
        public void onDispose(RtpSender var1);
    }
}

