/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import android.annotation.TargetApi;
import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Environment;
import android.support.annotation.Nullable;
import android.util.Log;
import cn.rongcloud.rtc.api.callback.IRCRTCAudioDataListener;
import cn.rongcloud.rtc.base.RCRTCAudioFrame;
import cn.rongcloud.rtc.core.audio.CustomAudioTrack;
import cn.rongcloud.rtc.core.rongRTC.DevicesUtils;
import cn.rongcloud.rtc.utils.FinLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class RongAudioTrack
implements CustomAudioTrack.AudioTrackProxy {
    private static final int DEFAULT_USAGE = RongAudioTrack.getDefaultUsageAttribute();
    private static final boolean isDump = false;
    private static final String TAG = "RongAudioTrack";
    @Nullable
    private FileOutputStream fos;
    @Nullable
    private FileChannel channel;
    private int sampleRateInHz;
    private int channelConfig;
    private byte[] localFrame;
    private RCRTCAudioFrame RCRTCAudioFrame;
    private IRCRTCAudioDataListener mAudioDataListener;
    private AudioTrack audioTrack;

    private static int getDefaultUsageAttribute() {
        if (Build.VERSION.SDK_INT >= 21) {
            return 2;
        }
        return 0;
    }

    @Override
    public void init(int sampleRate, int channelConfig, int minBufferSizeInBytes) {
        this.sampleRateInHz = sampleRate;
        this.channelConfig = channelConfig;
        this.audioTrack = Build.VERSION.SDK_INT >= 21 ? RongAudioTrack.createAudioTrackOnLollipopOrHigher(sampleRate, channelConfig, minBufferSizeInBytes) : RongAudioTrack.createAudioTrackOnLowerThanLollipop(sampleRate, channelConfig, minBufferSizeInBytes);
    }

    @Override
    public int write(ByteBuffer byteBuffer, int sizeInBytes) {
        IRCRTCAudioDataListener listener = this.mAudioDataListener;
        if (listener != null) {
            if (this.localFrame == null) {
                this.localFrame = new byte[byteBuffer.capacity()];
            }
            byteBuffer.rewind();
            byteBuffer.get(this.localFrame, 0, this.localFrame.length);
            if (this.RCRTCAudioFrame == null) {
                this.RCRTCAudioFrame = new RCRTCAudioFrame();
            }
            this.RCRTCAudioFrame.setBytes(this.localFrame);
            this.RCRTCAudioFrame.setLength(this.localFrame.length);
            this.RCRTCAudioFrame.setChannels(this.channelConfig);
            this.RCRTCAudioFrame.setSampleRate(this.sampleRateInHz);
            this.RCRTCAudioFrame.setAudioFormat(2);
            byte[] customAudioBuffer = null;
            try {
                customAudioBuffer = listener.onAudioFrame(this.RCRTCAudioFrame);
            }
            catch (Exception e) {
                FinLog.e(TAG, "AudioTrack.IRemoteAudioPCMBufferListener error: " + e.getMessage());
            }
            if (customAudioBuffer != null) {
                if (customAudioBuffer.length == byteBuffer.capacity()) {
                    byteBuffer.clear();
                    byteBuffer.put(customAudioBuffer);
                } else {
                    FinLog.e(TAG, "Error:The processed data is not the same length as the original data.");
                }
                byteBuffer.rewind();
                customAudioBuffer = null;
            }
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return this.audioTrack.write(byteBuffer, sizeInBytes, 0);
        }
        return this.audioTrack.write(byteBuffer.array(), byteBuffer.arrayOffset(), sizeInBytes);
    }

    @Override
    public void play() {
        if (this.audioTrack != null) {
            this.audioTrack.play();
        }
    }

    @Override
    public void stop() {
        if (this.audioTrack != null) {
            this.audioTrack.stop();
        }
    }

    @Override
    public void release() {
        if (this.audioTrack != null) {
            this.audioTrack.release();
            this.audioTrack = null;
        }
        this.mAudioDataListener = null;
    }

    @Override
    public boolean isPlaying() {
        if (this.audioTrack != null) {
            return this.audioTrack.getPlayState() == 3;
        }
        return false;
    }

    @Override
    public boolean isInitialized() {
        if (this.audioTrack != null) {
            return this.audioTrack.getState() == 1;
        }
        return false;
    }

    @TargetApi(value=21)
    private static AudioTrack createAudioTrackOnLollipopOrHigher(int sampleRateInHz, int channelConfig, int bufferSizeInBytes) {
        int nativeOutputSampleRate = AudioTrack.getNativeOutputSampleRate((int)DevicesUtils.getAudioMode());
        if (sampleRateInHz != nativeOutputSampleRate) {
            // empty if block
        }
        return new AudioTrack(new AudioAttributes.Builder().setUsage(DEFAULT_USAGE).setContentType(DevicesUtils.getAudioTrackContentType()).build(), new AudioFormat.Builder().setEncoding(2).setSampleRate(sampleRateInHz).setChannelMask(channelConfig).build(), bufferSizeInBytes, 1, 0);
    }

    private static AudioTrack createAudioTrackOnLowerThanLollipop(int sampleRateInHz, int channelConfig, int bufferSizeInBytes) {
        return new AudioTrack(DevicesUtils.getAudioMode(), sampleRateInHz, channelConfig, 2, bufferSizeInBytes, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFileToSDCard(String filename) {
        try {
            File parent_path = Environment.getExternalStorageDirectory();
            File dir = new File(parent_path.getAbsoluteFile(), "webrtc.pcm");
            dir.mkdir();
            File file = new File(dir.getAbsoluteFile(), "myfile_" + filename + ".pcm");
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            this.fos = new FileOutputStream(file);
            this.channel = this.fos.getChannel();
            Log.d((String)TAG, (String)("kurt create file success " + file.getAbsolutePath()));
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)"kurt create file failed");
        }
    }

    private void writeFileToSDCard(ByteBuffer buffer) {
        try {
            if (this.channel != null) {
                this.channel.write(buffer);
                Log.d((String)TAG, (String)"kurt write buffer success.");
            }
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)"kurt write file failed");
        }
    }

    private void closeFileToSDCard() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
            if (this.fos != null) {
                this.fos.flush();
                this.fos.close();
            }
            this.channel = null;
            this.fos = null;
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)"kurt close file failed");
        }
    }

    public void setAudioDataListener(IRCRTCAudioDataListener listener) {
        this.mAudioDataListener = listener;
    }
}

