/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import android.media.AudioRecord;
import android.os.Environment;
import android.support.annotation.Nullable;
import android.util.Log;
import cn.rongcloud.rtc.core.audio.CustomAudioRecord;
import cn.rongcloud.rtc.core.audio.OnAudioBufferAvailableListener;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.TimeCorrector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class RongAudioRecord
implements CustomAudioRecord.AudioRecordProxy {
    private static final int TIME_INTERVAL_MILLIS = 10;
    private AudioRecord audioRecord;
    private int audioSource = -1;
    private int sampleRate;
    private int channelCount;
    private int audioFormat;
    private int channelConfig;
    private int bufferSizeInBytes;
    private OnAudioBufferAvailableListener onAudioBufferAvailableListener;
    private static final boolean isDump = false;
    private static final String TAG = "RongAudioRecord";
    @Nullable
    private FileOutputStream fos;
    @Nullable
    private FileChannel channel;
    private TimeCorrector timeCorrector;
    private boolean initialized = false;

    @Override
    public void init(int audioSource, int sampleRate, int channelConfig, int audioFormat, int bufferSizeInBytes) {
        if (this.audioSource == -1) {
            this.audioSource = audioSource;
        }
        this.sampleRate = sampleRate;
        this.channelConfig = channelConfig;
        this.channelCount = this.channelConfigToCount(channelConfig);
        this.audioFormat = audioFormat;
        this.bufferSizeInBytes = bufferSizeInBytes;
        this.timeCorrector = new TimeCorrector(10L);
        if (RTCEngineImpl.getInstance().isMicrophoneEnabled()) {
            this.audioRecord = new AudioRecord(audioSource, sampleRate, channelConfig, audioFormat, bufferSizeInBytes);
        }
        this.initialized = true;
    }

    @Override
    public int read(ByteBuffer byteBuffer, int sizeInBytes) {
        int size;
        if (this.audioRecord != null) {
            size = this.audioRecord.read(byteBuffer, sizeInBytes);
        } else {
            this.timeCorrector.waitToNextInterval();
            size = sizeInBytes;
        }
        this.onAudioBufferAvailableListener.onAudioBuffer(byteBuffer, sizeInBytes, this.sampleRate, this.channelCount, this.audioFormat);
        return size;
    }

    public synchronized void switchAudioSource(int audioSource) {
        if (this.audioRecord == null) {
            this.audioSource = audioSource;
            return;
        }
        this.audioRecord.stop();
        this.audioRecord.release();
        AudioRecord newAudioRecord = new AudioRecord(audioSource, this.sampleRate, this.channelConfig, this.audioFormat, this.bufferSizeInBytes);
        newAudioRecord.startRecording();
        FinLog.i(TAG, "audio source: " + audioSource + ", recording state: " + newAudioRecord.getRecordingState());
        this.audioRecord = newAudioRecord;
    }

    @Override
    public void start() {
        if (this.audioRecord != null) {
            this.audioRecord.startRecording();
        }
    }

    @Override
    public void stop() {
        if (this.audioRecord != null) {
            this.audioRecord.stop();
        }
    }

    @Override
    public synchronized void release() {
        if (this.audioRecord != null) {
            Log.d((String)TAG, (String)"release");
            this.audioRecord.release();
            this.audioRecord = null;
        }
        this.initialized = false;
    }

    @Override
    public boolean isRecording() {
        if (this.audioRecord != null) {
            return this.audioRecord.getRecordingState() == 3;
        }
        return this.initialized;
    }

    @Override
    public boolean isInitialized() {
        if (this.audioRecord != null) {
            return this.audioRecord.getState() == 1;
        }
        return this.initialized;
    }

    public void setOnAudioBufferAvailableListener(OnAudioBufferAvailableListener listener) {
        this.onAudioBufferAvailableListener = listener;
    }

    private int channelConfigToCount(int channelConfig) {
        return channelConfig == 12 ? 2 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFileToSDCard(String filename) {
        try {
            File parent_path = Environment.getExternalStorageDirectory();
            File dir = new File(parent_path.getAbsoluteFile(), "webrtc.pcm");
            dir.mkdir();
            File file = new File(dir.getAbsoluteFile(), "myfile_" + filename + ".pcm");
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            this.fos = new FileOutputStream(file);
            this.channel = this.fos.getChannel();
            Log.d((String)TAG, (String)("kurt create file success " + file.getAbsolutePath()));
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)"kurt create file failed");
        }
    }

    private void writeFileToSDCard(ByteBuffer buffer) {
        try {
            if (this.channel != null) {
                this.channel.write(buffer);
                Log.d((String)TAG, (String)"kurt write buffer success.");
            }
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)"kurt write file failed");
        }
    }

    private void closeFileToSDCard() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
            if (this.fos != null) {
                this.fos.flush();
                this.fos.close();
            }
            this.channel = null;
            this.fos = null;
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)"kurt close file failed");
        }
    }
}

