/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import android.support.annotation.Nullable;
import cn.rongcloud.rtc.core.CalledByNative;
import java.util.ArrayList;
import java.util.List;

public class MediaConstraints {
    public static final String kGoogEchoCancellation = "googEchoCancellation";
    public static final String kExtendedFilterEchoCancellation = "googEchoCancellation2";
    public static final String kDAEchoCancellation = "googDAEchoCancellation";
    public static final String kAutoGainControl = "googAutoGainControl";
    public static final String kExperimentalAutoGainControl = "googAutoGainControl2";
    public static final String kNoiseSuppression = "googNoiseSuppression";
    public static final String kExperimentalNoiseSuppression = "googNoiseSuppression2";
    public static final String kHighpassFilter = "googHighpassFilter";
    public static final String kTypingNoiseDetection = "googTypingNoiseDetection";
    public static final String kAudioMirroring = "googAudioMirroring";
    public static final String kAudioNetworkAdaptorConfig = "googAudioNetworkAdaptorConfig";
    public static final String kAgcDigitalCompressionGain = "agcDigitalCompressionGain";
    public final List<KeyValuePair> mandatory = new ArrayList<KeyValuePair>();
    public final List<KeyValuePair> optional = new ArrayList<KeyValuePair>();

    public void updateMandatoryValues(String key, String value) {
        KeyValuePair mandatoryElem = null;
        for (KeyValuePair pair : this.mandatory) {
            if (key == null || !key.equals(pair.key)) continue;
            mandatoryElem = pair;
            break;
        }
        if (mandatoryElem != null) {
            this.mandatory.remove(mandatoryElem);
        }
        this.mandatory.add(new KeyValuePair(key, value));
    }

    private static String stringifyKeyValuePairList(List<KeyValuePair> list) {
        StringBuilder builder = new StringBuilder("[");
        for (KeyValuePair pair : list) {
            if (builder.length() > 1) {
                builder.append(", ");
            }
            builder.append(pair.toString());
        }
        return builder.append("]").toString();
    }

    public String toString() {
        return "mandatory: " + MediaConstraints.stringifyKeyValuePairList(this.mandatory) + ", optional: " + MediaConstraints.stringifyKeyValuePairList(this.optional);
    }

    @CalledByNative
    List<KeyValuePair> getMandatory() {
        return this.mandatory;
    }

    @CalledByNative
    List<KeyValuePair> getOptional() {
        return this.optional;
    }

    public static class KeyValuePair {
        private final String key;
        private final String value;

        public KeyValuePair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @CalledByNative(value="KeyValuePair")
        public String getKey() {
            return this.key;
        }

        @CalledByNative(value="KeyValuePair")
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.key + ": " + this.value;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            KeyValuePair that = (KeyValuePair)other;
            return this.key.equals(that.key) && this.value.equals(that.value);
        }

        public int hashCode() {
            return this.key.hashCode() + this.value.hashCode();
        }
    }
}

