/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import android.media.MediaCodecInfo;
import android.os.Build;
import android.support.annotation.Nullable;
import cn.rongcloud.rtc.core.H264Utils;
import cn.rongcloud.rtc.core.VideoCodecType;
import java.util.HashMap;
import java.util.Map;

class MediaCodecUtils {
    private static final String TAG = "MediaCodecUtils";
    static final String[] SOFTWARE_IMPLEMENTATION_PREFIXES = new String[]{"OMX.google.", "OMX.SEC."};
    static final String EXYNOS_PREFIX = "OMX.Exynos.";
    static final String INTEL_PREFIX = "OMX.Intel.";
    static final String NVIDIA_PREFIX = "OMX.Nvidia.";
    static final String QCOM_PREFIX = "OMX.qcom.";
    static final String GOOGLE_PREFIX = "OMX.google.";
    static final String allwinner = "OMX.allwinner.";
    static final String IMG = "OMX.IMG.";
    static final String MTK = "OMX.MTK.";
    static final String TI = "OMX.TI.";
    static final String hisi = "OMX.hisi.";
    static final String rk = "OMX.rk.";
    static final String amlogic = "OMX.amlogic.";
    static final String sprd = "OMX.sprd.";
    static final String[] cpuPrefixList = new String[]{"OMX.Exynos.", "OMX.Intel.", "OMX.Nvidia.", "OMX.qcom.", "OMX.google.", "OMX.allwinner.", "OMX.IMG.", "OMX.MTK.", "OMX.TI.", "OMX.hisi.", "OMX.rk.", "OMX.amlogic.", "OMX.sprd."};
    static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar32m4ka = 2141391873;
    static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar16m4ka = 2141391874;
    static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    public static final int COLOR_FormatYUV420Flexible = 2135033992;
    static final int[] DECODER_COLOR_FORMATS = new int[]{2135033992, 19, 21, 2141391872, 2141391873, 2141391874, 2141391875, 2141391876};
    static final int[] ENCODER_COLOR_FORMATS = new int[]{21, 19, 2135033992, 2141391872, 2141391876, 2130708361};
    static final int[] TEXTURE_COLOR_FORMATS = MediaCodecUtils.getTextureColorFormats();

    private static int[] getTextureColorFormats() {
        if (Build.VERSION.SDK_INT >= 18) {
            return new int[]{2130708361};
        }
        return new int[0];
    }

    @Nullable
    static Integer selectColorFormat(int[] supportedColorFormats, MediaCodecInfo.CodecCapabilities capabilities) {
        for (int supportedColorFormat : supportedColorFormats) {
            for (int codecColorFormat : capabilities.colorFormats) {
                if (codecColorFormat != supportedColorFormat) continue;
                return codecColorFormat;
            }
        }
        return null;
    }

    static boolean codecSupportsType(MediaCodecInfo info, VideoCodecType type) {
        for (String mimeType : info.getSupportedTypes()) {
            if (!type.mimeType().equals(mimeType)) continue;
            return true;
        }
        return false;
    }

    static Map<String, String> getCodecProperties(VideoCodecType type, boolean highProfile) {
        switch (type) {
            case VP8: 
            case VP9: {
                return new HashMap<String, String>();
            }
            case H264: {
                return H264Utils.getDefaultH264Params(highProfile);
            }
        }
        throw new IllegalArgumentException("Unsupported codec: " + (Object)((Object)type));
    }

    private MediaCodecUtils() {
    }
}

