/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.support.annotation.Nullable;
import cn.rongcloud.rtc.core.BaseBitrateAdjuster;
import cn.rongcloud.rtc.core.BitrateAdjuster;
import cn.rongcloud.rtc.core.DynamicBitrateAdjuster;
import cn.rongcloud.rtc.core.EglBase;
import cn.rongcloud.rtc.core.EglBase14;
import cn.rongcloud.rtc.core.FramerateBitrateAdjuster;
import cn.rongcloud.rtc.core.H264Utils;
import cn.rongcloud.rtc.core.HardwareVideoEncoder;
import cn.rongcloud.rtc.core.Logging;
import cn.rongcloud.rtc.core.MediaCodecUtils;
import cn.rongcloud.rtc.core.MediaCodecUtilsProxy;
import cn.rongcloud.rtc.core.MediaCodecWrapperFactoryImpl;
import cn.rongcloud.rtc.core.Predicate;
import cn.rongcloud.rtc.core.VideoCodecInfo;
import cn.rongcloud.rtc.core.VideoCodecType;
import cn.rongcloud.rtc.core.VideoEncoder;
import cn.rongcloud.rtc.core.VideoEncoderFactory;
import java.util.ArrayList;
import java.util.List;

public class HardwareVideoEncoderFactory
implements VideoEncoderFactory {
    private static final String TAG = "HardwareVideoEncoderFactory";
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_L_MS = 15000;
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_M_MS = 20000;
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_N_MS = 15000;
    @Nullable
    private final EglBase14.Context sharedContext;
    private final boolean enableIntelVp8Encoder;
    private final boolean enableH264HighProfile;
    @Nullable
    private final Predicate<MediaCodecInfo> codecAllowedPredicate;
    private MediaCodecUtilsProxy mediaCodecUtilsProxy;
    public static List<String> encoderBlackList = new ArrayList<String>();

    public HardwareVideoEncoderFactory(EglBase.Context sharedContext, boolean enableIntelVp8Encoder, boolean enableH264HighProfile, MediaCodecUtilsProxy mediaCodecUtils) {
        this(sharedContext, enableIntelVp8Encoder, enableH264HighProfile, mediaCodecUtils, null);
    }

    public HardwareVideoEncoderFactory(EglBase.Context sharedContext, boolean enableIntelVp8Encoder, boolean enableH264HighProfile, MediaCodecUtilsProxy mediaCodecUtils, @Nullable Predicate<MediaCodecInfo> codecAllowedPredicate) {
        if (sharedContext instanceof EglBase14.Context) {
            this.sharedContext = (EglBase14.Context)sharedContext;
        } else {
            Logging.w(TAG, "No shared EglBase.Context.  Encoders will not use texture mode.");
            this.sharedContext = null;
        }
        this.enableIntelVp8Encoder = enableIntelVp8Encoder;
        this.enableH264HighProfile = enableH264HighProfile;
        this.codecAllowedPredicate = codecAllowedPredicate;
        this.mediaCodecUtilsProxy = mediaCodecUtils != null ? mediaCodecUtils : new MediaCodecUtilsProxy();
    }

    @Deprecated
    public HardwareVideoEncoderFactory(boolean enableIntelVp8Encoder, boolean enableH264HighProfile) {
        this(null, enableIntelVp8Encoder, enableH264HighProfile, null);
    }

    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo input) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        VideoCodecType type = VideoCodecType.valueOf(input.name);
        MediaCodecInfo info = this.findCodecForType(type);
        if (info == null) {
            return null;
        }
        String codecName = info.getName();
        String mime = type.mimeType();
        Integer surfaceColorFormat = MediaCodecUtils.selectColorFormat(this.mediaCodecUtilsProxy.getTextureColorFormats(), info.getCapabilitiesForType(mime));
        Integer yuvColorFormat = MediaCodecUtils.selectColorFormat(this.mediaCodecUtilsProxy.getEncoderColorFormats(), info.getCapabilitiesForType(mime));
        if (type == VideoCodecType.H264) {
            boolean isHighProfile = H264Utils.isSameH264Profile(input.params, this.mediaCodecUtilsProxy.getCodecProperties(type, true));
            boolean isBaselineProfile = H264Utils.isSameH264Profile(input.params, this.mediaCodecUtilsProxy.getCodecProperties(type, false));
            if (!isHighProfile && !isBaselineProfile) {
                return null;
            }
            if (isHighProfile && !this.isH264HighProfileSupported(info)) {
                return null;
            }
        }
        return new HardwareVideoEncoder(new MediaCodecWrapperFactoryImpl(), codecName, type, surfaceColorFormat, yuvColorFormat, input.params, this.getKeyFrameIntervalSec(type), this.getForcedKeyFrameIntervalMs(type, codecName), this.createBitrateAdjuster(type, codecName), this.sharedContext);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        if (Build.VERSION.SDK_INT < 19) {
            return new VideoCodecInfo[0];
        }
        ArrayList<VideoCodecInfo> supportedCodecInfos = new ArrayList<VideoCodecInfo>();
        for (VideoCodecType type : new VideoCodecType[]{VideoCodecType.H264}) {
            MediaCodecInfo codec = this.findCodecForType(type);
            if (codec == null) continue;
            String name = type.name();
            if (type == VideoCodecType.H264 && this.isH264HighProfileSupported(codec)) {
                supportedCodecInfos.add(new VideoCodecInfo(name, this.mediaCodecUtilsProxy.getCodecProperties(type, true)));
            }
            supportedCodecInfos.add(new VideoCodecInfo(name, this.mediaCodecUtilsProxy.getCodecProperties(type, false)));
        }
        return supportedCodecInfos.toArray(new VideoCodecInfo[supportedCodecInfos.size()]);
    }

    @Nullable
    private MediaCodecInfo findCodecForType(VideoCodecType type) {
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo info = null;
            try {
                info = MediaCodecList.getCodecInfoAt((int)i);
            }
            catch (IllegalArgumentException e) {
                Logging.e(TAG, "Cannot retrieve encoder codec info", e);
            }
            if (info == null || !info.isEncoder() || !this.isSupportedCodec(info, type)) continue;
            return info;
        }
        return null;
    }

    private boolean isSupportedCodec(MediaCodecInfo info, VideoCodecType type) {
        if (!MediaCodecUtils.codecSupportsType(info, type)) {
            return false;
        }
        if (MediaCodecUtils.selectColorFormat(MediaCodecUtils.ENCODER_COLOR_FORMATS, info.getCapabilitiesForType(type.mimeType())) == null) {
            return false;
        }
        return this.isHardwareSupportedInCurrentSdk(info, type) && this.isMediaCodecAllowed(info);
    }

    private boolean isHardwareSupportedInCurrentSdk(MediaCodecInfo info, VideoCodecType type) {
        switch (type) {
            case VP8: {
                return this.isHardwareSupportedInCurrentSdkVp8(info);
            }
            case VP9: {
                return this.isHardwareSupportedInCurrentSdkVp9(info);
            }
            case H264: {
                return this.isHardwareSupportedInCurrentSdkH264(info);
            }
        }
        return false;
    }

    private boolean isHardwareSupportedInCurrentSdkVp8(MediaCodecInfo info) {
        String name = info.getName();
        return name.startsWith("OMX.qcom.") && Build.VERSION.SDK_INT >= 19 || name.startsWith("OMX.Exynos.") && Build.VERSION.SDK_INT >= 23 || name.startsWith("OMX.Intel.") && Build.VERSION.SDK_INT >= 21 && this.enableIntelVp8Encoder;
    }

    private boolean isHardwareSupportedInCurrentSdkVp9(MediaCodecInfo info) {
        String name = info.getName();
        return (name.startsWith("OMX.qcom.") || name.startsWith("OMX.Exynos.")) && Build.VERSION.SDK_INT >= 24;
    }

    private boolean isHardwareSupportedInCurrentSdkH264(MediaCodecInfo info) {
        if (this.mediaCodecUtilsProxy.getHWExceptionList().contains(Build.MODEL)) {
            return false;
        }
        String name = info.getName();
        for (String prefix : this.mediaCodecUtilsProxy.getH264SupportCpuPrefixList()) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean isMediaCodecAllowed(MediaCodecInfo info) {
        if (this.codecAllowedPredicate == null) {
            return true;
        }
        return this.codecAllowedPredicate.test(info);
    }

    private int getKeyFrameIntervalSec(VideoCodecType type) {
        switch (type) {
            case VP8: 
            case VP9: {
                return 100;
            }
            case H264: {
                return 20;
            }
        }
        throw new IllegalArgumentException("Unsupported VideoCodecType " + (Object)((Object)type));
    }

    private int getForcedKeyFrameIntervalMs(VideoCodecType type, String codecName) {
        if (type == VideoCodecType.VP8 && codecName.startsWith("OMX.qcom.")) {
            if (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22) {
                return 15000;
            }
            if (Build.VERSION.SDK_INT == 23) {
                return 20000;
            }
            if (Build.VERSION.SDK_INT > 23) {
                return 15000;
            }
        }
        return 0;
    }

    private BitrateAdjuster createBitrateAdjuster(VideoCodecType type, String codecName) {
        if (codecName.startsWith("OMX.Exynos.")) {
            if (type == VideoCodecType.VP8) {
                return new DynamicBitrateAdjuster();
            }
            return new FramerateBitrateAdjuster();
        }
        return new BaseBitrateAdjuster();
    }

    private boolean isH264HighProfileSupported(MediaCodecInfo info) {
        if (this.enableH264HighProfile) {
            for (String prefix : this.mediaCodecUtilsProxy.getH264HighProfileCpuPrefixList()) {
                if (!info.getName().startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }
}

