/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.os.Handler;
import android.os.SystemClock;
import cn.rongcloud.rtc.core.Camera1Enumerator;
import cn.rongcloud.rtc.core.CameraEnumerationAndroid;
import cn.rongcloud.rtc.core.CameraSession;
import cn.rongcloud.rtc.core.Histogram;
import cn.rongcloud.rtc.core.Logging;
import cn.rongcloud.rtc.core.NV21Buffer;
import cn.rongcloud.rtc.core.Size;
import cn.rongcloud.rtc.core.SurfaceTextureHelper;
import cn.rongcloud.rtc.core.TextureBufferImpl;
import cn.rongcloud.rtc.core.VideoFrame;
import cn.rongcloud.rtc.core.VideoSink;
import cn.rongcloud.rtc.core.rongRTC.DevicesUtils;
import cn.rongcloud.rtc.utils.FinLog;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class Camera1Session
extends CameraSession {
    private static final String TAG = "Camera1Session";
    private static final int NUMBER_OF_CAPTURE_BUFFERS = 3;
    private static final Histogram camera1StartTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera1.StartTimeMs", 1, 10000, 50);
    private static final Histogram camera1StopTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera1.StopTimeMs", 1, 10000, 50);
    private static final Histogram camera1ResolutionHistogram = Histogram.createEnumeration("WebRTC.Android.Camera1.Resolution", CameraEnumerationAndroid.COMMON_RESOLUTIONS.size());
    private static final RectF CAMERA_RECT = new RectF(-1000.0f, -1000.0f, 1000.0f, 1000.0f);
    private static final RectF PERCENT_RECT = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
    private static final int FOCUS_SIZE = 100;
    private final Handler cameraThreadHandler;
    private final CameraSession.Events events;
    private final boolean captureToTexture;
    private final Context applicationContext;
    private final SurfaceTextureHelper surfaceTextureHelper;
    private final int cameraId;
    private final Object stateLock = new Object();
    private final Camera camera;
    private final Camera.CameraInfo info;
    private final CameraEnumerationAndroid.CaptureFormat captureFormat;
    private final long constructionTimeNs;
    private SessionState state;
    private boolean firstFrameReported;
    private static int s_cameraOrientation;
    private static int s_frameOrientation;
    private Matrix mPreviewToCameraTransform;
    private Rect adaptedFrameSize;
    private int lastFrameOrientation = -1;

    public static void create(CameraSession.CreateSessionCallback callback, CameraSession.Events events, boolean captureToTexture, Context applicationContext, SurfaceTextureHelper surfaceTextureHelper, int cameraId, int width, int height, int frameRate, int cameraOrientation, int frameOrientation) {
        CameraEnumerationAndroid.CaptureFormat captureFormat;
        Camera camera;
        long constructionTimeNs = System.nanoTime();
        Logging.d(TAG, "Open camera " + cameraId);
        events.onCameraOpening();
        try {
            camera = Camera.open((int)cameraId);
        }
        catch (RuntimeException e) {
            callback.onFailure(CameraSession.FailureType.ERROR, e.getMessage());
            return;
        }
        if (camera == null) {
            callback.onFailure(CameraSession.FailureType.ERROR, "android.hardware.Camera.open returned null for camera id = " + cameraId);
            return;
        }
        try {
            camera.setPreviewTexture(surfaceTextureHelper.getSurfaceTexture());
        }
        catch (IOException | RuntimeException e) {
            camera.release();
            callback.onFailure(CameraSession.FailureType.ERROR, e.getMessage());
            return;
        }
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
        try {
            Camera.Parameters parameters = camera.getParameters();
            captureFormat = Camera1Session.findClosestCaptureFormat(parameters, width, height, frameRate);
            Size pictureSize = Camera1Session.findClosestPictureSize(parameters, width, height);
            Camera1Session.updateCameraParameters(camera, parameters, captureFormat, pictureSize, captureToTexture);
        }
        catch (RuntimeException e) {
            camera.release();
            callback.onFailure(CameraSession.FailureType.ERROR, e.getMessage());
            return;
        }
        if (!captureToTexture) {
            int frameSize = captureFormat.frameSize();
            for (int i = 0; i < 3; ++i) {
                ByteBuffer buffer = ByteBuffer.allocateDirect(frameSize);
                camera.addCallbackBuffer(buffer.array());
            }
        }
        s_cameraOrientation = cameraOrientation;
        s_frameOrientation = frameOrientation;
        FinLog.d(TAG, "videoConfig: setDisplayOrientation : " + cameraOrientation);
        camera.setDisplayOrientation(cameraOrientation);
        callback.onDone(new Camera1Session(events, captureToTexture, applicationContext, surfaceTextureHelper, cameraId, camera, info, captureFormat, constructionTimeNs));
    }

    private static void updateCameraParameters(Camera camera, Camera.Parameters parameters, CameraEnumerationAndroid.CaptureFormat captureFormat, Size pictureSize, boolean captureToTexture) {
        Map<String, String> userCustomizedParameter;
        List focusModes = parameters.getSupportedFocusModes();
        parameters.setPreviewFpsRange(captureFormat.framerate.min, captureFormat.framerate.max);
        parameters.setPreviewSize(captureFormat.width, captureFormat.height);
        parameters.setPictureSize(pictureSize.width, pictureSize.height);
        if (!captureToTexture) {
            parameters.setPreviewFormat(captureFormat.imageFormat);
        }
        if (parameters.isVideoStabilizationSupported()) {
            parameters.setVideoStabilization(true);
        }
        if (focusModes.contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        }
        if (null != (userCustomizedParameter = DevicesUtils.getCustomizedCameraParameter())) {
            for (Map.Entry<String, String> entry : userCustomizedParameter.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                FinLog.i(TAG, "userCustomized Parameter: key=" + key + " value=" + value);
                parameters.set(key, value);
            }
        }
        camera.setParameters(parameters);
    }

    private static CameraEnumerationAndroid.CaptureFormat findClosestCaptureFormat(Camera.Parameters parameters, int width, int height, int framerate) {
        List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> supportedFramerates = Camera1Enumerator.convertFramerates(parameters.getSupportedPreviewFpsRange());
        Logging.d(TAG, "Available fps ranges: " + supportedFramerates);
        CameraEnumerationAndroid.CaptureFormat.FramerateRange fpsRange = CameraEnumerationAndroid.getClosestSupportedFramerateRange(supportedFramerates, framerate);
        Size previewSize = CameraEnumerationAndroid.getUpClosestSupportedSize(Camera1Enumerator.convertSizes(parameters.getSupportedPreviewSizes()), width, height);
        CameraEnumerationAndroid.reportCameraResolution(camera1ResolutionHistogram, previewSize);
        return new CameraEnumerationAndroid.CaptureFormat(previewSize.width, previewSize.height, fpsRange);
    }

    private static Size findClosestPictureSize(Camera.Parameters parameters, int width, int height) {
        return CameraEnumerationAndroid.getUpClosestSupportedSize(Camera1Enumerator.convertSizes(parameters.getSupportedPictureSizes()), width, height);
    }

    private Camera1Session(CameraSession.Events events, boolean captureToTexture, Context applicationContext, SurfaceTextureHelper surfaceTextureHelper, int cameraId, Camera camera, Camera.CameraInfo info, CameraEnumerationAndroid.CaptureFormat captureFormat, long constructionTimeNs) {
        Logging.d(TAG, "Create new camera1 session on camera " + cameraId);
        this.cameraThreadHandler = new Handler();
        this.events = events;
        this.captureToTexture = captureToTexture;
        this.applicationContext = applicationContext;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.cameraId = cameraId;
        this.camera = camera;
        this.info = info;
        this.captureFormat = captureFormat;
        this.constructionTimeNs = constructionTimeNs;
        surfaceTextureHelper.setTextureSize(captureFormat.width, captureFormat.height);
        this.startCapturing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isAreaFocusSupported() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == SessionState.STOPPED) {
                return false;
            }
            return this.camera.getParameters().getMaxNumFocusAreas() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isAreaExposureSupported() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == SessionState.STOPPED) {
                return false;
            }
            return this.camera.getParameters().getMaxNumMeteringAreas() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean startFocusOn(float x, float y) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == SessionState.STOPPED || !this.isAreaFocusSupported() || this.mPreviewToCameraTransform == null) {
                return false;
            }
            Rect focusArea = this.mapPoint(this.mPreviewToCameraTransform, x, y);
            Camera.Parameters parameters = this.camera.getParameters();
            List<Camera.Area> focusAreas = Collections.singletonList(new Camera.Area(focusArea, 1000));
            FinLog.i(TAG, "startFocusOn:[" + focusArea.centerX() + "," + focusArea.centerY() + "]");
            parameters.setFocusAreas(focusAreas);
            final String originalFocusMode = parameters.getFocusMode();
            parameters.setFocusMode("macro");
            this.camera.cancelAutoFocus();
            this.camera.setParameters(parameters);
            this.camera.autoFocus(new Camera.AutoFocusCallback(){

                public void onAutoFocus(boolean success, Camera camera) {
                    Camera.Parameters params = camera.getParameters();
                    params.setFocusMode(originalFocusMode);
                    camera.setParameters(params);
                }
            });
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean startExposureOn(float x, float y) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == SessionState.STOPPED || !this.isAreaExposureSupported() || this.mPreviewToCameraTransform == null) {
                return false;
            }
            Rect focusArea = this.mapPoint(this.mPreviewToCameraTransform, x, y);
            Camera.Parameters parameters = this.camera.getParameters();
            List<Camera.Area> focusAreas = Collections.singletonList(new Camera.Area(focusArea, 1000));
            parameters.setMeteringAreas(focusAreas);
            this.camera.setParameters(parameters);
            return true;
        }
    }

    private Rect mapPoint(Matrix matrix, float x, float y) {
        float[] tapPoints = new float[]{x, y};
        matrix.mapPoints(tapPoints);
        tapPoints[0] = Camera1Session.clamp(tapPoints[0]);
        tapPoints[1] = Camera1Session.clamp(tapPoints[1]);
        return new Rect((int)(tapPoints[0] - 100.0f), (int)(tapPoints[1] - 100.0f), (int)(tapPoints[0] + 100.0f), (int)(tapPoints[1] + 100.0f));
    }

    private static float clamp(float x) {
        return Math.max(-899.0f, Math.min(899.0f, x));
    }

    private void updateAdaptedFrameSize(VideoFrame frame) {
        int adaptedFrameHeight;
        int adaptedFrameWidth;
        if (frame.getRotation() % 180 == 0) {
            adaptedFrameWidth = frame.getAdaptedWidth();
            adaptedFrameHeight = frame.getAdaptedHeight();
        } else {
            adaptedFrameWidth = frame.getAdaptedHeight();
            adaptedFrameHeight = frame.getAdaptedWidth();
        }
        this.adaptedFrameSize = new Rect(0, 0, adaptedFrameWidth, adaptedFrameHeight);
        this.mPreviewToCameraTransform = this.previewToCameraTransform(adaptedFrameWidth, adaptedFrameHeight, frame.getRotation());
    }

    private Matrix previewToCameraTransform(int frameWidth, int frameHeight, int frameRotation) {
        RectF frameRect = new RectF(0.0f, 0.0f, (float)frameWidth, (float)frameHeight);
        RectF previewRect = frameRotation % 180 == 0 ? new RectF(0.0f, 0.0f, (float)this.captureFormat.width, (float)this.captureFormat.height) : new RectF(0.0f, 0.0f, (float)this.captureFormat.height, (float)this.captureFormat.width);
        boolean mirrorX = this.info.facing == 1;
        Matrix percentToFrame = new Matrix();
        percentToFrame.setRectToRect(PERCENT_RECT, frameRect, Matrix.ScaleToFit.FILL);
        Matrix frameToPreview = new Matrix();
        frameToPreview.setRectToRect(frameRect, previewRect, Matrix.ScaleToFit.FILL);
        Matrix previewToCamera = new Matrix();
        previewToCamera.setRectToRect(previewRect, CAMERA_RECT, Matrix.ScaleToFit.FILL);
        Matrix transform = new Matrix();
        transform.postConcat(percentToFrame);
        transform.postConcat(frameToPreview);
        transform.postConcat(previewToCamera);
        transform.postScale(mirrorX ? -1.0f : 1.0f, 1.0f);
        transform.postRotate((float)(Camera1Session.getDeviceOrientation(this.applicationContext) - this.info.orientation + s_cameraOrientation));
        return transform;
    }

    @Override
    Rect getAdaptedFrameSize() {
        return this.adaptedFrameSize;
    }

    @Override
    public void stop() {
        Logging.d(TAG, "Stop camera1 session on camera " + this.cameraId);
        this.checkIsOnCameraThread();
        if (this.state != SessionState.STOPPED) {
            long stopStartTime = System.nanoTime();
            this.stopInternal();
            int stopTimeMs = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - stopStartTime);
            camera1StopTimeMsHistogram.addSample(stopTimeMs);
        }
    }

    private void startCapturing() {
        Logging.d(TAG, "Start capturing");
        this.checkIsOnCameraThread();
        this.state = SessionState.RUNNING;
        this.camera.setErrorCallback(new Camera.ErrorCallback(){

            public void onError(int error, Camera camera) {
                String errorMessage = error == 100 ? "Camera server died!" : "Camera error: " + error;
                Logging.e(Camera1Session.TAG, errorMessage);
                Camera1Session.this.stopInternal();
                if (error == 2) {
                    Camera1Session.this.events.onCameraDisconnected(Camera1Session.this);
                } else {
                    Camera1Session.this.events.onCameraError(Camera1Session.this, errorMessage);
                }
            }
        });
        if (this.captureToTexture) {
            this.listenForTextureFrames();
        } else {
            this.listenForBytebufferFrames();
        }
        try {
            this.camera.startPreview();
            this.events.onCameraStarted(this);
        }
        catch (RuntimeException e) {
            this.stopInternal();
            this.events.onCameraError(this, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopInternal() {
        Logging.d(TAG, "Stop internal");
        this.checkIsOnCameraThread();
        if (this.state == SessionState.STOPPED) {
            Logging.d(TAG, "Camera is already stopped");
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.state = SessionState.STOPPED;
            this.surfaceTextureHelper.stopListening();
            this.camera.stopPreview();
            this.camera.release();
        }
        this.events.onCameraClosed(this);
        Logging.d(TAG, "Stop done");
    }

    private void listenForTextureFrames() {
        this.surfaceTextureHelper.startListening(new TextureSinkListener());
    }

    private void listenForBytebufferFrames() {
        this.camera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(){

            public void onPreviewFrame(byte[] data, Camera callbackCamera) {
                Camera1Session.this.checkIsOnCameraThread();
                if (callbackCamera != Camera1Session.this.camera) {
                    Logging.e(Camera1Session.TAG, "Callback from a different camera. This should never happen.");
                    return;
                }
                if (Camera1Session.this.state != SessionState.RUNNING) {
                    Logging.d(Camera1Session.TAG, "Bytebuffer frame captured but camera is no longer running.");
                    return;
                }
                long captureTimeNs = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
                if (!Camera1Session.this.firstFrameReported) {
                    int startTimeMs = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - Camera1Session.this.constructionTimeNs);
                    camera1StartTimeMsHistogram.addSample(startTimeMs);
                    Camera1Session.this.firstFrameReported = true;
                }
                NV21Buffer frameBuffer = new NV21Buffer(data, ((Camera1Session)Camera1Session.this).captureFormat.width, ((Camera1Session)Camera1Session.this).captureFormat.height, new NV21BufferRunnable(data, Camera1Session.this));
                VideoFrame frame = new VideoFrame(frameBuffer, Camera1Session.this.getFrameOrientation(), captureTimeNs);
                Camera1Session.this.events.onFrameCaptured(Camera1Session.this, frame);
                Camera1Session.this.updateAdaptedFrameSize(frame);
                frame.release();
            }
        });
    }

    private int getFrameOrientation() {
        int frameOrientation;
        int finalFrameOrientation;
        int rotation = CameraSession.getDeviceOrientation(this.applicationContext);
        if (this.info.facing == 0) {
            rotation = 360 - rotation;
        }
        if (this.lastFrameOrientation != (finalFrameOrientation = (frameOrientation = s_frameOrientation) == -1 ? (this.info.orientation + rotation) % 360 : frameOrientation)) {
            this.lastFrameOrientation = finalFrameOrientation;
            Logging.d(TAG, "videoConfig: camera final frame orientation " + finalFrameOrientation + " frame orientation " + frameOrientation);
        }
        return finalFrameOrientation;
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            throw new IllegalStateException("Wrong thread");
        }
    }

    private static class CameraThreadHandlerRunnable
    implements Runnable {
        private byte[] data;
        private WeakReference<Camera1Session> session;

        public CameraThreadHandlerRunnable(byte[] data, WeakReference<Camera1Session> session) {
            this.data = data;
            this.session = session;
        }

        @Override
        public void run() {
            if (this.session.get() != null && ((Camera1Session)this.session.get()).state == SessionState.RUNNING) {
                ((Camera1Session)this.session.get()).camera.addCallbackBuffer(this.data);
            }
        }
    }

    private static class NV21BufferRunnable
    implements Runnable {
        private byte[] data;
        private WeakReference<Camera1Session> session;

        public NV21BufferRunnable(byte[] data, Camera1Session camera1Session) {
            this.data = data;
            this.session = new WeakReference<Camera1Session>(camera1Session);
        }

        @Override
        public void run() {
            ((Camera1Session)this.session.get()).cameraThreadHandler.post((Runnable)new CameraThreadHandlerRunnable(this.data, this.session));
        }
    }

    private class TextureSinkListener
    implements VideoSink {
        private TextureSinkListener() {
        }

        @Override
        public void onFrame(VideoFrame frame) {
            Camera1Session.this.checkIsOnCameraThread();
            if (Camera1Session.this.state != SessionState.RUNNING) {
                Logging.d(Camera1Session.TAG, "Texture frame captured but camera is no longer running.");
                return;
            }
            if (!Camera1Session.this.firstFrameReported) {
                int startTimeMs = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - Camera1Session.this.constructionTimeNs);
                camera1StartTimeMsHistogram.addSample(startTimeMs);
                Camera1Session.this.firstFrameReported = true;
            }
            VideoFrame modifiedFrame = new VideoFrame(CameraSession.createTextureBufferWithModifiedTransformMatrix((TextureBufferImpl)frame.getBuffer(), ((Camera1Session)Camera1Session.this).info.facing == 1, 0), Camera1Session.this.getFrameOrientation(), frame.getTimestampNs());
            Camera1Session.this.events.onFrameCaptured(Camera1Session.this, modifiedFrame);
            Camera1Session.this.updateAdaptedFrameSize(modifiedFrame);
            modifiedFrame.release();
        }
    }

    private static enum SessionState {
        RUNNING,
        STOPPED;

    }
}

