/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center.stream;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import cn.rongcloud.rtc.api.callback.IRCRTCVideoOutputFrameListener;
import cn.rongcloud.rtc.api.callback.IRCRTCVideoSource;
import cn.rongcloud.rtc.api.stream.RCRTCTextureView;
import cn.rongcloud.rtc.api.stream.RCRTCVideoOutputStream;
import cn.rongcloud.rtc.api.stream.RCRTCVideoStreamConfig;
import cn.rongcloud.rtc.api.stream.RCRTCVideoView;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.base.RCRTCStreamType;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.config.RCVideoConfigImpl;
import cn.rongcloud.rtc.center.stream.RCOutputStreamImpl;
import cn.rongcloud.rtc.core.CapturerObserver;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.core.NV21Buffer;
import cn.rongcloud.rtc.core.RendererCommon;
import cn.rongcloud.rtc.core.TextureBufferImpl;
import cn.rongcloud.rtc.core.VideoFrame;
import cn.rongcloud.rtc.core.VideoSource;
import cn.rongcloud.rtc.core.VideoTrack;
import cn.rongcloud.rtc.core.YuvConverter;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.webrtc.ILocalVideoStreamResource;
import java.util.concurrent.TimeUnit;

public class RCVideoOutStreamImpl
extends RCOutputStreamImpl
implements RCRTCVideoOutputStream,
IRCRTCVideoSource.IRCVideoConsumer,
ILocalVideoStreamResource,
CapturerObserver {
    private static final String TAG = "RCVideoOutStreamImpl";
    protected RCRTCVideoView mVideoView;
    protected RCRTCTextureView mTextureView;
    protected RCRTCStreamType mStreamType = RCRTCStreamType.NORMAL;
    protected RCRTCVideoStreamConfig videoStreamConfig = RCRTCVideoStreamConfig.Builder.create().build();
    private IRCRTCVideoSource source;
    protected CapturerObserver mVideoObserver;
    private Handler handler;
    private YuvConverter yuvConverter;

    public RCVideoOutStreamImpl(String tag, String userId) {
        super(tag, RCRTCMediaType.VIDEO, RCVideoOutStreamImpl.makeStreamId(userId, tag));
        this.setUserId(userId);
    }

    @Override
    public synchronized void setSource(IRCRTCVideoSource source) {
        this.source = source;
        if (source != null) {
            source.onInit(this);
        }
    }

    @Override
    public synchronized void setVideoView(RCRTCVideoView videoView) {
        this.onUnbindingSink();
        this.mVideoView = videoView;
        this.onBindingSink();
    }

    @Override
    public synchronized RCRTCVideoView getVideoView() {
        return this.mVideoView;
    }

    @Override
    public void setTextureView(RCRTCTextureView textureView) {
        this.onUnbindingSink();
        this.mTextureView = textureView;
        this.onBindingSink();
    }

    @Override
    public void setTrack(MediaStreamTrack track) {
        super.setTrack(track);
        if (track != null && track instanceof VideoTrack) {
            VideoSource videoSource = ((VideoTrack)track).getVideoSource();
            this.mVideoObserver = videoSource.getCapturerObserver();
        }
        this.onBindingSink();
    }

    private synchronized void onUnbindingSink() {
        if (this.track != null && this.track instanceof VideoTrack) {
            if (this.mVideoView != null) {
                final RCRTCVideoView videoView = this.mVideoView;
                RTCEngineImpl.getInstance().postUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ((VideoTrack)RCVideoOutStreamImpl.this.track).removeSink(videoView);
                        videoView.release();
                    }
                });
            }
            if (this.mTextureView != null) {
                final RCRTCTextureView textureView = this.mTextureView;
                RTCEngineImpl.getInstance().postUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ((VideoTrack)RCVideoOutStreamImpl.this.track).removeSink(textureView);
                        textureView.release();
                    }
                });
            }
        }
    }

    private synchronized void onBindingSink() {
        if (this.track != null && this.track instanceof VideoTrack) {
            if (this.mVideoView != null) {
                ReportUtil.appTask(ReportUtil.TAG.SETLOCALRENDERVIEW, "trackId|viewIdentity", this.track.id(), this.mVideoView.hashCode());
                RTCEngineImpl.getInstance().postUIThread(new Runnable(){

                    @Override
                    public void run() {
                        RCRTCVideoView videoView = RCVideoOutStreamImpl.this.mVideoView;
                        MediaStreamTrack track = RCVideoOutStreamImpl.this.track;
                        if (track == null || videoView == null) {
                            ReportUtil.appError(ReportUtil.TAG.SETLOCALRENDERVIEW, "code|desc", RTCErrorCode.UnknownError.getValue(), "RCRTCVideoView or MediaStreamTrack is Null");
                            return;
                        }
                        videoView.setIsLocal(true);
                        videoView.init(RTCEngineImpl.getInstance().getEglBaseContext(), new RendererCommon.RendererEvents(){

                            @Override
                            public void onFirstFrameRendered() {
                                RTCEngineImpl.getInstance().onFirstFrameRendered(RCVideoOutStreamImpl.this.getUserId(), RCVideoOutStreamImpl.this.getTag());
                            }

                            @Override
                            public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
                            }

                            @Override
                            public void onCreateEglFailed(Exception e) {
                                RTCEngineImpl.getInstance().onCreateEglFailed(RCVideoOutStreamImpl.this.getUserId(), RCVideoOutStreamImpl.this.getTag(), e);
                            }
                        });
                        try {
                            ((VideoTrack)track).addSink(videoView);
                            ReportUtil.appRes(ReportUtil.TAG.SETLOCALRENDERVIEW, "trackId|viewIdentity", track.id(), videoView.hashCode());
                        }
                        catch (Exception e) {
                            ReportUtil.appError(ReportUtil.TAG.SETLOCALRENDERVIEW, "code|desc", RTCErrorCode.UnknownError.getValue(), e.getMessage());
                            e.printStackTrace();
                        }
                    }
                });
            } else if (this.mTextureView != null) {
                RTCEngineImpl.getInstance().postUIThread(new Runnable(){

                    @Override
                    public void run() {
                        RCRTCTextureView textureView = RCVideoOutStreamImpl.this.mTextureView;
                        MediaStreamTrack track = RCVideoOutStreamImpl.this.track;
                        if (track == null || textureView == null) {
                            ReportUtil.appError(ReportUtil.TAG.SETLOCALRENDERVIEW, "code|desc", RTCErrorCode.UnknownError.getValue(), "RCRTCVideoView or MediaStreamTrack is Null");
                            return;
                        }
                        textureView.setIsLocal(true);
                        textureView.init(RTCEngineImpl.getInstance().getEglBaseContext(), new RendererCommon.RendererEvents(){

                            @Override
                            public void onFirstFrameRendered() {
                                RTCEngineImpl.getInstance().onFirstFrameRendered(RCVideoOutStreamImpl.this.getUserId(), RCVideoOutStreamImpl.this.getTag());
                            }

                            @Override
                            public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
                            }

                            @Override
                            public void onCreateEglFailed(Exception e) {
                                RTCEngineImpl.getInstance().onCreateEglFailed(RCVideoOutStreamImpl.this.getUserId(), RCVideoOutStreamImpl.this.getTag(), e);
                            }
                        });
                        try {
                            ((VideoTrack)track).addSink(textureView);
                            ReportUtil.appRes(ReportUtil.TAG.SETLOCALRENDERVIEW, "trackId|viewIdentity", track.id(), textureView.hashCode());
                        }
                        catch (Exception e) {
                            ReportUtil.appError(ReportUtil.TAG.SETLOCALRENDERVIEW, "code|desc", RTCErrorCode.UnknownError.getValue(), e.getMessage());
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
    }

    @Override
    public synchronized void writeTexture(int width, int height, int oesTextureId, float[] transformMatrix, int rotation, long timestamp) {
        if (this.mVideoObserver == null) {
            FinLog.e(TAG, "videoObserver is null");
            return;
        }
        if (this.handler == null || this.yuvConverter == null) {
            HandlerThread thread = new HandlerThread("Thread_" + this.getTag());
            thread.start();
            this.handler = new Handler(thread.getLooper());
            this.yuvConverter = new YuvConverter();
        }
        TextureBufferImpl buffer = new TextureBufferImpl(width, height, VideoFrame.TextureBuffer.Type.OES, oesTextureId, RendererCommon.convertMatrixToAndroidGraphicsMatrix(transformMatrix), this.handler, this.yuvConverter, new Runnable(){

            @Override
            public void run() {
            }
        });
        VideoFrame frame = new VideoFrame(buffer, rotation, timestamp);
        this.onFrameCaptured(frame);
    }

    @Override
    public synchronized void writeYuvData(byte[] data, int width, int height, int rotation) {
        if (this.mVideoObserver == null) {
            FinLog.e(TAG, "videoObserver is null");
            return;
        }
        NV21Buffer frameBuffer = new NV21Buffer(data, width, height, new Runnable(){

            @Override
            public void run() {
            }
        });
        long captureTimeNs = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
        VideoFrame frame = new VideoFrame(frameBuffer, rotation, captureTimeNs);
        this.onFrameCaptured(frame);
    }

    @Override
    public void setVideoConfig(RCRTCVideoStreamConfig config) {
        if (config == null) {
            return;
        }
        ReportUtil.libStatus(ReportUtil.TAG.RTCVIDEOCONFIG, "config", ((RCVideoConfigImpl)config).formatLogString());
        this.videoStreamConfig = config;
    }

    @Override
    public RCRTCVideoStreamConfig getVideoConfig() {
        return this.videoStreamConfig;
    }

    @Override
    public int getWidth() {
        return this.videoStreamConfig.getVideoResolution().getWidth();
    }

    @Override
    public int getHeight() {
        return this.videoStreamConfig.getVideoResolution().getHeight();
    }

    @Override
    public int getMaxBitrate() {
        return (int)(this.getVideoFps().getMultiplier() * (float)this.videoStreamConfig.getVideoResolution().getMaxBitRate());
    }

    @Override
    public int getMinBitrate() {
        return (int)(this.getVideoFps().getMultiplier() * (float)this.videoStreamConfig.getVideoResolution().getMinBitRate());
    }

    @Override
    public RCRTCParamsType.RCRTCVideoFps getVideoFps() {
        return this.videoStreamConfig.getVideoFps();
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    @Override
    public RCRTCStreamType getStreamType() {
        return this.mStreamType;
    }

    @Override
    public boolean isPreserved() {
        return false;
    }

    @Override
    public synchronized void start() {
        if (this.source != null) {
            this.source.onStart();
        }
    }

    @Override
    public synchronized void stop() {
        super.stop();
        if (this.source != null) {
            this.source.onStop();
        }
    }

    @Override
    public void setVideoFrameListener(IRCRTCVideoOutputFrameListener videoFrameListener) {
    }

    @Override
    public void release() {
        super.release();
        this.mVideoObserver = null;
        if (this.handler != null) {
            this.handler.getLooper().quit();
        }
        this.handler = null;
        if (this.yuvConverter != null) {
            this.yuvConverter.release();
        }
        this.yuvConverter = null;
        if (this.mVideoView != null) {
            this.mVideoView.release();
        }
        this.mVideoView = null;
        if (this.source != null) {
            this.source.onDispose();
        }
        this.source = null;
    }

    @Override
    public void onCapturerStarted(boolean success) {
        CapturerObserver observer = this.mVideoObserver;
        if (observer != null) {
            observer.onCapturerStarted(success);
        }
    }

    @Override
    public void onCapturerStopped() {
        CapturerObserver observer = this.mVideoObserver;
        if (observer != null) {
            observer.onCapturerStopped();
        }
    }

    @Override
    public void onFrameCaptured(VideoFrame frame) {
        CapturerObserver observer = this.mVideoObserver;
        if (observer != null) {
            observer.onFrameCaptured(frame);
        }
    }
}

