/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center.stream;

import cn.rongcloud.rtc.api.stream.RCRTCTextureView;
import cn.rongcloud.rtc.api.stream.RCRTCVideoInputStream;
import cn.rongcloud.rtc.api.stream.RCRTCVideoView;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RCRTCStreamType;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.stream.RCInputStreamImpl;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.core.RendererCommon;
import cn.rongcloud.rtc.core.VideoTrack;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.proxy.message.messagebeans.MediaResourceInfo;
import cn.rongcloud.rtc.utils.ReportUtil;
import cn.rongcloud.rtc.webrtc.IRemoteVideoStreamResource;

public class RCVideoInputStreamImpl
extends RCInputStreamImpl
implements RCRTCVideoInputStream,
IRemoteVideoStreamResource {
    private static final String TAG = "RCVideoInputStreamImpl";
    private RCRTCVideoView mVideoView;
    private RCRTCStreamType mStreamType = RCRTCStreamType.TINY;
    private RCRTCTextureView mTextureView;

    public RCVideoInputStreamImpl(String userId, String tag, String streamId, String uri) {
        super(userId, tag, RCRTCMediaType.VIDEO, streamId, uri);
    }

    public RCVideoInputStreamImpl(String userId, String tag, String streamId) {
        super(userId, tag, RCRTCMediaType.VIDEO, streamId, "");
    }

    public RCVideoInputStreamImpl(String userId, MediaResourceInfo mediaResourceInfo) {
        super(userId, mediaResourceInfo.getTag(), RCRTCMediaType.VIDEO, mediaResourceInfo.getStreamId(), mediaResourceInfo.getUri());
        this.setResourceState(mediaResourceInfo.getRCRTCResourceState());
    }

    @Override
    public synchronized void setVideoView(RCRTCVideoView videoView) {
        this.onUnbindingSink();
        this.mVideoView = videoView;
        this.onBindingSink();
    }

    @Override
    public void setTrack(MediaStreamTrack track) {
        this.onUnbindingSink();
        super.setTrack(track);
        this.onBindingSink();
    }

    private synchronized void onUnbindingSink() {
        if (this.track != null && this.track instanceof VideoTrack) {
            if (this.mVideoView != null) {
                final RCRTCVideoView videoView = this.mVideoView;
                RTCEngineImpl.getInstance().postUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ((VideoTrack)RCVideoInputStreamImpl.this.track).removeSink(videoView);
                        videoView.release();
                    }
                });
            }
            if (this.mTextureView != null) {
                final RCRTCTextureView textureView = this.mTextureView;
                RTCEngineImpl.getInstance().postUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ((VideoTrack)RCVideoInputStreamImpl.this.track).removeSink(textureView);
                        textureView.release();
                    }
                });
            }
        }
    }

    private synchronized void onBindingSink() {
        if (this.track != null && this.track instanceof VideoTrack) {
            if (this.mVideoView != null) {
                ReportUtil.appTask(ReportUtil.TAG.SETREMOTERENDERVIEW, "trackId|viewIdentity", this.track.id(), this.mVideoView.hashCode());
                RTCEngineImpl.getInstance().postUIThread(new Runnable(){

                    @Override
                    public void run() {
                        RCRTCVideoView videoView = RCVideoInputStreamImpl.this.mVideoView;
                        MediaStreamTrack track = RCVideoInputStreamImpl.this.track;
                        if (track == null || videoView == null) {
                            ReportUtil.appError(ReportUtil.TAG.SETREMOTERENDERVIEW, "code|desc", RTCErrorCode.UnknownError.getValue(), "RCRTCVideoView or MediaStreamTrack is Null");
                            return;
                        }
                        videoView.setIsLocal(false);
                        videoView.init(RTCEngineImpl.getInstance().getEglBaseContext(), new RendererCommon.RendererEvents(){

                            @Override
                            public void onFirstFrameRendered() {
                                RTCEngineImpl.getInstance().onFirstFrameRendered(RCVideoInputStreamImpl.this.getUserId(), RCVideoInputStreamImpl.this.getTag());
                            }

                            @Override
                            public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
                            }

                            @Override
                            public void onCreateEglFailed(Exception e) {
                                RTCEngineImpl.getInstance().onCreateEglFailed(RCVideoInputStreamImpl.this.getUserId(), RCVideoInputStreamImpl.this.getTag(), e);
                            }
                        });
                        try {
                            ((VideoTrack)track).addSink(videoView);
                            ReportUtil.appRes(ReportUtil.TAG.SETREMOTERENDERVIEW, "trackId|viewIdentity", track.id(), videoView.hashCode());
                        }
                        catch (Exception e) {
                            ReportUtil.appError(ReportUtil.TAG.SETREMOTERENDERVIEW, "code|desc", RTCErrorCode.UnknownError.getValue(), e.getMessage());
                            e.printStackTrace();
                        }
                    }
                });
            } else if (this.mTextureView != null) {
                RTCEngineImpl.getInstance().postUIThread(new Runnable(){

                    @Override
                    public void run() {
                        RCRTCTextureView textureView = RCVideoInputStreamImpl.this.mTextureView;
                        MediaStreamTrack track = RCVideoInputStreamImpl.this.track;
                        if (track == null || textureView == null) {
                            ReportUtil.appError(ReportUtil.TAG.SETREMOTERENDERVIEW, "code|desc", RTCErrorCode.UnknownError.getValue(), "RCRTCVideoView or MediaStreamTrack is Null");
                            return;
                        }
                        textureView.setIsLocal(false);
                        textureView.init(RTCEngineImpl.getInstance().getEglBaseContext(), new RendererCommon.RendererEvents(){

                            @Override
                            public void onFirstFrameRendered() {
                                RTCEngineImpl.getInstance().onFirstFrameRendered(RCVideoInputStreamImpl.this.getUserId(), RCVideoInputStreamImpl.this.getTag());
                            }

                            @Override
                            public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
                            }

                            @Override
                            public void onCreateEglFailed(Exception e) {
                                RTCEngineImpl.getInstance().onCreateEglFailed(RCVideoInputStreamImpl.this.getUserId(), RCVideoInputStreamImpl.this.getTag(), e);
                            }
                        });
                        try {
                            ((VideoTrack)track).addSink(textureView);
                            ReportUtil.appRes(ReportUtil.TAG.SETREMOTERENDERVIEW, "trackId|viewIdentity", track.id(), textureView.hashCode());
                        }
                        catch (Exception e) {
                            ReportUtil.appError(ReportUtil.TAG.SETREMOTERENDERVIEW, "code|desc", RTCErrorCode.UnknownError.getValue(), e.getMessage());
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
    }

    @Override
    public synchronized RCRTCVideoView getVideoView() {
        return this.mVideoView;
    }

    @Override
    public void setTextureView(RCRTCTextureView textureView) {
        this.mTextureView = textureView;
        this.onBindingSink();
    }

    @Override
    public RCRTCTextureView getTextureView() {
        return this.mTextureView;
    }

    @Override
    public void setStreamType(RCRTCStreamType streamType) {
        this.mStreamType = streamType;
    }

    @Override
    public RCRTCStreamType getStreamType() {
        return this.mStreamType;
    }

    @Override
    public void release() {
        super.release();
        if (this.mVideoView != null) {
            this.mVideoView.release();
        }
        this.mVideoView = null;
    }
}

