/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center.stream;

import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RCRTCResourceState;
import cn.rongcloud.rtc.base.RCRTCStream;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.webrtc.IStreamResource;

public class RCStreamImpl
implements RCRTCStream,
IStreamResource {
    protected String streamId;
    private RCRTCMediaType type;
    private String uri;
    private String tag;
    private String features;
    protected MediaStreamTrack track;
    private String userId;
    private RCRTCResourceState resourceState = RCRTCResourceState.NORMAL;
    private boolean enable = true;

    public RCStreamImpl(String tag, RCRTCMediaType type, String streamId) {
        this.tag = tag;
        this.type = type;
        this.streamId = streamId;
    }

    @Override
    public String getStreamId() {
        return this.streamId;
    }

    @Override
    public RCRTCMediaType getMediaType() {
        return this.type;
    }

    public void setType(RCRTCMediaType type) {
        this.type = type;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getFeatures() {
        return this.features;
    }

    public void setFeatures(String features) {
        this.features = features;
    }

    @Override
    public RCRTCResourceState getResourceState() {
        return this.resourceState;
    }

    @Override
    public synchronized void mute(boolean mute) {
        boolean bl = this.enable = !mute;
        if (this.track != null) {
            this.track.setEnabled(this.enable);
        }
    }

    @Override
    public boolean isMute() {
        if (this.track != null) {
            return !this.track.enabled();
        }
        return !this.enable;
    }

    @Override
    public void setTrack(MediaStreamTrack track) {
        if (track == null) {
            return;
        }
        this.track = track;
        this.track.setEnabled(this.enable);
    }

    @Override
    public MediaStreamTrack getTrack() {
        return this.track;
    }

    public String getUserId() {
        return this.userId;
    }

    protected void setUserId(String userId) {
        this.userId = userId;
    }

    public void setResourceState(RCRTCResourceState resourceState) {
        this.resourceState = resourceState;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void release() {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        this.track = null;
    }

    public static String makeStreamId(String userId, String tag) {
        return String.format("%s_%s", userId, tag);
    }

    public String toString() {
        return "RCStreamImpl{streamId='" + this.streamId + '\'' + ", type=" + (Object)((Object)this.type) + ", uri='" + this.uri + '\'' + ", tag='" + this.tag + '\'' + ", userId='" + this.userId + '\'' + ", resourceState=" + (Object)((Object)this.resourceState) + ", enable=" + this.enable + '}';
    }
}

