/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center.stream;

import cn.rongcloud.rtc.api.IAudioEffectManager;
import cn.rongcloud.rtc.api.callback.IRCRTCAudioDataListener;
import cn.rongcloud.rtc.api.stream.RCRTCAudioStreamConfig;
import cn.rongcloud.rtc.api.stream.RCRTCMicOutputStream;
import cn.rongcloud.rtc.base.RCRTCAudioFrame;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.base.RCRTCSyncCallBack;
import cn.rongcloud.rtc.center.config.RCRTCConfigImpl;
import cn.rongcloud.rtc.center.stream.RCAudioOutputStreamImpl;
import cn.rongcloud.rtc.center.stream.RCAudioStreamConfigImpl;
import cn.rongcloud.rtc.core.AudioTrack;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.core.audio.AudioEffectManager;
import cn.rongcloud.rtc.core.audio.OnAudioBufferAvailableListener;
import cn.rongcloud.rtc.earmonitor.EarMonitorManager;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.module.AudioDeviceManager;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import java.util.concurrent.atomic.AtomicBoolean;

public class RCMicOutputStreamImpl
extends RCAudioOutputStreamImpl
implements RCRTCMicOutputStream {
    private static final String TAG = RCMicOutputStreamImpl.class.getSimpleName();
    private AudioDeviceManager mAudioDeviceManager;
    private AudioEffectManager mAudioEffectManager;
    private EarMonitorManager mEarMonitorManager;
    private RCRTCAudioStreamConfig audioConfig;
    private AtomicBoolean needUpdateConfig = new AtomicBoolean(false);

    public RCMicOutputStreamImpl(String userId, AudioDeviceManager audioDeviceManager, AudioEffectManager audioEffectManager) {
        super("RongCloudRTC", userId);
        this.mAudioEffectManager = audioEffectManager;
        this.mAudioDeviceManager = audioDeviceManager;
        this.mAudioDeviceManager.registerAudioBufferListener(this.mAudioEffectManager);
        this.mAudioDeviceManager.setAudioDataListener(new IRCRTCAudioDataListener(){

            @Override
            public byte[] onAudioFrame(RCRTCAudioFrame rcRTCAudioFrame) {
                IRCRTCAudioDataListener audioDataListener = RCMicOutputStreamImpl.this.mAudioDataListener;
                if (audioDataListener != null) {
                    return audioDataListener.onAudioFrame(rcRTCAudioFrame);
                }
                return null;
            }
        });
        RCRTCConfigImpl rtcConfig = RTCEngineImpl.getInstance().getRTCConfig();
        if (rtcConfig != null && rtcConfig.isLowLatencyRecordingEnabled()) {
            this.mEarMonitorManager = new EarMonitorManager();
            this.mEarMonitorManager.init(RTCEngineImpl.getInstance().getContext(), this.mAudioDeviceManager);
        }
    }

    @Override
    public void adjustRecordingVolume(int volume) {
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null) {
            audioDeviceManager.adjustRecordingVolume(volume);
        } else {
            FinLog.e(TAG, "adjustRecordingVolume Failed: AudioDeviceManager is Null");
        }
    }

    @Override
    public int getRecordingVolume() {
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null) {
            return audioDeviceManager.getRecodVolume();
        }
        return 0;
    }

    @Override
    public void release() {
        EarMonitorManager earMonitorManager;
        AudioEffectManager audioEffectManager;
        super.release();
        this.resetStream();
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null) {
            audioDeviceManager.setAudioDataListener(null);
            audioDeviceManager.release();
            this.mAudioDeviceManager = null;
        }
        if ((audioEffectManager = this.mAudioEffectManager) != null) {
            audioEffectManager.release();
            this.mAudioEffectManager = null;
        }
        if ((earMonitorManager = this.mEarMonitorManager) != null) {
            earMonitorManager.release();
            this.mEarMonitorManager = null;
        }
    }

    public void resetStream() {
        EarMonitorManager earMonitorManager;
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null && this.isMicrophoneDisable()) {
            audioDeviceManager.muteAudio(false);
        }
        this.setRemoteAudioPCMBufferListener(null);
        this.track = null;
        this.mAudioDataListener = null;
        AudioEffectManager audioEffectManager = this.mAudioEffectManager;
        if (audioEffectManager != null) {
            audioEffectManager.stopAllEffects();
        }
        if ((earMonitorManager = this.mEarMonitorManager) != null) {
            earMonitorManager.enable(false);
        }
    }

    @Override
    public void setAudioConfig(RCRTCAudioStreamConfig config) {
        if (config == null) {
            FinLog.e(TAG, "setAudioConfig: RCRTCAudioStreamConfig is Null");
            return;
        }
        this.audioConfig = config;
        ((RCAudioStreamConfigImpl)this.audioConfig).updateServerConfig();
        this.needUpdateConfig.set(true);
        ReportUtil.libStatus(ReportUtil.TAG.RTCAUDIOCONFIG, "config", ((RCAudioStreamConfigImpl)config).formatLogString());
        this.onUpdateAudioConfig();
    }

    @Override
    public void setTrack(MediaStreamTrack track) {
        super.setTrack(track);
        this.onUpdateAudioConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUpdateAudioConfig() {
        AtomicBoolean atomicBoolean = this.needUpdateConfig;
        synchronized (atomicBoolean) {
            if (!this.needUpdateConfig.get()) {
                return;
            }
            AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
            AudioTrack track = (AudioTrack)this.getTrack();
            if (audioDeviceManager != null && track != null) {
                audioDeviceManager.updateAudioConfig(this.audioConfig, track);
                this.needUpdateConfig.set(false);
            } else {
                FinLog.w(TAG, "onUpdateAudio Failed: AudioDeviceManager or AudioTrack is Null");
            }
        }
    }

    @Override
    public void setMicrophoneDisable(boolean disable) {
        ReportUtil.appStatus(ReportUtil.TAG.SETMICROPHONEDISABLE, "disable", disable);
        if (this.isMicrophoneDisable() == disable) {
            return;
        }
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null) {
            audioDeviceManager.muteAudio(disable);
            RTCEngineImpl.getInstance().modifyResource(this, disable);
        } else {
            FinLog.e(TAG, "setMicrophoneDisable Failed: AudioDeviceManager is Null");
        }
    }

    @Override
    public boolean isMicrophoneDisable() {
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null) {
            return audioDeviceManager.isAudioMute();
        }
        return false;
    }

    @Override
    public void changeAudioScenario(RCRTCParamsType.AudioScenario audioScenario, RCRTCSyncCallBack otherActions) {
        ReportUtil.appStatus(ReportUtil.TAG.CHANGEAUDIOSCENARIO, "mode", audioScenario.getValue());
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null) {
            audioDeviceManager.switchSpeechMusicMode((AudioTrack)this.getTrack(), audioScenario, otherActions);
        } else {
            FinLog.e(TAG, "changeAudioScenario Failed: AudioDeviceManager is Null");
        }
    }

    public void setRemoteAudioPCMBufferListener(IRCRTCAudioDataListener listener) {
        FinLog.i(TAG, "setRemoteAudioPCMBufferListener listener = " + listener);
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null) {
            audioDeviceManager.setRemoteAudioPCMBufferListener(listener);
        }
    }

    public void muteAllRemoteAudio(boolean mute) {
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null) {
            audioDeviceManager.muteAllRemoteAudio(mute);
        }
    }

    public void registerAudioBufferListener(OnAudioBufferAvailableListener listener) {
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null) {
            audioDeviceManager.registerAudioBufferListener(listener);
        }
    }

    public void unregisterAudioBufferListener(OnAudioBufferAvailableListener listener) {
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null) {
            audioDeviceManager.unregisterAudioBufferListener(listener);
        }
    }

    public boolean isRecording() {
        AudioDeviceManager audioDeviceManager = this.mAudioDeviceManager;
        if (audioDeviceManager != null) {
            return audioDeviceManager.isRecording();
        }
        return false;
    }

    public IAudioEffectManager getAudioEffectManager() {
        return this.mAudioEffectManager;
    }

    @Override
    public void enableEarMonitoring(boolean enable) {
        EarMonitorManager earMonitorManager = this.mEarMonitorManager;
        if (earMonitorManager != null) {
            earMonitorManager.enable(enable);
        }
    }
}

