/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center.stream;

import android.opengl.Matrix;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCVideoOutputFrameListener;
import cn.rongcloud.rtc.api.callback.IRCRTCVideoSource;
import cn.rongcloud.rtc.api.stream.RCRTCCameraOutputStream;
import cn.rongcloud.rtc.api.stream.RCRTCVideoStreamConfig;
import cn.rongcloud.rtc.api.stream.RCRTCVideoView;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.base.RCRTCVideoFrame;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.stream.RCTinyVideoOutStream;
import cn.rongcloud.rtc.center.stream.RCVideoOutStreamImpl;
import cn.rongcloud.rtc.core.CameraVideoCapturer;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.core.NV21Buffer;
import cn.rongcloud.rtc.core.OesToRgbFilter;
import cn.rongcloud.rtc.core.RendererCommon;
import cn.rongcloud.rtc.core.TextureBufferImpl;
import cn.rongcloud.rtc.core.VideoFrame;
import cn.rongcloud.rtc.core.VideoTrack;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.module.camera.CameraManager;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;

public class RCCameraOutputStreamImpl
extends RCVideoOutStreamImpl
implements RCRTCCameraOutputStream {
    private static final String TAG = "RCCameraOutputStreamImpl";
    private CameraManager mCameraManager;
    private boolean mPreviewMirror = true;
    private IRCRTCVideoOutputFrameListener mVideoFrameListener;
    private TextureBufferImpl textureBuffer;
    private OesToRgbFilter mOesToRgbFilter;
    private RCRTCVideoFrame mVideoFrame;
    private RCRTCVideoFrame tmpVideoFrame;
    private NV21Buffer nv21Buffer;
    private RCTinyVideoOutStream mTinyVideoOutStream;

    public RCCameraOutputStreamImpl(String userId, CameraManager cameraManager) {
        super("RongCloudRTC", userId);
        this.mCameraManager = cameraManager;
        this.mCameraManager.setCaptureObserver(this);
    }

    @Override
    public void startCamera(final IRCRTCResultDataCallback<Boolean> cameraCallback) {
        ReportUtil.appTask(ReportUtil.TAG.STARTCAPTURE, "cameraId", -1);
        CameraManager mCameraManager = this.mCameraManager;
        if (mCameraManager == null) {
            ReportUtil.appError(ReportUtil.TAG.STARTCAPTURE, RTCErrorCode.CAMERA_IS_RELEASED);
            RTCEngineImpl.getInstance().onFailedCallback(RTCErrorCode.CAMERA_IS_RELEASED, cameraCallback);
            return;
        }
        mCameraManager.startCamera(this.getHeight(), this.getWidth(), this.getVideoFps().getFps(), new IRCRTCResultDataCallback<Boolean>(){

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.STARTCAPTURE, errorCode);
                RTCEngineImpl.getInstance().onFailedCallback(errorCode, cameraCallback);
            }

            @Override
            public void onSuccess(Boolean isFrontCamera) {
                ReportUtil.appRes(ReportUtil.TAG.STARTCAPTURE, "isFront", isFrontCamera);
                RTCEngineImpl.getInstance().onSuccessCallback(isFrontCamera, cameraCallback);
                RCCameraOutputStreamImpl.this.interiorSetPreviewMirror(isFrontCamera);
                RTCEngineImpl.getInstance().modifyResource(RCCameraOutputStreamImpl.this, false);
            }
        });
    }

    @Override
    public synchronized void mute(boolean mute) {
        super.mute(mute);
        RCTinyVideoOutStream tinyVideoOutStream = this.mTinyVideoOutStream;
        if (tinyVideoOutStream != null) {
            tinyVideoOutStream.mute(mute);
        }
    }

    @Override
    public void startCamera(int cameraId, boolean mirror, final IRCRTCResultDataCallback<Boolean> cameraCallback) {
        ReportUtil.appTask(ReportUtil.TAG.STARTCAPTURE, "cameraId", cameraId);
        CameraManager mCameraManager = this.mCameraManager;
        if (mCameraManager == null) {
            ReportUtil.appError(ReportUtil.TAG.STARTCAPTURE, RTCErrorCode.CAMERA_IS_RELEASED);
            RTCEngineImpl.getInstance().onFailedCallback(RTCErrorCode.CAMERA_IS_RELEASED, cameraCallback);
            return;
        }
        this.setPreviewMirror(mirror);
        mCameraManager.startCamera(cameraId, this.getHeight(), this.getWidth(), this.getVideoFps().getFps(), new IRCRTCResultDataCallback<Boolean>(){

            @Override
            public void onSuccess(Boolean isFrontCamera) {
                ReportUtil.appRes(ReportUtil.TAG.STARTCAPTURE, "isFront", isFrontCamera);
                RTCEngineImpl.getInstance().onSuccessCallback(isFrontCamera, cameraCallback);
                RCCameraOutputStreamImpl.this.interiorSetPreviewMirror(isFrontCamera);
                RTCEngineImpl.getInstance().modifyResource(RCCameraOutputStreamImpl.this, false);
            }

            @Override
            public void onFailed(RTCErrorCode errorCode) {
                ReportUtil.appError(ReportUtil.TAG.STARTCAPTURE, errorCode);
                RTCEngineImpl.getInstance().onFailedCallback(errorCode, cameraCallback);
            }
        });
    }

    @Override
    public void switchCamera(final CameraVideoCapturer.CameraSwitchHandler handler) {
        ReportUtil.appTask(ReportUtil.TAG.SWITCHCAMERA, "cameraId", -1);
        CameraManager mCameraManager = this.mCameraManager;
        if (mCameraManager != null) {
            mCameraManager.switchCamera(this.createCameraSwitchHandler(handler));
        } else {
            ReportUtil.appError(ReportUtil.TAG.SWITCHCAMERA, RTCErrorCode.CAMERA_IS_RELEASED);
            if (handler != null) {
                RTCEngineImpl.getInstance().postCallback(new Runnable(){

                    @Override
                    public void run() {
                        handler.onCameraSwitchError(RTCErrorCode.CAMERA_IS_RELEASED.getReason());
                    }
                });
            }
        }
    }

    @Override
    public void switchCamera(int cameraId, boolean mirror, final CameraVideoCapturer.CameraSwitchHandler handler) {
        ReportUtil.appTask(ReportUtil.TAG.SWITCHCAMERA, "cameraId", -1);
        if (this.mCameraManager != null) {
            this.mCameraManager.switchCamera(cameraId, mirror, this.createCameraSwitchHandler(handler));
        } else {
            ReportUtil.appError(ReportUtil.TAG.SWITCHCAMERA, RTCErrorCode.CAMERA_IS_RELEASED);
            if (handler != null) {
                RTCEngineImpl.getInstance().postCallback(new Runnable(){

                    @Override
                    public void run() {
                        handler.onCameraSwitchError(RTCErrorCode.CAMERA_IS_RELEASED.getReason());
                    }
                });
            }
        }
    }

    private CameraVideoCapturer.CameraSwitchHandler createCameraSwitchHandler(final CameraVideoCapturer.CameraSwitchHandler handler) {
        return new CameraVideoCapturer.CameraSwitchHandler(){

            @Override
            public void onCameraSwitchDone(final boolean isFrontCamera) {
                ReportUtil.appRes(ReportUtil.TAG.SWITCHCAMERA, "code|isFront", 0, isFrontCamera);
                if (handler != null) {
                    RTCEngineImpl.getInstance().postCallback(new Runnable(){

                        @Override
                        public void run() {
                            handler.onCameraSwitchDone(isFrontCamera);
                        }
                    });
                }
                RCCameraOutputStreamImpl.this.interiorSetPreviewMirror(isFrontCamera);
            }

            @Override
            public void onCameraSwitchError(final String errorDescription) {
                ReportUtil.appError(ReportUtil.TAG.SWITCHCAMERA, "code|desc", RTCErrorCode.UnknownError.getValue(), errorDescription);
                if (handler != null) {
                    RTCEngineImpl.getInstance().postCallback(new Runnable(){

                        @Override
                        public void run() {
                            handler.onCameraSwitchError(errorDescription);
                        }
                    });
                }
            }
        };
    }

    @Override
    public void stopCamera() {
        if (this.mCameraManager != null) {
            ReportUtil.appStatus(ReportUtil.TAG.STOPCAPTURE, "disable", true);
            this.mCameraManager.stopCamera();
            RTCEngineImpl.getInstance().modifyResource(this, true);
        } else {
            FinLog.e(TAG, "stopCamera: CameraManager is Null");
        }
    }

    @Override
    public void setVideoFrameListener(IRCRTCVideoOutputFrameListener videoFrameListener) {
        this.mVideoFrameListener = videoFrameListener;
    }

    @Override
    public synchronized void setVideoView(RCRTCVideoView videoView) {
        super.setVideoView(videoView);
        this.interiorSetPreviewMirror(this.mPreviewMirror);
    }

    @Override
    public void setPreviewMirror(boolean mirror) {
        this.mPreviewMirror = mirror;
        this.interiorSetPreviewMirror(mirror);
    }

    private void interiorSetPreviewMirror(boolean mirror) {
        RCRTCVideoView videoView = this.mVideoView;
        if (videoView != null) {
            videoView.setMirror(mirror && this.mPreviewMirror);
        }
    }

    @Override
    public boolean isPreviewMirror() {
        return this.mPreviewMirror;
    }

    @Override
    public void setVideoConfig(RCRTCVideoStreamConfig config) {
        RCRTCParamsType.RCRTCVideoResolution currentResolution = this.videoStreamConfig.getVideoResolution();
        if (config == null || config.getVideoResolution() == currentResolution && config.getVideoFps() == this.videoStreamConfig.getVideoFps()) {
            FinLog.e(TAG, "RCRTCVideoStreamConfig is null or is the same with previous settings");
            return;
        }
        super.setVideoConfig(config);
        RCRTCParamsType.RCRTCVideoResolution videoResolution = this.videoStreamConfig.getVideoResolution();
        MediaStreamTrack track = this.track;
        if (currentResolution != videoResolution && track != null && track instanceof VideoTrack) {
            ((VideoTrack)track).getVideoSource().adaptOutputFormat(this.getHeight(), this.getWidth(), this.getVideoFps().getFps());
        }
        if (this.isCapturing() && (currentResolution.getHeight() < videoResolution.getHeight() || currentResolution.getWidth() < videoResolution.getWidth())) {
            this.mCameraManager.restartCamera(this.getHeight(), this.getWidth(), this.getVideoFps().getFps());
        }
        RTCEngineImpl.getInstance().changeVideoSize();
    }

    public boolean isCapturing() {
        CameraManager cameraManager = this.mCameraManager;
        if (cameraManager != null) {
            return cameraManager.isCapturing();
        }
        return false;
    }

    @Override
    public void setCameraDisplayOrientation(int orientation) {
        if (this.mCameraManager != null) {
            this.mCameraManager.setCameraDisplayOrientation(orientation);
        }
    }

    @Override
    public void setFrameOrientation(int orientation) {
        if (this.mCameraManager != null) {
            this.mCameraManager.setFrameOrientation(orientation);
        }
    }

    @Override
    public final void setSource(IRCRTCVideoSource source) {
    }

    @Override
    public boolean isFrontCamera() {
        if (this.mCameraManager != null) {
            return this.mCameraManager.isFrontCamera();
        }
        return false;
    }

    @Override
    public void enableTinyStream(boolean enbale) {
        RTCEngineImpl.getInstance().setEnableTinyStream(enbale);
    }

    @Override
    public boolean isCameraFocusSupported() {
        if (this.mCameraManager != null) {
            return this.mCameraManager.isCameraFocusSupported();
        }
        return false;
    }

    @Override
    public boolean isCameraExposurePositionSupported() {
        if (this.mCameraManager != null) {
            return this.mCameraManager.isCameraExposurePositionSupported();
        }
        return false;
    }

    @Override
    public boolean setCameraExposurePositionInPreview(float x, float y) {
        if (this.mCameraManager != null) {
            return this.mCameraManager.setCameraExposurePositionInPreview(x, y);
        }
        return false;
    }

    @Override
    public boolean setCameraFocusPositionInPreview(float x, float y) {
        if (this.mCameraManager != null) {
            return this.mCameraManager.setCameraFocusPositionInPreview(x, y);
        }
        return false;
    }

    @Override
    public boolean isPreserved() {
        return true;
    }

    @Override
    public void release() {
        super.release();
        this.resetStream();
        if (this.mCameraManager != null) {
            this.mCameraManager.release();
            this.mCameraManager = null;
        }
        if (this.mOesToRgbFilter != null) {
            this.mOesToRgbFilter.destroy();
            this.mOesToRgbFilter = null;
        }
        this.track = null;
    }

    public void resetStream() {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        this.mVideoFrameListener = null;
        this.mCameraManager.stopCamera();
    }

    @Override
    public void onCapturerStarted(boolean success) {
        super.onCapturerStarted(success);
        RCTinyVideoOutStream tinyVideo = this.mTinyVideoOutStream;
        if (tinyVideo != null) {
            tinyVideo.onCapturerStarted(success);
        }
    }

    @Override
    public void onCapturerStopped() {
        super.onCapturerStopped();
        RCTinyVideoOutStream tinyVideo = this.mTinyVideoOutStream;
        if (tinyVideo != null) {
            tinyVideo.onCapturerStopped();
        }
    }

    @Override
    public void onFrameCaptured(VideoFrame frame) {
        this.onProcessVideoFrame(this.mVideoFrameListener, frame);
        super.onFrameCaptured(frame);
        RCTinyVideoOutStream tinyVideo = this.mTinyVideoOutStream;
        if (tinyVideo != null) {
            tinyVideo.onFrameCaptured(frame);
        }
    }

    private void onProcessVideoFrame(IRCRTCVideoOutputFrameListener videoFrameListener, VideoFrame frame) {
        if (videoFrameListener == null) {
            return;
        }
        if (frame.getBuffer() instanceof TextureBufferImpl) {
            this.textureBuffer = (TextureBufferImpl)frame.getBuffer();
            if (this.textureBuffer == null) {
                FinLog.e(TAG, "TextureBufferImpl is empty !");
                return;
            }
            if (this.mOesToRgbFilter == null) {
                this.mOesToRgbFilter = new OesToRgbFilter();
                this.mOesToRgbFilter.init();
            }
            this.mOesToRgbFilter.onSizeChanged(this.textureBuffer.getWidth(), this.textureBuffer.getHeight());
            int rgbTextureId = this.mOesToRgbFilter.drawTexture(this.textureBuffer.getTextureId(), this.textureBuffer.getOriginalMatrix());
            if (this.mVideoFrame == null) {
                this.mVideoFrame = new RCRTCVideoFrame();
            }
            this.mVideoFrame.setTextureId(rgbTextureId);
            this.mVideoFrame.setWidth(this.textureBuffer.getWidth());
            this.mVideoFrame.setHeight(this.textureBuffer.getHeight());
            this.mVideoFrame.setRotation(frame.getRotation());
            this.mVideoFrame.setTimestamp(frame.getTimestampNs());
            this.mVideoFrame.setTextureType(RCRTCVideoFrame.Type.RGB);
            this.tmpVideoFrame = videoFrameListener.processVideoFrame(this.mVideoFrame);
            if (this.tmpVideoFrame != null) {
                Matrix.setIdentityM((float[])this.textureBuffer.getOriginalMatrix(), (int)0);
                this.textureBuffer.setTransformMatrix(RendererCommon.convertMatrixToAndroidGraphicsMatrix(this.textureBuffer.getOriginalMatrix()));
                this.textureBuffer.setType(VideoFrame.TextureBuffer.Type.RGB);
                this.textureBuffer.setTextureId(this.tmpVideoFrame.getTextureId());
            }
        } else if (frame.getBuffer() instanceof NV21Buffer) {
            this.nv21Buffer = (NV21Buffer)frame.getBuffer();
            if (this.nv21Buffer == null) {
                FinLog.e(TAG, "NV21Buffer is empty !");
                return;
            }
            if (this.mVideoFrame == null) {
                this.mVideoFrame = new RCRTCVideoFrame();
            }
            this.mVideoFrame.setTextureId(-1);
            this.mVideoFrame.setData(this.nv21Buffer.getData());
            this.mVideoFrame.setWidth(this.nv21Buffer.getWidth());
            this.mVideoFrame.setHeight(this.nv21Buffer.getHeight());
            this.mVideoFrame.setRotation(frame.getRotation());
            this.mVideoFrame.setTimestamp(frame.getTimestampNs());
            this.tmpVideoFrame = videoFrameListener.processVideoFrame(this.mVideoFrame);
            if (this.tmpVideoFrame != null) {
                this.nv21Buffer.setData(this.tmpVideoFrame.getData());
            }
        }
    }

    public void setTinyVideoOutStream(RCTinyVideoOutStream tinyVideoOutStream) {
        RTCEngineImpl.getInstance().checkIsOnEngineThread();
        this.mTinyVideoOutStream = tinyVideoOutStream;
    }

    public RCTinyVideoOutStream getTinyVideoOutStream() {
        return this.mTinyVideoOutStream;
    }
}

